-- ============================================================
-- ADD SUPERVISOR ROLE & PAGE PERMISSIONS MANAGEMENT
-- ============================================================

-- Step 1: Update users table role ENUM to include Supervisor
ALTER TABLE users MODIFY COLUMN role ENUM('Administrator', 'Controller', 'Supervisor') NOT NULL DEFAULT 'Controller';

-- Step 2: Create role_permissions table to control page access
DROP TABLE IF EXISTS role_permissions;
CREATE TABLE role_permissions (
    id INT AUTO_INCREMENT PRIMARY KEY COMMENT 'Unique permission ID',
    role VARCHAR(50) NOT NULL COMMENT 'Role name (Controller, Supervisor)',
    page_name VARCHAR(100) NOT NULL COMMENT 'Page identifier (e.g., view_log, analytics, admin_fields)',
    page_label VARCHAR(150) NOT NULL COMMENT 'Display name of page',
    is_allowed BOOLEAN DEFAULT 0 COMMENT '1 = allowed, 0 = blocked',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    UNIQUE KEY unique_role_page (role, page_name),
    INDEX idx_role (role),
    INDEX idx_page_name (page_name)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Controls which pages each role can access';

-- Step 3: Insert default page permissions for Controller (restricted access)
INSERT INTO role_permissions (role, page_name, page_label, is_allowed) VALUES
('Controller', 'view_log', 'View Production Log', 1),
('Controller', 'analytics', 'Analytics & Reports', 1),
('Controller', 'admin_fields', 'Manage Fields', 0),
('Controller', 'entry_log', 'Entry Log', 1),
('Controller', 'tools_dashboard', 'Tools Dashboard', 1),
('Controller', 'all_employees', 'Employee Directory', 1),
('Controller', 'search_emp', 'Search Employees', 1),
('Controller', 'register_emp', 'Register Employee', 1),
('Controller', 'maintenance', 'Maintenance', 1),
('Controller', 'machines_tools_admin', 'Machines & Tools', 0);

-- Step 4: Insert default page permissions for Supervisor (all pages except admin_dashboard)
INSERT INTO role_permissions (role, page_name, page_label, is_allowed) VALUES
('Supervisor', 'view_log', 'View Production Log', 1),
('Supervisor', 'analytics', 'Analytics & Reports', 1),
('Supervisor', 'admin_fields', 'Manage Fields', 1),
('Supervisor', 'entry_log', 'Entry Log', 1),
('Supervisor', 'tools_dashboard', 'Tools Dashboard', 1),
('Supervisor', 'all_employees', 'Employee Directory', 1),
('Supervisor', 'search_emp', 'Search Employees', 1),
('Supervisor', 'register_emp', 'Register Employee', 1),
('Supervisor', 'maintenance', 'Maintenance & Reports', 1),
('Supervisor', 'machines_tools_admin', 'Machines & Tools', 1),
('Supervisor', 'admin_dashboard', 'Admin Dashboard', 0);

-- NOTE: Administrator role has access to ALL pages (no restrictions needed)

-- Verify the changes
SELECT * FROM role_permissions ORDER BY role, page_name;
