-- ======================================================
-- FIX FOR ADMIN DASHBOARD - ADD MISSING COLUMNS
-- This adds the missing columns to the existing users table
-- ======================================================

-- Add the missing 'created_by' column (self-referencing foreign key)
ALTER TABLE users ADD COLUMN created_by INT COMMENT 'ID of the Admin who created this user' AFTER role;

-- Add a foreign key constraint for created_by
ALTER TABLE users ADD CONSTRAINT fk_users_created_by FOREIGN KEY (created_by) REFERENCES users(id) ON DELETE SET NULL;

-- Add the missing 'created_at' timestamp column
ALTER TABLE users ADD COLUMN created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP COMMENT 'Date and time of account creation';

-- Add indexes for better performance
ALTER TABLE users ADD INDEX idx_created_by (created_by);

-- Verify the changes
DESCRIBE users;
