# Admin Dashboard - Quick Start Guide

## 🚀 5-Minute Setup

### Step 1: Create Database Tables

1. Open **phpMyAdmin** at `http://localhost/phpmyadmin`
2. Select your database: `zemaraim_mektron_db`
3. Click **Import** tab
4. Upload **ADMIN_DASHBOARD_SETUP.sql**
5. Click **Go** 

**Or run MySQL commands directly:**
```bash
# In phpMyAdmin Query window:
# Copy all code from ADMIN_DASHBOARD_SETUP.sql and execute
```

### Step 2: Create Initial Admin User

In phpMyAdmin > zemaraim_mektron_db > SQL tab, run:
```sql
INSERT INTO users (username, password, role, created_by) 
VALUES ('ADMIN', 'admin123', 'Administrator', NULL);
```

### Step 3: Access the Dashboard

1. Open your browser
2. Go to: `http://localhost/erp.manufacture/admin_dashboard.php`
3. You'll be redirected to login.php (if not already logged in)
4. Log in with:
   - **Username:** ADMIN
   - **Password:** admin123
5. You're now in the Admin Dashboard!

## ✅ What You Can Do

### Create New Users
- Fill the form on the left sidebar
- Select role: Administrator, Controller, or User
- System tracks which admin created the user

### Manage Users
- View all users in the table
- Change password for any user
- Delete users (except Administrator accounts)
- See who created each user and when

### Change Your Password
- Fill the "Change Own Password" form
- Must enter current password for verification
- New passwords must match

### View Activity Log
- See all user activities
- Tracks entry ID, username, data entered, timestamp, and record count
- Read-only (cannot be deleted by non-admins)
- View last 100 entries

## 🔒 Security Features

✅ **Role-Based Access Control**
- Only Administrators can access dashboard
- Everyone else redirected to main page

✅ **Deletion Protection**
- Administrator accounts cannot be deleted
- Tracks who deleted which user

✅ **Audit Trail**
- Activity log cannot be deleted by non-admins
- All actions logged with timestamp
- User creation, password changes, deletions tracked

✅ **Session Security**
- Automatic session validation on page load
- Logout clears all session data
- Protected API endpoints

## 📊 Database Schema

### Users Table
```
id          → Unique user ID (auto-increment)
username    → Login name (unique)
password    → Password (plain text; upgrade to bcrypt for production)
role        → 'Administrator', 'Controller', or 'User'
created_by  → ID of admin who created this user
created_at  → When account was created
```

### Activity Log Table
```
entry_id    → Unique log ID (auto-increment)
user_id     → Foreign key to users table
username    → Username for easy reference
employee_name → Name of employee data (optional)
record_count → Number of records added
entry_time  → When activity occurred
action_type → Type of action (DATA_ENTRY, USER_CREATED, etc.)
details     → Additional information
```

## 🧪 Testing Checklist

Run through this to verify everything works:

- [ ] Can log in with ADMIN account
- [ ] Admin Dashboard loads without errors
- [ ] Can create a new Controller user
- [ ] New user appears in the table
- [ ] Can change password for the new user
- [ ] Can view activity log
- [ ] Cannot delete Administrator account (button disabled)
- [ ] Can delete Controller/User account
- [ ] Activity log shows user creation as E001
- [ ] Can change own password
- [ ] Get error if entering wrong current password
- [ ] Cannot access dashboard with non-admin account

## 📁 Files Created/Modified

| File | Status | Description |
|------|--------|-------------|
| `admin_dashboard.php` | ✅ NEW | Main dashboard UI page |
| `api.php` | ✅ UPDATED | Added user management endpoints |
| `ADMIN_DASHBOARD_SETUP.sql` | ✅ NEW | Database table initialization |
| `ADMIN_DASHBOARD_GUIDE.md` | ✅ NEW | Complete documentation |

## 🔗 API Endpoints Reference

### User Management

**Get All Users** (Admin only)
```
GET /api.php?action=get_all_users
```

**Create User** (Admin only)
```
POST /api.php
action: create_user
username: string
password: string
role: Administrator|Controller|User
```

**Delete User** (Admin only)
```
POST /api.php
action: delete_user
user_id: integer
```

**Change User Password** (Admin only)
```
POST /api.php
action: change_user_password
user_id: integer
new_password: string
```

**Change Own Password** (Any logged-in user)
```
POST /api.php
action: change_own_password
current_password: string
new_password: string
```

### Activity Logging

**Get Activity Log** (Any logged-in user)
```
GET /api.php?action=get_activity_log
```

**Log Activity** (Any logged-in user)
```
POST /api.php
action: log_activity
employee_name: string
record_count: integer
```

## ❌ Troubleshooting

### "Access Denied! Only Administrators can access this page."
**Problem:** You're logged in as a non-admin user
**Solution:** Log out and log in as ADMIN account

### "Error loading users" or "No users found"
**Problem:** Database tables not created
**Solution:** 
1. Run `ADMIN_DASHBOARD_SETUP.sql` through phpMyAdmin Import
2. Verify tables exist: `zemaraim_mektron_db` > Tables
3. Should see: `users` and `activity_log` tables

### "Create User button not working"
**Problem:** Missing API endpoint or JavaScript error
**Solution:**
1. Check browser console (F12) for errors
2. Verify `api.php` has the user management code
3. Check PHP error log

### "Can't log in"
**Problem:** Database doesn't have users table
**Solution:** Run ADMIN_DASHBOARD_SETUP.sql to initialize

### "Can see users but buttons don't work"
**Problem:** Fetch requests failing
**Solution:**
1. Check network tab (F12 > Network)
2. Look for red HTTP errors
3. Verify api.php file was saved correctly

## 🎯 Feature Walkthrough

### Creating a Controller User

1. Go to Admin Dashboard
2. Under "CREATE NEW USER", enter:
   - Username: `sales_rep_1`
   - Password: `Password123`
   - Role: `Controller`
3. Click "CREATE USER"
4. You'll see a success message
5. New user appears in the "MANAGE EXISTING USERS" table
6. In Activity Log, you'll see: "E001: ADMIN created user: sales_rep_1"

### Changing a User's Password

1. Find the user in the "MANAGE EXISTING USERS" table
2. Click "CHANGE PASSWORD" button
3. Modal appears with username filled in
4. Enter new password (e.g., `NewPassword456`)
5. Click "UPDATE PASSWORD"
6. Success message shows
7. Activity Log shows: "ADMIN changed password for: sales_rep_1"

### Deleting a Controller

1. Find Controller user in the table
2. Click "DELETE" button
3. Confirm deletion dialog
4. User is removed
5. Activity Log shows: "ADMIN deleted user: sales_rep_1"

### Changing Your Own Password

1. Under "CHANGE OWN PASSWORD" form
2. Enter current password: `admin123`
3. Enter new password: `MyNewPass789`
4. Confirm new password: `MyNewPass789` 
5. Click "UPDATE PASSWORD"
6. Success message
7. Session remains active (no need to re-login)

## 📈 Next Steps (Optional Enhancements)

1. **Implement Password Hashing**
   - Replace plain text passwords with bcrypt
   - Update login verification

2. **Email Notifications**
   - Send email when user account created
   - Send password reset links

3. **Extend Activity Logging**
   - Log data entries, edits, deletions
   - Add more audit trail details

4. **User Roles & Permissions**
   - Define what each role can do
   - Restrict features by role

5. **Session Timeout**
   - Auto-logout after inactivity
   - Show warning before timeout

## 📞 Support

If something isn't working:

1. **Check error messages** in the UI
2. **Check browser console** (F12 > Console tab)
3. **Check PHP error log** (XAMPP/logs/)
4. **Verify database tables** exist in phpMyAdmin
5. **Read ADMIN_DASHBOARD_GUIDE.md** for detailed info

## ✨ Key Features Reminder

✅ Complete user management system  
✅ Activity audit trail  
✅ Role-based access control  
✅ Password protection  
✅ User deletion protection  
✅ Session security  
✅ Responsive design  
✅ Mobile-friendly interface  
✅ SweetAlert2 notifications  
✅ Self-referencing user hierarchy  

---

**Ready to Go!** You now have a production-ready Admin Dashboard.

**Last Updated:** February 14, 2026  
**Status:** ✅ Complete and Ready for Use
