<?php
/**
 * ADMIN DASHBOARD DIAGNOSTIC TOOL
 * Tests database tables, data, and API endpoints
 */

// Database connection
try {
    $pdo = new PDO('mysql:host=localhost;dbname=zemaraim_mektron_db;charset=utf8mb4', 'root', '', [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
    ]);
    echo "✅ Database connection successful\n\n";
} catch (Exception $e) {
    echo "❌ Database connection failed: " . $e->getMessage() . "\n";
    exit;
}

echo "=" . str_repeat("=", 78) . "\n";
echo "ADMIN DASHBOARD DIAGNOSTIC REPORT\n";
echo "=" . str_repeat("=", 78) . "\n\n";

// 1. Check if users table exists
echo "1. CHECKING USERS TABLE\n";
echo str_repeat("-", 80) . "\n";
try {
    $result = $pdo->query("DESCRIBE users");
    $columns = $result->fetchAll();
    if (!empty($columns)) {
        echo "✅ Users table exists with columns:\n";
        foreach ($columns as $col) {
            echo "   - {$col['Field']} ({$col['Type']})\n";
        }
        echo "\n";
        
        // Count users
        $count = $pdo->query("SELECT COUNT(*) as cnt FROM users")->fetch()['cnt'];
        echo "   Total users in database: $count\n";
        
        if ($count > 0) {
            echo "\n   Users:\n";
            $users = $pdo->query("SELECT id, username, role, created_by, created_at FROM users")->fetchAll();
            foreach ($users as $user) {
                echo "   - ID: {$user['id']}, Username: {$user['username']}, Role: {$user['role']}, Created By: {$user['created_by']}\n";
            }
        } else {
            echo "   ⚠️  NO USERS IN DATABASE - You need to insert the admin user!\n";
        }
        echo "\n";
    }
} catch (Exception $e) {
    echo "❌ Users table does not exist: " . $e->getMessage() . "\n\n";
}

// 2. Check if activity_log table exists
echo "2. CHECKING ACTIVITY_LOG TABLE\n";
echo str_repeat("-", 80) . "\n";
try {
    $result = $pdo->query("DESCRIBE activity_log");
    $columns = $result->fetchAll();
    if (!empty($columns)) {
        echo "✅ Activity_log table exists with columns:\n";
        foreach ($columns as $col) {
            echo "   - {$col['Field']} ({$col['Type']})\n";
        }
        echo "\n";
        
        // Count logs
        $count = $pdo->query("SELECT COUNT(*) as cnt FROM activity_log")->fetch()['cnt'];
        echo "   Total activity logs: $count\n";
        if ($count === 0) {
            echo "   (Empty - this is normal if no activities logged yet)\n";
        } else {
            echo "\n   Recent logs:\n";
            $logs = $pdo->query("SELECT entry_id, user_id, username, action_type, entry_time FROM activity_log LIMIT 5")->fetchAll();
            foreach ($logs as $log) {
                echo "   - Entry {$log['entry_id']}: {$log['username']} - {$log['action_type']} at {$log['entry_time']}\n";
            }
        }
        echo "\n";
    }
} catch (Exception $e) {
    echo "❌ Activity_log table does not exist: " . $e->getMessage() . "\n\n";
}

// 3. Test the API endpoint directly
echo "3. TESTING API ENDPOINTS\n";
echo str_repeat("-", 80) . "\n";

// Start session to test
session_start();
$_SESSION['user_id'] = 'ADMIN';
$_SESSION['role'] = 'Administrator';

echo "   Testing session:\n";
echo "   - user_id: {$_SESSION['user_id']}\n";
echo "   - role: {$_SESSION['role']}\n\n";

// Test get_all_users logic
echo "   Testing get_all_users logic:\n";
try {
    $stmt = $pdo->query("SELECT id, username, role, created_by, created_at FROM users ORDER BY created_at DESC");
    $users = $stmt->fetchAll();
    echo "   ✅ Query executed successfully\n";
    echo "   ✅ Retrieved " . count($users) . " users\n";
    
    if (count($users) > 0) {
        // Get creator names
        foreach ($users as &$user) {
            if ($user['created_by']) {
                $creatorStmt = $pdo->prepare("SELECT username FROM users WHERE id = ?");
                $creatorStmt->execute([$user['created_by']]);
                $creator = $creatorStmt->fetch();
                $user['created_by'] = $creator['username'] ?? 'Unknown';
            }
        }
        echo "   ✅ Creator lookup successful\n";
    }
    echo "\n";
} catch (Exception $e) {
    echo "   ❌ Query failed: " . $e->getMessage() . "\n\n";
}

// Test get_activity_log logic
echo "   Testing get_activity_log logic:\n";
try {
    $query = "SELECT entry_id, user_id, username, employee_name, record_count, entry_time, action_type FROM activity_log ORDER BY entry_time DESC LIMIT 100";
    $stmt = $pdo->query($query);
    $logs = $stmt->fetchAll();
    echo "   ✅ Query executed successfully\n";
    echo "   ✅ Retrieved " . count($logs) . " activity logs\n\n";
} catch (Exception $e) {
    echo "   ❌ Query failed: " . $e->getMessage() . "\n\n";
}

// 4. Recommendations
echo "4. RECOMMENDED ACTIONS\n";
echo str_repeat("-", 80) . "\n";

$userCount = $pdo->query("SELECT COUNT(*) as cnt FROM users")->fetch()['cnt'];

if ($userCount === 0) {
    echo "⚠️  IMPORTANT: NO ADMIN USER FOUND IN DATABASE\n\n";
    echo "Run this SQL command to create the initial admin user:\n\n";
    echo "INSERT INTO users (username, password, role, created_by)\n";
    echo "VALUES ('ADMIN', 'admin123', 'Administrator', NULL);\n\n";
    echo "Steps:\n";
    echo "1. Open phpMyAdmin\n";
    echo "2. Select your database: zemaraim_mektron_db\n";
    echo "3. Go to SQL tab\n";
    echo "4. Paste the INSERT command above\n";
    echo "5. Click Go\n";
    echo "6. Then refresh the Admin Dashboard page\n\n";
} else {
    echo "✅ Admin user exists in database\n";
    echo "✅ Tables are created and populated\n\n";
    echo "If you're still seeing errors:\n";
    echo "1. Clear browser cache (Ctrl+Shift+Delete)\n";
    echo "2. Open admin_dashboard.php\n";
    echo "3. Press F12 to open developer console\n";
    echo "4. Check Console tab for JavaScript errors\n";
    echo "5. Check Network tab for failed API calls\n";
}

echo "\n" . str_repeat("=", 80) . "\n";
echo "END OF DIAGNOSTIC REPORT\n";
echo str_repeat("=", 80) . "\n";
?>
