<?php
// Protect this page with session check
include 'session_check.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>All Employees - Mektron</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" href="style.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
        /* --- NEW GRID DESIGN STYLES --- */
        .emp-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
            gap: 25px;
            margin-top: 30px;
        }

        .emp-card {
            background: white;
            border-radius: 12px;
            padding: 20px;
            position: relative;
            border: 1px solid #eee;
            box-shadow: 0 4px 6px rgba(0,0,0,0.02);
            transition: all 0.3s cubic-bezier(0.25, 0.8, 0.25, 1);
            border-left: 5px solid #2ecc71; /* Default Active Green */
            overflow: hidden;
            animation: fadeInUp 0.5s ease backwards;
        }

        .emp-card:hover {
            transform: translateY(-7px);
            box-shadow: 0 15px 30px rgba(0,0,0,0.1);
        }

        .emp-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 10px;
        }

        .emp-id {
            background: #f0f3f5;
            color: #7f8c8d;
            font-size: 11px;
            font-weight: 700;
            padding: 4px 8px;
            border-radius: 4px;
        }

        /* --- STATUS BADGES --- */
        .badge-green {
            background: #eafaf1; color: #2ecc71; 
            font-size: 10px; font-weight: 800; padding: 4px 8px; border-radius: 20px; text-transform: uppercase;
        }
        .badge-red {
            background: #fdedec; color: #e74c3c; 
            font-size: 10px; font-weight: 800; padding: 4px 8px; border-radius: 20px; text-transform: uppercase;
        }

        .emp-name {
            font-size: 18px; font-weight: 700; color: #2c3e50; margin: 10px 0 5px 0;
        }

        .emp-designation {
            font-size: 13px; color: #3498db; font-weight: 600; text-transform: uppercase; margin-bottom: 15px;
        }

        .emp-details {
            border-top: 1px dashed #eee; padding-top: 10px; margin-top: 10px; font-size: 13px; color: #7f8c8d; display: flex; align-items: center; gap: 8px;
        }

        /* --- ACTION BUTTONS --- */
        .btn-deactivate {
            background: #fff; color: #e74c3c; border: 1px solid #fadbd8;
            padding: 8px 15px; border-radius: 6px; font-size: 12px; font-weight: 600; cursor: pointer; width: 100%; margin-top: 15px; transition: 0.2s;
        }
        .btn-deactivate:hover { background: #e74c3c; color: white; border-color: #e74c3c; }

        .btn-activate {
            background: #fff; color: #2ecc71; border: 1px solid #abebc6;
            padding: 8px 15px; border-radius: 6px; font-size: 12px; font-weight: 600; cursor: pointer; width: 100%; margin-top: 15px; transition: 0.2s;
        }
        .btn-activate:hover { background: #2ecc71; color: white; border-color: #2ecc71; }

        .btn-add-new {
            background: #2ecc71; color: white; padding: 10px 25px; border-radius: 30px; text-decoration: none; box-shadow: 0 4px 10px rgba(46, 204, 113, 0.3); transition: transform 0.2s;
        }
        .btn-add-new:hover { transform: scale(1.05); }

        @keyframes fadeInUp { from { opacity: 0; transform: translateY(20px); } to { opacity: 1; transform: translateY(0); } }
    </style>
</head>
<body>

    <div class="main-content">
        <div class="container">
            <div style="display:flex; justify-content:space-between; align-items:center; margin-bottom: 10px;">
                <div>
                    <h2 style="margin-bottom: 5px;">Staff Directory</h2>
                    <p style="color:#7f8c8d; margin:0;">Manage Active & Inactive Status</p>
                </div>
                <a id="addEmpBtn" href="register_emp.php" class="btn-add-new">+ Add Employee</a>
            </div>
            
            <div id="employeeGrid" class="emp-grid">
                <p style="grid-column: 1/-1; text-align: center; padding: 40px; color: #aaa;">Loading profiles...</p>
            </div>

        </div>
    </div>

    <script src="sidebar.js"></script>
    <script src="script.js"></script>
    
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Use server session role directly for reliable role-based UI on first load
            const addBtn = document.getElementById('addEmpBtn');
            const sessionRole = <?php echo json_encode($_SESSION['role'] ?? ''); ?>;
            const role = String(sessionRole || '').trim().toLowerCase();
            const canAddEmployee = role === 'administrator' || role === 'admin' || role === 'supervisor';

            localStorage.setItem('user_role', sessionRole || '');
            if (addBtn) addBtn.style.display = canAddEmployee ? '' : 'none';

            if (typeof loadAllEmployees === 'function') {
                loadAllEmployees(sessionRole);
            }
        });
    </script>
</body>
</html>
