<?php
// Detailed diagnostic
$pdo = new PDO('mysql:host=localhost;dbname=zemaraim_mektron_db;charset=utf8mb4', 'root', '');

echo "=== USERS TABLE DETAILED INFO ===\n\n";

// Get full structure
echo "1. COLUMN STRUCTURE:\n";
$result = $pdo->query("DESCRIBE users");
foreach ($result->fetchAll() as $col) {
    echo "   {$col['Field']} - {$col['Type']} - Null: {$col['Null']}\n";
}

// Get all users with all data
echo "\n2. ALL USERS IN DATABASE:\n";
$users = $pdo->query("SELECT * FROM users")->fetchAll();
echo "   Total: " . count($users) . "\n";
foreach ($users as $i => $user) {
    echo "\n   User #" . ($i+1) . ":\n";
    foreach ($user as $key => $val) {
        echo "      $key: " . ($val ?? 'NULL') . "\n";
    }
}

// Test the login query
echo "\n3. TEST LOGIN QUERY:\n";
echo "   Query: SELECT * FROM users WHERE username = 'ADMIN' AND role = 'Administrator'\n";
$stmt = $pdo->prepare("SELECT * FROM users WHERE username = ? AND role = ?");
$stmt->execute(['ADMIN', 'Administrator']);
$result = $stmt->fetch();
if ($result) {
    echo "   ✅ Result found: " . $result['username'] . " (" . $result['role'] . ")\n";
} else {
    echo "   ❌ No result found\n";
}

// Check role column values
echo "\n4. ROLE VALUES IN DATABASE:\n";
$roles = $pdo->query("SELECT DISTINCT role FROM users")->fetchAll();
foreach ($roles as $row) {
    echo "   - '" . $row['role'] . "'\n";
}

echo "\n";
?>
