<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Mektron</title>
    <style>
        :root {
            --preloader-bg: #e3e5e8;
            --preloader-core: #e3e5e8;
            --gear-primary: #f2a615;
            --gear-secondary: #00554f;
        }

        /* --- RESET & FONTS --- */
        * { box-sizing: border-box; }
        body {
            margin: 0;
            padding: 0;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #013b3b; /* Deep Teal Background */
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        /* --- PRELOADER --- */
        .page-preloader {
            position: fixed;
            inset: 0;
            display: grid;
            place-items: center;
            background: var(--preloader-bg);
            z-index: 9999;
            opacity: 1;
            visibility: visible;
            transition: opacity 0.55s cubic-bezier(0.22, 1, 0.36, 1), visibility 0.55s ease;
        }

        .page-preloader::before {
            content: "";
            position: absolute;
            inset: 0;
            background: radial-gradient(circle at center, rgba(255, 255, 255, 0.18) 0%, rgba(255, 255, 255, 0) 58%);
            pointer-events: none;
        }

        .page-preloader.is-hidden {
            opacity: 0;
            visibility: hidden;
            pointer-events: none;
        }

        .loader-gears {
            position: relative;
            width: 172px;
            height: 140px;
            transition: transform 0.5s cubic-bezier(0.22, 1, 0.36, 1), opacity 0.5s ease;
            transform-origin: center;
        }

        .page-preloader.is-hidden .loader-gears {
            transform: scale(0.9);
            opacity: 0;
        }

        .gear-icon {
            position: absolute;
            display: block;
            transform-origin: center;
            will-change: transform;
            filter: drop-shadow(0 4px 8px rgba(0, 0, 0, 0.12));
        }

        .gear-tooth {
            fill: currentColor;
        }

        .gear-ring {
            fill: none;
            stroke: currentColor;
            stroke-width: 12;
            stroke-linecap: round;
            stroke-linejoin: round;
        }

        .gear-core {
            fill: var(--preloader-core);
        }

        .gear-icon.primary {
            width: 86px;
            height: 86px;
            top: 20px;
            left: 34px;
            color: var(--gear-primary);
            animation: spin-cw 2.1s linear infinite;
        }

        .gear-icon.secondary {
            width: 76px;
            height: 76px;
            top: 58px;
            left: 86px;
            color: var(--gear-secondary);
            animation: spin-ccw 1.7s linear infinite;
        }

        @keyframes spin-cw {
            to { transform: rotate(360deg); }
        }

        @keyframes spin-ccw {
            to { transform: rotate(-360deg); }
        }

        @media (prefers-reduced-motion: reduce) {
            .gear-icon.primary,
            .gear-icon.secondary {
                animation-duration: 3.6s;
            }
        }

        /* --- LOGIN CARD --- */
        .login-card {
            background: #ffffff;
            width: 100%;
            max-width: 400px;
            padding: 40px;
            border-radius: 12px;
            box-shadow: 0 15px 35px rgba(0,0,0,0.3);
            text-align: center;
            border-top: 5px solid #f39c12; /* Gold Accent Bar */
        }

        /* --- LOGO AREA --- */
        .logo-container {
            margin-bottom: 25px;
        }
        .logo-container img {
            height: 60px; 
            width: auto;
            margin-bottom: 10px;
        }
        .logo-container h2 {
            margin: 0;
            color: #013b3b;
            font-size: 24px;
            letter-spacing: 1px;
            font-weight: 800;
            text-transform: uppercase;
        }
        .logo-container p {
            margin: 5px 0 0 0;
            color: #7f8c8d;
            font-size: 14px;
        }

        /* --- FORM STYLES --- */
        .form-group {
            margin-bottom: 20px;
            text-align: left;
        }
        
        label {
            display: block;
            margin-bottom: 8px;
            color: #34495e;
            font-weight: 600;
            font-size: 13px;
        }

        /* Styling for Input AND Select Dropdown */
        input, select {
            width: 100%;
            padding: 12px 15px;
            border: 1px solid #bdc3c7;
            border-radius: 6px;
            font-size: 15px;
            transition: all 0.3s;
            background: #f9f9f9;
            color: #2c3e50;
            appearance: none; /* Removes default browser arrow */
        }

        /* Custom Arrow for Dropdown */
        select {
            background-image: url("data:image/svg+xml;charset=US-ASCII,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%22292.4%22%20height%3D%22292.4%22%3E%3Cpath%20fill%3D%22%23007CB2%22%20d%3D%22M287%2069.4a17.6%2017.6%200%200%200-13-5.4H18.4c-5%200-9.3%201.8-12.9%205.4A17.6%2017.6%200%200%200%200%2082.2c0%205%201.8%209.3%205.4%2012.9l128%20127.9c3.6%203.6%207.8%205.4%2012.8%205.4s9.2-1.8%2012.8-5.4L287%2095c3.5-3.5%205.4-7.8%205.4-12.8%200-5-1.9-9.2-5.5-12.8z%22%2F%3E%3C%2Fsvg%3E");
            background-repeat: no-repeat;
            background-position: right .7em top 50%;
            background-size: .65em auto;
            cursor: pointer;
        }

        input:focus, select:focus {
            border-color: #f39c12; /* Gold border on focus */
            background-color: white;
            outline: none;
            box-shadow: 0 0 0 3px rgba(243, 156, 18, 0.2);
        }

        /* --- BUTTON --- */
        .btn-login {
            width: 100%;
            padding: 14px;
            background: linear-gradient(135deg, #f39c12 0%, #d35400 100%); /* Gold Gradient */
            color: white;
            border: none;
            border-radius: 6px;
            font-size: 16px;
            font-weight: bold;
            cursor: pointer;
            transition: transform 0.2s, box-shadow 0.2s;
            margin-top: 10px;
        }

        .btn-login:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(211, 84, 0, 0.4);
        }

        .btn-login:active {
            transform: translateY(0);
        }

        /* --- MESSAGES --- */
        .error-msg {
            background-color: #fee2e2;
            color: #dc2626;
            padding: 10px;
            border-radius: 6px;
            margin-bottom: 20px;
            font-size: 14px;
            border: 1px solid #fecaca;
            display: none;
        }

        /* --- FOOTER --- */
        .login-footer {
            margin-top: 25px;
            font-size: 12px;
            color: #bdc3c7;
        }

        /* --- CREDENTIALS INFO BOX --- */
        .credentials-info {
            background: linear-gradient(135deg, #ecf0f1 0%, #f8f9fa 100%);
            border-left: 5px solid #f39c12;
            border-radius: 8px;
            padding: 18px;
            margin-bottom: 28px;
            font-size: 13px;
            text-align: left;
            display: block !important;
            visibility: visible !important;
            opacity: 1 !important;
            box-shadow: 0 3px 10px rgba(0,0,0,0.1);
        }

        .credentials-info h4 {
            margin: 0 0 14px 0;
            color: #013b3b;
            font-size: 15px;
            text-transform: uppercase;
            font-weight: 700;
            border-bottom: 3px solid #f39c12;
            padding-bottom: 10px;
            letter-spacing: 0.5px;
        }

        .credential-item {
            margin-bottom: 12px;
            display: flex;
            align-items: flex-start;
            padding: 8px 0;
            border-bottom: 1px solid rgba(0,59,59,0.1);
        }

        .credential-item:last-child {
            border-bottom: none;
        }

        .credential-item strong {
            color: #013b3b;
            min-width: 120px;
            margin-right: 12px;
            font-size: 14px;
            font-weight: 700;
        }

        .credential-item span {
            color: #34495e;
            flex: 1;
            font-size: 13px;
            line-height: 1.4;
        }

        .credential-access {
            display: inline-block;
            background: linear-gradient(135deg, #27ae60 0%, #229954 100%);
            color: white;
            padding: 3px 10px;
            border-radius: 4px;
            font-size: 11px;
            font-weight: 600;
            margin-left: 8px;
            box-shadow: 0 2px 4px rgba(39,174,96,0.3);
        }

        .credential-restricted {
            display: inline-block;
            background: linear-gradient(135deg, #e74c3c 0%, #c0392b 100%);
            color: white;
            padding: 3px 10px;
            border-radius: 4px;
            font-size: 11px;
            font-weight: 600;
            margin-left: 8px;
            box-shadow: 0 2px 4px rgba(231,76,60,0.3);
        }
    </style>
</head>
<body>

    <div id="pagePreloader" class="page-preloader" aria-hidden="true">
        <div class="loader-gears">
            <svg class="gear-icon primary" viewBox="0 0 100 100" fill="none" aria-hidden="true">
                <g>
                    <rect class="gear-tooth" x="47" y="17" width="6" height="9" rx="1.5"></rect>
                    <rect class="gear-tooth" x="47" y="17" width="6" height="9" rx="1.5" transform="rotate(45 50 50)"></rect>
                    <rect class="gear-tooth" x="47" y="17" width="6" height="9" rx="1.5" transform="rotate(90 50 50)"></rect>
                    <rect class="gear-tooth" x="47" y="17" width="6" height="9" rx="1.5" transform="rotate(135 50 50)"></rect>
                    <rect class="gear-tooth" x="47" y="17" width="6" height="9" rx="1.5" transform="rotate(180 50 50)"></rect>
                    <rect class="gear-tooth" x="47" y="17" width="6" height="9" rx="1.5" transform="rotate(225 50 50)"></rect>
                    <rect class="gear-tooth" x="47" y="17" width="6" height="9" rx="1.5" transform="rotate(270 50 50)"></rect>
                    <rect class="gear-tooth" x="47" y="17" width="6" height="9" rx="1.5" transform="rotate(315 50 50)"></rect>
                </g>
                <circle class="gear-ring" cx="50" cy="50" r="21.5"></circle>
                <circle class="gear-core" cx="50" cy="50" r="10"></circle>
            </svg>

            <svg class="gear-icon secondary" viewBox="0 0 100 100" fill="none" aria-hidden="true">
                <g>
                    <rect class="gear-tooth" x="47" y="17" width="6" height="9" rx="1.5"></rect>
                    <rect class="gear-tooth" x="47" y="17" width="6" height="9" rx="1.5" transform="rotate(45 50 50)"></rect>
                    <rect class="gear-tooth" x="47" y="17" width="6" height="9" rx="1.5" transform="rotate(90 50 50)"></rect>
                    <rect class="gear-tooth" x="47" y="17" width="6" height="9" rx="1.5" transform="rotate(135 50 50)"></rect>
                    <rect class="gear-tooth" x="47" y="17" width="6" height="9" rx="1.5" transform="rotate(180 50 50)"></rect>
                    <rect class="gear-tooth" x="47" y="17" width="6" height="9" rx="1.5" transform="rotate(225 50 50)"></rect>
                    <rect class="gear-tooth" x="47" y="17" width="6" height="9" rx="1.5" transform="rotate(270 50 50)"></rect>
                    <rect class="gear-tooth" x="47" y="17" width="6" height="9" rx="1.5" transform="rotate(315 50 50)"></rect>
                </g>
                <circle class="gear-ring" cx="50" cy="50" r="21.5"></circle>
                <circle class="gear-core" cx="50" cy="50" r="10"></circle>
            </svg>
        </div>
    </div>

    <div class="login-card">
        <div class="logo-container">
            <img src="logo.png" alt="Mektron Logo" onerror="this.style.display='none'">
            <h2>MEKTRON</h2>
            <p>Production Log System</p>
        </div>

        <div id="errorMsg" class="error-msg"></div>

        <form id="loginForm">
            <div class="form-group">
                <label for="roleSelect">SELECT ROLE</label>
                <select id="roleSelect" required>
                    <option value="" disabled selected>-- Select Role --</option>
                    <option value="Administrator">Administrator</option>
                    <option value="Supervisor">Supervisor</option>
                    <option value="Controller">Controller</option>
                </select>
            </div>

            <div class="form-group">
                <label for="username">USERNAME</label>
                <input type="text" id="username" placeholder="Enter Username" required>
            </div>
            
            <div class="form-group">
                <label for="password">PASSWORD</label>
                <input type="password" id="password" placeholder="Enter Password" required>
            </div>

            <button type="submit" class="btn-login">LOGIN NOW</button>
        </form>

        <div class="login-footer">
            &copy; 2026 Mektron Industrial. All rights reserved.
        </div>
    </div>

    <script>
        (function() {
            const preloader = document.getElementById('pagePreloader');
            const minVisibleMs = 750;
            const startedAt = performance.now();
            let isHidden = false;

            function hidePreloader() {
                if (!preloader || isHidden) {
                    return;
                }

                const elapsed = performance.now() - startedAt;
                const waitMs = Math.max(0, minVisibleMs - elapsed);

                window.setTimeout(() => {
                    if (isHidden) {
                        return;
                    }
                    isHidden = true;
                    preloader.classList.add('is-hidden');
                    window.setTimeout(() => preloader.remove(), 700);
                }, waitMs);
            }

            if (document.readyState === 'complete') {
                hidePreloader();
            } else {
                window.addEventListener('load', hidePreloader, { once: true });
                window.setTimeout(hidePreloader, 2500);
            }
        })();

        document.getElementById('loginForm').addEventListener('submit', function(e) {
            e.preventDefault();
            
            // UI Feedback
            const btn = document.querySelector('.btn-login');
            const originalText = btn.textContent;
            btn.textContent = "VERIFYING...";
            btn.style.opacity = "0.7";

            const formData = new FormData();
            formData.append('action', 'login');
            formData.append('role', document.getElementById('roleSelect').value);
            formData.append('username', document.getElementById('username').value);
            formData.append('password', document.getElementById('password').value);

            fetch('api.php', { method: 'POST', body: formData })
            .then(res => res.json())
            .then(data => {
                if(data.success) {
                    window.location.href = 'index.php';
                } else {
                    const err = document.getElementById('errorMsg');
                    err.textContent = data.message || data.error || 'Login Failed'; 
                    err.style.display = 'block';
                    
                    // Reset button on error
                    btn.textContent = originalText;
                    btn.style.opacity = "1";
                }
            })
            .catch(err => {
                console.error(err);
                alert("Connection Error. Is XAMPP running?");
                btn.textContent = originalText;
                btn.style.opacity = "1";
            });
        });
    </script>
</body>
</html>
