# Machine-Wise Analytics Guide - Complete Example

## 📋 Overview

The enhanced Machine Analytics feature provides detailed breakdowns of machine operations with:
- **Date-wise order** - Chronological view from oldest to newest
- **Tools used** - Which tools are used in the machine
- **Employees working** - Who operates the machine
- **Daily plans** - Number of operations per day
- **Multiple visualizations** - Bar, Line, and Pie charts

---

## 🔧 How to Use: Step-by-Step Example

### Step 1: Select Machine Field and View Machines

```
1. Go to Analytics Page
2. Select a Machine/Tool Field from dropdown
   Example: "M/C No" field
3. Table shows all machines with:
   - Machine/Tool Name
   - Employees Count
   - Total Operations
   - [View Detail] button
```

**Example Output:**
```
┌─────────────────────────────────────────────────────────┐
│ Machine/Tool Statistics                                 │
├────────────────────┬──────────┬───────────┬────────────┤
│ Machine/Tool       │Employees │Operations │ Action     │
├────────────────────┼──────────┼───────────┼────────────┤
│ CNC-M1            │    3     │    245    │[View Detail]│
│ Drilling-M2       │    2     │    198    │[View Detail]│
│ Lathe-M3          │    4     │    312    │[View Detail]│
│ Grinding-M4       │    2     │    156    │[View Detail]│
└────────────────────┴──────────┴───────────┴────────────┘
```

### Step 2: Click "View Detail" for a Machine

**Example: Clicking [View Detail] for CNC-M1**

---

## 📊 Machine Detail Analysis - Complete Example

### Section 1: Summary Cards

After clicking [View Detail] for CNC-M1, you'll see:

```
╔═══════════════════════════════════════════════════════════════╗
║ Machine: CNC-M1 - Detailed Analysis                          ║
╠═══════════════════════════════════════════════════════════════╣
║                                                               ║
║ ┌──────────────────┐ ┌──────────────────┐ ┌──────────────────┐
║ │ Total Operations │ │ Assigned Emps    │ │ Tools Used       │
║ │      245         │ │       3          │ │       2          │
║ └──────────────────┘ └──────────────────┘ └──────────────────┘
║ ┌──────────────────┐
║ │ Avg Daily Plans  │
║ │      24.5        │
║ └──────────────────┘
║
║ (These are clickable insights showing key metrics)
║
╚═══════════════════════════════════════════════════════════════╝
```

**What Each Card Shows:**
- **Total Operations:** 245 = Total production logs for CNC-M1
- **Assigned Employees:** 3 = Three people work on CNC-M1
- **Tools Used:** 2 = Two different tools used on this machine
- **Avg Daily Plans:** 24.5 = Average 24-25 operations per day

---

### Section 2: Tools Used Table

```
╔═══════════════════════════════════════════════════════════════╗
║ Tools Used in This Machine                                   ║
╠═══════════════════════════════════════════════════════════════╣
║                                                               ║
║ ┌────────────────┬──────────────┬──────────────┐             ║
║ │ Tool Name      │ Usage Count  │ Percentage   │             ║
║ ├────────────────┼──────────────┼──────────────┤             ║
║ │ Cutting Bit-1  │    156       │ 63.7%        │             ║
║ │                │ ███████████  │              │             ║
║ ├────────────────┼──────────────┼──────────────┤             ║
║ │ Chuck Tool     │     89       │ 36.3%        │             ║
║ │                │ ███████      │              │             ║
║ └────────────────┴──────────────┴──────────────┘             ║
║                                                               ║
║ Interpretation:                                              ║
║ • Cutting Bit-1 is used more (156 times, 63.7%)            ║
║ • Chuck Tool is used 89 times (36.3%)                       ║
║ • Total tool uses = 245 (matches total operations)           ║
║                                                               ║
╚═══════════════════════════════════════════════════════════════╝
```

---

### Section 3: Employees Working Table

```
╔═══════════════════════════════════════════════════════════════╗
║ Employees Working on This Machine                            ║
╠═══════════════════════════════════════════════════════════════╣
║                                                               ║
║ ┌────────┬───────────────┬──────────────┬──────────────┐     ║
║ │ Emp ID │ Employee Name │ Operations   │ % of Total   │     ║
║ ├────────┼───────────────┼──────────────┼──────────────┤     ║
║ │ EMP001 │ John Smith    │    98        │ 40.0%        │     ║
║ │        │               │ ████████     │              │     ║
║ ├────────┼───────────────┼──────────────┼──────────────┤     ║
║ │ EMP002 │ Jane Doe      │    89        │ 36.3%        │     ║
║ │        │               │ ███████      │              │     ║
║ ├────────┼───────────────┼──────────────┼──────────────┤     ║
║ │ EMP003 │ Mike Johnson  │    58        │ 23.7%        │     ║
║ │        │               │ ████         │              │     ║
║ └────────┴───────────────┴──────────────┴──────────────┘     ║
║                                                               ║
║ Key Insights:                                                ║
║ • John Smith is most active (98 ops, 40%)                   ║
║ • Jane Doe does 89 operations (36.3%)                       ║
║ • Mike Johnson contributes 58 operations (23.7%)            ║
║ • Total: 245 operations across 3 employees                  ║
║                                                               ║
╚═══════════════════════════════════════════════════════════════╝
```

---

### Section 4: Date-Wise Operations Charts (Multiple Views)

The most important section showing **chronological date order** from oldest to newest.

#### Option A: BAR CHART (Default)

```
Comparative Distribution
[Bar] [Line] [Pie]  ← Click to switch view

Operations per Day (Bar Chart):

    Operations
    120 │
    100 │     ┌─────┐
     80 │     │     │     ┌─────┐
     60 │ ┌───┤     │ ┌───┤     │
     40 │ │   │ ┌───┤ │   │     │
     20 │ │   │ │   │ │   │ ┌───┤
      0 └─┴───┴─┴───┴─┴───┴─┴───┴───
        1-28  1-29  1-30  2-1   2-2

    Legend:
    ░ Total Operations (Blue)
    ░ Employees Active (Pink)
    ░ Tools Used (Green)
```

**What It Shows:**
- Each day from 2026-01-28 to 2026-02-02
- Bars show three metrics side-by-side
- Taller bars = more activity that day
- Easy to spot busy and slow days

**Example Interpretation:**
```
Date 01-30 (Wednesday):
• 45 total operations (blue bar)
• 3 employees worked (pink bar)
• 2 tools used (green bar)

Date 02-01 (Friday):
• 28 total operations
• 2 employees worked
• 2 tools used
```

---

#### Option B: LINE CHART

```
Comparative Distribution
[Bar] [Line] [Pie]

Operations Over Time (Line Chart):

    Operations
    120 │
    100 │    ╱╲       ╱─────╲
     80 │   ╱  ╲     ╱       ╲
     60 │  ╱    ╲   ╱         ╲
     40 │╱       ╲ ╱           ╲
     20 │         ╲╱             ╲
      0 └────────────────────────────
        01-28 01-29 01-30 02-01 02-02

    Legend:
    ─── Total Operations (Blue)
    ─── Employees Active (Pink)
    ─── Tools Used (Green)
```

**What It Shows:**
- Trend lines show ups and downs over time
- Easy to spot patterns and trends
- Shows if activity is increasing or decreasing
- Good for understanding flow over time

**Example Patterns:**
```
Trend 1: Activity increases mid-week
• 01-28 (Mon): 20 ops (low)
• 01-29 (Tue): 35 ops (up)
• 01-30 (Wed): 45 ops (peak)
• 01-31 (Thu): 38 ops (down)
• 02-01 (Fri): 28 ops (low)

Interpretation: Peak activity on Wednesday
```

---

#### Option C: PIE CHART

```
Comparative Distribution
[Bar] [Line] [Pie]

Operations Distribution by Day (Pie Chart):

         ╱──────────────╲
        ╱                ╲
       │   01-30          │
       │   18%            │ Each slice = 1 day
       │  ┌────────────┐  │ Size = % of total ops
       │  │ Operations │  │
       │  └────────────┘  │
        ╲                ╱
         ╲──────────────╱

    Days with most activity:
    • 01-30 (Wed): 45 ops = 18%
    • 01-29 (Tue): 42 ops = 17%
    • 02-02 (Mon): 39 ops = 16%
    • 01-28 (Mon): 38 ops = 15%
    • 02-01 (Fri): 28 ops = 11%
    • 01-31 (Thu): 13 ops = 5%
```

**What It Shows:**
- Each slice represents one day
- Bigger slice = more operations that day
- Shows proportion of total work
- Good for understanding workload distribution

**Example Insight:**
```
Wednesday (01-30) has the most operations:
• 45 out of 245 total = 18%
• Almost 1/5 of all weekly work
• Busiest day of the week
```

---

### Section 5: Daily Plans & Operations Table

**Final detailed table showing date-wise order:**

```
╔════════════════════════════════════════════════════════════════╗
║ Daily Plans & Operations                                       ║
╠════╦═════╦═══════════╦═════════════╦════════════╦═════════════╣
║Date║ Day ║Operations ║  Employees  │ Tools Used │Avg Per Emp  ║
╠════╬═════╬═══════════╬═════════════╬════════════╬═════════════╣
║1-28║ Mon │    20     │      1      │     1      │    20.0     ║
║1-29║ Tue │    42     │      2      │     2      │    21.0     ║
║1-30║ Wed │    45     │      3      │     2      │    15.0     ║  ← Peak Day
║1-31║ Thu │    13     │      1      │     1      │    13.0     ║
║2-1 │ Fri │    28     │      2      │     2      │    14.0     ║
║2-2 │ Sat │    39     │      2      │     2      │    19.5     ║
║2-3 │ Sun │    35     │      2      │     2      │    17.5     ║
║2-4 │ Mon │    23     │      1      │     1      │    23.0     ║
╚════╩═════╩═══════════╩═════════════╩════════════╩═════════════╝
```

**How to Read:**

**Row Example (01-30, Wednesday):**
- **Date:** 01-30
- **Day:** Wed (Wednesday)
- **Daily Operations:** 45 (45 production records entered)
- **Employees Active:** 3 (Three people worked that day)
- **Tools Used:** 2 (Two different tools used)
- **Avg Per Employee:** 15.0 (45 ÷ 3 = 15 ops per employee on average)

**Detailed Breakdown for 01-30:**
```
Wednesday 01-30 Analysis:
┌─────────────────────────────────────────┐
│ Total Operations: 45                    │
│ Assigned to: 3 employees                │
│ Tools used: 2                           │
│ Average per employee: 15 operations     │
│                                         │
│ Breakdown:                              │
│ • EMP001 (John): 18 operations          │
│ • EMP002 (Jane): 15 operations          │
│ • EMP003 (Mike): 12 operations          │
│ ───────────────────────────────         │
│ Total: 45 ✓                             │
│                                         │
│ Tools breakdown:                        │
│ • Cutting Bit: 28 uses                  │
│ • Chuck Tool: 17 uses                   │
│ ───────────────────────────────         │
│ Total: 45 ✓                             │
└─────────────────────────────────────────┘
```

---

## 🎯 Complete Example Workflow

### Scenario: Analyzing CNC-M1 Machine Operations

**Goal:** Understand CNC-M1 performance and identify issues

**Step 1: View Overall Machine Statistics**
```
Machine: CNC-M1
• Total Operations: 245
• Assigned Employees: 3
• Tools Used: 2
• Avg Daily: 24.5 operations
```

**Step 2: Check Tool Usage**
```
Tools Used Table:
• Cutting Bit-1: 156 ops (63.7%)
• Chuck Tool: 89 ops (36.3%)

Finding: One tool heavily dominant
Action: Plan maintenance for Cutting Bit
```

**Step 3: Review Employee Contribution**
```
Employees Table:
• EMP001 (John): 98 ops (40%)
• EMP002 (Jane): 89 ops (36%)
• EMP003 (Mike): 58 ops (24%)

Finding: John is most active, Mike contributes less
Action: Consider training for Mike
```

**Step 4: Analyze Daily Trends (Using Charts)**

**Using BAR CHART:**
```
Visual inspection shows:
• Peak on Wednesday (45 ops)
• Low on Thursday (13 ops)
• Pattern suggests weekly schedule
```

**Using LINE CHART:**
```
Trend analysis shows:
• Uptrend Tue-Wed (20→35→45)
• Downtrend Wed-Thu (45→13)
• Unstable Thu-Fri period
```

**Using PIE CHART:**
```
Distribution shows:
• Wednesday = 18% of total work
• Monday = 15% of total work
• Thursday = 5% of total work (LOWEST)
```

**Step 5: Detailed Date Analysis**

Looking at the Daily Plans Table:

```
Problem Identified: Thursday (01-31)
├─ Operations: 13 (VERY LOW)
├─ Employees: 1 (Only 1 person)
├─ Tools: 1 (Only 1 tool)
└─ Action Needed: INVESTIGATE

Resolution Options:
1. Check if machine was under maintenance
2. Check if employee was absent
3. Check if it's a scheduled low-activity day
4. Review schedule for that day

Better Day: Wednesday (01-30)
├─ Operations: 45 (HIGHEST)
├─ Employees: 3 (Full team)
├─ Tools: 2 (Both tools in use)
└─ Status: OPTIMAL - This should be the target
```

---

## 📈 Data Interpretation Guide

### Chart Reading Tips

**BAR CHART Best For:**
- Quick comparison across days
- Spotting peak and low days
- Comparing three metrics side-by-side

**LINE CHART Best For:**
- Seeing trends over time
- Identifying patterns
- Understanding growth/decline

**PIE CHART Best For:**
- Understanding proportions
- Seeing which days are most important
- Distribution analysis

### Key Metrics Explained

| Metric | What It Means | Good Value | Action |
|--------|---------------|-----------|--------|
| Daily Operations | Work done that day | 20-30 avg | Track consistency |
| Employees Active | People working | Match capacity | Plan staffing |
| Tools Used | Different tools | Should vary | Check tool rotation |
| Avg Per Employee | Work/person ratio | 15-25 per day | Monitor efficiency |

---

## 💡 Common Analysis Scenarios

### Scenario 1: Machine Underutilized
**Symptoms:**
- Daily operations < 10
- Only 1 employee assigned
- Tools not being used

**Action:**
- Check machine status
- Review maintenance schedule
- Increase workload if possible

### Scenario 2: One Employee Overloaded
**Symptoms:**
- One employee has 60%+ of operations
- Others have <30%

**Action:**
- Balance workload
- Provide additional training
- Consider equipment upgrade

### Scenario 3: Tool Shortage
**Symptoms:**
- Only 1 tool being used
- High tool usage count

**Action:**
- Procure additional tools
- Plan tool maintenance
- Diversify tool usage

### Scenario 4: Efficiency Declining
**Symptoms:**
- Line chart trending downward
- Operations decreasing over time

**Action:**
- Check for maintenance issues
- Review employee morale
- Analyze order volume

---

## 📊 Example Data Export

### If You Need to Export for Reports:

**Screenshot the sections you need:**
1. Summary cards (metrics)
2. Preferred chart (Bar/Line/Pie)
3. Detailed table

**Or copy table data to Excel:**
```
Date,Day,Operations,Employees,Tools,Avg
01-28,Mon,20,1,1,20.0
01-29,Tue,42,2,2,21.0
01-30,Wed,45,3,2,15.0
01-31,Thu,13,1,1,13.0
02-01,Fri,28,2,2,14.0
```

---

## 🔄 Workflow for Daily Use

### Morning Standup (5 minutes):
1. Check date-wise chart for week trends
2. Identify any anomalies (unusually low/high)
3. Share with team

### Weekly Review (15 minutes):
1. Look at all 7 days
2. Calculate weekly average
3. Compare to previous week
4. Plan next week based on trends

### Monthly Analysis (30 minutes):
1. Export all data from the month
2. Create summary report
3. Identify patterns
4. Plan improvements

---

## 📱 Mobile Access

All sections are responsive:
- Charts adjust to screen size
- Tables scroll horizontally
- Summary cards stack vertically
- Easy to view on phone/tablet

---

**Now you have a complete understanding of Machine-Wise Analytics with date order!**

For any questions, refer to the implementation guide or contact support.
