# Notification System - Quick Reference Card

## 🔔 Bell Icon Location
**Top-Right Corner** of Analytics Dashboard (admin users only)

---

## ⚡ Quick Features

| Feature | Details |
|---------|---------|
| **Access** | Click bell icon in dashboard |
| **View** | Slides in from right side |
| **Refresh** | Auto-updates every 30 seconds |
| **Alerts** | Machines (maintenance) & Tools (strokes) |
| **Severity** | Critical (Red), Warning (Orange), Info (Blue) |

---

## 🎯 Default Thresholds

- **Machines**: Alert when due in **15 days**
- **Tools**: Alert when **1000 strokes** remaining

---

## ⚙️ Changing Settings

1. Click **bell icon**
2. Click **Settings ⚙️** button
3. Modify threshold values
4. Click **Save Settings**

---

## 📊 Notification Types

### Machine Alert
```
⚙️ Machine M-001 Maintenance Due
Machine will require maintenance in 10 days
Details: Next due: March 31 • Updated: Today
[Go to Maintenance] button
```

### Tool Alert
```
🔧 Tool G3 Stroke Limit Warning
Tool has 800 strokes remaining
Details: G3 • Updated: Today
[Go to Maintenance] button
```

---

## 🔴 Severity Guide

| Level | Color | Condition |
|-------|-------|-----------|
| **CRITICAL** | 🔴 Red | <5 days OR <100 strokes |
| **WARNING** | 🟠 Orange | Within configured threshold |
| **INFO** | 🔵 Blue | General alerts |

---

## 💡 Common Actions

### View All Notifications
→ Click bell icon

### Check Specific Item
→ Click [Go to Maintenance] button

### Update Thresholds
→ Click Settings in sidebar

### Clear Notifications
→ Click "Clear All" button

---

## 🐛 Quick Troubleshooting

| Issue | Solution |
|-------|----------|
| Bell icon doesn't show | Check if logged in as admin |
| No notifications appear | Verify database has notification_settings table |
| Sidebar won't open | Clear browser cache (Ctrl+F5) |
| Settings won't save | Check number input format |

---

## 📋 Recommended Thresholds by Environment

### Standard Production
- Machine: **20 days**
- Tools: **1000 strokes**

### High-Volume Production
- Machine: **10 days**
- Tools: **500 strokes**

### Critical Equipment
- Machine: **30 days**
- Tools: **2000 strokes**

---

## 🚀 Workflow Shortcut

1. **Dashboard** → See notification badge
2. **Click bell** → Read alert message
3. **Click action** → Jump to maintenance page
4. **Update record** → Resolve issue
5. **Alert clears** → Auto-regenerated when needed

---

## 📱 Badge Explanation

```
🔔 [24]  ← Badge shows count
     ↑
  Pulsing
  animation
  when active
```

- **Number** = Total notifications
- **Red background** = Critical alerts present
- **Pulsing** = New notifications arriving

---

## ⏰ Auto-Refresh Details

- **Check interval**: Every 30 seconds
- **Updates**: New notifications, badge count
- **Manual refresh**: Click on bell (sidebar refresh)
- **Immediate updates**: When entry logs are saved

---

## 🔒 Security Notes

- **Admin only** - Not visible to regular employees
- **Database secured** - Uses prepared statements
- **Session authenticated** - Verifies admin status
- **No sensitive data** - Only thresholds and alerts

---

## 📞 Support

**Issues**? Check these files:
- `NOTIFICATION_ADMIN_GUIDE.md` - Full guide
- `NOTIFICATION_UI_INTEGRATION.md` - Technical details
- `notifications.php` - Backend code
- `notification_ui.html` - Frontend code

---

## ✅ Verification Checklist

- [ ] Bell icon appears in top-right
- [ ] Can click to open/close sidebar
- [ ] Settings can be modified
- [ ] Notifications display item details
- [ ] [Go to Maintenance] button works
- [ ] Auto-refresh updates every 30 seconds
- [ ] Not visible to non-admin users

