# Notification System - Quick Start Guide

## 👤 For All Users

### Accessing Notifications

1. **Login to the Dashboard**
   - Go to: `http://localhost/erp.manufacture/index.php`
   - Login with your credentials

2. **Click the Bell Icon** 🔔
   - Located in the top-right corner of the navigation bar
   - Visible to all logged-in users

3. **View Your Alerts**
   - Notification popup appears in the center of the screen
   - Shows all current maintenance alerts and tool status

### Understanding the Notifications

#### 🟥 CRITICAL (Red Badge)
- **Machines:** Due for maintenance ≤ 7 days OR overdue
- **Tools:** Out of service (exceeded stroke limit)
- **Action:** Address immediately

#### 🟧 WARNING (Orange Badge)
- **Machines:** Due for maintenance in 8-14 days
- **Tools:** Only 5-20% of strokes remaining
- **Action:** Plan maintenance soon

#### 🔵 INFO (Blue Badge)
- **Machines:** Due for maintenance in 15-30 days
- **Tools:** Only up to 20% of strokes remaining
- **Action:** Schedule when convenient

### What You'll See

#### For Machines 🔧
- **Machine Name** - Which machine needs attention
- **Last Service Date** - When it was last serviced
- **Maintenance Interval** - How often it needs service (in months)
- **Due Date** - When the next maintenance is due
- **Days Remaining** - How many days until due (or how many days overdue)

**Example:**
```
⚙️ Machine Due For Maintenance
Lathe #1 is due for maintenance in 5 days

Last Service: 2024-01-15
Life Limit: 3 months
Due Date: 2024-04-15
📍 5 days remaining ← CRITICAL
```

#### For Tools 🔨
- **Tool Name** - Which tool needs attention
- **Current Usage** - How many strokes have been used
- **Max Strokes** - Total stroke capacity
- **Remaining Strokes** - How many strokes are left
- **Usage Percentage** - Visual bar showing wear level

**Example:**
```
⚠️ Tool Maintenance Needed
Punch Press Tool (XYZ-123) strokes remaining: 500 / 20,000 (97.5%)

Current Usage: 19,500
Max Strokes: 20,000
[████████████████████] 97.5%
📍 500 strokes remaining ← CRITICAL
```

### Taking Action

When you see an alert:

1. **Click the Action Button**
   - For Machines: "View Details" → Goes to Maintenance Dashboard
   - For Tools: "View Details" → Goes to Tools Dashboard

2. **From the Dashboard**
   - Log the maintenance service, OR
   - Replace the tool, OR
   - Refurbish/reset the tool

3. **Notification Updates**
   - Once you update the data, the notification disappears
   - System automatically recalculates based on new dates/counts

---

## 👨‍💼 For Administrators Only

### Configuring Alert Thresholds

1. **Open Notification Settings**
   - Click the bell icon 🔔
   - Click "Settings" button at bottom of popup

2. **Adjust Thresholds**

   **Machine Maintenance Alert (Default: 15 days)**
   - Set how many days before due date to show WARNING
   - Example: Set to 10 = alerts appear 10 days before due
   
   **Tool Strokes Alert (Default: 1000 strokes)**
   - Set remaining stroke threshold for WARNING alert
   - Example: Set to 1000 = alerts when 1000 or fewer strokes remain

3. **Save Changes**
   - Click "Save Settings" button
   - Settings apply immediately system-wide

### Settings Examples

```
Machine Warning (days): 15
  → Alert appears when due date is within 15 days
  
Tool Warning (strokes): 1000
  → Alert appears when remaining strokes ≤ 1000
```

---

## 🔄 Auto-Refresh

- Notifications update **every 30 seconds** automatically
- You don't need to manually refresh
- Just leave the popup open to see real-time updates

---

## ❌ No Notifications?

If the bell shows no alerts:

**This means:**
- ✅ All machines are within 30 days of next scheduled maintenance
- ✅ All tools have more than 20% of their strokes remaining
- ✅ No expired machines or tools
- **Everything is in good condition!**

---

## 📊 Quick Reference

| Alert Type | Machine | Tool |
|-----------|---------|------|
| CRITICAL | Due ≤7 days or overdue | No strokes left |
| WARNING | Due in 8-14 days | <20% strokes left |
| INFO | Due in 15-30 days | - |

---

## 💡 Tips

1. **Check notifications regularly** - Before starting production runs
2. **Plan ahead** - Don't wait for CRITICAL alerts
3. **For admins** - Adjust thresholds based on your business needs
4. **Mobile friendly** - Popup adapts to phone/tablet screens
5. **Always available** - Bell icon is always visible in the top-right

---

## 🆘 Troubleshooting

**Bell icon not showing?**
- Make sure you're logged in
- Refresh the page (F5 or Ctrl+R)
- Check your user permissions

**Notifications not updating?**
- Click the bell icon to load latest notifications
- Check your internet connection
- Try refreshing (`F5`)

**Settings button disabled?**
- Only administrators can modify thresholds
- Contact your admin if you need to adjust settings

---

## 📞 Support

For issues or questions:
1. Contact your system administrator
2. Check the machine/tool maintenance pages for more details
3. Review the maintenance history logs

---

**Last Updated:** February 2024
**Version:** 2.0 - All Users Edition
