# 🔧 Tool Norm Value Setup Guide

## Where to Set Tool Norm Rates in Admin

### Step 1: Open Manage Fields Page
- Go to Admin Dashboard → **Manage Fields**
- You'll see a list of all form fields

### Step 2: Locate Your TOOL Field
- Look for the field labeled **"TOOL NO"** (or your custom tool field name)
- It will have a green badge saying **"MAIN CATEGORY"**

### Step 3: Click "Data" Button
- On the TOOL field row, click the blue **"Data"** button
- A modal window will open titled "Manage Dropdown Data"

### Step 4: Configure Tool Norm Rates
The modal now shows:

#### **📋 Tool Norm Configuration Box** (Green box at top)
- Explains what tool norms are
- Shows an example calculation
- Only appears for TOOL fields

#### **➕ Add New Option Section**
Fields for adding new tools:
- **Option Name**: Enter the tool name (e.g., "Drilling", "Milling")
- **Norm/Rate**: Enter the norm rate (e.g., 5, 10, 15)
- Click **"Add"** button

#### **📊 Existing Options List**
Shows all previously added tools with:
- Tool name
- Current norm rate
- **"Edit Rate"** button to change the norm
- **Delete** button to remove

---

## Example Setup

### Scenario: You have 3 tools
| Tool | Norm Rate | Meaning |
|------|-----------|---------|
| Drilling | 5 | 5 norms per hour |
| Milling | 8 | 8 norms per hour |
| Turning | 6 | 6 norms per hour |

### Steps:
1. Click **"Data"** on TOOL NO field
2. Add "Drilling" with norm rate **5**
3. Add "Milling" with norm rate **8**
4. Add "Turning" with norm rate **6**

---

## How It Works in Production Entry

Once norm rates are set:

1. Employee opens **Daily Production Entry** form
2. Selects **"Drilling"** from TOOL dropdown
3. Enters START TIME: **08:00**
4. Enters END TIME: **10:30** (2.5 hours)
5. Duration auto-calculates: **02:30**
6. **Norms auto-calculate:** 2.5 hours × 5 norms/hr = **12.5 → 13 norms** ✅

---

## Editing Existing Tool Norms

### To Change a Tool's Norm Rate:
1. Open Manage Fields → Tool Field → "Data" button
2. Find the tool in the **Existing Options** list
3. Click the **"Edit Rate"** button
4. Enter the new norm rate value
5. Click OK to save

### To Delete a Tool:
1. Open Manage Fields → Tool Field → "Data" button
2. Find the tool in the **Existing Options** list
3. Click the **Delete** button (trash icon)

---

## Common Norm Rate Examples

| Industry | Tool Type | Typical Norm Rate |
|----------|-----------|-------------------|
| Manufacturing | Drilling | 4-6 per hour |
| Manufacturing | Milling | 6-10 per hour |
| Manufacturing | Turning | 5-8 per hour |
| Manufacturing | Assembly | 10-15 per hour |

*Adjust based on your operation's actual production capacity*

---

## 💡 Tips

✅ **DO:**
- Set norm rates based on your operation's average production capacity
- Use decimal values (e.g., 5.5) for fine-tuning
- Review and update norms periodically as efficiency changes
- Ensure consistent naming for the same tool across entries

❌ **DON'T:**
- Set norm rate to 0 (norms won't calculate)
- Leave norm rate blank (field will show "Not set")
- Use negative values

---

## Troubleshooting

**Q: Norms aren't calculating in production entry?**
A: Check that:
- Tool norm rate is set (not blank)
- Duration is calculated (Start and End time are entered)
- Employee selected a tool from dropdown

**Q: Where does it show "Norm Rate: X per hour"?**
A: In the admin modal, each tool shows its rate under "Existing Options"

**Q: Can I change a tool's norm rate later?**
A: Yes! Click "Edit Rate" button on the tool - doesn't affect past entries

