# Tool-Wise Production Analytics Guide

## 📊 Overview

The Tool-Wise Production Analytics feature allows you to analyze production metrics **by individual tools**. Similar to the image you provided, each tool shows 4 bars representing **Plan, Produced, Accepted, and NC** quantities.

---

## 🎯 What's New

### 1. **Tool Selection Dropdown** (Controls Section)
```
📁 Select Tool: [▼ Dropdown with all tools]
```
- Automatically populated from database
- Shows all tools used in production
- Select a tool to see its dedicated analytics
- "All Tools" option shows aggregate view

### 2. **Two New Visualization Sections**

#### **Tool-Wise Production Analytics - Chart**
- **Chart Type:** Grouped Bar Chart (like the image example)
- **Bars per Tool:** 4 bars
  - 🔵 **Blue:** Plan Quantity
  - 🟢 **Green:** Produced Quantity  
  - 🟠 **Orange:** Accepted Quantity
  - 🔴 **Red:** NC Quantity (Non-Conforming)
- **Shows:** Top 15 tools by production volume
- **Height:** 350px (responsive)

#### **Tool-Wise Production Breakdown - Detailed Table**
- **Columns:** 8 columns
  - Tool No
  - Total Entries (work logs for that tool)
  - Plan Qty
  - Produced Qty ✅ (Key metric from your image)
  - Accepted Qty
  - NC Qty (Red highlight)
  - Quality %
  - Efficiency %
- **Rows:** Up to 30 tools
- **Auto-calculated metrics:**
  - Quality % = (Accepted ÷ Produced) × 100
  - Efficiency % = (Produced ÷ Plan) × 100
  - NC Qty = Produced - Accepted

---

## 🔧 How to Use

### **View All Tools Analytics**
```
1. Analytics page loads automatically
2. Tool-Wise chart shows all tools (top 15)
3. Detailed table shows breakdown
4. No selection needed
```

### **Analyze Specific Tool**
```
1. Open analytics.php page
2. Go to "Select Tool:" dropdown (Controls section)
3. Click dropdown → All tools appear
4. Select a tool (e.g., "T001", "LATHE-1")
5. Chart updates to show:
   - 4 bars for that tool (Plan, Produced, Accepted, NC)
   - Detailed metrics in table below
```

### **Compare Multiple Tools**
```
1. Leave "Select Tool" as "All Tools"
2. View chart showing all tools in one view
3. Compare tools side-by-side:
   - Which tool has highest production?
   - Which tool has most rejections (red bars)?
   - Which tool meets plan targets?
```

### **Combine Filters**
```
Example: Analyze Tool T001 in Jan 2026
1. Set Start Date: 2026-01-01
2. Set End Date: 2026-01-31
3. Select Tool: T001
4. Click "Apply All Filters"
→ Shows T001 performance for January only
```

---

## 📈 Understanding the Metrics

### **Quality % (From Your Image)**
```
Formula: (Accepted ÷ Produced) × 100
Target: > 95%
Example: 945 accepted ÷ 987 produced = 95.63% ✅ GOOD
```

### **Efficiency % (From Your Image)**
```
Formula: (Produced ÷ Plan) × 100
Target: > 80%
Example: 987 produced ÷ 1050 plan = 93.89% ✅ EXCELLENT
```

### **NC Qty (Red Numbers)**
```
Formula: Produced - Accepted
Shows: How many items were rejected
Example: 987 produced - 945 accepted = 42 NC items
```

---

## 🎨 Color Legend (Image Reference)

Matches the production analytics image:

| Color | Metric | What It Means |
|-------|--------|--------------|
| 🔵 Blue | Plan Qty | Target quantity for the day/tool |
| 🟢 Green | Produced Qty | Actually produced |
| 🟠 Orange | Accepted Qty | Quality-approved items |
| 🔴 Red | NC Qty | Rejected/non-conforming items |

---

## 📋 Page Layout

### **Order of Sections (Top to Bottom)**

```
1. CONTROLS SECTION
   ├─ Date Range (Start/End)
   ├─ Field Selector
   ├─ Employee Selector
   ├─ 🆕 TOOL SELECTOR ← NEW!
   ├─ Compare Fields
   └─ Apply/Reset buttons

2. STATS CARDS
   ├─ Total Records
   ├─ Active Employees
   └─ Data Points

3. DAY-WISE PRODUCTION CHART
   ├─ 4 bars per day (30 days)
   └─ Detailed table

4. 🆕 TOOL-WISE PRODUCTION CHART ← NEW!
   ├─ 4 bars per tool (top 15)
   └─ Detailed table

5. FIELD/TOOL-WISE CHART
   └─ Top 10 fields/tools

6. EMPLOYEE-WISE TABLE
   └─ Top 15 employees
```

---

## 🔍 Key Features

### **Auto-Population**
✅ Tool dropdown loads all tools from database  
✅ No manual configuration needed  
✅ Updates dynamically with new tools  

### **Interactive**
✅ Select tool → Chart/table updates instantly  
✅ Combine with date range → Filtered analytics  
✅ No page refresh needed  

### **Accurate Calculations**
✅ Server-side SQL aggregation  
✅ Auto-calculated metrics (Quality%, Efficiency%)  
✅ NC highlighted in red for easy spotting  

### **Mobile Responsive**
✅ Controls stack vertically on small screens  
✅ Tables scroll horizontally if needed  
✅ Charts responsive to container size  

---

## 📊 Typical Workflows

### **Workflow 1: Daily Tool Performance Review**
```
1. Open analytics.php
2. Tool-wise chart shows all tools
3. Look at red bars (NC) - identify problem tools
4. Select high-NC tool → Drill down into details
5. Check Quality % → If < 95%, investigate
```

### **Workflow 2: Production Manager Review**
```
1. Set date range for week
2. Apply filters
3. Compare tool performance:
   - Which tools met plan? (Check green/blue bars)
   - Which tools had quality issues? (Check red bars)
4. Select worst performer → Review entries in table
```

### **Workflow 3: Capacity Planning**
```
1. View all tools chart (no filters)
2. Compare efficiency % across tools
3. Identify underutilized tools (low Efficiency%)
4. Plan maintenance for worst performers
```

### **Workflow 4: Quality Analysis**
```
1. Sort by Quality % (lowest first)
2. Tools with Quality% < 90% = Problem tools
3. Select tool → See rejected item count (NC Qty)
4. Investigate quality issues for that tool
```

---

## 🎓 For Different Users

### **Production Manager**
- **Use:** Tool-wise chart to monitor all tools
- **Look for:** Red bars (NC) and low Efficiency%
- **Action:** Select high-NC tools for investigation

### **Quality Assurance**
- **Use:** Quality% column in table
- **Look for:** Tools with Quality% < 95%
- **Action:** Review rejected items (NC Qty) by tool

### **Operations**
- **Use:** Efficiency% to track production targets
- **Look for:** Tools not meeting efficiency targets
- **Action:** Plan maintenance for underperforming tools

### **Executive**
- **Use:** All tools view for overall assessment
- **Look for:** Trends across tools
- **Action:** Resource allocation based on performance

---

## 🐛 Troubleshooting

### **Tool Dropdown Empty?**
- Refresh page (Ctrl+R)
- Check database has production_logs entries
- Verify tool_no column is populated

### **Chart Not Showing?**
- Wait 2-3 seconds (data loading)
- Check browser console (F12) for errors
- Refresh page if stuck

### **No Data for Selected Tool?**
- Tool may have no recent entries
- Try different tool
- Check date range doesn't exclude data

### **Metrics Look Wrong?**
- Refresh page
- Check database has complete data (plan_qty, produced_qty, accepted_qty)
- Verify calculations: Quality% = (Accepted ÷ Produced) × 100

---

## 💻 Technical Details

### **New API Endpoints**
```
GET api.php?action=get_all_tools
├─ Returns: All tools in database
└─ Used: Populate tool dropdown

GET api.php?action=get_all_tool_production_analytics
├─ Returns: All tools with aggregated metrics
└─ Used: Tool-wise chart (default view)

GET api.php?action=get_tool_production_analytics&tool_no=T001
├─ Returns: Specific tool production data
└─ Used: When tool selected from dropdown
```

### **New JavaScript Functions**
```
populateToolDropdown()
├─ Loads all tools from database
└─ Runs on page initialization

analyzeToolData()
├─ Triggered when tool is selected
└─ Updates chart and table

fetchToolWiseAnalytics(toolName, callback)
├─ Fetches tool production data
└─ Calls API with optional tool_no parameter

renderToolWiseChart(containerId, data)
├─ Renders grouped bar chart
└─ 4 bars per tool (Plan, Produced, Accepted, NC)

renderToolWiseBreakdownTable(containerId, data)
├─ Renders detailed table
└─ 8 columns with auto-calculated metrics
```

### **Database Query**
```sql
SELECT 
  tool_no,
  COUNT(*) as total_entries,
  SUM(plan_qty) as total_plan_qty,
  SUM(produced_qty) as total_produced_qty,
  SUM(accepted_qty) as total_accepted_qty,
  ROUND((SUM(accepted_qty) / SUM(produced_qty)) * 100, 2) as quality_percent,
  ROUND((SUM(produced_qty) / SUM(plan_qty)) * 100, 2) as efficiency_percent
FROM production_logs
GROUP BY tool_no
ORDER BY total_produced_qty DESC
```

---

## ✅ Verification Checklist

- [ ] Tool dropdown populated with tools from database
- [ ] Tool-wise chart displays with 4 bars per tool
- [ ] Table shows 8 columns (Tool No, Entries, Plan, Produced, Accepted, NC, Quality%, Efficiency%)
- [ ] Red highlighting appears in NC Qty column
- [ ] Selecting tool updates chart/table
- [ ] Quality % > 95% for good tools
- [ ] Efficiency % > 80% for good tools
- [ ] Date filters work with tool selection
- [ ] "All Tools" shows aggregate view
- [ ] Mobile responsive design works

---

## 🚀 Feature Highlights

✨ **Just Like the Image You Provided:**
- Bar chart with 4 bars per item (Plan, Produced, Accepted, NC)
- Detailed breakdown table with all metrics
- Quality and Efficiency percentages
- Color-coded bars (blue, green, orange, red)
- Responsive design

📊 **On Analytics Page:**
- Section 1: Day-Wise Analytics (days as X-axis)
- Section 2: Tool-Wise Analytics (tools as X-axis) ← NEW!
- Section 3: Field-Wise Analytics (fields as X-axis)
- Section 4: Employee-Wise Analytics (employees as X-axis)

🎯 **User Benefit:**
- Compare production across all tools in one view
- Drill down into specific tool performance
- Identify quality and efficiency issues
- Make data-driven decisions

---

## 📞 Support

**For detailed charts help:**
- See: ANALYTICS_VISUAL_GUIDE.md

**For technical documentation:**
- See: COMPLETE_ANALYTICS_IMPLEMENTATION.md

**For quick reference:**
- See: ANALYTICS_QUICK_USER_GUIDE.md

---

**Status: ✅ READY TO USE**

Navigate to: `http://localhost/erp.manufacture/analytics.php`

The Tool-Wise Analytics feature is now fully integrated and operational!
