<?php
// Test notifications API
include 'db.php';

// Test 1: Check if tables exist
echo "=== DATABASE STRUCTURE TEST ===\n\n";

try {
    // Check custom_fields
    $result = $pdo->query('SELECT COUNT(*) as count FROM custom_fields');
    $count = $result->fetch();
    echo "✓ custom_fields table exists (" . $count['count'] . " records)\n";
    
    // Check field_options
    $result = $pdo->query('SELECT COUNT(*) as count FROM field_options');
    $count = $result->fetch();
    echo "✓ field_options table exists (" . $count['count'] . " records)\n";
    
    // Check notification_settings
    $result = $pdo->query('SELECT COUNT(*) as count FROM notification_settings');
    $count = $result->fetch();
    echo "✓ notification_settings table exists (" . $count['count'] . " records)\n";
    
} catch (Exception $e) {
    echo "✗ Error: " . $e->getMessage() . "\n";
    exit;
}

echo "\n=== MACHINES CHECK ===\n\n";

// Find machine field
$machineFieldStmt = $pdo->prepare("SELECT id, field_label FROM custom_fields WHERE field_label LIKE '%M/C%' OR field_label LIKE '%Machine%' LIMIT 1");
$machineFieldStmt->execute();
$machineField = $machineFieldStmt->fetch();

if ($machineField) {
    echo "Machine field found: " . $machineField['field_label'] . " (ID: " . $machineField['id'] . ")\n";
    
    $machines = $pdo->prepare("SELECT id, label, last_service, life_limit FROM field_options WHERE field_id = ?");
    $machines->execute([$machineField['id']]);
    $machineCount = $machines->rowCount();
    
    echo "Total machines: " . $machineCount . "\n";
    
    if ($machineCount > 0) {
        echo "\nSample machines:\n";
        $machines = $pdo->prepare("SELECT id, label, last_service, life_limit FROM field_options WHERE field_id = ? LIMIT 3");
        $machines->execute([$machineField['id']]);
        while ($machine = $machines->fetch()) {
            echo "  - " . $machine['label'] . " (Last service: " . $machine['last_service'] . ", Interval: " . $machine['life_limit'] . " months)\n";
        }
    }
} else {
    echo "No machine field found in database\n";
}

echo "\n=== TOOLS CHECK ===\n\n";

// Find tool field
$toolFieldStmt = $pdo->prepare("SELECT id, field_label FROM custom_fields WHERE field_label LIKE '%Tool%' LIMIT 1");
$toolFieldStmt->execute();
$toolField = $toolFieldStmt->fetch();

if ($toolField) {
    echo "Tool field found: " . $toolField['field_label'] . " (ID: " . $toolField['id'] . ")\n";
    
    $tools = $pdo->prepare("SELECT id, label, current_usage, life_limit FROM field_options WHERE field_id = ?");
    $tools->execute([$toolField['id']]);
    $toolCount = $tools->rowCount();
    
    echo "Total tools: " . $toolCount . "\n";
    
    if ($toolCount > 0) {
        echo "\nSample tools:\n";
        $tools = $pdo->prepare("SELECT id, label, current_usage, life_limit FROM field_options WHERE field_id = ? LIMIT 3");
        $tools->execute([$toolField['id']]);
        while ($tool = $tools->fetch()) {
            $remaining = intval($tool['life_limit']) - intval($tool['current_usage']);
            $percent = intval($tool['life_limit']) > 0 ? round((intval($tool['current_usage']) / intval($tool['life_limit'])) * 100, 1) : 0;
            echo "  - " . $tool['label'] . " (Usage: " . intval($tool['current_usage']) . " / " . intval($tool['life_limit']) . " = " . $percent . "%)\n";
        }
    }
} else {
    echo "No tool field found in database\n";
}

echo "\n=== NOTIFICATION SETTINGS ===\n\n";

$settings = $pdo->query("SELECT setting_key, setting_value FROM notification_settings");
while ($setting = $settings->fetch()) {
    echo $setting['setting_key'] . ": " . $setting['setting_value'] . "\n";
}

echo "\n✓ All database checks complete!\n";
?>
