<?php
/**
 * Notification System - Complete Verification & Setup
 * Run this script to verify and fix all notification system issues
 */

  $host = 'localhost'; 
    $db = 'zemaraim_mektron_db'; 
    $user = 'zemaraim'; 
    $pass = '8wwxk]-X3Kx]CJ]5';

echo "================================================\n";
echo "NOTIFICATION SYSTEM VERIFICATION & SETUP\n";
echo "================================================\n\n";

try {
    // Step 1: Database Connection
    echo "[1] Testing database connection...\n";
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8mb4", $user, $pass, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
    ]);
    echo "✓ Database connection successful\n\n";

    // Step 2: Check/Create notification_settings table
    echo "[2] Checking notification_settings table...\n";
    $tableCheck = $pdo->query("SHOW TABLES LIKE 'notification_settings'");
    $tableExists = $tableCheck->rowCount() > 0;

    if (!$tableExists) {
        echo "⚠ Table does not exist, creating...\n";
        $createTableSQL = "CREATE TABLE `notification_settings` (
            `id` INT AUTO_INCREMENT PRIMARY KEY,
            `setting_key` VARCHAR(100) UNIQUE NOT NULL,
            `setting_value` VARCHAR(255) NOT NULL,
            `description` TEXT,
            `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
        
        $pdo->exec($createTableSQL);
        echo "✓ Table created successfully\n";
    } else {
        echo "✓ Table already exists\n";
    }

    // Step 3: Verify table structure
    echo "\n[3] Verifying table structure...\n";
    $columnCheck = $pdo->query("SHOW COLUMNS FROM notification_settings");
    $columns = [];
    while ($col = $columnCheck->fetch()) {
        $columns[] = $col['Field'];
        echo "  - {$col['Field']}: {$col['Type']}\n";
    }

    $requiredColumns = ['id', 'setting_key', 'setting_value', 'created_at', 'updated_at'];
    $missingColumns = array_diff($requiredColumns, $columns);
    
    if (!empty($missingColumns)) {
        echo "✗ Missing columns: " . implode(', ', $missingColumns) . "\n";
    } else {
        echo "✓ All required columns present\n";
    }

    // Step 4: Check for default data
    echo "\n[4] Checking for default settings...\n";
    $countStmt = $pdo->query("SELECT COUNT(*) as count FROM notification_settings");
    $count = $countStmt->fetch()['count'];
    echo "  Current records: $count\n";

    if ($count == 0) {
        echo "⚠ No settings found, inserting defaults...\n";
        $insertSQL = "INSERT INTO `notification_settings` (`setting_key`, `setting_value`, `description`) VALUES 
        (?, ?, ?),
        (?, ?, ?)";

        $stmt = $pdo->prepare($insertSQL);
        $stmt->execute([
            'machine_days_threshold', '15', 'Number of days before machine maintenance due to trigger alert',
            'tool_strokes_threshold', '1000', 'Number of remaining strokes before tool alert is triggered'
        ]);
        echo "✓ Default settings inserted\n";
    } else {
        echo "✓ Settings already exist\n";
    }

    // Step 5: Display current settings
    echo "\n[5] Current notification settings:\n";
    $settingsStmt = $pdo->query("SELECT setting_key, setting_value FROM notification_settings ORDER BY id");
    while ($setting = $settingsStmt->fetch()) {
        echo "  {$setting['setting_key']}: {$setting['setting_value']}\n";
    }

    // Step 6: Test UPDATE functionality
    echo "\n[6] Testing UPDATE functionality...\n";
    $testValue = 20;
    $updateStmt = $pdo->prepare("UPDATE notification_settings SET setting_value = ? WHERE setting_key = ?");
    $updateStmt->execute([$testValue, 'machine_days_threshold']);
    
    if ($updateStmt->rowCount() > 0) {
        echo "✓ UPDATE works correctly (rows affected: " . $updateStmt->rowCount() . ")\n";
        
        // Revert test change
        $revertStmt = $pdo->prepare("UPDATE notification_settings SET setting_value = ? WHERE setting_key = ?");
        $revertStmt->execute(['15', 'machine_days_threshold']);
        echo "✓ Reverted test change\n";
    } else {
        echo "✗ UPDATE failed or no rows matched\n";
    }

    // Step 7: Test INSERT functionality
    echo "\n[7] Testing INSERT functionality...\n";
    $testInsertStmt = $pdo->prepare("INSERT INTO notification_settings (setting_key, setting_value, description) VALUES (?, ?, ?)");
    try {
        $testInsertStmt->execute(['test_setting', '999', 'Test setting']);
        
        // Delete test record
        $deleteStmt = $pdo->prepare("DELETE FROM notification_settings WHERE setting_key = ?");
        $deleteStmt->execute(['test_setting']);
        echo "✓ INSERT works correctly\n";
    } catch (Exception $e) {
        echo "✗ INSERT test failed: " . $e->getMessage() . "\n";
    }

    // Step 8: Verify related tables
    echo "\n[8] Verifying related tables...\n";
    $tables = ['custom_fields', 'field_options', 'machines'];
    foreach ($tables as $table) {
        $tableCheck = $pdo->query("SHOW TABLES LIKE '$table'");
        if ($tableCheck->rowCount() > 0) {
            $countStmt = $pdo->query("SELECT COUNT(*) as count FROM `$table`");
            $count = $countStmt->fetch()['count'];
            echo "✓ $table exists ($count records)\n";
        } else {
            echo "⚠ $table not found\n";
        }
    }

    // Step 9: Test session
    echo "\n[9] Session information:\n";
    session_start();
    echo "  Session ID: " . session_id() . "\n";
    echo "  User role: " . ($_SESSION['role'] ?? 'Not set') . "\n";
    echo "  Is admin: " . (isset($_SESSION['role']) && $_SESSION['role'] === 'admin' ? 'Yes' : 'No') . "\n";

    // Summary
    echo "\n================================================\n";
    echo "✓ VERIFICATION COMPLETE\n";
    echo "================================================\n\n";
    echo "Next steps:\n";
    echo "1. Log in to the system as an admin\n";
    echo "2. Click the notification bell icon\n";
    echo "3. Click 'Settings' button\n";
    echo "4. Modify the threshold values\n";
    echo "5. Click 'Save Settings'\n";
    echo "6. Check browser console (F12) for logs\n";
    echo "7. Monitor network requests in DevTools\n\n";

} catch (Exception $e) {
    echo "\n✗ ERROR: " . $e->getMessage() . "\n";
    echo "\nTroubleshooting:\n";
    echo "1. Verify database credentials in this script\n";
    echo "2. Check if MySQL is running\n";
    echo "3. Verify database '" . $db . "' exists\n";
    echo "4. Check file permissions\n";
}
?>
