# Gallery Management System - Visual Architecture

## System Flow Diagram

```
┌─────────────────────────────────────────────────────────────────┐
│                    RESTAURANT GALLERY SYSTEM                      │
└─────────────────────────────────────────────────────────────────┘

┌─────────────────────────┐         ┌──────────────────────────────┐
│   ADMIN PANEL           │         │  PUBLIC WEBSITE              │
│   (admin/gallery.php)   │         │  (gallery.php)               │
├─────────────────────────┤         ├──────────────────────────────┤
│                         │         │                              │
│ 1. ADD IMAGE            │──────┐  │ 1. DISPLAY IMAGES            │
│   ├─ Title input        │      │  │   └─ From database           │
│   ├─ Category select    │      │  │                              │
│   ├─ File upload        │      └──→ 2. FILTER BY CATEGORY       │
│   └─ Submit button      │         │   ├─ Food                   │
│                         │         │   ├─ Events                 │
│ 2. VIEW IMAGES          │         │   └─ Staff                  │
│   ├─ Table list         │         │                              │
│   ├─ Thumbnails        │         │ 3. LIGHTBOX PREVIEW         │
│   └─ Date added        │         │   └─ PhotoSwipe             │
│                         │         │                              │
│ 3. EDIT IMAGE           │         │ 4. RESPONSIVE DESIGN        │
│   ├─ Update title       │         │   ├─ Desktop (1200px+)      │
│   ├─ Change category    │         │   ├─ Tablet (768px)         │
│   └─ Save changes       │         │   └─ Mobile (480px)         │
│                         │         │                              │
│ 4. DELETE IMAGE         │         └──────────────────────────────┘
│   ├─ Confirm dialog     │
│   ├─ Delete from DB     │
│   └─ Remove from server │
│                         │
└─────────────────────────┘
         │
         │ (Image Upload)
         ▼
┌─────────────────────────────────────────┐
│  DATABASE (bermiz_db)                   │
├─────────────────────────────────────────┤
│  gallery table:                         │
│  ├─ id (INT, PK)                        │
│  ├─ title (VARCHAR 255)                 │
│  ├─ category (food/events/staff)        │
│  ├─ image_path (assets/images/...)      │
│  ├─ created_date (TIMESTAMP)            │
│  └─ updated_date (TIMESTAMP)            │
└─────────────────────────────────────────┘
         │
         │ (Image File)
         ▼
┌─────────────────────────────────────────┐
│  FILE SYSTEM                            │
├─────────────────────────────────────────┤
│  assets/images/gallery/                 │
│  ├─ 1704067200_a3f4b2c1.jpg             │
│  ├─ 1704067201_b5f7d3e2.png             │
│  ├─ 1704067202_c8a9f4g3.jpg             │
│  └─ ... (more images)                   │
└─────────────────────────────────────────┘
```

---

## Data Flow

### Adding an Image

```
Admin enters data:
│
├─ Title: "Spicy Biryani"
├─ Category: "food"
└─ File: biryani.jpg
│
▼
Validation:
├─ ✓ Title not empty
├─ ✓ Category valid (food/events/staff)
├─ ✓ File is image (JPG/PNG/GIF/WebP)
└─ ✓ Size < 5MB
│
▼
Processing:
├─ Generate unique name: 1704067200_a3f4b2c1.jpg
├─ Move file to: assets/images/gallery/
└─ Insert to database:
   INSERT INTO gallery (title, category, image_path)
   VALUES ("Spicy Biryani", "food", "assets/images/gallery/1704067200_a3f4b2c1.jpg")
│
▼
Result:
├─ File stored on server ✓
├─ Record in database ✓
└─ Visible on website ✓
```

### Editing an Image

```
Admin clicks "Edit":
│
▼
Modal shows:
├─ Current title
└─ Current category
│
▼
Admin changes:
├─ New title: "Fragrant Biryani"
└─ New category: "events"
│
▼
Update database:
UPDATE gallery SET title = ?, category = ? WHERE id = ?
│
▼
Result:
└─ Website updates instantly ✓
```

### Deleting an Image

```
Admin clicks "Delete":
│
▼
Confirmation dialog:
├─ "Are you sure?"
└─ Buttons: [Delete] [Cancel]
│
▼
If confirmed:
│
├─ Delete from database:
│  DELETE FROM gallery WHERE id = ?
│
├─ Delete file from server:
│  rm assets/images/gallery/1704067200_a3f4b2c1.jpg
│
▼
Result:
├─ Database: Record gone ✓
├─ Server: File deleted ✓
└─ Website: Image removed ✓
```

---

## File Structure

```
hotel/
│
├── admin/
│   ├── gallery.php ......................... Admin management panel
│   ├── gallery_setup.sql .................. Database setup script
│   ├── GALLERY_DOCUMENTATION.md .......... Full documentation
│   ├── sidebar.php ........................ Navigation (has gallery link)
│   └── index.php .......................... Dashboard (has gallery action)
│
├── gallery.php ............................ Public website gallery
│
├── assets/
│   ├── images/
│   │   ├── gallery/ ...................... Uploaded images (auto-created)
│   │   │   ├── 1704067200_a3f4b2c1.jpg
│   │   │   ├── 1704067201_b5f7d3e2.png
│   │   │   └── ...
│   │   ├── menupage-6/ .................. Original images (fallback)
│   │   └── chefspage2/ .................. Original images (fallback)
│   └── css/
│       └── style.css ..................... Contains gallery styling
│
├── db_connect.php ......................... Database connection
│
├── GALLERY_QUICK_START.md ................ Quick start guide
├── GALLERY_IMPLEMENTATION_SUMMARY.md .... Implementation details
└── README files
```

---

## User Interface Layout

### Admin Panel - Add Image Section

```
╔════════════════════════════════════════════════════════════╗
║  ☰ Gallery Management                  ← Back to Dashboard ║
╚════════════════════════════════════════════════════════════╝

╔════════════════════════════════════════════════════════════╗
║ ✓ Success: Image added successfully!                  ✕  ║
╚════════════════════════════════════════════════════════════╝

┌────────────────────────────────────────────────────────────┐
│ Add New Gallery Image                                      │
├────────────────────────────────────────────────────────────┤
│                                                            │
│ Image Title *                                             │
│ ┌──────────────────────────────────────────────────────┐  │
│ │ Enter image title...                                 │  │
│ └──────────────────────────────────────────────────────┘  │
│                                                            │
│ Category *                     File *                     │
│ ┌──────────────────────────┐  ┌──────────────────────┐  │
│ │ [Select Category] ▼      │  │ 📤 Click to upload   │  │
│ │ - Food                   │  │    or drag image     │  │
│ │ - Ambience & Events      │  │ Max 5MB              │  │
│ │ - Staff                  │  │                      │  │
│ └──────────────────────────┘  └──────────────────────┘  │
│                                                            │
│                    ┌──────────────────┐                   │
│                    │ Add Image        │                   │
│                    └──────────────────┘                   │
│                                                            │
└────────────────────────────────────────────────────────────┘
```

### Admin Panel - Gallery Table

```
┌────────────────────────────────────────────────────────────┐
│ All Gallery Images                                         │
├────────────────────────────────────────────────────────────┤
│                                                            │
│ Image  │ Title          │ Category │ Date Added │ Actions  │
├────────┼────────────────┼──────────┼────────────┼──────────┤
│ [IMG]  │ Spicy Biryani  │ FOOD     │ Jan 1,24  │ 👁 📝 🗑 │
│ [IMG]  │ Restaurant     │ EVENTS   │ Jan 2,24  │ 👁 📝 🗑 │
│ [IMG]  │ Head Chef      │ STAFF    │ Jan 3,24  │ 👁 📝 🗑 │
│                                                            │
└────────────────────────────────────────────────────────────┘
```

### Edit Modal

```
╔════════════════════════════════════════════════════════════╗
║ Edit Gallery Image                                    ✕   ║
╠════════════════════════════════════════════════════════════╣
║                                                            ║
║ Image Title *                                             ║
║ ┌──────────────────────────────────────────────────────┐  ║
║ │ Spicy Biryani                                        │  ║
║ └──────────────────────────────────────────────────────┘  ║
║                                                            ║
║ Category *                                                ║
║ ┌──────────────────────────────────────────────────────┐  ║
║ │ [food] ▼                                             │  ║
║ │ - Food                                               │  ║
║ │ - Ambience & Events                                  │  ║
║ │ - Staff                                              │  ║
║ └──────────────────────────────────────────────────────┘  ║
║                                                            ║
║               ┌──────────────────────┐                    ║
║               │ Save Changes         │                    ║
║               └──────────────────────┘                    ║
║                                                            ║
╚════════════════════════════════════════════════════════════╝
```

---

## Category Badge Colors

```
┌──────────────────────────────────────┐
│ FOOD              │ RED              │ #ff6b6b
├──────────────────────────────────────┤
│ AMBIENCE & EVENTS │ BLUE             │ #4a90e2
├──────────────────────────────────────┤
│ STAFF             │ GREEN            │ #84cc16
└──────────────────────────────────────┘
```

---

## Website Gallery Display

```
╔════════════════════════════════════════════════════════════╗
║                     Our Gallery                           ║
║    A glimpse of our food, ambience, events & team        ║
╚════════════════════════════════════════════════════════════╝

Filter Buttons:
┌──────┐ ┌──────┐ ┌──────────┐ ┌──────┐
│ All  │ │ Food │ │ Ambience │ │Staff │
└──────┘ └──────┘ └──────────┘ └──────┘

Gallery Grid:
┌──────────┬──────────┬──────────┐
│          │          │          │
│ Image 1  │ Image 2  │ Image 3  │
│          │          │          │
├──────────┼──────────┼──────────┤
│          │          │          │
│ Image 4  │ Image 5  │ Image 6  │
│          │          │          │
└──────────┴──────────┴──────────┘

Click any image → Lightbox Preview:

╔════════════════════════════════════════════════════════════╗
║                                                        ✕   ║
║                                                            ║
║                    ┌───────────────┐                       ║
║                    │               │                       ║
║                    │   Large       │                       ║
║                    │   Image       │                       ║
║                    │               │                       ║
║                    └───────────────┘                       ║
║                                                            ║
║               (Click outside to close)                     ║
╚════════════════════════════════════════════════════════════╝
```

---

## Security Layers

```
┌─────────────────────────────────────────────────────────────┐
│                    SECURITY LAYERS                          │
├─────────────────────────────────────────────────────────────┤
│                                                             │
│ 1. AUTHENTICATION                                           │
│    └─ Admin login required (check_admin.php)               │
│                                                             │
│ 2. INPUT VALIDATION                                         │
│    ├─ Title: Required, not empty                           │
│    ├─ Category: Must be food/events/staff                  │
│    └─ File: Only images allowed                            │
│                                                             │
│ 3. FILE VALIDATION                                          │
│    ├─ MIME type: image/jpeg, image/png, etc.              │
│    ├─ Size limit: 5MB maximum                              │
│    └─ Extension check                                      │
│                                                             │
│ 4. DATABASE SECURITY                                        │
│    └─ Prepared statements (prevent SQL injection)          │
│                                                             │
│ 5. XSS PROTECTION                                           │
│    └─ htmlspecialchars() on all output                     │
│                                                             │
│ 6. FILE NAMING                                              │
│    └─ Random names: timestamp_randomstring.ext             │
│                                                             │
│ 7. CONFIRMATION DIALOGS                                     │
│    └─ Delete operations require confirmation               │
│                                                             │
└─────────────────────────────────────────────────────────────┘
```

---

## Responsive Breakpoints

```
┌──────────────────────────────────────────────────────┐
│             RESPONSIVE DESIGN                        │
├──────────────────────────────────────────────────────┤
│                                                      │
│ DESKTOP (1200px+)                                    │
│ ┌─────────────┬─────────────┬─────────────────────┐ │
│ │ Title       │ Category    │ Actions            │ │
│ ├─────────────┼─────────────┼─────────────────────┤ │
│ │ Biryani     │ FOOD        │ [View] [Edit] [Del]│ │
│ └─────────────┴─────────────┴─────────────────────┘ │
│                                                      │
│ TABLET (768px)                                       │
│ ┌─────────────────┬─────────────────────────────────┐│
│ │ Title           │ [View] [Edit] [Delete]         ││
│ │ Category: FOOD  │ Date: Jan 1, 24                ││
│ └─────────────────┴─────────────────────────────────┘│
│                                                      │
│ MOBILE (480px)                                       │
│ ┌───────────────────────────────────────────────────┐│
│ │ [Image Thumbnail]                                ││
│ │ Biryani                                           ││
│ │ FOOD Badge                                        ││
│ │ Jan 1, 24                                         ││
│ │ ┌─────────────────────────────────────────────┐ ││
│ │ │ [View]                                      │ ││
│ │ ├─────────────────────────────────────────────┤ ││
│ │ │ [Edit]                                      │ ││
│ │ ├─────────────────────────────────────────────┤ ││
│ │ │ [Delete]                                    │ ││
│ │ └─────────────────────────────────────────────┘ ││
│ └───────────────────────────────────────────────────┘│
│                                                      │
└──────────────────────────────────────────────────────┘
```

---

## Integration Points

```
Admin Panel                Public Website
(admin/gallery.php)        (gallery.php)
        │                          │
        └──────────────┬───────────┘
                       │
                       ▼
          ┌─────────────────────────┐
          │   Database (gallery)    │
          │   - title               │
          │   - category            │
          │   - image_path          │
          │   - dates               │
          └─────────────────────────┘
                       │
                       ▼
          ┌─────────────────────────┐
          │  File System            │
          │  /assets/images/gallery/│
          │  - image1.jpg           │
          │  - image2.png           │
          │  - image3.gif           │
          └─────────────────────────┘
```

---

## Operation Timeline

```
1. Admin Logs In
   │
   ▼
2. Clicks "Gallery" in Sidebar
   │
   ▼
3. Lands on admin/gallery.php
   │
   ├─ Page loads gallery images from database
   ├─ Displays in table with thumbnails
   └─ Shows upload form at top
   │
   ▼
4. Admin Adds Image
   ├─ Fills title, category, uploads file
   ├─ Page validates inputs
   ├─ Moves file to assets/images/gallery/
   ├─ Inserts record into gallery table
   └─ Success message displayed
   │
   ▼
5. Website Auto-Updates
   ├─ gallery.php queries database
   ├─ Fetches all images from gallery table
   ├─ Displays with category filter
   └─ Image visible immediately
   │
   ▼
6. Admin Edits/Deletes
   ├─ Can change title or category
   ├─ Can delete with confirmation
   ├─ Website reflects changes instantly
   └─ Back to step 4 for more images
```

---

*Gallery System Architecture v1.0*
