# Gallery Management System - Testing Checklist

## Pre-Testing Setup

- [ ] Admin user logged in
- [ ] Database connection working
- [ ] `assets/images/gallery/` directory exists or can be created
- [ ] Adequate disk space available (minimum 500MB recommended)

---

## Phase 1: Database Setup

### Database Table Creation
- [ ] Navigate to `admin/gallery.php`
- [ ] Check if gallery table is auto-created
- [ ] Verify table in phpMyAdmin:
  - [ ] Table name: `gallery`
  - [ ] Column: `id` (INT, Primary Key, Auto Increment)
  - [ ] Column: `title` (VARCHAR 255)
  - [ ] Column: `category` (VARCHAR 50)
  - [ ] Column: `image_path` (VARCHAR 255)
  - [ ] Column: `created_date` (TIMESTAMP)
  - [ ] Column: `updated_date` (TIMESTAMP)

### Database Connection
- [ ] `db_connect.php` properly configured
- [ ] Database user has INSERT permissions
- [ ] Database user has UPDATE permissions
- [ ] Database user has DELETE permissions
- [ ] Database user has SELECT permissions

---

## Phase 2: Admin Interface Testing

### Navigation
- [ ] Gallery link appears in admin sidebar
- [ ] Gallery link is clickable
- [ ] "Manage Gallery" button appears in dashboard
- [ ] Both links open `admin/gallery.php`
- [ ] Page loads without errors
- [ ] Admin authentication check works

### Form Validation

**Title Field**
- [ ] Placeholder text shows
- [ ] Can type text input
- [ ] Required field works
- [ ] Rejects empty submission

**Category Dropdown**
- [ ] Shows all 3 categories:
  - [ ] Food
  - [ ] Ambience & Events
  - [ ] Staff
- [ ] Required field works
- [ ] Rejects empty submission
- [ ] Can select each option

**File Upload**
- [ ] Upload area is visible
- [ ] Drag-drop zone shows hover effect
- [ ] Can click to select file
- [ ] File input accepts images
- [ ] Shows selected filename
- [ ] Drag-drop works properly

### Image Upload

**Valid Images**
- [ ] Upload JPG image (success)
- [ ] Upload PNG image (success)
- [ ] Upload GIF image (success)
- [ ] Upload WebP image (success)
- [ ] File appears in `assets/images/gallery/`
- [ ] File has unique name (timestamp_random)
- [ ] Image appears in table

**Invalid Images**
- [ ] Reject PDF file (error message)
- [ ] Reject TXT file (error message)
- [ ] Reject EXE file (error message)
- [ ] Reject file >5MB (error message)
- [ ] Show appropriate error message
- [ ] File not stored on server

**Edge Cases**
- [ ] Empty title field (rejected)
- [ ] No category selected (rejected)
- [ ] No file selected (rejected)
- [ ] All fields filled correctly (accepted)

---

## Phase 3: Gallery Table Display

### Table Rendering
- [ ] Table appears below upload form
- [ ] Table headers visible:
  - [ ] Image
  - [ ] Title
  - [ ] Category
  - [ ] Date Added
  - [ ] Actions
- [ ] Responsive on different screen sizes
- [ ] Table doesn't overflow on mobile

### Image Display
- [ ] Thumbnails (80x80px) show correctly
- [ ] Image aspect ratio maintained
- [ ] Placeholder for broken images
- [ ] All uploaded images appear in table
- [ ] Most recent images shown first (DESC order)

### Category Badges
- [ ] Food images show red badge
- [ ] Events images show blue badge
- [ ] Staff images show green badge
- [ ] Badge text is readable
- [ ] Badge formatting consistent

### Date Display
- [ ] Date format: "Mon DD, YYYY"
- [ ] All images show creation date
- [ ] Dates are correct

### Empty State
- [ ] If no images: shows "No gallery images yet" message
- [ ] Message is centered and visible
- [ ] Upload form still works when empty

---

## Phase 4: Edit Functionality

### Edit Button
- [ ] Edit button visible on each image row
- [ ] Edit button is clickable
- [ ] Edit button text and icon visible

### Edit Modal
- [ ] Modal opens when clicking Edit
- [ ] Modal has title "Edit Gallery Image"
- [ ] Modal has close (X) button
- [ ] Modal has Title field pre-filled with current title
- [ ] Modal has Category dropdown pre-selected with current category
- [ ] Modal has "Save Changes" button
- [ ] Modal styling matches overall design

### Edit Operation
- [ ] Change title, save → title updates in table
- [ ] Change category, save → category updates and badge color changes
- [ ] Change both, save → both update correctly
- [ ] Empty title rejected with error
- [ ] Invalid category rejected with error
- [ ] Website gallery updates instantly after edit
- [ ] Date modified timestamp updates in database

### Modal Interactions
- [ ] Can close modal with X button
- [ ] Can close modal by clicking outside
- [ ] Can close modal with Escape key
- [ ] Clicking outside doesn't save
- [ ] Can't edit image file (good for security)

---

## Phase 5: Delete Functionality

### Delete Button
- [ ] Delete button visible on each image row
- [ ] Delete button is clickable
- [ ] Delete button styling (red color)

### Delete Confirmation
- [ ] Clicking Delete shows confirmation dialog
- [ ] Dialog asks "Are you sure?"
- [ ] Dialog has [Delete] and [Cancel] buttons
- [ ] [Cancel] closes dialog without deleting
- [ ] [Delete] removes image

### Delete Operation
- [ ] Record removed from database
- [ ] File deleted from `assets/images/gallery/`
- [ ] Image removed from table immediately
- [ ] Image removed from website gallery immediately
- [ ] Success message displayed
- [ ] No file orphans left on server

### Delete Edge Cases
- [ ] Delete multiple images in succession (works)
- [ ] Delete doesn't affect other images
- [ ] Can't undo delete (by design)
- [ ] Delete with missing file (database only)

---

## Phase 6: View Functionality

### View Button
- [ ] View button visible on each image row
- [ ] View button is clickable
- [ ] Clicking View opens lightbox
- [ ] Lightbox shows full-size image
- [ ] Image is centered in lightbox
- [ ] Close button (X) visible

### Lightbox
- [ ] Background darkened
- [ ] Image scrollable if larger than viewport
- [ ] Can close with X button
- [ ] Can close by clicking outside image
- [ ] Can close with Escape key
- [ ] No scrollbar visible (body overflow hidden)

### Thumbnail Click
- [ ] Clicking thumbnail also opens lightbox
- [ ] Shows same image as View button
- [ ] All lightbox functions work

---

## Phase 7: Website Gallery Integration

### Page Load
- [ ] gallery.php loads without errors
- [ ] Database query executes successfully
- [ ] Images displayed (either from DB or fallback)
- [ ] No PHP errors in browser console

### Display Images
- [ ] All images from gallery table appear
- [ ] Images have correct alt text (title)
- [ ] Image paths are correct
- [ ] Images load and display properly

### Category Classes
- [ ] Food images have class="gallery-item food"
- [ ] Events images have class="gallery-item events"
- [ ] Staff images have class="gallery-item staff"
- [ ] Classes properly set for filtering

### Filter Buttons
- [ ] All filter buttons visible:
  - [ ] All
  - [ ] Food
  - [ ] Ambience & Events
  - [ ] Staff
- [ ] "All" button active by default
- [ ] Clicking Food shows only food images
- [ ] Clicking Events shows only event images
- [ ] Clicking Staff shows only staff images
- [ ] Clicking All shows all images
- [ ] Filter works correctly for multiple images

### Lightbox Preview
- [ ] Clicking image opens lightbox
- [ ] Shows full image preview
- [ ] Close button works
- [ ] Can close with Escape
- [ ] Can close by clicking outside

### Responsive Display
- [ ] Desktop: Grid layout with multiple columns
- [ ] Tablet: Adjusted grid (2-3 columns)
- [ ] Mobile: Single column
- [ ] Images scale appropriately
- [ ] No horizontal scrolling on any device

### Fallback Display
- [ ] If gallery table is empty, shows original images
- [ ] Fallback images display correctly
- [ ] Fallback filtering works
- [ ] User doesn't notice any issues

---

## Phase 8: Responsive Design Testing

### Admin Panel Responsiveness

**Desktop (1200px+)**
- [ ] Full layout with side-by-side elements
- [ ] All buttons and text readable
- [ ] Table columns not cramped

**Tablet (768-1200px)**
- [ ] Form elements stack properly
- [ ] Table still readable
- [ ] Buttons full width or auto width
- [ ] No horizontal scroll

**Mobile (480-768px)**
- [ ] Responsive grid applied
- [ ] Form inputs full width
- [ ] Buttons stack vertically
- [ ] Table columns adjust or scroll

**Small Mobile (320-480px)**
- [ ] All elements readable
- [ ] Text resized appropriately
- [ ] No overlapping elements
- [ ] Touch targets adequate (>44px)

### Website Gallery Responsiveness

**All Breakpoints**
- [ ] Images scale appropriately
- [ ] Filter buttons responsive
- [ ] Grid adjusts for screen size
- [ ] No horizontal overflow
- [ ] Text readable at all sizes

---

## Phase 9: Security Testing

### Authentication
- [ ] Logout first
- [ ] Try to access admin/gallery.php directly
- [ ] Should redirect to login page (not allowed)
- [ ] Login, then access should work

### File Upload Security
- [ ] Try uploading PHP file (rejected)
- [ ] Try uploading HTML file (rejected)
- [ ] Try uploading ZIP file (rejected)
- [ ] Try uploading very large file (rejected)
- [ ] Valid image file accepted

### SQL Injection Prevention
- [ ] Add image with title: `'; DROP TABLE gallery; --`
- [ ] Image added successfully (not executed)
- [ ] Title shows as literal string in table
- [ ] Database not compromised

### XSS Prevention
- [ ] Add image with title: `<script>alert('xss')</script>`
- [ ] No alert box appears
- [ ] Title displays as literal text
- [ ] HTML tags not executed

### File Naming
- [ ] Uploaded files have random names
- [ ] Names format: `timestamp_randomstring.ext`
- [ ] Can't predict filename
- [ ] No directory traversal possible

---

## Phase 10: Error Handling

### Database Errors
- [ ] Kill database connection
- [ ] Try to add image
- [ ] Shows error message (not PHP error)
- [ ] Page doesn't crash
- [ ] User can retry

### File Upload Errors
- [ ] No disk space (simulated)
- [ ] Shows appropriate error
- [ ] Page recovers gracefully
- [ ] User can retry with different file

### Validation Errors
- [ ] Missing title: "Title and Category are required!"
- [ ] Missing category: "Title and Category are required!"
- [ ] Invalid file: "Please select a valid image file!"
- [ ] Wrong format: "Only JPG, PNG, GIF, and WebP..."
- [ ] File too large: "Image size must be less than 5MB!"

---

## Phase 11: Performance Testing

### Page Load
- [ ] Admin panel loads in <2 seconds
- [ ] Gallery with 50 images loads quickly
- [ ] No slow queries in database
- [ ] Images load efficiently

### Image Thumbnails
- [ ] Thumbnails (80x80) load quickly
- [ ] No lazy loading issues
- [ ] No broken image placeholders

### Lightbox Performance
- [ ] Opening lightbox is instant
- [ ] Large images load smoothly
- [ ] No lag when opening/closing

### Database Queries
- [ ] Only one query on page load (SELECT all images)
- [ ] No N+1 query problems
- [ ] Add/Edit/Delete queries optimized

---

## Phase 12: Browser Compatibility

**Chrome/Chromium**
- [ ] All features work
- [ ] Styling looks correct
- [ ] No console errors

**Firefox**
- [ ] All features work
- [ ] Styling looks correct
- [ ] No console errors

**Safari**
- [ ] All features work
- [ ] Styling looks correct
- [ ] No console errors

**Edge**
- [ ] All features work
- [ ] Styling looks correct
- [ ] No console errors

**Mobile Browsers**
- [ ] iOS Safari - works
- [ ] Android Chrome - works
- [ ] Responsive design verified

---

## Phase 13: User Workflow Testing

### Complete User Journey 1: Add & Display
1. [ ] Admin adds image with title "Biryani"
2. [ ] Category: "Food"
3. [ ] File uploaded successfully
4. [ ] Image appears in admin table
5. [ ] Visit website gallery.php
6. [ ] Image visible in Food category
7. [ ] Can preview in lightbox
8. [ ] Filtering works correctly

### Complete User Journey 2: Edit & Update
1. [ ] Admin edits "Biryani" → "Fragrant Biryani"
2. [ ] Changes category to "Events"
3. [ ] Changes saved
4. [ ] Admin table shows updated info
5. [ ] Visit website gallery.php
6. [ ] Image now in Events category
7. [ ] Old title gone
8. [ ] Filter works with new category

### Complete User Journey 3: Delete & Verify
1. [ ] Admin deletes "Fragrant Biryani"
2. [ ] Confirms deletion
3. [ ] Image removed from admin table
4. [ ] Visit website gallery.php
5. [ ] Image no longer visible
6. [ ] Filter buttons still work
7. [ ] Other images unaffected

---

## Phase 14: Documentation Verification

### Documentation Files
- [ ] GALLERY_QUICK_START.md exists and readable
- [ ] GALLERY_DOCUMENTATION.md exists and complete
- [ ] GALLERY_IMPLEMENTATION_SUMMARY.md exists
- [ ] GALLERY_ARCHITECTURE.md exists with diagrams
- [ ] gallery_setup.sql exists with correct schema
- [ ] This checklist file exists

### Documentation Quality
- [ ] Instructions are clear
- [ ] Code examples are correct
- [ ] Troubleshooting section helpful
- [ ] Screenshots would be helpful (optional)
- [ ] FAQ section answers common questions

---

## Phase 15: Accessibility Testing

### Keyboard Navigation
- [ ] Tab through form fields
- [ ] Tab to buttons
- [ ] Enter to submit forms
- [ ] No keyboard traps

### Screen Reader (NVDA/JAWS)
- [ ] Image alt text read correctly
- [ ] Form labels announced
- [ ] Button text clear
- [ ] Table headers announced

### Color Contrast
- [ ] Gold text on dark background has good contrast
- [ ] White text on dark background has good contrast
- [ ] Red button text readable
- [ ] Badge colors not sole indicator

---

## Bugs Found & Fixed

Document any issues found during testing:

| Issue | Severity | Fixed | Notes |
|-------|----------|-------|-------|
|       |          |       |       |
|       |          |       |       |
|       |          |       |       |

---

## Final Sign-Off

- [ ] All phases completed
- [ ] No critical bugs remaining
- [ ] Documentation complete
- [ ] Ready for production
- [ ] User training materials prepared

### Tested By: ___________________
### Date: ___________________
### Approved By: ___________________

---

## Notes & Recommendations

```
[Space for additional notes]
```

---

*Gallery Management System Testing Checklist v1.0*
*Use this checklist before deploying to production*
