# 📧 PHPMailer Gmail Integration - Visual Diagram & Reference

## 🔄 How It Works (Detailed Flow)

```
USER SIDE                          SERVER SIDE                        GMAIL SIDE
─────────────────────────────────────────────────────────────────────────────────

User clicks                         auth.php
"Send OTP"                          receives request
     │                                  │
     │                                  ├─→ Validate email format
     │                                  │   (filter_var FILTER_VALIDATE_EMAIL)
     │                                  │
     │                                  ├─→ Check email not already registered
     │                                  │   (SELECT FROM users)
     │                                  │
     │                                  ├─→ Generate 6-digit OTP
     │                                  │   (random_int 0-999999)
     │                                  │
     │                                  ├─→ Store in database
     │                                  │   INSERT INTO email_otp (
     │                                  │       email, otp, expires_at
     │                                  │   )
     │                                  │
     │                                  └─→ Create PHPMailer instance
     │                                      │
     │                                      ├─ Connect to smtp.gmail.com:587
     │                                      │
     │                                      ├─ Authenticate with:
     │                                      │  Username: your-gmail@gmail.com
     │                                      │  Password: app-password
     │                                      │
     │                                      └─→ Send Email────────────────→ Gmail SMTP
     │                                          (HTML formatted)            │
     │                                          Subject: OTP               │
     │                                          Body: Professional HTML    │
     │                                          Alt: Plain text            │
     │                                          To: user's email           │
     │                                                                      │
     │                                                                      ├─→ Gmail processes
     │                                                                      │   email
     │                                                                      │
     │                                                                      └─→ Delivers to
                                                                               user's inbox
     │
     ├─→ Show success message
     │   "OTP sent successfully!"
     │
     └─→ Display OTP verification form

User receives email
with OTP code ✅
```

---

## 📊 File Structure Diagram

```
your-hotel-project/
│
├── auth.php ✅ MODIFIED
│   ├── PHPMailer imports (lines 3-10)
│   ├── sendOtpEmail() function (lines 48-120) [UPDATED]
│   │   ├── Creates PHPMailer instance
│   │   ├── Sets Gmail SMTP config
│   │   ├── Builds HTML email
│   │   └── Sends via Gmail
│   └── Other actions unchanged
│
├── PHPMailer/ (Already included)
│   ├── src/
│   │   ├── Exception.php
│   │   ├── PHPMailer.php
│   │   └── SMTP.php
│   └── ...
│
├── login.php (Already updated for OTP)
│
├── otp-test.php (Test & debug page)
│
├── db_connect.php (Database connection)
│
└── Documentation:
    ├── README_PHPMAILER_GMAIL.md ← START HERE
    ├── GMAIL_INSTANT_SETUP.txt (3-min quick start)
    ├── GMAIL_SETUP_QUICK.txt (2-min reference)
    ├── PHPMAILER_VISUAL_GUIDE.md (Before/after)
    ├── PHPMAILER_GMAIL_COMPLETE_SUMMARY.md
    ├── GMAIL_PHPMAILER_SETUP.md (Full guide)
    └── OTP_VERIFICATION_CHECKLIST.md (Testing)
```

---

## 🔐 Gmail Credential Flow

```
┌──────────────────────────────────────────────────────────────┐
│  GMAIL SECURITY: 2-FACTOR AUTH + APP PASSWORD               │
└──────────────────────────────────────────────────────────────┘

Your Gmail Account (e.g., bermiz.restaurant@gmail.com)
    │
    ├── Security Setting: 2-Factor Authentication
    │   └── REQUIRED for App Password generation
    │
    └── App Password (16 characters)
        └── Unique token for THIS application only
            (Different from your Gmail login password)
            └── More secure than using actual Gmail password
                (Can be revoked independently)
                └── Can't be used to access other apps


IN auth.php:
┌────────────────────────────────────────────┐
│ $mail->Username = 'bermiz@gmail.com'       │
│ $mail->Password = 'xxxx xxxx xxxx xxxx'    │
│                  (App Password - 16 chars) │
└────────────────────────────────────────────┘
    │
    └──→ Connects to: smtp.gmail.com:587
         │
         ├── Validates username & password
         │
         └── Creates secure connection (TLS encryption)
             │
             └──→ Ready to send emails!
```

---

## 📧 Email Structure Diagram

```
┌────────────────────────────────────────────────────────┐
│            EMAIL PARTS & STRUCTURE                     │
├────────────────────────────────────────────────────────┤
│                                                        │
│ FROM:     Bermiz Restaurant <bermiz@gmail.com>       │
│ TO:       user's-email@domain.com                     │
│ SUBJECT:  Your Bermiz Registration OTP: 456789       │
│                                                        │
│ ┌──────────────────────────────────────────────────┐  │
│ │ HTML BODY (What user sees in email client):      │  │
│ │                                                  │  │
│ │ ╔════════════════════════════════════════════╗  │  │
│ │ ║     🍽️ Bermiz Restaurant                 ║  │  │
│ │ ║        Email Verification                 ║  │  │
│ │ ╚════════════════════════════════════════════╝  │  │
│ │                                                  │  │
│ │ Hello,                                           │  │
│ │                                                  │  │
│ │ Thank you for registering with                   │  │
│ │ Bermiz Restaurant!                               │  │
│ │                                                  │  │
│ │ Your One-Time Password (OTP) for email           │  │
│ │ verification is:                                 │  │
│ │                                                  │  │
│ │ ╔════════════════════════════════════════════╗  │  │
│ │ ║          4 5 6 7 8 9                       ║  │  │
│ │ ║       (Large text, spaced out)             ║  │  │
│ │ ╚════════════════════════════════════════════╝  │  │
│ │                                                  │  │
│ │ ⏰ This OTP is valid for 10 minutes only.       │  │
│ │                                                  │  │
│ │ If you did not request this registration,       │  │
│ │ please ignore this email.                        │  │
│ │                                                  │  │
│ │ Best regards,                                    │  │
│ │ Bermiz Restaurant Team                           │  │
│ │                                                  │  │
│ ├──────────────────────────────────────────────┤  │  │
│ │ © 2025 Bermiz Restaurant. All rights reserved.  │  │
│ │ Do not reply to this email - it is automated.   │  │
│ └──────────────────────────────────────────────┘  │  │
│                                                        │
│ PLAIN TEXT FALLBACK (For old email clients):         │
│ "Your OTP is: 456789                                 │
│  Valid for 10 minutes only.                          │
│  If you didn't request this, ignore this email."    │
│                                                        │
└────────────────────────────────────────────────────────┘
```

---

## 🔄 OTP Database Flow

```
STEP 1: SEND OTP
────────────────
User submits email → OTP generated → Stored in database

┌─────────────────────────────────────────────────────────┐
│ email_otp TABLE                                         │
├────────┬──────┬────────────┬─────────────┬──────────┤
│ ID     │ OTP  │ created_at │ expires_at  │ verified │
├────────┼──────┼────────────┼─────────────┼──────────┤
│ 1      │ 456789│ 10:30:00  │ 10:40:00   │ 0       │ ← New!
└────────┴──────┴────────────┴─────────────┴──────────┘
                                              │
                                              └─→ Not verified yet

         ↓ 10 minutes later if not verified...

         Record expires (10:40:00 passes)


STEP 2: VERIFY OTP
──────────────────
User enters OTP → Database checked → Marked as verified

┌─────────────────────────────────────────────────────────┐
│ email_otp TABLE                                         │
├────────┬──────┬────────────┬─────────────┬──────────┤
│ ID     │ OTP  │ created_at │ expires_at  │ verified │
├────────┼──────┼────────────┼─────────────┼──────────┤
│ 1      │ 456789│ 10:30:00  │ 10:40:00   │ 1       │ ← Updated!
└────────┴──────┴────────────┴─────────────┴──────────┘
                                              │
                                              └─→ Now verified


STEP 3: REGISTRATION COMPLETE
──────────────────────────────
User creates account → User stored → OTP deleted

┌─────────────────────────────────────────────────────────┐
│ email_otp TABLE                                         │
├────────┬──────┬────────────┬─────────────┬──────────┤
│ (empty - record deleted)                              │
└─────────────────────────────────────────────────────────┘

┌──────────────────────────────────────────────────────────┐
│ users TABLE                                              │
├──────┬──────────┬──────────────────────┬────────────┤
│ ID   │ name     │ email                │ password   │
├──────┼──────────┼──────────────────────┼────────────┤
│ 1    │ John Doe │ john@example.com     │ $2y$10... │ ← New!
└──────┴──────────┴──────────────────────┴────────────┘
```

---

## 🚀 Setup Timeline

```
Timeline to get Gmail PHPMailer working:

00:00 - 02:00 ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━ Enable 2FA on Gmail
       (Visit https://myaccount.google.com, set up 2-Step)

02:00 - 03:30 ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━ Create App Password
       (Go to https://myaccount.google.com/apppasswords, generate)

03:30 - 04:30 ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━ Update auth.php
       (Open file, update 3 lines with credentials)

04:30 - 06:00 ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━ Test
       (Send OTP, verify email arrives)

06:00 ✅ DONE - System ready to use!

Total: ~6 minutes
```

---

## 🎯 Key Configuration Points

```
FILE: auth.php
───────────────

Line 66:  $mail->Username   = 'YOUR-GMAIL@gmail.com';
          └─→ Must be complete email address (name@gmail.com)

Line 67:  $mail->Password   = 'XXXX XXXX XXXX XXXX';
          └─→ Must be 16-character App Password
          └─→ Remove spaces when pasting!

Line 72:  $mail->setFrom('YOUR-GMAIL@gmail.com', 'Bermiz Restaurant');
          └─→ Must match line 66 (same Gmail address)

Line 77:  $mail->Subject = 'Your Bermiz Registration OTP: ' . $otp;
          └─→ Can customize subject if desired

Lines 79-115: HTML email template
              └─→ Can customize design/branding if desired
```

---

## 📋 Pre-Flight Checklist

```
BEFORE TESTING:

✅ PHPMailer files present:
   □ PHPMailer/src/Exception.php
   □ PHPMailer/src/PHPMailer.php
   □ PHPMailer/src/SMTP.php

✅ auth.php updated:
   □ PHPMailer imports added (lines 3-10)
   □ sendOtpEmail function replaced (lines 48-120)
   □ Gmail credentials set (lines 66-67)
   □ setFrom email set (line 72)

✅ Gmail account ready:
   □ 2-Factor Authentication enabled
   □ App Password generated (16 chars)
   □ App Password copied (spaces removed)

✅ Files accessible:
   □ login.php loads without errors
   □ otp-test.php loads without errors
   □ db_connect.php working


AFTER FIRST TEST:

✅ OTP sent:
   □ Message "OTP sent successfully" appears
   □ No PHP errors in console

✅ Email received:
   □ Email arrives in 5-10 seconds
   □ Email from "Bermiz Restaurant"
   □ Beautiful HTML formatting
   □ OTP clearly visible

✅ OTP in database:
   □ Record visible in otp-test.php
   □ OTP value correct
   □ expires_at is 10 min in future

✅ Complete flow:
   □ Can verify OTP
   □ Can complete registration
   □ User created in users table
   □ OTP record deleted
   □ Can login with new account
```

---

**Last Updated:** December 24, 2025  
**Version:** Complete Setup Documentation
