# Hero Slider Dynamic Management System

## Overview
The Hero Slider Dynamic Management System allows admins to change hero slider content on the homepage without editing code. This is especially useful during festivals, special events, and seasonal promotions.

## Features

✅ **Dynamic Slide Management**
- Add unlimited hero slides through the admin panel
- Edit existing slides with live preview
- Delete slides with automatic image cleanup
- Toggle slides active/inactive status
- Set custom display order

✅ **Image Management**
- Upload background images for each slide
- Upload optional decorative layer images
- Automatic image optimization and storage
- Old images are automatically deleted when replaced

✅ **Festival & Event Management**
- Perfect for seasonal campaigns (Diwali, Christmas, New Year, etc.)
- Quickly activate/deactivate slides for different events
- Schedule content changes instantly
- Reorder slides on-the-fly

✅ **User-Friendly Admin Interface**
- Split-view form and preview layout
- Real-time image previews
- Activity status badges (Active/Inactive)
- One-click edit and delete actions

---

## Installation

### Step 1: Create Database Table

Run the following SQL query in your database:

```sql
CREATE TABLE IF NOT EXISTS hero_slides (
    id INT AUTO_INCREMENT PRIMARY KEY,
    title VARCHAR(255) NOT NULL,
    description TEXT NOT NULL,
    button_text VARCHAR(100) NOT NULL,
    button_link VARCHAR(255) NOT NULL,
    background_image VARCHAR(255) NOT NULL,
    layer_image VARCHAR(255),
    is_active TINYINT(1) DEFAULT 1,
    display_order INT DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Insert default hero slides
INSERT INTO hero_slides (title, description, button_text, button_link, background_image, layer_image, is_active, display_order) VALUES
('Perfectly Light In Every Bite', 'We create magical flavors with love, passion, and the finest ingredients.', 'Discover Menu', 'menupage-veg.php', 'assets/images/bg/1.jpeg', 'assets/images/layer/1.png', 1, 1),
('Taste That Feels Like Home', 'Crafted with tradition, served with passion — your comfort food awaits.', 'Explore Specials', 'menupage-nonveg.php', 'assets/images/bg/2.png', 'assets/images/layer/2.png', 1, 2),
('Where Every Meal Tells a Story', 'A blend of authentic flavors & modern cooking — made fresh every day.', 'Order Now', 'menupage-nonveg.php', 'assets/images/bg/3.jpeg', 'assets/images/layer/3.png', 1, 3);
```

### Step 2: Check Files Created

The following files have been created/modified:

- ✅ `admin/slider.php` - Admin management interface
- ✅ `index.php` - Updated to load slides from database
- ✅ `admin/sidebar.php` - Added navigation link

### Step 3: Create Slider Upload Directory

The system automatically creates `assets/images/slider/` directory on first use.

---

## Usage

### Access Admin Slider Panel

1. Login to admin panel
2. Go to **Admin Dashboard**
3. Click on **Hero Slider** in the sidebar menu

### Add a New Slide

1. Fill in the form fields:
   - **Slide Title** - Main headline (e.g., "Festival Special Offers")
   - **Description** - Secondary text
   - **Button Text** - CTA button label (e.g., "Order Now")
   - **Button Link** - Page to navigate to (e.g., `menupage-veg.php`)
   - **Background Image** - Upload main background image
   - **Layer Image** - Optional decorative overlay image
   - **Display Order** - Lower numbers appear first
   - **Active on Homepage** - Check to show on homepage

2. Click **Add Slide** button

3. Slide appears immediately on homepage (if marked active)

### Edit a Slide

1. Find the slide in the list
2. Click **Edit** button
3. Modify any fields
4. Upload new images (optional) - old images auto-delete
5. Click **Update Slide**

### Delete a Slide

1. Click **Delete** button next to the slide
2. Confirm deletion
3. Images are automatically removed from server

### Festival/Event Workflow

**During Diwali Festival:**
```
1. Create new slides with festival-themed content
2. Set Display Order to 1 (show first)
3. Mark as Active
4. Old default slides automatically hidden or reordered
```

**During Clearance Sale:**
```
1. Create promotion slides
2. Set high priority (low display order)
3. Activate temporarily
4. Deactivate after sale ends
```

---

## Database Fields Explained

| Field | Type | Purpose |
|-------|------|---------|
| `id` | INT | Unique slide identifier |
| `title` | VARCHAR(255) | Main headline text |
| `description` | TEXT | Subheading/description |
| `button_text` | VARCHAR(100) | CTA button label |
| `button_link` | VARCHAR(255) | Button destination URL |
| `background_image` | VARCHAR(255) | Path to background image |
| `layer_image` | VARCHAR(255) | Path to decorative layer image (optional) |
| `is_active` | TINYINT(1) | 1 = show, 0 = hide |
| `display_order` | INT | Sort order (1-based) |
| `created_at` | TIMESTAMP | When slide was created |
| `updated_at` | TIMESTAMP | Last modification time |

---

## Image Specifications

### Background Image
- **Recommended Size**: 1920x600px (16:10 ratio)
- **File Types**: JPG, PNG, WebP
- **Max Size**: 5MB
- **Format**: Full-width banner image

### Layer/Decorative Image
- **Recommended Size**: 400-500px width
- **File Types**: PNG (for transparency)
- **Max Size**: 2MB
- **Format**: Transparent PNG for best results

---

## Code Changes Made

### index.php
**Before:**
```php
<!-- Hardcoded 3 slides in HTML -->
```

**After:**
```php
<?php
$slides_result = $conn->query("SELECT * FROM hero_slides WHERE is_active = 1 ORDER BY display_order ASC");
// Dynamically generate slides from database
// Fallback to default slides if none exist
?>
```

### admin/sidebar.php
**Added Navigation:**
```php
<li>
    <a href="slider.php" class="<?php echo $current_page == 'slider.php' ? 'active' : ''; ?>">
        <i class="fas fa-images"></i> Hero Slider
    </a>
</li>
```

---

## Festival Campaign Examples

### Diwali Campaign
```
Slide 1: "Celebrate with Delicious Diwali Sweets"
Button: "Order Sweets"
Link: menupage-veg.php

Slide 2: "Diwali Catering Packages Available"
Button: "Book Now"
Link: catering-events.php

Slide 3: "Special Diwali Thali Offers"
Button: "Explore"
Link: menupage-nonveg.php
```

### Christmas Campaign
```
Slide 1: "Festive Christmas Menu is Live"
Button: "Discover Menu"
Link: menupage-veg.php

Slide 2: "Holiday Party Catering"
Button: "Reserve Now"
Link: catering-events.php
```

---

## Troubleshooting

### Images not uploading?
- Check `assets/images/slider/` folder permissions (755)
- Verify file size limits in PHP
- Check browser console for upload errors

### Slides not appearing on homepage?
- Verify slides are marked as "Active"
- Check database connection in `index.php`
- Clear browser cache

### Hero Slider table doesn't exist?
- The system creates it automatically on first access
- Or manually run the SQL setup query provided above

---

## Technical Details

**File Locations:**
- Admin Interface: `/admin/slider.php`
- Upload Directory: `/assets/images/slider/`
- Database Table: `hero_slides`

**Key Functions:**
- Automatic image cleanup on update/delete
- Database-driven ordering system
- Fallback to defaults if no slides exist
- Responsive image handling
- XSS prevention with htmlspecialchars()

**Security:**
- Admin authentication required
- SQL injection prevention with real_escape_string()
- File upload validation
- Proper permission handling

---

## Performance Notes

- Queries are optimized with `ORDER BY display_order`
- Only active slides are queried on homepage
- Images are cached by browser
- Database indexes recommended for large datasets

---

## Support & Maintenance

**Regular Tasks:**
- Delete old promotional slides
- Update images during seasons
- Archive past campaign slides
- Monitor image folder size

**Best Practices:**
1. Keep display orders sequential (1, 2, 3...)
2. Use high-quality images (compressed)
3. Test slides on mobile before going live
4. Keep backup of important content
5. Regularly clean up unused images

---

**Version**: 1.0  
**Last Updated**: December 2025  
**Status**: ✅ Production Ready
