# Restaurant Admin Dashboard

A comprehensive admin dashboard for managing restaurant operations including menus, reservations, contact messages, and online orders.

## 📁 Folder Structure

```
/admin/
├── admin_login.php          # Admin authentication page
├── index.php                # Main dashboard
├── menu.php                 # Menu management
├── reservations.php         # Reservation management
├── contact.php              # Contact messages
├── orders.php               # Online orders/delivery management
├── logout.php               # Logout script
├── check_admin.php          # Authentication checker
├── db_connect.php           # Database connection
├── database_setup.sql       # SQL database schema
├── assets/
│   ├── css/
│   │   └── admin-style.css  # Main admin stylesheet
│   └── js/
│       └── (JavaScript files for functionality)
└── README.md                # This file
```

## 🚀 Features

### 1. **Menu Management** 📋
- View all menu items organized by category
- Add new menu items with name, description, price
- Edit existing menu items
- Delete menu items
- Toggle availability status
- Category-wise filtering and statistics

### 2. **Reservation Management** 📅
- View all customer reservations
- Filter by status (pending, approved, rejected)
- Approve or reject reservations
- View detailed reservation information
- Delete reservations
- Track reservation statistics

### 3. **Contact Messages** 💬
- View all customer contact submissions
- Filter by read/unread status
- Mark messages as read
- View full message details
- Delete messages
- Track message count statistics

### 4. **Online Orders/Delivery** 🛵
- Track all online orders
- Update order status (pending → processing → completed)
- Cancel orders
- View order items and details
- Track delivery information
- Revenue tracking for completed orders
- Filter orders by status

### 5. **Dashboard Overview** 📊
- Quick statistics for all modules
- Pending items count
- Recent activity summary
- System status information

## 🔧 Installation & Setup

### Step 1: Database Setup

1. Open phpMyAdmin (http://localhost/phpmyadmin)
2. Create a new database named `bermiz_db` (if not already created)
3. Run the SQL script provided in `database_setup.sql`:
   - Copy all SQL code from `database_setup.sql`
   - Paste it into phpMyAdmin SQL query window
   - Click Execute

### Step 2: Update Admin Credentials

After running the SQL script, you need to set a secure password for the admin account:

1. In phpMyAdmin, go to the `admins` table
2. Click Edit on the default admin record
3. Update the password using PHP's password_hash function:

```php
// In PHP command line or any PHP file:
echo password_hash('your_new_password', PASSWORD_BCRYPT);
```

4. Copy the hashed password and update it in the database

**Default Admin Credentials (from setup):**
- Email: `admin@restaurant.com`
- Password: `admin123`

### Step 3: Access the Admin Panel

1. Navigate to: `http://localhost/Restaurant/admin/admin_login.php`
2. Login with admin credentials
3. You'll be redirected to the dashboard

## 📊 Database Tables

### admins
- Stores admin user credentials
- Email, hashed password, name

### menu_items
- Stores all menu items
- Fields: name, category, description, price, availability, image_url

### reservations
- Stores table reservations
- Fields: name, email, phone, date, time, guests, special requests, status

### contact_messages
- Stores customer contact submissions
- Fields: name, email, phone, message, read status

### orders
- Stores online delivery orders
- Fields: customer info, delivery address, items (JSON), totals, status

### catering_bookings
- Stores catering event bookings
- Fields: event info, guests, preferences, location

## 🔐 Security Features

- Session-based authentication
- Admin login verification
- Protected pages with `check_admin.php`
- Password hashing with bcrypt
- SQL injection prevention with prepared statements
- CSRF protection ready (can be enhanced)

## 💾 Database Operations

### CREATE (Add)
All modules support adding new items:
- Menu items via the modal form
- Messages are auto-created from contact form
- Reservations are auto-created from booking form
- Orders are auto-created from online checkout

### READ (View)
- View all items in tabular format
- Filter by various criteria
- View detailed information via modals

### UPDATE (Edit)
- Update menu availability
- Change reservation status
- Mark contact messages as read
- Update order status

### DELETE
- Delete menu items with confirmation
- Delete reservations
- Delete contact messages
- Delete orders

## 📱 Responsive Design

The admin dashboard is fully responsive:
- Desktop (1024px+)
- Tablet (768px - 1023px)
- Mobile (below 768px)

The sidebar collapses on smaller screens for better usability.

## 🎨 UI/UX Features

- Modern gradient design with purple theme
- Color-coded status badges
- Smooth animations and transitions
- Interactive modals for detailed views
- Quick statistics cards
- Easy-to-use filter buttons
- Bootstrap 5 for responsive grid
- Font Awesome icons for better visual appeal

## 📝 Usage Examples

### Adding a Menu Item
1. Go to Menu Management
2. Click "Add New Menu Item"
3. Fill in the form (name, category, description, price)
4. Check "Available" checkbox if item is available
5. Click "Save Item"

### Managing Reservations
1. Go to Reservations
2. Click filter buttons to view specific statuses
3. Click the checkmark icon to approve
4. Click the X icon to reject
5. Click eye icon to view full details

### Viewing Contact Messages
1. Go to Contact Messages
2. Click "Unread" to see new messages
3. Click "View" to read the full message
4. Click checkmark to mark as read
5. Click trash icon to delete

### Processing Orders
1. Go to Orders
2. See pending orders at the top
3. Click status dropdown to change order status
4. Click eye icon to see order details
5. Mark as completed when order is delivered

## 🔗 Integration with Frontend

The admin panel uses the same database (`bermiz_db`) as your restaurant website. Make sure:

1. Database connection parameters are correct in `db_connect.php`
2. Table names match your existing database
3. User sessions are compatible

## 🛠️ Troubleshooting

### Can't login
- Check if admin account exists in database
- Verify password hash format
- Check database connection in `db_connect.php`

### 404 errors
- Verify admin folder is in correct location: `/Restaurant/admin/`
- Check file names match exactly
- Clear browser cache

### Database errors
- Verify `bermiz_db` database exists
- Check SQL tables are created correctly
- Verify connection credentials in `db_connect.php`

### Styling issues
- Ensure `admin-style.css` is loaded
- Check Bootstrap CDN is accessible
- Verify file paths are relative to current location

## 📋 Checklist

- [ ] Database created and tables set up
- [ ] Admin account credentials created
- [ ] Admin panel accessible via login
- [ ] Can add menu items
- [ ] Can view and manage reservations
- [ ] Can view contact messages
- [ ] Can process online orders
- [ ] Dashboard statistics displaying correctly
- [ ] Logout functionality working
- [ ] Responsive design working on mobile

## 🔄 Future Enhancements

- [ ] Admin user management (create multiple admins)
- [ ] Detailed analytics and reports
- [ ] Email notifications for orders/reservations
- [ ] Payment integration
- [ ] Export functionality (PDF/Excel)
- [ ] User management dashboard
- [ ] Sales graphs and trends
- [ ] Inventory management
- [ ] Staff management
- [ ] Kitchen display system (KDS)

## 📞 Support

For issues or questions:
1. Check the troubleshooting section
2. Verify all files are in place
3. Check browser console for JavaScript errors
4. Verify database connections
5. Review error logs in database

## 📄 License

This admin dashboard is part of your restaurant website management system.

---

**Version:** 1.0  
**Last Updated:** December 18, 2025  
**Created for:** Restaurant Management System
