<?php
/**
 * Migration Script: Add timestamp columns to orders table
 * Run this once to ensure the orders table has created_at and updated_at columns
 */

require_once 'db_connect.php';

try {
    // Check if created_at column exists
    $result = $conn->query("SHOW COLUMNS FROM orders LIKE 'created_at'");
    if ($result->num_rows === 0) {
        // Add created_at column
        $conn->query("ALTER TABLE orders ADD COLUMN created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP");
        echo "✓ Added created_at column to orders table<br>";
    } else {
        echo "✓ created_at column already exists<br>";
    }

    // Check if updated_at column exists
    $result = $conn->query("SHOW COLUMNS FROM orders LIKE 'updated_at'");
    if ($result->num_rows === 0) {
        // Add updated_at column
        $conn->query("ALTER TABLE orders ADD COLUMN updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP");
        echo "✓ Added updated_at column to orders table<br>";
    } else {
        echo "✓ updated_at column already exists<br>";
    }

    echo "<br><strong>Database migration completed successfully!</strong>";
    echo "<br><a href='orders.php' class='btn btn-primary mt-3'>Go to Orders</a>";

} catch (Exception $e) {
    die("Error: " . $e->getMessage());
}
?>
