<?php
require_once 'check_admin.php';

$message = "";
$error = "";

// --- HANDLE DELETE ---
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action']) && $_POST['action'] == 'delete') {
    $contact_id = intval($_POST['contact_id']);
    $stmt = $conn->prepare("DELETE FROM contact_messages WHERE id = ?");
    $stmt->bind_param("i", $contact_id);
    if ($stmt->execute()) {
        $message = "Contact message deleted successfully!";
    } else {
        $error = "Failed to delete message.";
    }
}

// --- HANDLE MARK AS READ ---
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action']) && $_POST['action'] == 'mark_read') {
    $contact_id = intval($_POST['contact_id']);
    $stmt = $conn->prepare("UPDATE contact_messages SET is_read = 1 WHERE id = ?");
    $stmt->bind_param("i", $contact_id);
    $stmt->execute();
    $message = "Message marked as read.";
}

// --- FILTERS ---
$filter = isset($_GET['filter']) ? $_GET['filter'] : 'all';
$query = "SELECT * FROM contact_messages WHERE 1=1";

if ($filter == 'unread') {
    $query .= " AND is_read=0";
} elseif ($filter == 'read') {
    $query .= " AND is_read=1";
}

$query .= " ORDER BY created_at DESC";
$result = $conn->query($query);
$contacts = [];
while ($row = $result->fetch_assoc()) {
    $contacts[] = $row;
}

// --- STATISTICS ---
$stats = [
    'total'  => $conn->query("SELECT COUNT(*) as count FROM contact_messages")->fetch_assoc()['count'],
    'unread' => $conn->query("SELECT COUNT(*) as count FROM contact_messages WHERE is_read=0")->fetch_assoc()['count'],
    'read'   => $conn->query("SELECT COUNT(*) as count FROM contact_messages WHERE is_read=1")->fetch_assoc()['count'],
];
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Contact Messages - Admin</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="assets/css/admin-style.css">
    <style>
        /* Force Stat Card Styling ensures numbers are visible */
        .stat-card {
            border-radius: 15px;
            padding: 20px;
            color: white;
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
            transition: transform 0.3s;
            position: relative;
            overflow: hidden;
        }
        .stat-card:hover { transform: translateY(-5px); }
        .stat-card h3 { font-size: 2.5rem; font-weight: 700; margin: 0; }
        .stat-card h6 { font-size: 0.9rem; text-transform: uppercase; letter-spacing: 1px; opacity: 0.8; margin-bottom: 5px; }
        .stat-icon { position: absolute; right: 20px; top: 50%; transform: translateY(-50%); opacity: 0.2; font-size: 3rem; }
    </style>
</head>
<body>

<div class="wrapper">
    
    <?php include 'sidebar.php'; ?>

    <div class="main-content">
        <nav class="top-nav">
            <div class="nav-left">
                <h2><i class="fas fa-envelope"></i> Contact Messages</h2>
            </div>
            <div class="nav-right">
                <span class="admin-name">Welcome, Admin</span>
            </div>
        </nav>

        <div class="content">
            
            <?php if (!empty($message)): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo htmlspecialchars($message); ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <?php if (!empty($error)): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?php echo htmlspecialchars($error); ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <div class="row mb-4">
                <div class="col-md-4">
                    <div class="stat-card" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                        <div class="stat-icon"><i class="fas fa-inbox"></i></div>
                        <h6>Total Messages</h6>
                        <h3><?php echo $stats['total']; ?></h3>
                    </div>
                </div>
                
                <div class="col-md-4">
                    <div class="stat-card" style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);">
                        <div class="stat-icon"><i class="fas fa-envelope-open-text"></i></div>
                        <h6>Unread</h6>
                        <h3><?php echo $stats['unread']; ?></h3>
                    </div>
                </div>
                
                <div class="col-md-4">
                    <div class="stat-card" style="background: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%);">
                        <div class="stat-icon"><i class="fas fa-check-double"></i></div>
                        <h6>Read</h6>
                        <h3><?php echo $stats['read']; ?></h3>
                    </div>
                </div>
            </div>

            <div class="mb-3">
                <a href="?filter=all" class="btn btn-outline-secondary btn-sm <?php echo $filter == 'all' ? 'active' : ''; ?>">All</a>
                <a href="?filter=unread" class="btn btn-outline-warning btn-sm <?php echo $filter == 'unread' ? 'active' : ''; ?>">Unread</a>
                <a href="?filter=read" class="btn btn-outline-success btn-sm <?php echo $filter == 'read' ? 'active' : ''; ?>">Read</a>
            </div>

            <div class="table-responsive">
                <table class="table table-modern align-middle table-hover">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Phone</th>
                            <th>Subject</th>
                            <th>Date</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($contacts as $contact): ?>
                        <tr class="<?php echo $contact['is_read'] == 0 ? 'fw-bold bg-white' : ''; ?>">
                            <td>#<?php echo $contact['id']; ?></td>
                            <td><?php echo htmlspecialchars($contact['name']); ?></td>
                            <td><?php echo htmlspecialchars($contact['email']); ?></td>
                            <td><?php echo htmlspecialchars($contact['phone']); ?></td>
                            <td><?php echo substr(htmlspecialchars($contact['message']), 0, 30) . '...'; ?></td>
                            <td><?php echo date('M d, Y', strtotime($contact['created_at'])); ?></td>
                            <td>
                                <?php if ($contact['is_read'] == 0): ?>
                                    <span class="badge bg-danger">Unread</span>
                                <?php else: ?>
                                    <span class="badge bg-success">Read</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="action-buttons">
                                    <button class="btn btn-sm btn-info text-white" 
                                            data-bs-toggle="modal" 
                                            data-bs-target="#messageModal" 
                                            onclick='showMessage(<?php echo json_encode($contact, JSON_HEX_APOS | JSON_HEX_QUOT); ?>)'>
                                        <i class="fas fa-eye"></i>
                                    </button>

                                    <?php if ($contact['is_read'] == 0): ?>
                                        <form method="POST" style="display:inline;">
                                            <input type="hidden" name="action" value="mark_read">
                                            <input type="hidden" name="contact_id" value="<?php echo $contact['id']; ?>">
                                            <button type="submit" class="btn btn-sm btn-success" title="Mark as Read">
                                                <i class="fas fa-check"></i>
                                            </button>
                                        </form>
                                    <?php endif; ?>

                                    <form method="POST" style="display:inline;">
                                        <input type="hidden" name="action" value="delete">
                                        <input type="hidden" name="contact_id" value="<?php echo $contact['id']; ?>">
                                        <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>

        </div> </div> </div> <div class="modal fade" id="messageModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header" style="background: #931A2A; color: white;">
                <h5 class="modal-title">Message Details</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="messageContent">
                </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/js/bootstrap.bundle.min.js"></script>
<script>
    function showMessage(contact) {
        const html = `
            <div class="message-detail">
                <div class="row mb-3">
                    <div class="col-md-6">
                        <p><strong>From:</strong> ${contact.name}</p>
                        <p><strong>Email:</strong> <a href="mailto:${contact.email}">${contact.email}</a></p>
                    </div>
                    <div class="col-md-6">
                        <p><strong>Phone:</strong> ${contact.phone}</p>
                        <p><strong>Date:</strong> ${new Date(contact.created_at).toLocaleString()}</p>
                    </div>
                </div>
                <hr>
                <h6 class="mb-3">Message Content:</h6>
                <div class="p-3 bg-light rounded border">
                    ${contact.message.replace(/\n/g, '<br>')}
                </div>
            </div>
        `;
        document.getElementById('messageContent').innerHTML = html;
    }
</script>
</body>
</html>