<?php
require_once 'check_admin.php';

// Get dashboard statistics
$stats = [
    'total_menus'        => $conn->query("SELECT COUNT(*) as count FROM menu_items")->fetch_assoc()['count'],
    'total_reservations' => $conn->query("SELECT COUNT(*) as count FROM reservations")->fetch_assoc()['count'],
    'total_contacts'     => $conn->query("SELECT COUNT(*) as count FROM contact_messages")->fetch_assoc()['count'],
    'pending_orders'     => $conn->query("SELECT COUNT(*) as count FROM orders WHERE status='pending'")->fetch_assoc()['count'],
    'pending_catering'   => $conn->query("SELECT COUNT(*) as count FROM catering_bookings WHERE status='pending'")->fetch_assoc()['count'],
    'logged_in_users'    => $conn->query("SELECT COUNT(*) as count FROM users")->fetch_assoc()['count'],
];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard - Restaurant Management</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="assets/css/admin-style.css">
</head>
<body>
    <div class="wrapper">
        
        <?php include 'sidebar.php'; ?>

        <div class="main-content">
            <nav class="top-nav">
                <div class="nav-left">
                    <h2><i class="fas fa-tachometer-alt"></i> Dashboard Overview</h2>
                </div>
                <div class="nav-right">
                    <span class="admin-name">Welcome, Admin</span>
                </div>
            </nav>

            <div class="content">
                
                <div class="row mb-4">
                    <div class="col-md-3 mb-3">
                        <div class="stat-card" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);"> <div class="stat-icon mb-2">
                                <i class="fas fa-utensils fa-2x opacity-50"></i>
                            </div>
                            <h3><?php echo $stats['total_menus']; ?></h3>
                            <p class="mb-0 text-white-50 text-uppercase small ls-1">Menu Items</p>
                        </div>
                    </div>

                    <div class="col-md-3 mb-3">
                        <div class="stat-card" style="background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);"> <div class="stat-icon mb-2">
                                <i class="fas fa-calendar-check fa-2x opacity-50"></i>
                            </div>
                            <h3><?php echo $stats['total_reservations']; ?></h3>
                            <p class="mb-0 text-white-50 text-uppercase small ls-1">Total Reservations</p>
                        </div>
                    </div>

                    <div class="col-md-3 mb-3">
                        <div class="stat-card" style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);"> <div class="stat-icon mb-2">
                                <i class="fas fa-shopping-cart fa-2x opacity-50"></i>
                            </div>
                            <h3><?php echo $stats['pending_orders']; ?></h3>
                            <p class="mb-0 text-white-50 text-uppercase small ls-1">Pending Orders</p>
                        </div>
                    </div>

                    <div class="col-md-3 mb-3">
                        <div class="stat-card" style="background: linear-gradient(135deg, #fa709a 0%, #fee140 100%);"> <div class="stat-icon mb-2">
                                <i class="fas fa-glass-cheers fa-2x opacity-50"></i>
                            </div>
                            <h3><?php echo $stats['pending_catering']; ?></h3>
                            <p class="mb-0 text-white-50 text-uppercase small ls-1">Catering Requests</p>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-3 mb-4">
                        <div class="stat-card h-100 d-flex flex-column justify-content-center align-items-center" style="background: linear-gradient(135deg, #a8edea 0%, #fed6e3 100%);">
                            <div class="stat-icon mb-2">
                                <i class="fas fa-users fa-2x opacity-50"></i>
                            </div>
                            <h3><?php echo $stats['logged_in_users']; ?></h3>
                            <p class="mb-0 text-white-50 text-uppercase small ls-1">Registered Users</p>
                        </div>
                    </div>

                    <div class="col-md-3 mb-4">
                        <div class="stat-card h-100 d-flex flex-column justify-content-center align-items-center" style="background: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%);">
                            <div class="stat-icon mb-2">
                                <i class="fas fa-envelope fa-2x opacity-50"></i>
                            </div>
                            <h3><?php echo $stats['total_contacts']; ?></h3>
                            <p class="mb-0 text-white-50 text-uppercase small ls-1">Total Messages</p>
                            <a href="contact.php" class="btn btn-light btn-sm mt-3 rounded-pill px-4">View Inbox</a>
                        </div>
                    </div>

                    <div class="col-md-6 mb-4">
                        <div class="admin-form-section h-100">
                            <h5 class="form-title mb-4">Quick Actions</h5>
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <a href="menu.php" class="btn btn-outline-primary w-100 p-3 text-start">
                                        <i class="fas fa-plus-circle me-2"></i> Add Menu Item
                                    </a>
                                </div>
                                <div class="col-md-6">
                                    <a href="reservations.php?filter=pending" class="btn btn-outline-warning w-100 p-3 text-start">
                                        <i class="fas fa-clock me-2"></i> Review Reservations
                                    </a>
                                </div>
                                <div class="col-md-6">
                                    <a href="gallery.php" class="btn btn-outline-success w-100 p-3 text-start">
                                        <i class="fas fa-images me-2"></i> Manage Gallery
                                    </a>
                                </div>
                                <div class="col-md-6">
                                    <a href="orders.php?filter=pending" class="btn btn-outline-danger w-100 p-3 text-start">
                                        <i class="fas fa-shipping-fast me-2"></i> Process Orders
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row mt-2">
                    <div class="col-12">
                        <div class="bg-white p-3 rounded shadow-sm text-muted small d-flex justify-content-between align-items-center">
                            <div>
                                <i class="fas fa-user-shield me-1"></i> Logged in as: <strong><?php echo htmlspecialchars($_SESSION['admin_email']); ?></strong>
                            </div>
                            <div>
                                <i class="fas fa-clock me-1"></i> Last Login: <?php echo date('d M Y, h:i A'); ?>
                                <span class="mx-2">|</span>
                                <span class="badge bg-success">System Online</span>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/js/bootstrap.bundle.min.js"></script>
</body>
</html>