<?php
/* ===============================
   1. SETUP & PHPMAILER
================================ */
require_once 'check_admin.php'; // Ensure admin is logged in

// Adjust these paths based on where your PHPMailer folder is located relative to the admin folder
require_once __DIR__ . '/../PHPMailer/src/PHPMailer.php'; 
require_once __DIR__ . '/../PHPMailer/src/SMTP.php';
require_once __DIR__ . '/../PHPMailer/src/Exception.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

$message = "";
$error = "";

/* ===============================
   2. HELPER FUNCTION: SEND EMAIL
================================ */
function sendStatusEmail($toEmail, $toName, $status, $date, $time) {
    $mail = new PHPMailer(true);
    try {
        $mail->isSMTP();
        $mail->Host       = 'smtp.gmail.com';
        $mail->SMTPAuth   = true;
        $mail->Username   = 'pradeepnatarajan400@gmail.com'; // Your Email
        $mail->Password   = 'jhaz xdav sibf gufm';           // Your App Password
        $mail->SMTPSecure = 'tls';
        $mail->Port       = 587;

        $mail->setFrom('pradeepnatarajan400@gmail.com', 'Bermiz Restaurant');
        $mail->addAddress($toEmail, $toName);

        $mail->isHTML(true);
        
        if ($status == 'approved') {
            $mail->Subject = "Reservation Confirmed - Bermiz Restaurant";
            $mail->Body    = "
                <h2>Reservation Confirmed!</h2>
                <p>Dear $toName,</p>
                <p>We are pleased to inform you that your table reservation has been <b>APPROVED</b>.</p>
                <p><b>Date:</b> $date<br><b>Time:</b> $time</p>
                <p>We look forward to serving you!</p>";
        } else {
            $mail->Subject = "Update on your Reservation - Bermiz Restaurant";
            $mail->Body    = "
                <h2>Reservation Status Update</h2>
                <p>Dear $toName,</p>
                <p>We regret to inform you that we could not accommodate your reservation request for $date at $time.</p>
                <p>Please try a different time slot or contact us directly.</p>";
        }

        $mail->send();
        return true;
    } catch (Exception $e) {
        return false; // Email failed
    }
}

/* ===============================
   3. HANDLE CRUD & ACTIONS
================================ */
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    
    // --- ACTION: APPROVE ---
    if (isset($_POST['action']) && $_POST['action'] == 'approve') {
        $id = intval($_POST['reservation_id']);
        
        $stmt = $conn->prepare("SELECT * FROM reservations WHERE id=?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $res = $stmt->get_result()->fetch_assoc();
        $stmt->close();

        if ($res) {
            $update = $conn->query("UPDATE reservations SET status='approved' WHERE id=$id");
            
            if ($update) {
                $mailSent = sendStatusEmail($res['email'], $res['name'], 'approved', $res['res_date'], $res['res_time']);
                $message = "Reservation Approved! " . ($mailSent ? "Email sent." : "Email failed to send.");
            } else {
                $error = "Failed to update database.";
            }
        }
    }

    // --- ACTION: REJECT ---
    elseif (isset($_POST['action']) && $_POST['action'] == 'reject') {
        $id = intval($_POST['reservation_id']);
        
        $stmt = $conn->prepare("SELECT * FROM reservations WHERE id=?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $res = $stmt->get_result()->fetch_assoc();
        $stmt->close();

        if ($res) {
            $update = $conn->query("UPDATE reservations SET status='rejected' WHERE id=$id");
            
            if ($update) {
                $mailSent = sendStatusEmail($res['email'], $res['name'], 'rejected', $res['res_date'], $res['res_time']);
                $message = "Reservation Rejected. " . ($mailSent ? "Email sent." : "Email failed to send.");
            } else {
                $error = "Failed to update database.";
            }
        }
    }

    // --- ACTION: DELETE ---
    elseif (isset($_POST['action']) && $_POST['action'] == 'delete') {
        $id = intval($_POST['reservation_id']);
        $conn->query("DELETE FROM reservations WHERE id=$id");
        $message = "Reservation deleted successfully.";
    }

    // --- ACTION: ADD / UPDATE (Manual Entry) ---
    elseif (isset($_POST['action']) && ($_POST['action'] == 'add' || $_POST['action'] == 'update')) {
        $name = $_POST['name'];
        $email = $_POST['email'];
        $phone = $_POST['phone'];
        $guests = $_POST['guests'];
        $date = $_POST['reservation_date'];
        $time = $_POST['reservation_time'];
        
        if ($_POST['action'] == 'add') {
            $stmt = $conn->prepare("INSERT INTO reservations (name, email, phone, guests, res_date, res_time, status) VALUES (?, ?, ?, ?, ?, ?, 'pending')");
            $stmt->bind_param("sssiis", $name, $email, $phone, $guests, $date, $time);
            if ($stmt->execute()) $message = "Reservation added manually.";
            else $error = "Error adding reservation.";
        } else {
            $id = $_POST['reservation_id'];
            $status = $_POST['status'];
            $stmt = $conn->prepare("UPDATE reservations SET name=?, email=?, phone=?, guests=?, res_date=?, res_time=?, status=? WHERE id=?");
            $stmt->bind_param("sssiissi", $name, $email, $phone, $guests, $date, $time, $status, $id);
            if ($stmt->execute()) $message = "Reservation updated.";
            else $error = "Error updating reservation.";
        }
    }
}

// --- GET DATA FOR TABLE ---
$filter = isset($_GET['filter']) ? $_GET['filter'] : 'all';
$sql = "SELECT * FROM reservations";
if ($filter != 'all') {
    $sql .= " WHERE status = '$filter'";
}
$sql .= " ORDER BY res_date DESC";

$result = $conn->query($sql);
$reservations = [];
while ($row = $result->fetch_assoc()) {
    $reservations[] = $row;
}

// --- STATS ---
$stats = [
    'total' => $conn->query("SELECT COUNT(*) FROM reservations")->fetch_row()[0],
    'pending' => $conn->query("SELECT COUNT(*) FROM reservations WHERE status='pending'")->fetch_row()[0],
    'approved' => $conn->query("SELECT COUNT(*) FROM reservations WHERE status='approved'")->fetch_row()[0],
    'rejected' => $conn->query("SELECT COUNT(*) FROM reservations WHERE status='rejected'")->fetch_row()[0],
];

// --- EDIT MODE DATA ---
$edit_reservation = null;
if (isset($_GET['edit'])) {
    $id = intval($_GET['edit']);
    $edit_reservation = $conn->query("SELECT * FROM reservations WHERE id=$id")->fetch_assoc();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Reservation Management - Admin</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="assets/css/admin-style.css">
    <style>
        .admin-form-section { background: #f8f9fa; padding: 25px; border-radius: 10px; margin-bottom: 30px; box-shadow: 0 2px 8px rgba(0,0,0,0.1); }
        .table-modern thead th { background: #931A2A; color: white; border: none; padding: 15px; }
        .btn-primary-custom { background: #931A2A; color: white; border: none; }
        .btn-primary-custom:hover { background: #7a1522; color: white; }
        .stat-card { padding: 20px; border-radius: 10px; text-align: center; color: white; }
        .stat-card.total { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); }
        .stat-card.pending { background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%); }
        .stat-card.approved { background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%); }
        .stat-card.rejected { background: linear-gradient(135deg, #fa709a 0%, #fee140 100%); }
    </style>
</head>
<body>

<div class="wrapper">
    
    <?php include 'sidebar.php'; ?>

    <div class="main-content">
        
        <nav class="top-nav">
             <div class="nav-left">
                <h2><i class="fas fa-calendar-alt"></i> Reservation Management</h2>
            </div>
            <div class="nav-right">
                <span>Welcome, Admin</span>
            </div>
        </nav>

        <div class="content">
            
            <?php if ($message): ?>
                <div class="alert alert-success alert-dismissible fade show">
                    <?php echo $message; ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>
            <?php if ($error): ?>
                <div class="alert alert-danger alert-dismissible fade show">
                    <?php echo $error; ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <div class="row mb-4">
                <div class="col-md-3"><div class="stat-card total"><h6>Total</h6><h3><?php echo $stats['total']; ?></h3></div></div>
                <div class="col-md-3"><div class="stat-card pending"><h6>Pending</h6><h3><?php echo $stats['pending']; ?></h3></div></div>
                <div class="col-md-3"><div class="stat-card approved"><h6>Approved</h6><h3><?php echo $stats['approved']; ?></h3></div></div>
                <div class="col-md-3"><div class="stat-card rejected"><h6>Rejected</h6><h3><?php echo $stats['rejected']; ?></h3></div></div>
            </div>

            <div class="admin-form-section">
                <h5><?php echo $edit_reservation ? 'Edit Reservation' : 'Add Reservation'; ?></h5>
                <form method="POST">
                    <input type="hidden" name="action" value="<?php echo $edit_reservation ? 'update' : 'add'; ?>">
                    <?php if($edit_reservation): ?><input type="hidden" name="reservation_id" value="<?php echo $edit_reservation['id']; ?>"><?php endif; ?>
                    
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label>Name</label>
                            <input type="text" name="name" class="form-control" required value="<?php echo $edit_reservation['name'] ?? ''; ?>">
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>Email</label>
                            <input type="email" name="email" class="form-control" required value="<?php echo $edit_reservation['email'] ?? ''; ?>">
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>Phone</label>
                            <input type="text" name="phone" class="form-control" required value="<?php echo $edit_reservation['phone'] ?? ''; ?>">
                        </div>
                        <div class="col-md-3 mb-3">
                            <label>Date</label>
                            <input type="date" name="reservation_date" class="form-control" required value="<?php echo $edit_reservation['res_date'] ?? ''; ?>">
                        </div>
                        <div class="col-md-3 mb-3">
                            <label>Time</label>
                            <input type="time" name="reservation_time" class="form-control" required value="<?php echo $edit_reservation['res_time'] ?? ''; ?>">
                        </div>
                        <div class="col-md-3 mb-3">
                            <label>Guests</label>
                            <input type="number" name="guests" class="form-control" required value="<?php echo $edit_reservation['guests'] ?? ''; ?>">
                        </div>
                        <?php if($edit_reservation): ?>
                        <div class="col-md-3 mb-3">
                            <label>Status</label>
                            <select name="status" class="form-control">
                                <option value="pending" <?php echo $edit_reservation['status']=='pending'?'selected':''; ?>>Pending</option>
                                <option value="approved" <?php echo $edit_reservation['status']=='approved'?'selected':''; ?>>Approved</option>
                                <option value="rejected" <?php echo $edit_reservation['status']=='rejected'?'selected':''; ?>>Rejected</option>
                            </select>
                        </div>
                        <?php endif; ?>
                    </div>
                    <button type="submit" class="btn btn-primary-custom">Save Reservation</button>
                    <?php if($edit_reservation): ?> <a href="reservations.php" class="btn btn-secondary">Cancel</a> <?php endif; ?>
                </form>
            </div>

            <div class="mb-3">
                <a href="?filter=all" class="btn btn-outline-secondary btn-sm <?php echo $filter=='all'?'active':''; ?>">All</a>
                <a href="?filter=pending" class="btn btn-outline-warning btn-sm <?php echo $filter=='pending'?'active':''; ?>">Pending</a>
                <a href="?filter=approved" class="btn btn-outline-success btn-sm <?php echo $filter=='approved'?'active':''; ?>">Approved</a>
            </div>

            <div class="table-responsive">
                <table class="table table-modern table-hover">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Phone</th>
                            <th>Date</th> <th>Time</th> <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach($reservations as $res): ?>
                        <tr>
                            <td>#<?php echo $res['id']; ?></td>
                            <td><?php echo htmlspecialchars($res['name']); ?></td>
                            <td><?php echo htmlspecialchars($res['email']); ?></td>
                            <td><?php echo htmlspecialchars($res['phone']); ?></td>
                            
                            <td><?php echo date('M d, Y', strtotime($res['res_date'])); ?></td>
                            <td><?php echo date('h:i A', strtotime($res['res_time'])); ?></td>
                            
                            <td>
                                <?php 
                                    $badgeClass = 'bg-secondary';
                                    if($res['status'] == 'pending') $badgeClass = 'bg-warning text-dark';
                                    if($res['status'] == 'approved') $badgeClass = 'bg-success';
                                    if($res['status'] == 'rejected') $badgeClass = 'bg-danger';
                                ?>
                                <span class="badge <?php echo $badgeClass; ?>"><?php echo ucfirst($res['status']); ?></span>
                            </td>
                            <td>
                                <?php if($res['status'] == 'pending'): ?>
                                <form method="POST" style="display:inline-block;">
                                    <input type="hidden" name="action" value="approve">
                                    <input type="hidden" name="reservation_id" value="<?php echo $res['id']; ?>">
                                    <button class="btn btn-success btn-sm" title="Approve & Email"><i class="fas fa-check"></i></button>
                                </form>

                                <form method="POST" style="display:inline-block;">
                                    <input type="hidden" name="action" value="reject">
                                    <input type="hidden" name="reservation_id" value="<?php echo $res['id']; ?>">
                                    <button class="btn btn-warning btn-sm" title="Reject & Email"><i class="fas fa-times"></i></button>
                                </form>
                                <?php endif; ?>

                                <a href="?edit=<?php echo $res['id']; ?>" class="btn btn-info btn-sm text-white"><i class="fas fa-edit"></i></a>
                                
                                <form method="POST" style="display:inline-block;" onsubmit="return confirm('Delete this reservation?');">
                                    <input type="hidden" name="action" value="delete">
                                    <input type="hidden" name="reservation_id" value="<?php echo $res['id']; ?>">
                                    <button class="btn btn-danger btn-sm"><i class="fas fa-trash"></i></button>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            
        </div> </div> </div> <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/js/bootstrap.bundle.min.js"></script>
</body>
</html>