<?php
// Get the current page name
$current_page = basename($_SERVER['PHP_SELF']);

// Initialize counts to avoid errors if $conn isn't set
$pending_orders = 0;
$pending_reservations = 0;
$unread_contacts = 0;
$pending_catering = 0;

if (isset($conn)) {
    $q1 = $conn->query("SELECT COUNT(*) as count FROM orders WHERE status='pending'");
    if($q1) $pending_orders = $q1->fetch_assoc()['count'];

    $q2 = $conn->query("SELECT COUNT(*) as count FROM reservations WHERE status='pending'");
    if($q2) $pending_reservations = $q2->fetch_assoc()['count'];

    $q3 = $conn->query("SELECT COUNT(*) as count FROM contact_messages WHERE is_read=0");
    if($q3) $unread_contacts = $q3->fetch_assoc()['count'];
    
    // Check if catering table exists before querying
    $checkTable = $conn->query("SHOW TABLES LIKE 'catering_bookings'");
    if($checkTable && $checkTable->num_rows > 0) {
        $q4 = $conn->query("SELECT COUNT(*) as count FROM catering_bookings WHERE status='pending'");
        if($q4) $pending_catering = $q4->fetch_assoc()['count'];
    }
}
?>
<nav class="sidebar">
    <div class="sidebar-header">
        <h3>Admin Panel</h3>
    </div>
    
    <ul class="nav">
        <li>
            <a href="index.php" class="<?php echo $current_page == 'index.php' ? 'active' : ''; ?>">
                <i class="fas fa-tachometer-alt"></i> Dashboard
            </a>
        </li>
        <li>
            <a href="menu.php" class="<?php echo $current_page == 'menu.php' ? 'active' : ''; ?>">
                <i class="fas fa-utensils"></i> Menu Management
            </a>
        </li>
        <li>
            <a href="reservations.php" class="<?php echo ($current_page == 'reservations.php') ? 'active' : ''; ?>">
                <i class="fas fa-calendar-alt"></i> Reservations
                <?php if ($pending_reservations > 0): ?>
                    <span class="badge bg-danger rounded-pill"><?php echo $pending_reservations; ?></span>
                <?php endif; ?>
            </a>
        </li>
        <li>
            <a href="contact.php" class="<?php echo $current_page == 'contact.php' ? 'active' : ''; ?>">
                <i class="fas fa-envelope"></i> Contact Messages
                <?php if ($unread_contacts > 0): ?>
                    <span class="badge bg-danger rounded-pill"><?php echo $unread_contacts; ?></span>
                <?php endif; ?>
            </a>
        </li>
        <li>
            <a href="orders.php" class="<?php echo $current_page == 'orders.php' ? 'active' : ''; ?>">
                <i class="fas fa-shopping-cart"></i> Orders
                <?php if ($pending_orders > 0): ?>
                    <span class="badge bg-danger rounded-pill"><?php echo $pending_orders; ?></span>
                <?php endif; ?>
            </a>
        </li>
        <li>
            <a href="gallery.php" class="<?php echo $current_page == 'gallery.php' ? 'active' : ''; ?>">
                <i class="fas fa-images"></i> Gallery
            </a>
        </li>
        <li>
            <a href="weekly.php" class="<?php echo $current_page == 'weekly.php' ? 'active' : ''; ?>">
                <i class="fas fa-star"></i> Weekly Specials
            </a>
        </li>
        <li>
            <a href="slider.php" class="<?php echo $current_page == 'slider.php' ? 'active' : ''; ?>">
                <i class="fas fa-images"></i> Hero Slider
            </a>
        </li>
        <li>
            <a href="catering_admin.php" class="<?php echo $current_page == 'catering_admin.php' ? 'active' : ''; ?>">
                <i class="fas fa-glass-cheers"></i> Catering Bookings
                <?php if ($pending_catering > 0): ?>
                    <span class="badge bg-danger rounded-pill"><?php echo $pending_catering; ?></span>
                <?php endif; ?>
            </a>
        </li>
        <li>
            <a href="users.php" class="<?php echo $current_page == 'users.php' ? 'active' : ''; ?>">
                <i class="fas fa-users"></i> Registered Users
            </a>
        </li>
        <li>
            <a href="logout.php">
                <i class="fas fa-sign-out-alt"></i> Logout
            </a>
        </li>
    </ul>
</nav>