﻿<?php
session_start();
// Check if user is logged in
$is_logged_in = isset($_SESSION['user_name']) ? 'true' : 'false';
?>
<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title>Bermiz</title>
	<link rel="icon" href="assets/images/favicon/icon.png">
	<link href="../../../css2?family=Elsie&display=swap" rel="stylesheet">
	<link href="../../../css2-1?family=Elsie&family=Lexend:wght@400;500&display=swap" rel="stylesheet">
	<link rel="stylesheet" href="assets/css/all.min.css">
	<link rel="stylesheet" href="assets/css/slick.css">
	<link rel="stylesheet" href="assets/css/aos.css">
	<link rel="stylesheet" href="assets/css/animate.css">
	<link rel="stylesheet" href="assets/css/bootstrap.min.css">
	<link rel="stylesheet" href="assets/css/photoswipe.min.css">
	<link rel="stylesheet" href="assets/css/default-skin.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
	<link rel="stylesheet" href="assets/css/style.css">
	<link rel="stylesheet" href="assets/css/media-query.css">
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
</head>
<body>
	<div class="site_content">
		<!-- Preloader Start -->
<!-- ===== RESTAURANT PRELOADER ===== -->
<div id="preloader">

  <!-- INLINE SVG COFFEE -->
  <svg width="140" height="140"
       viewBox="0 0 140 140"
       xmlns="http://www.w3.org/2000/svg">

    <!-- Cup body -->
    <rect x="40" y="65" width="60" height="35"
          rx="8" fill="#78350f"/>

    <!-- Cup handle -->
    <path d="M100 72 Q115 82 100 92"
          fill="none"
          stroke="#78350f"
          stroke-width="5"/>

    <!-- Saucer -->
    <ellipse cx="70" cy="105" rx="40" ry="6"
             fill="#e5e7eb"/>

    <!-- Steam 1 -->
    <path d="M55 60 C45 50 65 40 55 30"
          stroke="#d97706"
          stroke-width="4"
          fill="none">
      <animate attributeName="opacity"
               values="0;1;0"
               dur="1.2s"
               repeatCount="indefinite"/>
    </path>

    <!-- Steam 2 -->
    <path d="M70 60 C60 50 80 40 70 30"
          stroke="#f59e0b"
          stroke-width="4"
          fill="none">
      <animate attributeName="opacity"
               values="0;1;0"
               dur="1.2s"
               begin="0.3s"
               repeatCount="indefinite"/>
    </path>

    <!-- Steam 3 -->
    <path d="M85 60 C75 50 95 40 85 30"
          stroke="#d97706"
          stroke-width="4"
          fill="none">
      <animate attributeName="opacity"
               values="0;1;0"
               dur="1.2s"
               begin="0.6s"
               repeatCount="indefinite"/>
    </path>

    <!-- Text -->
    <text x="70" y="130"
          text-anchor="middle"
          font-size="11"
          fill="#92400e">
      Brewing Coffee…
    </text>

  </svg>

</div>

		<!-- Preloader End --><!-- ================= TOP INFO HEADER ================= -->
<div class="top-header">
    <div class="container-fluid top-header-inner">

        <div class="welcome-text">
            Welcome to Bermiz Restaurant & Catering Services
        </div>

        <div class="social-icons">
            <a href="#"><i class="fa-brands fa-facebook-f"></i></a>
            <a href="#"><i class="fa-brands fa-twitter"></i></a>
            <a href="#"><i class="fa-brands fa-instagram"></i></a>
            <a href="#"><i class="fa-brands fa-whatsapp"></i></a>
            <a href="#"><i class="fa-brands fa-youtube"></i></a>
        </div>

    </div>
</div>

<!-- ================= CONTACT STRIP ================= -->
<div class="top-header-container">
    
    <div class="logo-area">
        <a href="index.php">
        <img src="assets/images/Homepage1/logo.png" class="strip-logo">
		</a>
    </div>

    <div class="header-right-side">
        
        <div class="contact-group">
            
            <div class="contact-item">
                <i class="fas fa-phone-alt contact-icon"></i> <div>
                    <h5 class="contact-title">Call Us:</h5>
                    <p class="contact-text">+91 98765 43210</p>
                </div>
            </div>

            <div class="contact-item">
                <i class="fas fa-envelope contact-icon"></i>
                <div>
                    <h5 class="contact-title">Mail Us:</h5>
                    <p class="contact-text">bermizrestaurant@gmail.com</p>
                </div>
            </div>

            <div class="contact-item">
                <i class="fas fa-map-marker-alt contact-icon"></i>
                <div>
                    <h5 class="contact-title">Location:</h5>
                    <p class="contact-text">Coimbatore, Tamil Nadu</p>
                </div>
            </div>

        </div> 
 <div class="auth-actions" id="authContainer">
    <?php if (isset($_SESSION['user_name'])): ?>
        
        <div class="user-menu-dropdown">
            <button class="user-btn">
                <i class="fa fa-user-circle"></i> <span class="u-name"><?php echo htmlspecialchars($_SESSION['user_name']); ?></span>
                <i class="fa fa-caret-down"></i> </button>

            <div class="dropdown-content">
                <a href="profile.php">
                    <i class="fa fa-id-card"></i> View Profile
                </a>
                <a href="logout.php" class="logout-item">
                    <i class="fa fa-sign-out"></i> Logout
                </a>
            </div>
        </div>

    <?php else: ?>

        <a href="login.php" class="btn-auth btn-login">Sign In</a>
        <a href="login.php?show=signup" class="btn-auth btn-signup">Sign Up</a>

    <?php endif; ?>
</div>

    </div>
	<style>/* ========================================= */
/* TOP HEADER LAYOUT                        */
/* ========================================= */
</style>
</div>
	
		<!-- Header Section Start -->
<header id="header-homepage1" class="menupage1-header">
	<div class="header-full-section">
		<!-- Logo -->
		<div class="header-logo">
			<a href="index.php">
				<img src="assets/images/Homepage1/logo.png" alt="header-logo" class="homepage1-logo">
			</a>
		</div>


		<!-- Desktop Menu -->
		<div class="header-menu-wrap">
			<div class="header-nav-wrap">
				<nav class="navbar navbar-expand-xl p-0">
					<div class="navbar-collapse" id="navbarSupportedContent">
						<ul class="navbar-nav mx-auto align-items-center">

							<!-- HOME -->
							<li class="nav-item">
								<a class="nav-link" href="index.php">Home</a>
							</li>

							<!-- ABOUT US DROPDOWN -->
							<li class="nav-item dropdown">
								<a class="nav-link dropdown-toggle" href="javascript:void(0);">About Us</a>
								<ul class="dropdown-menu">
									<li><a class="dropdown-item" href="about-us.php">About</a></li>
									<li><a class="dropdown-item" href="chefspage2.php">Chefs</a></li>
									<li><a class="dropdown-item" href="blogpage-1.php">Blog</a></li>
									<li><a class="dropdown-item" href="faq.php">FAQ</a></li>
								</ul>
							</li>

							<!-- MENU -->
							<li class="nav-item dropdown">
								<a class="nav-link dropdown-toggle" href="javascript:void(0);">Menu</a>
								<ul class="dropdown-menu">
									<li><a class="dropdown-item" href="menupage-veg.php">Veg</a></li>
									<li><a class="dropdown-item" href="menupage-nonveg.php">Non-Veg</a></li>
									<li><a class="dropdown-item" href="drinks.php">Drinks</a></li>
                                </ul>
							</li>

							<!-- WEEKLY SPECIAL -->
							<li class="nav-item">
								<a class="nav-link" href="weekly.php">Weekly Special</a>
							</li>

							<!-- Catering & Events -->
							<li class="nav-item">
								<a class="nav-link" href="catering-events.php">Catering & Events</a>
							</li>

							<!-- RESERVATION -->
							<li class="nav-item">
								<a class="nav-link" href="online-delivery.php">Online Delivery</a>
							</li>

							<!-- GALLERY -->
							<li class="nav-item">
								<a class="nav-link" href="gallery.php">Gallery</a>
							</li>

							<!-- CONTACT -->
							<li class="nav-item">
								<a class="nav-link" href="contact-us.php">Contact Us</a>
							</li>

						</ul>
					</div>
				</nav>
			</div>
		</div>

		<!-- CART ICON -->
<div class="header-cart-sec">

    <!-- Mobile Toggle -->
    <div class="mobile-menu-icon d-xl-none">
        <a data-bs-toggle="collapse" href="#navbarSupportedmobile" role="button">
            <i class="fa-solid fa-bars"></i>
        </a>
    </div>

    <!-- CART (DESKTOP ONLY) -->
    <div class="header-cart-btn d-none d-xl-flex">
        <a href="cart-view.php">
            <i class="fa fa-shopping-cart"></i>
            <span class="cart-count">0</span>
        </a>
    </div>

    <!-- BOOKING (DESKTOP ONLY) -->
    <div class="header-cart-sec-first d-none d-xl-block">
        <a href="reservation-1.php" class="booking-btn-text">
            Booking
        </a>
    </div>

</div>



</div>

	</div>

	<!-- MOBILE MENU -->
<div class="mobile-menu-wrap d-lg-none d-block">
    <div class="mb-header-left">
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedmobile">
            <span class="navbar-toggler-icon"><i class="fa-solid fa-bars"></i></span>
        </button>

        <div class="collapse navbar-collapse" id="navbarSupportedmobile">
            <span class="close-menu"><i class="fa-regular fa-xmark"></i></span>

            <nav id='cssmenu'>
                <ul class="open-detail-menu">

                    <?php if (isset($_SESSION['user_name'])): ?>
                        <li style="border-bottom: 1px solid #ffffffff; background: #931A2A;">
                            <a href="profile.php" style="color: #ffffffff; font-weight: 700;">
                                <i class="fa fa-user-circle" style="margin-right:8px;"></i> 
                                Hello, <?php echo htmlspecialchars($_SESSION['user_name']); ?>
                            </a>
                        </li>
                    <?php endif; ?>
                    <li><a href="index.php">Home</a></li>

                    <li><a href="javascript:void(0);">About Us</a>
                        <ul class="sub-back-wrap">
                            <li><a href="about-us.php">About</a></li>
                            <li><a href="chefspage2.php">Chefs</a></li>
                            <li><a href="blogpage-1.php">Blog</a></li>
                            <li><a href="faq.php">FAQ</a></li>
                        </ul>
                    </li>

                    <li><a href="javascript:void(0);">Menu</a>
                        <ul class="sub-back-wrap">
                            <li><a href="menupage-veg.php">Veg</a></li>
                            <li><a href="menupage-nonveg.php">Non-Veg</a></li>
                            <li><a href="drinks.php">Drinks</a></li>
                        </ul>
                    </li>

                    <li><a href="weekly-special.php">Weekly Special</a></li>
                    <li><a href="catering-events.php">Catering & Events</a></li>
                    <li><a href="online-delivery.php">Online Delivery</a></li>
                    <li><a href="gallery.php">Gallery</a></li>
                    <li><a href="contact-us.php">Contact Us</a></li>
                    
                    <li class="mobile-extra">
                        <a href="cart-view.php" class="mobile-cart">
                            <i class="fa fa-shopping-cart"></i>
                            Cart <span class="mobile-cart-count">0</span>
                        </a>
                    </li>

                    <li class="mobile-extra">
                        <a href="reservation-1.php" class="booking-link">Booking</a>
                    </li>

                    <li class="mobile-auth-text">
                        <?php if (isset($_SESSION['user_name'])): ?>
                            <a href="logout.php" class="mobile-login-link" style="color: #dc3545;">
                                <i class="fa fa-sign-out"></i> Logout
                            </a>
                        <?php else: ?>
                            <a href="login.php" class="mobile-login-link">Sign In</a>
                            <a href="login.php?show=signup" class="mobile-signup-link">Sign Up</a>
                        <?php endif; ?>
                    </li>
                    </ul>
            </nav>
        </div>
    </div>
</div>				</ul>
				</nav>
			</div>
		</div>
	</div>
	<div class="header-boder"></div>
</header>


		<!-- Header Section End -->
		<!-- Hero Section Start -->
<section id="menupage-1-section">
    <div class="menupage-1-section-img">
        <div class="menupage-1-overlay"></div>
        
        <div class="menupage-1-conten text-center"> <h1 class="menupage-1-hero-txt1 wow fadeInDown" data-wow-duration="1s" data-wow-delay="0.5s">
                Cart View
            </h1>

            <nav aria-label="breadcrumb">
                <ol class="breadcrumb justify-content-center transparent-breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="index.php">
                            <span class="home-icon">
                                <svg width="24" height="24" viewbox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <mask id="mask0_564_5237" style="mask-type:alpha" maskunits="userSpaceOnUse" x="0" y="0" width="24" height="24">
                                        <rect width="24" height="24" fill="white"></rect>
                                    </mask>
                                    <g mask="url(#mask0_564_5237)">
                                        <path d="M9.15722 20.7714V17.7047C9.1572 16.9246 9.79312 16.2908 10.581 16.2856H13.4671C14.2587 16.2856 14.9005 16.9209 14.9005 17.7047V17.7047V20.7809C14.9003 21.4432 15.4343 21.9845 16.103 22H18.0271C19.9451 22 21.5 20.4607 21.5 18.5618V18.5618V9.83784C21.4898 9.09083 21.1355 8.38935 20.538 7.93303L13.9577 2.6853C12.8049 1.77157 11.1662 1.77157 10.0134 2.6853L3.46203 7.94256C2.86226 8.39702 2.50739 9.09967 2.5 9.84736V18.5618C2.5 20.4607 4.05488 22 5.97291 22H7.89696C8.58235 22 9.13797 21.4499 9.13797 20.7714V20.7714" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
                                    </g>
                                </svg>
                            </span>
                            Home
                        </a>
                    </li>
                    <li class="breadcrumb-item active text-white" aria-current="page">Cart View</li>
                </ol>
            </nav>

        </div>
    </div>
    <div class="menupage1-boder"></div>
</section>
		<!-- Hero Section End -->
		<!-- Cart Section End -->

<style>
        .cart-table img { width: 60px; height: 60px; object-fit: cover; border-radius: 8px; }
        .summary-box { background: #f8f9fa; padding: 20px; border-radius: 10px; }
    </style>


<section class="container mt-5">
    <div class="row g-4">
        <div class="col-lg-8">
            <div class="cart-box p-3 border rounded bg-white">
                <h3>Your Cart</h3>
                <table class="table cart-table align-middle">
                    <thead>
                        <tr>
                            <th>Image</th>
                            <th>Item</th>
                            <th>Price</th>
                            <th>Qty</th>
                            <th>Total</th>
                            <th>Remove</th>
                        </tr>
                    </thead>
                    <tbody id="cartItems">
                        </tbody>
                </table>
            </div>
        </div>

        <div class="col-lg-4">
            <div class="summary-box">
                <h4>Order Summary</h4>
                <div class="mb-3">
                    <input type="radio" name="orderType" value="delivery" checked> Delivery
                    <input type="radio" name="orderType" value="takeaway" class="ms-3"> Takeaway
                </div>
                <hr>
                <p class="d-flex justify-content-between">Subtotal: <span>₹<span id="subTotal">0</span></span></p>
                <p class="d-flex justify-content-between">Delivery: <span>₹<span id="deliveryCharge">0</span></span></p>
                <p class="d-flex justify-content-between">Discount: <span>₹10</span></p>
                <h5 class="d-flex justify-content-between">Total: <span>₹<span id="grandTotal">0</span></span></h5>
                <a href="checkout-page.php" id="checkoutBtn" class="btn btn-success w-100 mt-3 py-2 fw-bold">
                        Proceed to Checkout
                    </a>
            </div>
        </div>
    </div>
    <script>const isLoggedIn = <?php echo $is_logged_in; ?>;

    // 2. Listen for Click on Checkout Button
    document.getElementById('checkoutBtn').addEventListener('click', function(e) {
        
        // If user is NOT logged in
        if (!isLoggedIn) {
            e.preventDefault(); // Stop the link from opening checkout.php

            // Show SweetAlert Popup
            Swal.fire({
                title: 'Login Required!',
                text: "You need to login to place an order.",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Login Now',
                cancelButtonText: 'Continue Shopping'
            }).then((result) => {
                if (result.isConfirmed) {
                    // Redirect to Login Page
                    window.location.href = 'login.php';
                }
            });
        } else {
            // Check order type (Delivery or Takeaway)
            e.preventDefault();
            const orderType = document.querySelector('input[name="orderType"]:checked').value;
            
            if (orderType === 'delivery') {
                // Go to checkout-page.php for delivery
                window.location.href = 'checkout-page.php';
            } else if (orderType === 'takeaway') {
                // Go to takeaway.php for takeaway
                window.location.href = 'takeaway.php';
            }
        }
    });</script>
</section>

<script>
    const deliveryFee = 40;
    const discount = 10;

    // 1. Fetch Cart Data from Database (PHP)
    function loadCart() {
        const formData = new FormData();
        formData.append('action', 'fetch');

        fetch('cart-actions.php', {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            console.log("Cart Items Loaded:", data); // Debugging line
            renderCart(data);
        })
        .catch(error => console.error('Error fetching cart:', error));
    }

    // 2. Render HTML Table Rows
    function renderCart(cartItems) {
        let cartBox = document.getElementById("cartItems");
        cartBox.innerHTML = "";
        let subTotal = 0;
        let cartCount = 0;

        // Handle Empty Cart
        if (cartItems.length === 0) {
            cartBox.innerHTML = "<tr><td colspan='6' class='text-center py-4'>Your cart is empty!</td></tr>";
            updateSummary(0);
            updateCartCount(0);
            return;
        }

        // Loop through items and create table rows
        cartItems.forEach((item) => {
            let itemTotal = parseFloat(item.product_price) * parseInt(item.quantity);
            subTotal += itemTotal;
            cartCount += parseInt(item.quantity);

            cartBox.innerHTML += `
            <tr>
                <td><img src="${item.product_image}" alt="${item.product_name}"></td>
                <td>${item.product_name}</td>
                <td>₹${item.product_price}</td>
                <td>
                    <button class="btn btn-sm btn-light border" onclick="updateQty(${item.id}, ${item.quantity - 1})">-</button>
                    <span class="mx-2 fw-bold">${item.quantity}</span>
                    <button class="btn btn-sm btn-light border" onclick="updateQty(${item.id}, ${item.quantity + 1})">+</button>
                </td>
                <td>₹${itemTotal}</td>
                <td><i class="fa fa-trash text-danger" style="cursor:pointer;" onclick="removeItem(${item.id})"></i></td>
            </tr>`;
        });

        document.getElementById("subTotal").innerText = subTotal;
        updateSummary(subTotal);
        updateCartCount(cartCount);
    }

    // 3. Update Quantity
    function updateQty(id, newQty) {
        const formData = new FormData();
        formData.append('action', 'update_qty');
        formData.append('id', id);
        formData.append('qty', newQty);

        fetch('cart-actions.php', { method: 'POST', body: formData })
            .then(() => loadCart()); // Reload to show changes
    }

    // 4. Remove Item
    function removeItem(id) {
        if(!confirm("Are you sure you want to remove this item?")) return;
        
        const formData = new FormData();
        formData.append('action', 'remove');
        formData.append('id', id);

        fetch('cart-actions.php', { method: 'POST', body: formData })
            .then(() => loadCart());
    }

    // 5. Calculate Total Price
    function updateSummary(subTotal) {
        let orderType = document.querySelector("input[name='orderType']:checked").value;
        let delivery = orderType === "delivery" ? deliveryFee : 0;
        
        if (subTotal === 0) {
            document.getElementById("deliveryCharge").innerText = 0;
            document.getElementById("grandTotal").innerText = 0;
        } else {
            document.getElementById("deliveryCharge").innerText = delivery;
            document.getElementById("grandTotal").innerText = (subTotal + delivery) - discount;
        }
    }

    // 6. Update Header Cart Count (Optional UI enhancement)
    function updateCartCount(count) {
        let countElements = document.querySelectorAll('.cart-count, .mobile-cart-count');
        countElements.forEach(el => el.innerText = count);
    }

    // Event Listener for Delivery/Takeaway toggle
    document.querySelectorAll("input[name='orderType']").forEach(radio => {
        radio.addEventListener("change", () => {
            let subTotal = Number(document.getElementById("subTotal").innerText);
            updateSummary(subTotal);
        });
    });

    // Start the process when page loads
    loadCart();
    
</script>
<script>
    const deliveryFee = 40;
    const discount = 10;
    let currentCartData = []; // Store fetched data globally

    // 1. Fetch Cart Data
    function loadCart() {
        const formData = new FormData();
        formData.append('action', 'fetch');

        fetch('cart-actions.php', { method: 'POST', body: formData })
        .then(response => response.json())
        .then(data => {
            currentCartData = data; // SAVE DATA GLOBALLY
            renderCart(data);
        })
        .catch(error => console.error('Error fetching cart:', error));
    }

    // ... (Keep your renderCart, updateQty, removeItem functions exactly as they are) ...
    // ... (Keep your updateSummary function exactly as it is) ...

    const isLoggedIn = <?php echo $is_logged_in; ?>;

    // 2. MODIFIED: Proceed to Checkout Logic
    document.getElementById('checkoutBtn').addEventListener('click', function(e) {
        e.preventDefault();

        if (!isLoggedIn) {
            // ... (Your existing SweetAlert Login logic) ...
            Swal.fire({ /* ... */ }).then((result) => {
                if (result.isConfirmed) window.location.href = 'login.php';
            });
            return;
        }

        // --- NEW LOGIC STARTS HERE ---
        const orderType = document.querySelector('input[name="orderType"]:checked').value;
        const subTotal = document.getElementById("subTotal").innerText;
        const grandTotal = document.getElementById("grandTotal").innerText;
        const deliveryCharge = document.getElementById("deliveryCharge").innerText;

        // Create a data object
        const checkoutPayload = {
            items: currentCartData,
            summary: {
                subTotal: subTotal,
                delivery: deliveryCharge,
                discount: discount,
                grandTotal: grandTotal,
                orderType: orderType
            }
        };

        // Save to LocalStorage
        localStorage.setItem('checkoutData', JSON.stringify(checkoutPayload));

        // Redirect based on type
        if (orderType === 'delivery') {
            window.location.href = 'checkout-page.php';
        } else {
            window.location.href = 'takeaway.php';
        }
    });

    // Initial Load
    loadCart();
</script>
		<!-- Checkout Section End -->
		<!-- Footer Section Start -->
<footer class="restaurant-footer">
    <div class="footer-container">

        <!-- Left Top Logo + Text -->
        <div class="footer-brand">
            <img src="assets/images/Homepage1/footer-logo.png" alt="Restaurant Logo" class="footer-logo">
            <p class="footer-desc">
                A premium dining experience with handcrafted dishes, fresh ingredients, 
                and an elegant ambiance. Your comfort is our priority.
            </p>
        </div>

        <!-- Quick Links -->
        <div class="footer-links">
            <h4>Quick Links</h4>
            <ul>
                <li><a href="reservation-1.php">Reserve a Table</a></li>
                
                <li><a href="#menupage-veg.php">Explore Menu</a></li>
                <li><a href="#weekly.php">Special Offers</a></li>
                <li><a href="#catering-events.php">Catering Service</a></li>
            </ul>
        </div>

        <!-- Contact Section -->
        <div class="footer-contact">
            <h4>Contact Us</h4>
            <p> 123 Food Street, Chennai</p>
            <p> +91 98765 43210</p>
            <p>✉ support@restaurant.com</p>

            <div class="footer-social">
                <a href="#"><i class="fa fa-facebook"></i></a>
                <a href="#"><i class="fa fa-instagram"></i></a>
                <a href="#"><i class="fa fa-twitter"></i></a>
                <a href="#"><i class="fa fa-youtube"></i></a>
            </div>
        </div>

        <!-- Working Hours -->
        <div class="footer-hours">
            <h4>Working Hours</h4>
            <p>Mon – Fri : 09:00 - 22:00</p>
            <p>Saturday : 11:00 - 23:30</p>
            <p>Sunday : 11:00 - 23:00</p>
        </div>

    </div>

    <div class="footer-bottom">
        <p>© 2025 Your Restaurant Name. All Rights Reserved.</p>
        <div class="footer-bottom-links">
            <a href="#">Privacy Policy</a>
            <a href="#">Terms of Service</a>
        </div>
    </div>
</footer>

			<!-- Footer Section End -->
			<!-- Fixed Search Bar Start -->
			<div>
				<div class="fixed-serach-icon ">
					<div class="fixed-search ">
						<a href="javascript:void(0)">
							<svg width="24" height="24" viewbox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
								<mask id="mask0_504_17203" style="mask-type:alpha" maskunits="userSpaceOnUse" x="0" y="0" width="24" height="24">
									<rect width="24" height="24" fill="white"></rect>
								</mask>
								<g mask="url(#mask0_504_17203)">
									<circle cx="11.7666" cy="11.7666" r="8.98856" stroke="#0B1315" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></circle>
									<path d="M18.0183 18.4851L21.5423 22" stroke="#0B1315" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
								</g>
							</svg>
						</a>
					</div>
				</div> 
				<div class="search-popup">
					<span class="search-back-drop"></span>
					<button class="close-search"><span class="fa fa-times"></span></button>
					<div class="search-inner">
						<form method="post" action="index.php">
							<div class="form-group">
								<input type="search" name="search-field" value="" placeholder="Search..." required="">
								<button type="submit"><i class="fa fa-search"></i></button>
							</div>
						</form>
					</div>
				</div>
			</div>
			<!-- Fixed Search Bar End -->
			<!-- Hero Video Modal Start -->
			<div class="modal fade homepage-video-modal" id="hero-video-modal">
				<div class="modal-dialog modal-dialog-centered">
					<div class="modal-content">
						<div class="modal-header">
							<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
						</div>
						<div class="modal-body">
							<video class="video-sec" controls="" loop="" muted="" autoplay="">
								<source src="assets/images/Homepage1/video.mp4" type="video/mp4">
								</video>
							</div>
						</div>
					</div>
				</div>
				<!-- Hero Video Modal End -->
				<!--Scroll Top to Bottom Start -->
				<div class="scroll-top" data-scroll="up">		
				</div>
				<!--Scroll Top to Bottom  End -->
			</div>
        
			<script src="assets/js/jquery-min-3.6.0.js"></script>
			<script src="assets/js/slick.min.js"></script>
			<script src="assets/js/bootstrap.bundle.min.js"></script>
			<script src="assets/js/aos.js"></script>
			<script src="assets/js/jquery-ui.min.js"></script>
			<script src="assets/js/datepicker.js"></script>
			<script src="assets/js/wow.min.js"></script>
			<script src="assets/js/photoswipe.min.js"></script>
			<script src="assets/js/photoswipe-ui-default.min.js"></script>
			<script src="assets/js/gallery-popup.js"></script>
			<script src="assets/js/TweenMax.min.js"></script>
			<script src="assets/js/ScrollMagic.js"></script>
			<script src="assets/js/animation.gsap.min.js"></script>
			<script src="assets/js/scolling.js"></script>
			<script src="assets/js/custom.js"></script>
            <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
            </body>
		