<?php
session_start();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Forgot Password - Bermiz</title>
    <link rel="icon" href="assets/images/favicon/icon.png">
    
    <link href="https://fonts.googleapis.com/css2?family=Elsie&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Elsie&family=Lexend:wght@400;500&display=swap" rel="stylesheet">
    
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">

    <style>
        /* General Page Styling */
        body {
            font-family: 'Lexend', sans-serif;
            background-color: #fdf8f5; /* Restaurant Cream Background */
            background-image: url('assets/images/pattern-bg.png'); /* Optional Texture */
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0;
            padding: 20px;
        }

        /* Preloader Styles */
        #preloader {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: #fff;
            z-index: 99999;
            display: flex;
            justify-content: center;
            align-items: center;
            transition: opacity 1s ease-out;
        }

        /* Auth Container */
        .auth-wrapper {
            width: 100%;
            max-width: 480px;
            text-align: center;
        }

        .auth-logo {
            margin-bottom: 25px;
            max-width: 150px;
            height: auto;
        }

        .auth-card {
            background: #fff;
            border-radius: 15px;
            box-shadow: 0 10px 40px rgba(147, 26, 42, 0.1);
            padding: 40px;
            border-top: 5px solid #931A2A; /* Bermiz Red */
            position: relative;
            overflow: hidden;
        }

        /* Typography */
        .section-title {
            font-family: 'Elsie', serif;
            font-size: 28px;
            color: #931A2A;
            margin-bottom: 10px;
        }

        .section-subtitle {
            color: #666;
            font-size: 14px;
            margin-bottom: 30px;
        }

        /* Form Elements */
        .form-group {
            text-align: left;
            margin-bottom: 20px;
        }

        .form-group label {
            font-weight: 500;
            color: #333;
            margin-bottom: 8px;
            display: block;
        }

        .form-control-custom {
            width: 100%;
            padding: 12px 15px;
            border: 1px solid #e0e0e0;
            border-radius: 8px;
            font-size: 15px;
            background-color: #fafafa;
            transition: all 0.3s;
        }

        .form-control-custom:focus {
            border-color: #931A2A;
            background-color: #fff;
            box-shadow: 0 0 0 3px rgba(147, 26, 42, 0.1);
            outline: none;
        }

        /* Buttons */
        .btn-bermiz {
            width: 100%;
            padding: 14px;
            background-color: #931A2A;
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 1px;
            cursor: pointer;
            transition: all 0.3s;
        }

        .btn-bermiz:hover {
            background-color: #7a1523;
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(147, 26, 42, 0.2);
        }

        .btn-bermiz:disabled {
            background-color: #ccc;
            cursor: not-allowed;
            transform: none;
        }

        /* Icons */
        .icon-circle {
            width: 60px;
            height: 60px;
            background: #fff0f1;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
            font-size: 26px;
            color: #931A2A;
        }

        /* OTP Inputs */
        .otp-input-container {
            display: flex;
            gap: 10px;
            justify-content: center;
            margin-bottom: 25px;
        }

        .otp-input {
            width: 45px;
            height: 50px;
            text-align: center;
            font-size: 20px;
            font-weight: bold;
            border: 2px solid #eee;
            border-radius: 8px;
            color: #931A2A;
            transition: all 0.3s;
        }

        .otp-input:focus {
            border-color: #931A2A;
            background-color: #fff0f1;
            outline: none;
        }

        /* Links */
        .back-link {
            margin-top: 25px;
            font-size: 14px;
        }

        .back-link a {
            color: #666;
            text-decoration: none;
            font-weight: 500;
            transition: color 0.3s;
        }

        .back-link a:hover {
            color: #931A2A;
        }

        /* Alerts */
        .message {
            padding: 12px;
            border-radius: 8px;
            margin-bottom: 20px;
            display: none;
            font-size: 14px;
            font-weight: 500;
        }
        .message.success { background: #d4edda; color: #155724; border: 1px solid #c3e6cb; }
        .message.error { background: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; }

        /* Animation */
        .form-section { display: none; animation: fadeIn 0.5s; }
        .form-section.active { display: block; }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .timer { color: #931A2A; font-weight: bold; margin-top: 15px; font-size: 14px; }
    </style>
</head>
<body>

    <div id="preloader">
        <div class="food-loader">
            <svg width="140" height="140" viewBox="0 0 140 140" xmlns="http://www.w3.org/2000/svg">
                <rect x="40" y="65" width="60" height="35" rx="8" fill="#78350f"/>
                <path d="M100 72 Q115 82 100 92" fill="none" stroke="#78350f" stroke-width="5"/>
                <ellipse cx="70" cy="105" rx="40" ry="6" fill="#e5e7eb"/>
                <path d="M55 60 C45 50 65 40 55 30" stroke="#d97706" stroke-width="4" fill="none">
                  <animate attributeName="opacity" values="0;1;0" dur="3s" repeatCount="indefinite"/>
                </path>
                <path d="M70 60 C60 50 80 40 70 30" stroke="#f59e0b" stroke-width="4" fill="none">
                  <animate attributeName="opacity" values="0;1;0" dur="3s" begin="0.8s" repeatCount="indefinite"/>
                </path>
                <path d="M85 60 C75 50 95 40 85 30" stroke="#d97706" stroke-width="4" fill="none">
                  <animate attributeName="opacity" values="0;1;0" dur="3s" begin="1.6s" repeatCount="indefinite"/>
                </path>
                <text x="70" y="130" text-anchor="middle" font-size="11" fill="#92400e">Brewing Coffee…</text>
            </svg>
        </div>
    </div>

    <div class="auth-wrapper">
        <a href="index.php">
            <img src="assets/images/Homepage1/logo.png" alt="Bermiz Logo" class="auth-logo">
        </a>

        <div class="auth-card">
            
            <div id="successMessage" class="message success"></div>
            <div id="errorMessage" class="message error"></div>

            <div id="emailSection" class="form-section active">
                <div class="icon-circle"><i class="fa-regular fa-envelope"></i></div>
                <h2 class="section-title">Forgot Password?</h2>
                <p class="section-subtitle">No worries! Enter your email to receive a verification code.</p>
                <form onsubmit="return sendPasswordOtp(event)">
                    <div class="form-group">
                        <label>Email Address</label>
                        <input type="email" id="forgotEmail" class="form-control-custom" placeholder="name@example.com" required>
                    </div>
                    <button type="submit" class="btn-bermiz" id="emailSubmitBtn">Send Code</button>
                </form>
                <div class="back-link">
                    <a href="login.php"><i class="fa-solid fa-arrow-left"></i> Back to Sign In</a>
                </div>
            </div>

            <div id="otpSection" class="form-section">
                <div class="icon-circle"><i class="fa-solid fa-shield-halved"></i></div>
                <h2 class="section-title">Verify OTP</h2>
                <p class="section-subtitle">Enter the 6-digit code sent to your email.</p>
                <p id="otpEmail" style="color: #931A2A; font-weight: 600; font-size: 14px; margin-bottom: 20px;"></p>
                
                <form onsubmit="return verifyPasswordOtp(event)">
                    <div class="otp-input-container" id="otpInputContainer">
                        <input type="text" class="otp-input" maxlength="1" inputmode="numeric" required>
                        <input type="text" class="otp-input" maxlength="1" inputmode="numeric" required>
                        <input type="text" class="otp-input" maxlength="1" inputmode="numeric" required>
                        <input type="text" class="otp-input" maxlength="1" inputmode="numeric" required>
                        <input type="text" class="otp-input" maxlength="1" inputmode="numeric" required>
                        <input type="text" class="otp-input" maxlength="1" inputmode="numeric" required>
                    </div>
                    <button type="submit" class="btn-bermiz" id="otpSubmitBtn">Verify & Proceed</button>
                </form>
                
                <div class="timer">
                    <i class="fa-regular fa-clock"></i> <span id="otpTimer">10:00</span> remaining
                </div>
                <div class="back-link">
                    Didn't get the code? <a href="#" onclick="resendPasswordOtp()">Resend OTP</a>
                </div>
            </div>

            <div id="passwordSection" class="form-section">
                <div class="icon-circle"><i class="fa-solid fa-lock"></i></div>
                <h2 class="section-title">Reset Password</h2>
                <p class="section-subtitle">Create a new strong password.</p>
                
                <form onsubmit="return resetPassword(event)">
                    <div class="form-group">
                        <label>New Password</label>
                        <input type="password" id="newPassword" class="form-control-custom" placeholder="Min 6 characters" required>
                    </div>
                    <div class="form-group">
                        <label>Confirm Password</label>
                        <input type="password" id="confirmPassword" class="form-control-custom" placeholder="Re-enter password" required>
                    </div>
                    <button type="submit" class="btn-bermiz" id="passwordSubmitBtn">Update Password</button>
                </form>
                <div class="back-link">
                    <a href="login.php">Cancel & Return to Login</a>
                </div>
            </div>

        </div>
    </div>

<script src="assets/js/jquery-min-3.6.0.js"></script>
<script>
    // === PRELOADER LOGIC (4 Seconds Delay) ===
    window.addEventListener('load', function() {
        const preloader = document.getElementById('preloader');
        if (preloader) {
            setTimeout(function() {
                preloader.style.opacity = '0';
                setTimeout(function() {
                    preloader.style.display = 'none';
                }, 1000);
            }, 4000); 
        }
    });

    // === LOGIC VARIABLES ===
    let forgotPasswordEmail = '';
    let verifiedEmail = null;
    let otpAttempts = 0;
    const MAX_OTP_ATTEMPTS = 3;

    // === 1. SEND OTP ===
    function sendPasswordOtp(event) {
        event.preventDefault();
        forgotPasswordEmail = document.getElementById('forgotEmail').value;

        if (!forgotPasswordEmail) {
            showError('Please enter your email');
            return false;
        }

        const emailSubmitBtn = document.getElementById('emailSubmitBtn');
        emailSubmitBtn.disabled = true;
        emailSubmitBtn.innerHTML = '<i class="fa-solid fa-spinner fa-spin"></i> Sending...';

        fetch('auth.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({
                action: 'send_password_reset_otp',
                email: forgotPasswordEmail
            })
        })
        .then(response => response.json())
        .then(result => {
            if (result.status === 'success') {
                showSuccess('OTP sent successfully!');
                document.getElementById('otpEmail').textContent = 'Code sent to ' + forgotPasswordEmail;
                setTimeout(() => {
                    document.getElementById('emailSection').classList.remove('active');
                    document.getElementById('otpSection').classList.add('active');
                    startOtpTimer();
                }, 1000);
            } else {
                showError(result.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showError('Failed to send OTP. Check connection.');
        })
        .finally(() => {
            emailSubmitBtn.disabled = false;
            emailSubmitBtn.textContent = 'Send Code';
        });

        return false;
    }

    // === 2. VERIFY OTP ===
    function verifyPasswordOtp(event) {
        event.preventDefault();
        
        const otpInputs = document.querySelectorAll('.otp-input');
        let otp = '';
        otpInputs.forEach(input => otp += input.value);

        if (otp.length !== 6) {
            showError('Please enter the complete 6-digit OTP');
            return false;
        }

        const otpSubmitBtn = document.getElementById('otpSubmitBtn');
        otpSubmitBtn.disabled = true;
        otpSubmitBtn.innerHTML = '<i class="fa-solid fa-spinner fa-spin"></i> Verifying...';

        fetch('auth.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({
                action: 'verify_password_reset_otp',
                email: forgotPasswordEmail,
                otp: otp
            })
        })
        .then(response => response.json())
        .then(result => {
            if (result.status === 'success') {
                verifiedEmail = forgotPasswordEmail;
                showSuccess('OTP verified! Redirecting...');
                setTimeout(() => {
                    document.getElementById('otpSection').classList.remove('active');
                    document.getElementById('passwordSection').classList.add('active');
                }, 1000);
            } else {
                otpAttempts++;
                if (otpAttempts >= MAX_OTP_ATTEMPTS) {
                    showError('Too many failed attempts. Try again later.');
                } else {
                    showError(result.message + ' (' + (MAX_OTP_ATTEMPTS - otpAttempts) + ' attempts left)');
                }
            }
        })
        .catch(error => {
            showError('Verification failed. Try again.');
        })
        .finally(() => {
            otpSubmitBtn.disabled = false;
            otpSubmitBtn.textContent = 'Verify & Proceed';
        });

        return false;
    }

    // === 3. RESET PASSWORD ===
    function resetPassword(event) {
        event.preventDefault();

        const newPassword = document.getElementById('newPassword').value;
        const confirmPassword = document.getElementById('confirmPassword').value;

        if (newPassword !== confirmPassword) {
            showError('Passwords do not match');
            return false;
        }

        if (newPassword.length < 6) {
            showError('Password must be at least 6 characters');
            return false;
        }

        const passwordSubmitBtn = document.getElementById('passwordSubmitBtn');
        passwordSubmitBtn.disabled = true;
        passwordSubmitBtn.innerHTML = '<i class="fa-solid fa-spinner fa-spin"></i> Updating...';

        fetch('auth.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({
                action: 'reset_password',
                email: verifiedEmail,
                password: newPassword
            })
        })
        .then(response => response.json())
        .then(result => {
            if (result.status === 'success') {
                showSuccess('Password updated! Redirecting to login...');
                setTimeout(() => {
                    window.location.href = 'login.php';
                }, 2000);
            } else {
                showError(result.message);
            }
        })
        .catch(error => {
            showError('Update failed. Try again.');
        })
        .finally(() => {
            passwordSubmitBtn.disabled = false;
            passwordSubmitBtn.textContent = 'Update Password';
        });

        return false;
    }

    function resendPasswordOtp() {
        sendPasswordOtp({preventDefault: () => {}});
    }

    // === TIMER ===
    let timerInterval;
    function startOtpTimer() {
        let timeLeft = 600; // 10 minutes
        clearInterval(timerInterval);
        timerInterval = setInterval(() => {
            timeLeft--;
            const minutes = Math.floor(timeLeft / 60);
            const seconds = timeLeft % 60;
            document.getElementById('otpTimer').textContent = 
                (minutes < 10 ? '0' : '') + minutes + ':' + (seconds < 10 ? '0' : '') + seconds;

            if (timeLeft <= 0) {
                clearInterval(timerInterval);
                showError('OTP expired. Please request a new one.');
                document.getElementById('otpSection').classList.remove('active');
                document.getElementById('emailSection').classList.add('active');
            }
        }, 1000);
    }

    // === INPUT HANDLING ===
    document.querySelectorAll('.otp-input').forEach((input, index) => {
        input.addEventListener('input', (e) => {
            if (e.target.value.length === 1 && index < 5) {
                document.querySelectorAll('.otp-input')[index + 1].focus();
            }
        });
        input.addEventListener('keydown', (e) => {
            if (e.key === 'Backspace' && index > 0 && !e.target.value) {
                document.querySelectorAll('.otp-input')[index - 1].focus();
            }
        });
    });

    function showSuccess(msg) {
        const el = document.getElementById('successMessage');
        el.textContent = msg;
        el.style.display = 'block';
        setTimeout(() => el.style.display = 'none', 3000);
    }

    function showError(msg) {
        const el = document.getElementById('errorMessage');
        el.textContent = msg;
        el.style.display = 'block';
        setTimeout(() => el.style.display = 'none', 4000);
    }
</script>

</body>
</html>