<?php
session_start();
include 'db_connect.php';

// Fetch gallery images from database
$gallery_images = [];
$result = $conn->query("SELECT * FROM gallery ORDER BY created_date DESC");
if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $gallery_images[] = $row;
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title>Bermiz</title>
	<link rel="icon" href="assets/images/favicon/icon.png">
	<link href="../../../css2?family=Elsie&display=swap" rel="stylesheet">
	<link href="../../../css2-1?family=Elsie&family=Lexend:wght@400;500&display=swap" rel="stylesheet">
	<link rel="stylesheet" href="assets/css/all.min.css">
	<link rel="stylesheet" href="assets/css/slick.css">
	<link rel="stylesheet" href="assets/css/aos.css">
	<link rel="stylesheet" href="assets/css/animate.css">
	<link rel="stylesheet" href="assets/css/bootstrap.min.css">
	<link rel="stylesheet" href="assets/css/photoswipe.min.css">
	<link rel="stylesheet" href="assets/css/default-skin.min.css">
	<link rel="stylesheet" href="assets/css/style.css">
	<link rel="stylesheet" href="assets/css/media-query.css">
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
</head>
<body>
	<div class="site_content">
		<!-- Preloader Start -->
<!-- ===== RESTAURANT PRELOADER ===== -->
<div id="preloader">

  <!-- INLINE SVG COFFEE -->
  <svg width="140" height="140"
       viewBox="0 0 140 140"
       xmlns="http://www.w3.org/2000/svg">

    <!-- Cup body -->
    <rect x="40" y="65" width="60" height="35"
          rx="8" fill="#78350f"/>

    <!-- Cup handle -->
    <path d="M100 72 Q115 82 100 92"
          fill="none"
          stroke="#78350f"
          stroke-width="5"/>

    <!-- Saucer -->
    <ellipse cx="70" cy="105" rx="40" ry="6"
             fill="#e5e7eb"/>

    <!-- Steam 1 -->
    <path d="M55 60 C45 50 65 40 55 30"
          stroke="#d97706"
          stroke-width="4"
          fill="none">
      <animate attributeName="opacity"
               values="0;1;0"
               dur="1.2s"
               repeatCount="indefinite"/>
    </path>

    <!-- Steam 2 -->
    <path d="M70 60 C60 50 80 40 70 30"
          stroke="#f59e0b"
          stroke-width="4"
          fill="none">
      <animate attributeName="opacity"
               values="0;1;0"
               dur="1.2s"
               begin="0.3s"
               repeatCount="indefinite"/>
    </path>

    <!-- Steam 3 -->
    <path d="M85 60 C75 50 95 40 85 30"
          stroke="#d97706"
          stroke-width="4"
          fill="none">
      <animate attributeName="opacity"
               values="0;1;0"
               dur="1.2s"
               begin="0.6s"
               repeatCount="indefinite"/>
    </path>

    <!-- Text -->
    <text x="70" y="130"
          text-anchor="middle"
          font-size="11"
          fill="#92400e">
      Brewing Coffee…
    </text>

  </svg>

</div>

		<!-- Preloader End --><!-- ================= TOP INFO HEADER ================= -->
<div class="top-header">
    <div class="container-fluid top-header-inner">

        <div class="welcome-text">
            Welcome to Bermiz Restaurant & Catering Services
        </div>

        <div class="social-icons">
            <a href="#"><i class="fa-brands fa-facebook-f"></i></a>
            <a href="#"><i class="fa-brands fa-twitter"></i></a>
            <a href="#"><i class="fa-brands fa-instagram"></i></a>
            <a href="#"><i class="fa-brands fa-whatsapp"></i></a>
            <a href="#"><i class="fa-brands fa-youtube"></i></a>
        </div>

    </div>
</div>

<!-- ================= CONTACT STRIP ================= -->
<div class="top-header-container">
    
    <div class="logo-area">
        <a href="index.php">
        <img src="assets/images/Homepage1/logo.png" class="strip-logo">
		</a>
    </div>

    <div class="header-right-side">
        
        <div class="contact-group">
            
            <div class="contact-item">
                <i class="fas fa-phone-alt contact-icon"></i> <div>
                    <h5 class="contact-title">Call Us:</h5>
                    <p class="contact-text">+91 98765 43210</p>
                </div>
            </div>

            <div class="contact-item">
                <i class="fas fa-envelope contact-icon"></i>
                <div>
                    <h5 class="contact-title">Mail Us:</h5>
                    <p class="contact-text">bermizrestaurant@gmail.com</p>
                </div>
            </div>

            <div class="contact-item">
                <i class="fas fa-map-marker-alt contact-icon"></i>
                <div>
                    <h5 class="contact-title">Location:</h5>
                    <p class="contact-text">Coimbatore, Tamil Nadu</p>
                </div>
            </div>

        </div> 
 <div class="auth-actions" id="authContainer">
    <?php if (isset($_SESSION['user_name'])): ?>
        
        <div class="user-menu-dropdown">
            <button class="user-btn">
                <i class="fa fa-user-circle"></i> <span class="u-name"><?php echo htmlspecialchars($_SESSION['user_name']); ?></span>
                <i class="fa fa-caret-down"></i> </button>

            <div class="dropdown-content">
                <a href="profile.php">
                    <i class="fa fa-id-card"></i> View Profile
                </a>
                <a href="logout.php" class="logout-item">
                    <i class="fa fa-sign-out"></i> Logout
                </a>
            </div>
        </div>

    <?php else: ?>

        <a href="login.php" class="btn-auth btn-login">Sign In</a>
        <a href="login.php?show=signup" class="btn-auth btn-signup">Sign Up</a>

    <?php endif; ?>
</div>

    </div>
	<style>/* ========================================= */
/* TOP HEADER LAYOUT                        */
/* ========================================= */
</style>
</div>
	
		<!-- Header Section Start -->
<header id="header-homepage1" class="menupage1-header">
	<div class="header-full-section">
		<!-- Logo -->
		<div class="header-logo">
			<a href="index.php">
				<img src="assets/images/Homepage1/logo.png" alt="header-logo" class="homepage1-logo">
			</a>
		</div>


		<!-- Desktop Menu -->
		<div class="header-menu-wrap">
			<div class="header-nav-wrap">
				<nav class="navbar navbar-expand-xl p-0">
					<div class="navbar-collapse" id="navbarSupportedContent">
						<ul class="navbar-nav mx-auto align-items-center">

							<!-- HOME -->
							<li class="nav-item">
								<a class="nav-link" href="index.php">Home</a>
							</li>

							<!-- ABOUT US DROPDOWN -->
							<li class="nav-item dropdown">
								<a class="nav-link dropdown-toggle" href="javascript:void(0);">About Us</a>
								<ul class="dropdown-menu">
									<li><a class="dropdown-item" href="about-us.php">About</a></li>
									<li><a class="dropdown-item" href="chefspage2.php">Chefs</a></li>
									<li><a class="dropdown-item" href="blogpage-1.php">Blog</a></li>
									<li><a class="dropdown-item" href="faq.php">FAQ</a></li>
								</ul>
							</li>

							<!-- MENU -->
							<li class="nav-item dropdown">
								<a class="nav-link dropdown-toggle" href="javascript:void(0);">Menu</a>
								<ul class="dropdown-menu">
									<li><a class="dropdown-item" href="menupage-veg.php">Veg</a></li>
									<li><a class="dropdown-item" href="menupage-nonveg.php">Non-Veg</a></li>
									<li><a class="dropdown-item" href="drinks.php">Drinks</a></li>
                                </ul>
							</li>

							<!-- WEEKLY SPECIAL -->
							<li class="nav-item">
								<a class="nav-link" href="weekly.php">Weekly Special</a>
							</li>

							<!-- Catering & Events -->
							<li class="nav-item">
								<a class="nav-link" href="catering-events.php">Catering & Events</a>
							</li>

							<!-- RESERVATION -->
							<li class="nav-item">
								<a class="nav-link" href="online-delivery.php">Online Delivery</a>
							</li>

							<!-- GALLERY -->
							<li class="nav-item">
								<a class="nav-link" href="gallery.php">Gallery</a>
							</li>

							<!-- CONTACT -->
							<li class="nav-item">
								<a class="nav-link" href="contact-us.php">Contact Us</a>
							</li>

						</ul>
					</div>
				</nav>
			</div>
		</div>

		<!-- CART ICON -->
<div class="header-cart-sec">

    <!-- Mobile Toggle -->
    <div class="mobile-menu-icon d-xl-none">
        <a data-bs-toggle="collapse" href="#navbarSupportedmobile" role="button">
            <i class="fa-solid fa-bars"></i>
        </a>
    </div>

    <!-- CART (DESKTOP ONLY) -->
    <div class="header-cart-btn d-none d-xl-flex">
        <a href="cart-view.php">
            <i class="fa fa-shopping-cart"></i>
            <span class="cart-count">0</span>
        </a>
    </div>

    <!-- BOOKING (DESKTOP ONLY) -->
    <div class="header-cart-sec-first d-none d-xl-block">
        <a href="reservation-1.php" class="booking-btn-text">
            Booking
        </a>
    </div>

</div>



</div>

	</div>

	<!-- MOBILE MENU -->
<div class="mobile-menu-wrap d-lg-none d-block">
    <div class="mb-header-left">
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedmobile">
            <span class="navbar-toggler-icon"><i class="fa-solid fa-bars"></i></span>
        </button>

        <div class="collapse navbar-collapse" id="navbarSupportedmobile">
            <span class="close-menu"><i class="fa-regular fa-xmark"></i></span>

            <nav id='cssmenu'>
                <ul class="open-detail-menu">

                    <?php if (isset($_SESSION['user_name'])): ?>
                        <li style="border-bottom: 1px solid #ffffffff; background: #931A2A;">
                            <a href="profile.php" style="color: #ffffffff; font-weight: 700;">
                                <i class="fa fa-user-circle" style="margin-right:8px;"></i> 
                                Hello, <?php echo htmlspecialchars($_SESSION['user_name']); ?>
                            </a>
                        </li>
                    <?php endif; ?>
                    <li><a href="index.php">Home</a></li>

                    <li><a href="javascript:void(0);">About Us</a>
                        <ul class="sub-back-wrap">
                            <li><a href="about-us.php">About</a></li>
                            <li><a href="chefspage2.php">Chefs</a></li>
                            <li><a href="blogpage-1.php">Blog</a></li>
                            <li><a href="faq.php">FAQ</a></li>
                        </ul>
                    </li>

                    <li><a href="javascript:void(0);">Menu</a>
                        <ul class="sub-back-wrap">
                            <li><a href="menupage-veg.php">Veg</a></li>
                            <li><a href="menupage-nonveg.php">Non-Veg</a></li>
                            <li><a href="drinks.php">Drinks</a></li>
                        </ul>
                    </li>

                    <li><a href="weekly-special.php">Weekly Special</a></li>
                    <li><a href="catering-events.php">Catering & Events</a></li>
                    <li><a href="online-delivery.php">Online Delivery</a></li>
                    <li><a href="gallery.php">Gallery</a></li>
                    <li><a href="contact-us.php">Contact Us</a></li>
                    
                    <li class="mobile-extra">
                        <a href="cart-view.php" class="mobile-cart">
                            <i class="fa fa-shopping-cart"></i>
                            Cart <span class="mobile-cart-count">0</span>
                        </a>
                    </li>

                    <li class="mobile-extra">
                        <a href="reservation-1.php" class="booking-link">Booking</a>
                    </li>

                    <li class="mobile-auth-text">
                        <?php if (isset($_SESSION['user_name'])): ?>
                            <a href="logout.php" class="mobile-login-link" style="color: #dc3545;">
                                <i class="fa fa-sign-out"></i> Logout
                            </a>
                        <?php else: ?>
                            <a href="login.php" class="mobile-login-link">Sign In</a>
                            <a href="login.php?show=signup" class="mobile-signup-link">Sign Up</a>
                        <?php endif; ?>
                    </li>
                    </ul>
            </nav>
        </div>
    </div>
</div>				</ul>
				</nav>
			</div>
		</div>
	</div>
	<div class="header-boder"></div>
</header>


<style>/* ====================================================== */
/* 0. ROOT VARIABLES & KEYFRAME ANIMATIONS                */
/* ====================================================== */
:root {
    --primary-color: #931A2A; 
    --transition-speed: 0.4s;
}

@keyframes zoom {
    from {transform: scale(0)}
    to {transform: scale(1)}
}

/* General Wrapper for centering and max width */
#gallery-section-wrapper { 
    max-width: 1200px;
    margin: 50px auto; 
    padding: 0 20px;
    display: flex;
    flex-direction: column;
    align-items: center;
}


/* ====================================================== */
/* 1. GALLERY FILTER BUTTONS CSS (Desktop Base)           */
/* ====================================================== */
.gallery-filter {
    display: flex;
    justify-content: center;
    gap: 15px;
    margin-bottom: 40px;
    padding: 0 15px;
}

.filter-btn {
    flex-grow: 1; 
    max-width: 250px;
    background: #f0f0f0;
    color: #333;
    border: none;
    padding: 10px 25px;
    border-radius: 5px;
    cursor: pointer;
    font-weight: 600;
    transition: all 0.3s ease-in-out;
    white-space: nowrap;
}

/* Hover Effect */
.filter-btn:hover {
    background: #e0e0e0;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
}

/* Active/Selected Button Style */
.filter-btn.active {
    background: var(--primary-color); 
    color: white;
    box-shadow: 0 6px 15px rgba(147, 26, 42, 0.4);
    transform: translateY(-2px);
}
.filter-btn.active:hover {
    background: #A32A3A;
}


/* ====================================================== */
/* 2. GALLERY GRID & IMAGE ANIMATION CSS (Desktop Base)   */
/* ====================================================== */
.gallery-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, 280px);
    gap: 20px; 
    padding: 0 20px;
    width: 100%;
    max-width: 1200px;
    margin: 0 auto;
    justify-content: center;
}

/* --- Category Heading CSS Removed per user request --- */


.gallery-item {
    overflow: hidden;
    border-radius: 8px;
    box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
    position: relative;
    cursor: pointer;
    transition: opacity 0.5s ease, transform 0.5s ease;
    margin: 0;
    width: 280px;
    height: 280px;
}

.gallery-item img {
    width: 100%; height: 100%; object-fit: cover; display: block;
    transition: transform 0.4s ease-in-out;
}

/* Image Hover Animation: Lift and Zoom */
.gallery-item:hover {
    box-shadow: 0 12px 20px rgba(0, 0, 0, 0.2);
    transform: translateY(-5px);
}
.gallery-item:hover img { transform: scale(1.05); }

/* Hidden state for filtering */
.gallery-item.hidden {
    display: none;
}


/* ====================================================== */
/* 3. LIGHTBOX/IMAGE VIEWER STYLES                        */
/* ====================================================== */
.lightbox {
    display: none; position: fixed; z-index: 1000; left: 0; top: 0; width: 100%; height: 100%;
    background-color: rgba(0, 0, 0, 0.9); transition: opacity 0.3s ease; opacity: 0; padding-top: 60px;
}
.lightbox.visible { display: block; opacity: 1; }
.lightbox-content { margin: auto; display: block; width: 90%; max-width: 900px; animation-name: zoom; animation-duration: 0.6s; }
#closeLightbox {
    position: absolute; top: 15px; right: 35px; color: #f1f1f1; font-size: 40px; font-weight: bold; transition: 0.3s; cursor: pointer;
}
#closeLightbox:hover, #closeLightbox:focus { color: #bbb; text-decoration: none; cursor: pointer; }

/* =============================== */
/* GALLERY PAGE HEADING            */
/* =============================== */

.gallery-header {
    text-align: center;
    margin-bottom: 35px;
}

.gallery-header h1 {
    font-size: 42px;
    font-weight: 700;
    color: #931A2A;
    margin-bottom: 10px;
    letter-spacing: 1px;
}

.gallery-header p {
    font-size: 16px;
    color: #555;
    max-width: 600px;
    margin: 0 auto;
    line-height: 1.6;
}

/* Mobile adjustment */
@media (max-width: 768px) {
    .gallery-header h1 {
        font-size: 32px;
    }
    .gallery-header p {
        font-size: 15px;
        padding: 0 10px;
    }
    
    .gallery-grid {
        grid-template-columns: repeat(auto-fill, 200px);
        justify-content: center;
    }
    
    .gallery-item {
        width: 200px;
        height: 200px;
    }
}


/* ====================================================== */
/* 4. MOBILE RESPONSIVENESS (Screens 768px and Smaller)   */
/* ====================================================== */
@media (max-width: 768px) {
    
    /* Filter Buttons stack vertically */
    .gallery-filter { flex-direction: column; gap: 10px; margin-bottom: 30px; }
    .filter-btn { max-width: 100%; transform: none; }
    
    /* Gallery Grid adjusts to 2 columns */
    .gallery-grid { grid-template-columns: repeat(2, 1fr); gap: 15px; padding: 0 10px; }

    /* Disable all hover effects on mobile */
    .gallery-item:hover { transform: none; box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1); }
    .gallery-item:hover img { transform: scale(1); }
}

@media (max-width: 480px) {
    /* Gallery Grid adjusts to 1 column on smallest screens */
    .gallery-grid { 
        grid-template-columns: repeat(auto-fill, 150px);
        justify-content: center;
    }
    
    .gallery-item {
        width: 150px;
        height: 150px;
    }
}</style>
</head>
<body>

<!-- ================================================= -->
<!-- ===================== HEADER ===================== -->
<!-- ================================================= -->
<section id="menupage-1-section">
    <div class="menupage-1-section-img">
        <div class="menupage-1-overlay"></div>
        
        <div class="menupage-1-conten text-center"> <h1 class="menupage-1-hero-txt1 wow fadeInDown" data-wow-duration="1s" data-wow-delay="0.5s">
                Gallery
            </h1>

            <nav aria-label="breadcrumb">
                <ol class="breadcrumb justify-content-center transparent-breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="index.php">
                            <span class="home-icon">
                                <svg width="24" height="24" viewbox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <mask id="mask0_564_5237" style="mask-type:alpha" maskunits="userSpaceOnUse" x="0" y="0" width="24" height="24">
                                        <rect width="24" height="24" fill="white"></rect>
                                    </mask>
                                    <g mask="url(#mask0_564_5237)">
                                        <path d="M9.15722 20.7714V17.7047C9.1572 16.9246 9.79312 16.2908 10.581 16.2856H13.4671C14.2587 16.2856 14.9005 16.9209 14.9005 17.7047V17.7047V20.7809C14.9003 21.4432 15.4343 21.9845 16.103 22H18.0271C19.9451 22 21.5 20.4607 21.5 18.5618V18.5618V9.83784C21.4898 9.09083 21.1355 8.38935 20.538 7.93303L13.9577 2.6853C12.8049 1.77157 11.1662 1.77157 10.0134 2.6853L3.46203 7.94256C2.86226 8.39702 2.50739 9.09967 2.5 9.84736V18.5618C2.5 20.4607 4.05488 22 5.97291 22H7.89696C8.58235 22 9.13797 21.4499 9.13797 20.7714V20.7714" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
                                    </g>
                                </svg>
                            </span>
                            Home
                        </a>
                    </li>
                    <li class="breadcrumb-item active text-white" aria-current="page">gallery</li>
                </ol>
            </nav>

        </div>
    </div>
    <div class="menupage1-boder"></div>
</section>
<<section id="gallery-section-wrapper">
    <div class="gallery-header">
    <h1>Our Gallery</h1>
    <p>A glimpse of our food, ambience, events & passionate team</p>
</div>

    <div class="gallery-filter">
        <button class="filter-btn active" data-filter="all">All</button>
        <button class="filter-btn" data-filter="food">Food</button>
        <button class="filter-btn" data-filter="events">Ambience & Events</button>
        <button class="filter-btn" data-filter="staff">Staff</button>
    </div>

    <div class="gallery-grid">
        <?php 
        if (!empty($gallery_images)) {
            foreach ($gallery_images as $image) {
                $category = htmlspecialchars($image['category']);
                $image_path = htmlspecialchars($image['image_path']);
                $title = htmlspecialchars($image['title']);
                echo '<div class="gallery-item ' . $category . '"><img src="' . $image_path . '" alt="' . $title . '"></div>';
            }
        } else {
            // Fallback to old images if database is empty
            echo '
            <div class="gallery-item food"><img src="assets/images/menupage-6/menu-1.png" alt="Food Item 1"></div>
            <div class="gallery-item food"><img src="assets/images/menupage-6/menu-2.png" alt="Food Item 2"></div>
            <div class="gallery-item food"><img src="assets/images/menupage-6/menu-3.png" alt="Food Item 3"></div>
            <div class="gallery-item food"><img src="assets/images/menupage-6/menu-4.png" alt="Food Item 4"></div>
            <div class="gallery-item food"><img src="assets/images/menupage-6/menu-5.png" alt="Food Item 5"></div>
            <div class="gallery-item food"><img src="assets/images/menupage-6/menu-6.png" alt="Food Item 6"></div>

            <div class="gallery-item events"><img src="assets/images/menupage-6/1.jpg" alt="Ambience 1"></div>
            <div class="gallery-item events"><img src="assets/images/menupage-6/3.jpg" alt="Ambience 2"></div>
            <div class="gallery-item events"><img src="assets/images/menupage-6/2.jpg" alt="Ambience 3"></div>
            <div class="gallery-item events"><img src="assets/images/menupage-6/4.jpg" alt="Ambience 4"></div>

            <div class="gallery-item staff"><img src="assets/images/chefspage2/chefs-1.png" alt="Chef 1"></div>
            <div class="gallery-item staff"><img src="assets/images/chefspage2/chefs-2.png" alt="Chef 2"></div>
            <div class="gallery-item staff"><img src="assets/images/chefspage2/chefs-3.png" alt="Chef 3"></div>
            ';
        }
        ?>
    </div>
</section>
<div id="lightbox" class="lightbox">
    <span id="closeLightbox">&times;</span>
    <img id="lightboxImg" class="lightbox-content" alt="Enlarged Gallery Image">
</div>

<script>
    // Paste the JavaScript from Section 3 below here
</script>



<!-- ================================================= -->
<!-- ===================== FOOTER ===================== -->
<!-- ================================================= -->
<footer class="restaurant-footer">
    <div class="footer-container">

        <!-- Left Top Logo + Text -->
        <div class="footer-brand">
            <img src="assets/images/Homepage1/footer-logo.png" alt="Restaurant Logo" class="footer-logo">
            <p class="footer-desc">
                A premium dining experience with handcrafted dishes, fresh ingredients, 
                and an elegant ambiance. Your comfort is our priority.
            </p>
        </div>

        <!-- Quick Links -->
        <div class="footer-links">
            <h4>Quick Links</h4>
            <ul>
                <li><a href="reservation-1.php">Reserve a Table</a></li>
                
                <li><a href="#menupage-veg.php">Explore Menu</a></li>
                <li><a href="#weekly.php">Special Offers</a></li>
                <li><a href="#catering-events.php">Catering Service</a></li>
            </ul>
        </div>

        <!-- Contact Section -->
        <div class="footer-contact">
            <h4>Contact Us</h4>
            <p> 123 Food Street, Chennai</p>
            <p> +91 98765 43210</p>
            <p>✉ support@restaurant.com</p>

            <div class="footer-social">
                <a href="#"><i class="fa fa-facebook"></i></a>
                <a href="#"><i class="fa fa-instagram"></i></a>
                <a href="#"><i class="fa fa-twitter"></i></a>
                <a href="#"><i class="fa fa-youtube"></i></a>
            </div>
        </div>

        <!-- Working Hours -->
        <div class="footer-hours">
            <h4>Working Hours</h4>
            <p>Mon – Fri : 09:00 - 22:00</p>
            <p>Saturday : 11:00 - 23:30</p>
            <p>Sunday : 11:00 - 23:00</p>
        </div>

    </div>

    <div class="footer-bottom">
        <p>© 2025 Your Restaurant Name. All Rights Reserved.</p>
        <div class="footer-bottom-links">
            <a href="#">Privacy Policy</a>
            <a href="#">Terms of Service</a>
        </div>
    </div>
</footer>
			<!-- Footer Section End -->
			<!-- Fixed Search Bar Start -->
			<div>
				<div class="fixed-serach-icon ">
					<div class="fixed-search ">
						<a href="javascript:void(0)">
							<svg width="24" height="24" viewbox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
								<mask id="mask0_504_17203" style="mask-type:alpha" maskunits="userSpaceOnUse" x="0" y="0" width="24" height="24">
									<rect width="24" height="24" fill="white"></rect>
								</mask>
								<g mask="url(#mask0_504_17203)">
									<circle cx="11.7666" cy="11.7666" r="8.98856" stroke="#0A1A2F" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></circle>
									<path d="M18.0183 18.4851L21.5423 22" stroke="#0A1A2F" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
								</g>
							</svg>
						</a>
					</div>
				</div> 
				<div class="search-popup">
					<span class="search-back-drop"></span>
					<button class="close-search"><span class="fa fa-times"></span></button>
					<div class="search-inner">
						<form method="post" action="index.php">
							<div class="form-group">
								<input type="search" name="search-field" value="" placeholder="Search..." required="">
								<button type="submit"><i class="fa fa-search"></i></button>
							</div>
						</form>
					</div>
				</div>
			</div>
			<!-- Fixed Search Bar End -->
			<!-- Hero Video Modal Start -->
			<div class="modal fade homepage-video-modal" id="hero-video-modal">
				<div class="modal-dialog modal-dialog-centered">
					<div class="modal-content">
						<div class="modal-header">
							<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
						</div>
						<div class="modal-body">
							<video class="video-sec" controls="" loop="" muted="" autoplay="">
								<source src="assets/images/Homepage1/video.mp4" type="video/mp4">
								</video>
							</div>
						</div>
					</div>
				</div>
				<!-- Hero Video Modal End -->
				<!--Scroll Top to Bottom Start -->
				<div class="scroll-top" data-scroll="up">		
				</div>
				<!--Scroll Top to Bottom  End -->
			</div>
			<script src="assets/js/jquery-min-3.6.0.js"></script>
			<script src="assets/js/slick.min.js"></script>
			<script src="assets/js/bootstrap.bundle.min.js"></script>
			<script src="assets/js/aos.js"></script>
			<script src="assets/js/jquery-ui.min.js"></script>
			<script src="assets/js/datepicker.js"></script>
			<script src="assets/js/wow.min.js"></script>
			<script src="assets/js/photoswipe.min.js"></script>
			<script src="assets/js/photoswipe-ui-default.min.js"></script>
			<script src="assets/js/gallery-popup.js"></script>
			<script src="assets/js/TweenMax.min.js"></script>
			<script src="assets/js/ScrollMagic.js"></script>
			<script src="assets/js/animation.gsap.min.js"></script>
			<script src="assets/js/scolling.js"></script>
			<script src="assets/js/custom.js"></script>

<!-- FILTER SCRIPT -->

<script>
document.addEventListener('DOMContentLoaded', function() {
    const filterBtns = document.querySelectorAll('.filter-btn');
    const galleryItems = document.querySelectorAll('.gallery-item');
    const lightbox = document.getElementById('lightbox');
    const lightboxImg = document.getElementById('lightboxImg');
    const closeLightbox = document.getElementById('closeLightbox');

    // --- A. Filtering Logic ---
    filterBtns.forEach(button => {
        button.addEventListener('click', function() {
            // 1. Update Active State
            filterBtns.forEach(btn => btn.classList.remove('active'));
            this.classList.add('active');

            const filterValue = this.getAttribute('data-filter');

            // 2. Filter Gallery Items
            galleryItems.forEach(item => {
                const isMatch = filterValue === 'all' || item.classList.contains(filterValue);

                if (isMatch) {
                    item.classList.remove('hidden');
                } else {
                    item.classList.add('hidden');
                }
            });
        });
    });

    // --- B. Lightbox Logic ---
    galleryItems.forEach(item => {
        item.addEventListener('click', function() {
            const imgSrc = this.querySelector('img').src;
            
            lightboxImg.src = imgSrc;
            lightbox.classList.add('visible');
            document.body.style.overflow = 'hidden'; // Prevent scrolling
        });
    });

    // Close Lightbox on X click, outside click, and ESC key
    closeLightbox.addEventListener('click', function() {
        lightbox.classList.remove('visible');
        document.body.style.overflow = 'auto';
    });

    lightbox.addEventListener('click', function(e) {
        if (e.target === lightbox) {
            lightbox.classList.remove('visible');
            document.body.style.overflow = 'auto';
        }
    });

    document.addEventListener('keydown', function(e) {
        if (e.key === "Escape" && lightbox.classList.contains('visible')) {
            lightbox.classList.remove('visible');
            document.body.style.overflow = 'auto';
        }
    });
});
</script>



</body>
</html>
