﻿<?php
session_start();
include 'db_connect.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title>Bermiz</title>
	<link rel="icon" href="assets/images/favicon/icon.png">
	<link href="../../../css2?family=Elsie&display=swap" rel="stylesheet">
	<link href="../../../css2-1?family=Elsie&family=Lexend:wght@400;500&display=swap" rel="stylesheet">
	<link rel="stylesheet" href="assets/css/all.min.css">
	<link rel="stylesheet" href="assets/css/slick.css">
	<link rel="stylesheet" href="assets/css/aos.css">
	<link rel="stylesheet" href="assets/css/animate.css">
	<link rel="stylesheet" href="assets/css/bootstrap.min.css">
	<link rel="stylesheet" href="assets/css/photoswipe.min.css">
	<link rel="stylesheet" href="assets/css/default-skin.min.css">
	<link rel="stylesheet" href="assets/css/style.css">
	<link rel="stylesheet" href="assets/css/media-query.css">
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
	
</head>
<body>
	<div class="site_content">
		<!-- Preloader Start -->
<!-- ===== RESTAURANT PRELOADER ===== -->
<div id="preloader">

  <!-- INLINE SVG COFFEE -->
  <svg width="140" height="140"
       viewBox="0 0 140 140"
       xmlns="http://www.w3.org/2000/svg">

    <!-- Cup body -->
    <rect x="40" y="65" width="60" height="35"
          rx="8" fill="#78350f"/>

    <!-- Cup handle -->
    <path d="M100 72 Q115 82 100 92"
          fill="none"
          stroke="#78350f"
          stroke-width="5"/>

    <!-- Saucer -->
    <ellipse cx="70" cy="105" rx="40" ry="6"
             fill="#e5e7eb"/>

    <!-- Steam 1 -->
    <path d="M55 60 C45 50 65 40 55 30"
          stroke="#d97706"
          stroke-width="4"
          fill="none">
      <animate attributeName="opacity"
               values="0;1;0"
               dur="1.2s"
               repeatCount="indefinite"/>
    </path>

    <!-- Steam 2 -->
    <path d="M70 60 C60 50 80 40 70 30"
          stroke="#f59e0b"
          stroke-width="4"
          fill="none">
      <animate attributeName="opacity"
               values="0;1;0"
               dur="1.2s"
               begin="0.3s"
               repeatCount="indefinite"/>
    </path>

    <!-- Steam 3 -->
    <path d="M85 60 C75 50 95 40 85 30"
          stroke="#d97706"
          stroke-width="4"
          fill="none">
      <animate attributeName="opacity"
               values="0;1;0"
               dur="1.2s"
               begin="0.6s"
               repeatCount="indefinite"/>
    </path>

    <!-- Text -->
    <text x="70" y="130"
          text-anchor="middle"
          font-size="11"
          fill="#92400e">
      Brewing Coffee…
    </text>

  </svg>

</div>



		<!-- Preloader End --><!-- ================= TOP INFO HEADER ================= -->
<div class="top-header">
    <div class="container-fluid top-header-inner">

        <div class="welcome-text">
            Welcome to Bermiz Restaurant & Catering Services
        </div>

        <div class="social-icons">
            <a href="#"><i class="fa-brands fa-facebook-f"></i></a>
            <a href="#"><i class="fa-brands fa-twitter"></i></a>
            <a href="#"><i class="fa-brands fa-instagram"></i></a>
            <a href="#"><i class="fa-brands fa-whatsapp"></i></a>
            <a href="#"><i class="fa-brands fa-youtube"></i></a>
        </div>

    </div>
</div>

<!-- ================= CONTACT STRIP ================= -->
<div class="top-header-container">
    
    <div class="logo-area">
        <a href="index.php">
        <img src="assets/images/Homepage1/logo.png" class="strip-logo">
		</a>
    </div>

    <div class="header-right-side">
        
        <div class="contact-group">
            
            <div class="contact-item">
                <i class="fas fa-phone-alt contact-icon"></i> <div>
                    <h5 class="contact-title">Call Us:</h5>
                    <p class="contact-text">+91 98765 43210</p>
                </div>
            </div>

            <div class="contact-item">
                <i class="fas fa-envelope contact-icon"></i>
                <div>
                    <h5 class="contact-title">Mail Us:</h5>
                    <p class="contact-text">bermizrestaurant@gmail.com</p>
                </div>
            </div>

            <div class="contact-item">
                <i class="fas fa-map-marker-alt contact-icon"></i>
                <div>
                    <h5 class="contact-title">Location:</h5>
                    <p class="contact-text">Coimbatore, Tamil Nadu</p>
                </div>
            </div>

        </div> 
<div class="auth-actions" id="authContainer">
    <?php if (isset($_SESSION['user_name'])): ?>
        
        <div class="user-menu-dropdown">
            <button class="user-btn">
                <i class="fa fa-user-circle"></i> <span class="u-name"><?php echo htmlspecialchars($_SESSION['user_name']); ?></span>
                <i class="fa fa-caret-down"></i> </button>

            <div class="dropdown-content">
                <a href="profile.php">
                    <i class="fa fa-id-card"></i> View Profile
                </a>
                <a href="logout.php" class="logout-item">
                    <i class="fa fa-sign-out"></i> Logout
                </a>
            </div>
        </div>

    <?php else: ?>

        <a href="login.php" class="btn-auth btn-login">Sign In</a>
        <a href="login.php?show=signup" class="btn-auth btn-signup">Sign Up</a>

    <?php endif; ?>
</div>

    </div>
	<style>/* ========================================= */
/* TOP HEADER LAYOUT                        */
/* ========================================= */
</style>
</div>
	
		<!-- Header Section Start -->
<header id="header-homepage1" class="menupage1-header">
	<div class="header-full-section">
		<!-- Logo -->
		<div class="header-logo">
			<a href="index.php">
				<img src="assets/images/Homepage1/logo.png" alt="header-logo" class="homepage1-logo">
			</a>
		</div>


		<!-- Desktop Menu -->
		<div class="header-menu-wrap">
			<div class="header-nav-wrap">
				<nav class="navbar navbar-expand-xl p-0">
					<div class="navbar-collapse" id="navbarSupportedContent">
						<ul class="navbar-nav mx-auto align-items-center">

							<!-- HOME -->
							<li class="nav-item">
								<a class="nav-link" href="index.php">Home</a>
							</li>

							<!-- ABOUT US DROPDOWN -->
							<li class="nav-item dropdown">
								<a class="nav-link dropdown-toggle" href="javascript:void(0);">About Us</a>
								<ul class="dropdown-menu">
									<li><a class="dropdown-item" href="about-us.php">About</a></li>
									<li><a class="dropdown-item" href="chefspage2.php">Chefs</a></li>
									<li><a class="dropdown-item" href="blogpage-1.php">Blog</a></li>
									<li><a class="dropdown-item" href="faq.php">FAQ</a></li>
								</ul>
							</li>

							<!-- MENU -->
							<li class="nav-item dropdown">
								<a class="nav-link dropdown-toggle" href="javascript:void(0);">Menu</a>
								<ul class="dropdown-menu">
									<li><a class="dropdown-item" href="menupage-veg.php">Veg</a></li>
									<li><a class="dropdown-item" href="menupage-nonveg.php">Non-Veg</a></li>
									<li><a class="dropdown-item" href="drinks.php">Drinks</a></li>
                                </ul>
							</li>

							<!-- WEEKLY SPECIAL -->
							<li class="nav-item">
								<a class="nav-link" href="weekly.php">Weekly Special</a>
							</li>

							<!-- Catering & Events -->
							<li class="nav-item">
								<a class="nav-link" href="catering-events.php">Catering & Events</a>
							</li>

							<!-- RESERVATION -->
							<li class="nav-item">
								<a class="nav-link" href="online-delivery.php">Online Delivery</a>
							</li>

							<!-- GALLERY -->
							<li class="nav-item">
								<a class="nav-link" href="gallery.php">Gallery</a>
							</li>

							<!-- CONTACT -->
							<li class="nav-item">
								<a class="nav-link" href="contact-us.php">Contact Us</a>
							</li>

						</ul>
					</div>
				</nav>
			</div>
		</div>

		<!-- CART ICON -->
<div class="header-cart-sec">

    <!-- Mobile Toggle -->
    <div class="mobile-menu-icon d-xl-none">
        <a data-bs-toggle="collapse" href="#navbarSupportedmobile" role="button">
            <i class="fa-solid fa-bars"></i>
        </a>
    </div>

    <!-- CART (DESKTOP ONLY) -->
    <div class="header-cart-btn d-none d-xl-flex">
        <a href="cart-view.php">
            <i class="fa fa-shopping-cart"></i>
            <span class="cart-count">0</span>
        </a>
    </div>

    <!-- BOOKING (DESKTOP ONLY) -->
    <div class="header-cart-sec-first d-none d-xl-block">
        <a href="reservation-1.php" class="booking-btn-text">
            Booking
        </a>
    </div>

</div>



</div>

	</div>

	<!-- MOBILE MENU -->
<div class="mobile-menu-wrap d-lg-none d-block">
    <div class="mb-header-left">
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedmobile">
            <span class="navbar-toggler-icon"><i class="fa-solid fa-bars"></i></span>
        </button>

        <div class="collapse navbar-collapse" id="navbarSupportedmobile">
            <span class="close-menu"><i class="fa-regular fa-xmark"></i></span>

            <nav id='cssmenu'>
                <ul class="open-detail-menu">

                    <?php if (isset($_SESSION['user_name'])): ?>
                        <li style="border-bottom: 1px solid #ffffffff; background: #931A2A;">
                            <a href="profile.php" style="color: #ffffffff; font-weight: 700;">
                                <i class="fa fa-user-circle" style="margin-right:8px;"></i> 
                                Hello, <?php echo htmlspecialchars($_SESSION['user_name']); ?>
                            </a>
                        </li>
                    <?php endif; ?>
                    <li><a href="index.php">Home</a></li>

                    <li><a href="javascript:void(0);">About Us</a>
                        <ul class="sub-back-wrap">
                            <li><a href="about-us.php">About</a></li>
                            <li><a href="chefspage2.php">Chefs</a></li>
                            <li><a href="blogpage-1.php">Blog</a></li>
                            <li><a href="faq.php">FAQ</a></li>
                        </ul>
                    </li>

                    <li><a href="javascript:void(0);">Menu</a>
                        <ul class="sub-back-wrap">
                            <li><a href="menupage-veg.php">Veg</a></li>
                            <li><a href="menupage-nonveg.php">Non-Veg</a></li>
                            <li><a href="drinks.php">Drinks</a></li>
                        </ul>
                    </li>

                    <li><a href="weekly-special.php">Weekly Special</a></li>
                    <li><a href="catering-events.php">Catering & Events</a></li>
                    <li><a href="online-delivery.php">Online Delivery</a></li>
                    <li><a href="gallery.php">Gallery</a></li>
                    <li><a href="contact-us.php">Contact Us</a></li>
                    
                    <li class="mobile-extra">
                        <a href="cart-view.php" class="mobile-cart">
                            <i class="fa fa-shopping-cart"></i>
                            Cart <span class="mobile-cart-count">0</span>
                        </a>
                    </li>

                    <li class="mobile-extra">
                        <a href="reservation-1.php" class="booking-link">Booking</a>
                    </li>

                    <li class="mobile-auth-text">
                        <?php if (isset($_SESSION['user_name'])): ?>
                            <a href="logout.php" class="mobile-login-link" style="color: #dc3545;">
                                <i class="fa fa-sign-out"></i> Logout
                            </a>
                        <?php else: ?>
                            <a href="login.php" class="mobile-login-link">Sign In</a>
                            <a href="login.php?show=signup" class="mobile-signup-link">Sign Up</a>
                        <?php endif; ?>
                    </li>
                    </ul>
            </nav>
        </div>
    </div>
</div>
					</ul>
				</nav>
			</div>
		</div>
	</div>
	<div class="header-boder"></div>
</header>


		<!-- Header Section End -->
		<!-- Hero Section Start -->
<section id="hero-slider">

    <div class="hero-slider-container">
        <?php
        // Fetch active hero slides from database
        $slides_result = $conn->query("SELECT * FROM hero_slides WHERE is_active = 1 ORDER BY display_order ASC");
        
        if ($slides_result && $slides_result->num_rows > 0) {
            $slide_count = 0;
            while ($slide = $slides_result->fetch_assoc()) {
                $is_active = ($slide_count === 0) ? 'active' : '';
                $bg_image = !empty($slide['background_image']) ? $slide['background_image'] : 'assets/images/bg/default.jpg';
        ?>
        <!-- ==== DYNAMIC SLIDE <?php echo $slide_count + 1; ?> ==== -->
        <div class="hero-slide <?php echo $is_active; ?>" style="background-image: url('<?php echo htmlspecialchars($bg_image); ?>');">
            <div class="hero-content">
                <h1 class="hero-title"><?php echo htmlspecialchars($slide['title']); ?></h1>
                <p class="hero-desc"><?php echo htmlspecialchars($slide['description']); ?></p>
                <a href="<?php echo htmlspecialchars($slide['button_link']); ?>" class="hero-btn"><?php echo htmlspecialchars($slide['button_text']); ?></a>
            </div>
            <?php if (!empty($slide['layer_image'])): ?>
            <div class="hero-layer">
                <img src="<?php echo htmlspecialchars($slide['layer_image']); ?>" alt="<?php echo htmlspecialchars($slide['title']); ?> Layer">
            </div>
            <?php endif; ?>
        </div>
        <?php
                $slide_count++;
            }
        } else {
            // Fallback to default slides if no database slides exist
        ?>
        <!-- ==== SLIDE 1 ==== -->
        <div class="hero-slide active" style="background-image: url('assets/images/bg/1.jpeg');">
            <div class="hero-content">
                <h1 class="hero-title">Perfectly Light In Every Bite</h1>
                <p class="hero-desc">We create magical flavors with love, passion, and the finest ingredients.</p>
                <a href="menupage-veg.php" class="hero-btn">Discover Menu</a>
            </div>
            <div class="hero-layer">
                <img src="assets/images/layer/1.png" alt="Decorative Layer">
            </div>
        </div>

        <!-- ==== SLIDE 2 ==== -->
        <div class="hero-slide" style="background-image: url('assets/images/bg/2.png');">
            <div class="hero-content">
                <h1 class="hero-title">Taste That Feels Like Home</h1>
                <p class="hero-desc">Crafted with tradition, served with passion — your comfort food awaits.</p>
                <a href="menupage-nonveg.php" class="hero-btn">Explore Specials</a>
            </div>
            <div class="hero-layer">
                <img src="assets/images/layer/2.png" alt="Specials Decorative Layer">
            </div>
        </div>

        <div class="hero-slide" style="background-image: url('assets/images/bg/3.jpeg');">
            <div class="hero-content">
                <h1 class="hero-title">Where Every Meal Tells a Story</h1>
                <p class="hero-desc">A blend of authentic flavors & modern cooking — made fresh every day.</p>
                <a href="menupage-nonveg.php" class="hero-btn">Order Now</a>
            </div>
            <div class="hero-layer">
                <img src="assets/images/layer/3.png" alt="Fresh Food Decorative Layer">
            </div>
        </div>
        <?php } ?>
<style>/* Container for the PNG */
.hero-layer {
    position: absolute;
    right: 5%;          /* Distance from the right edge */
    top: 50%;           /* Vertically centered */
    transform: translateY(-50%);
    z-index: 1;         /* Behind the text (if they overlap), above background */
    pointer-events: none; /* Allows clicks to pass through to the background */
    width: 450px;       /* Adjust size as needed */
    max-width: 45%;
    opacity: 0;         /* Hidden by default */
}

.hero-layer img {
    width: 100%;
    height: auto;
    display: block;
}

/* Ensure Text is above the image */
.hero-content {
    position: relative;
    z-index: 2; 
}

/* --- THE ANIMATION --- */

/* Only animate when the parent has the 'active' class */
.hero-slide.active .hero-layer {
    animation: slideInRight 1.5s ease-out forwards;
}

/* Define the movement */
@keyframes slideInRight {
    0% {
        opacity: 0;
        transform: translate(100px, -50%); /* Start 100px to the right */
    }
    100% {
        opacity: 1;
        transform: translate(0, -50%); /* End at original position */
    }
}

/* --- MOBILE RESPONSIVENESS --- */
@media screen and (max-width: 768px) {
    .hero-layer {
        display: none; /* Hide on mobile to save space */
        /* OR make it smaller and move to bottom: */
        /* width: 200px;
        right: -50px;
        top: 80%;
        display: block;
        */
    }
}</style>
    </div>

    <!-- Slide Controls - Dynamic -->
    <div class="hero-controls">
        <?php
        // Generate dots based on number of slides
        $slides_result = $conn->query("SELECT COUNT(*) as total FROM hero_slides WHERE is_active = 1");
        $slide_count = $slides_result->fetch_assoc()['total'];
        
        // If no active slides in database, default to 3
        if ($slide_count == 0) {
            $slide_count = 3;
        }
        
        for ($i = 0; $i < $slide_count; $i++) {
            $active_class = ($i === 0) ? 'active' : '';
            echo '<span class="hero-dot ' . $active_class . '" data-slide="' . $i . '"></span>';
        }
        ?>
    </div>

</section>


		<!-- Hero Section End -->
		<!-- Hero Video Section Start -->

		<!-- Hero Video Section End -->
		<!-- Our Restaurant Section Start-->
<section id="restaurant-section-new" class="restaurant-new">
    <div class="container">

        <div class="restaurant-grid">

            <!-- LEFT : IMAGES -->
            <div class="restaurant-images">
                <div class="img-main">
                    <img src="assets/images/Homepage1/restaurant-1.png" alt="Restaurant">
                </div>

                <div class="img-overlay">
                    <img src="assets/images/Homepage1/restaurant-2.png" alt="Restaurant">
                </div>
            </div>

            <!-- RIGHT : CONTENT -->
            <div class="restaurant-content">
                <p class="section-tag">
                    <img src="assets/images/Homepage1/yellow-star.png"> Our Restaurant
                </p>

                <h2>
                    For Every Special Occasion <br>
                    There’s <span>Heritaste</span>
                </h2>

                <p class="desc">
                    Diam leo massa pellentesque a neque turpis cum mi gravida. 
                    Amet massa adipiscing mi dictum urna commodo.
                </p>

                <div class="features">
                    <div class="feature">
                        <img src="assets/images/Homepage1/restaurant-3.png">
                        <div>
                            <h4>Quiet Environment</h4>
                            <p>Calm, peaceful dining experience with elegant ambience.</p>
                        </div>
                    </div>

                    <div class="feature">
                        <img src="assets/images/Homepage1/restaurant-4.png">
                        <div>
                            <h4>Hygienic Food</h4>
                            <p>Prepared with utmost care & quality ingredients.</p>
                        </div>
                    </div>
                </div>

                <a href="about-us.php" class="btn-explore">Explore Us</a>
            </div>

        </div>

    </div>
	<style>/* ================= RESTAURANT NEW ================= */

</style>
<script>
    const reveals = document.querySelectorAll('.reveal');

    function revealOnScroll() {
        reveals.forEach(el => {
            const windowHeight = window.innerHeight;
            const elementTop = el.getBoundingClientRect().top;

            if (elementTop < windowHeight - 100) {
                el.classList.add('active');
            }
        });
    }

    window.addEventListener('scroll', revealOnScroll);
    revealOnScroll();
</script>

</section>

		<!-- Our Restaurant Section End -->
		<!-- Ticker Section Start -->
			<section id="ticker-section">
				<div class="ticker-wrap">
					<h2 class="d-none">Ticker Section</h2>
					<div class="marquee">
						<div class="marquee_group">
							<p>Door Delivery</p>
							<p aria-hidden="true">Fine Dining</p>
							<p aria-hidden="true">Outdoor Catering </p>
							<p aria-hidden="true">Banquets</p>
							<p aria-hidden="true">Wine Shop</p>
						</div>
						<div aria-hidden="true" class="marquee_group">
							<p>Door Delivery</p>
							<p>Fine Dining</p>
							<p>Outdoor Catering </p>
							<p>Banquets</p>
							<p>Wine Shop</p>
						</div>
					</div>
				</div>
			</section>
		<!-- Ticker Section End -->
		<!-- Chefs Secrets Start -->
		<section id="chefs-secrets-section" class="reveal">
			<div class="container line ptb-100">
				<span class="line-3"></span>
				<span class="line-4"></span>
				<span class="line-5"> </span>
				<div class="chefs-top-sec">
					<h2 class="chefs-txt1 wow fadeInUp" data-wow-duration="1s">Various Quality Specialities Made With A Personal Touch</h2>
				</div>
				<div class="chefs-bottom-sec">
					<div class="chefs-bottom-sec-wrap">
						<div class="chefs-bottom-left">
							<div class="chefs-img-sec">
								<div class="chefs-img-sec-22 pbmit-animation-style1 reveal">
									<img src="assets/images/Homepage1/chefs-1.png" alt="food-img" class="">
								</div>
								<div class="chefs-img-sec-2">
									<img src="assets/images/Homepage1/chefs-2.png" alt="food-img">
								</div>
							</div>
						</div>
						<div class="chefs-bottom-rigth">
							<div class="chefs-bottom-rigth-wrap">
								<p class="chefs-txt2"><span class="pr-10"><img src="assets/images/Homepage1/yellow-star.png" alt="yellow-star"></span>CHEFS SECRETS<span class="pf-10"><img src="assets/images/Homepage1/yellow-star.png" alt="yellow-star"></span></p>
								<h3 class="chefs-txt3 wow fadeInUp" data-wow-duration="1s">Truly Exotic & Appetizing Cuisine For Thous Special Moments In Life</h3>
								<p class="chefs-txt4 wow fadeInUp" data-wow-duration="1.5s">Nam turpis quis fermentum egestas nibh diam feugiat faucibus. Commodo tellus lorem fames mauris, at praesent gravida. Porttitor eu eu sed vestibulum, tortor cursus nunc. Sit egestas diam quam integer augue cum erat egestas convallis.</p>
								<h4 class="booking">Booking Request</h4>
								<div class="chef-number">
									<a href="tel:+012345678990">+01-2345-678-990</a>
								</div>
								<div class="chef-reservation-btn">
									<a href="#reservation-sec">Make A Reservation</a>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section> 
		<!-- Chefs Secrets End -->
		<!-- Counter Section Start  -->
		<section id="counter-section" class="mt-100 reveal" data-aos="fade-down" data-aos-duration="1000">
			<div class="container">
				<div class="counter-full-section">
					<div class="counter-wrap">
						<div class="counter-img">
							<svg width="100" height="100" viewbox="0 0 100 100" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path fill-rule="evenodd" clip-rule="evenodd" d="M89.3103 0.238579C88.5218 0.675604 88.326 1.28677 88.3184 3.33411C88.3117 5.16156 88.334 5.26183 88.8779 5.87046C89.6881 6.77734 90.844 6.77734 91.6541 5.87046C92.1941 5.26613 92.2205 5.15101 92.2205 3.39216C92.2205 2.37777 92.1154 1.31707 91.9869 1.03523C91.5591 0.0959011 90.2633 -0.289721 89.3103 0.238579ZM81.4923 8.05656C80.5674 8.56903 80.2592 9.69521 80.7721 10.6871C81.1802 11.4763 81.8578 11.6927 83.92 11.6927C85.6788 11.6927 85.7939 11.6663 86.3983 11.1263C86.9228 10.6576 87.0323 10.4184 87.0323 9.73821C87.0323 9.05804 86.9228 8.81881 86.3983 8.35012C85.7896 7.80619 85.6894 7.78391 83.8619 7.79055C82.6605 7.79505 81.7872 7.89297 81.4923 8.05656ZM94.1338 8.35012C93.6092 8.81881 93.4997 9.05804 93.4997 9.73821C93.4997 10.4184 93.6092 10.6576 94.1338 11.1263C94.7381 11.6663 94.8532 11.6927 96.6121 11.6927C98.6742 11.6927 99.3519 11.4763 99.76 10.6871C100.283 9.67527 99.9204 8.45078 98.969 8.01727C98.6872 7.88886 97.6264 7.78371 96.6121 7.78371C94.8532 7.78371 94.7381 7.8101 94.1338 8.35012ZM46.0944 10.7383C35.8883 11.7605 26.2977 16.8369 19.7365 24.6901C6.82825 40.1398 7.6507 62.8993 21.6423 77.4347C27.404 83.4203 35.0199 87.4253 43.4791 88.9183C47.1209 89.5611 52.9371 89.5613 56.551 88.9187C61.0442 88.1199 65.2848 86.6415 69.1426 84.5291C71.6461 83.1582 72.2847 82.5396 72.2847 81.485C72.2847 80.8826 72.1609 80.5451 71.8128 80.1968C71.0379 79.4218 70.3896 79.3714 69.2626 79.9982C64.5533 82.6182 61.0758 84.0047 57.2351 84.7943C44.8477 87.3406 31.6064 82.951 23.3895 73.5742C18.4028 67.8834 15.4751 61.1604 14.6384 53.4776C13.7933 45.7193 15.8817 37.1715 20.2392 30.5536C26.2229 21.4662 35.5236 15.8343 46.5266 14.6358C49.112 14.3541 51.2148 14.376 54.109 14.7149C67.8298 16.3211 79.2597 25.5679 83.6084 38.5795C84.6207 41.6086 85.1255 44.0904 85.4138 47.4584C86.013 54.4545 84.1699 62.2762 80.5086 68.2753C79.5134 69.9062 79.3334 70.7032 79.7997 71.415C80.2127 72.0453 81.197 72.4755 81.9127 72.3387C82.6136 72.2048 83.1714 71.5217 84.4776 69.198C86.5943 65.4327 88.1092 61.1193 88.9205 56.5484C89.5661 52.9112 89.5675 47.0976 88.9241 43.4765C87.6562 36.3422 84.7579 30.0665 80.2262 24.6426C71.9203 14.7016 59.015 9.44425 46.0944 10.7383ZM89.56 13.0495C89.3331 13.1453 88.9592 13.4629 88.7294 13.7551C88.3703 14.2115 88.3115 14.5429 88.3115 16.1075C88.3115 18.147 88.5296 18.825 89.3171 19.2322C90.3289 19.7554 91.5534 19.3926 91.9869 18.4412C92.1154 18.1593 92.2205 17.0986 92.2205 16.0843C92.2205 14.3453 92.1898 14.206 91.683 13.6497C91.1061 13.0167 90.2271 12.7681 89.56 13.0495ZM36.0773 37.9545C34.0589 38.7075 32.7495 40.5262 32.7198 42.6171C32.7077 43.4687 32.7814 43.6497 33.3445 44.1531C34.2166 44.9328 35.1661 44.9324 35.9461 44.1524C36.33 43.7685 36.5174 43.3837 36.5174 42.9797C36.5174 42.2499 37.1174 41.5965 37.7878 41.5965C38.4582 41.5965 39.0583 42.2499 39.0583 42.9797C39.0583 43.8406 39.9831 44.7237 40.8849 44.7237C41.7799 44.7237 42.7165 43.9466 42.8814 43.067C43.0519 42.1588 42.5236 40.482 41.7869 39.5929C40.828 38.4359 39.6405 37.8411 38.1152 37.7547C37.3006 37.7084 36.5352 37.7834 36.0773 37.9545ZM61.6235 37.9466C59.4429 38.7869 58.2123 40.5139 58.2123 42.734C58.2123 45.171 61.5721 45.4187 62.0181 43.0147C62.0931 42.6109 62.2925 42.1267 62.4614 41.9385C63.1224 41.2019 64.4667 41.7489 64.4667 42.7543C64.4667 43.4145 65.0548 44.2861 65.6734 44.5423C66.4405 44.8601 67.4983 44.6136 67.9764 44.006C68.8217 42.9314 68.2248 40.4769 66.7871 39.1156C65.4359 37.836 63.2154 37.3333 61.6235 37.9466ZM40.4907 56.931C39.6708 57.2875 39.4492 57.7562 39.4492 59.133C39.4492 62.7353 41.8997 66.6662 45.2356 68.4151C51.9567 71.9388 59.9016 68.1846 61.456 60.7505C61.6245 59.9443 61.7185 58.9461 61.6647 58.5326C61.4763 57.0829 60.193 56.3371 58.9235 56.9395C58.1619 57.3008 57.957 57.7336 57.675 59.5778C57.2888 62.1015 55.7776 64.1734 53.5676 65.2091C52.5841 65.67 52.2065 65.7343 50.492 65.7331C48.1252 65.7316 47.2161 65.3833 45.6066 63.8611C44.2844 62.6106 43.6087 61.2741 43.3806 59.4586C43.1731 57.8057 42.9502 57.3348 42.1894 56.9412C41.499 56.5843 41.2905 56.583 40.4907 56.931ZM75.2014 75.1987C73.4519 76.9484 75.8373 79.6333 77.7279 78.0425C78.4804 77.4093 78.6622 76.6073 78.25 75.7386C77.6671 74.5104 76.1571 74.243 75.2014 75.1987ZM8.78509 80.7638C7.99664 81.2008 7.8008 81.812 7.79318 83.8593C7.78653 85.6867 7.80882 85.787 8.35275 86.3956C8.82144 86.9202 9.06067 87.0297 9.74083 87.0297C10.421 87.0297 10.6602 86.9202 11.1289 86.3956C11.6689 85.7913 11.6953 85.6762 11.6953 83.9173C11.6953 82.903 11.5902 81.8423 11.4618 81.5604C11.0339 80.6211 9.7381 80.2355 8.78509 80.7638ZM0.967107 88.5817C0.0422402 89.0942 -0.265984 90.2204 0.246876 91.2123C0.654974 92.0015 1.3326 92.2179 3.39478 92.2179C5.15363 92.2179 5.26875 92.1915 5.87308 91.6515C6.77997 90.8413 6.77997 89.6854 5.87308 88.8753C5.26445 88.3314 5.16419 88.3091 3.33674 88.3157C2.13531 88.3202 1.26204 88.4181 0.967107 88.5817ZM13.6086 88.8753C13.084 89.344 12.9745 89.5832 12.9745 90.2634C12.9745 90.9436 13.084 91.1828 13.6086 91.6515C14.2129 92.1915 14.328 92.2179 16.0869 92.2179C18.1491 92.2179 18.8267 92.0015 19.2348 91.2123C19.5874 90.5306 19.5874 89.9962 19.2348 89.3145C18.8267 88.5253 18.1491 88.3089 16.0869 88.3089C14.328 88.3089 14.2129 88.3353 13.6086 88.8753ZM9.03487 93.5747C8.80795 93.6705 8.43406 93.9881 8.20421 94.2803C7.84517 94.7366 7.78634 95.0681 7.78634 96.6327C7.78634 98.6722 8.00446 99.3502 8.79193 99.7573C9.80377 100.281 11.0283 99.9178 11.4618 98.9664C11.5902 98.6845 11.6953 97.6238 11.6953 96.6094C11.6953 94.8705 11.6646 94.7312 11.1578 94.1749C10.5809 93.5419 9.70194 93.2932 9.03487 93.5747Z" fill="#FFDE9F"></path>
							</svg>
						</div>
						<h3 class="text-center">
							<span class="counter-txt" data-count="7.5">0</span>
							<span class="counter-txt-K">K</span>
						</h3>
						<p class="conter-name">Happy Customers</p>
					</div>
					<div class="counter-wrap">
						<div class="counter-img">
							<svg width="87" height="100" viewbox="0 0 87 100" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path fill-rule="evenodd" clip-rule="evenodd" d="M33.2525 0.364438C31.3861 0.85345 29.6799 1.77872 28.3149 3.04219L27.2112 4.06358L25.8651 3.90064C19.0623 3.07657 13.0793 8.14527 12.7489 15.0129C12.5801 18.5175 13.6498 21.2642 16.1669 23.7901L17.6414 25.2699L16.9201 31.131C16.5233 34.3546 16.2027 37.4878 16.2072 38.0938L16.2158 39.1953L15.4923 39.3311C11.556 40.0696 9.97738 44.9789 12.7569 47.8369C13.446 48.5454 15.0877 49.3933 15.7762 49.3962C16.0178 49.3974 16.2158 49.4357 16.2158 49.4818C16.2158 50.2136 16.7513 52.9623 17.1234 54.1402C17.6883 55.9284 18.1044 56.4315 19.0183 56.4315C20.2488 56.4315 20.6653 55.4822 20.1161 53.9298C19.3208 51.6826 19.1463 49.8612 19.1463 43.8082V38.0741L19.5859 37.9744C21.6359 37.5095 31.2079 36.8981 36.4366 36.8981C41.8501 36.8981 50.6615 37.4733 53.2092 37.9928L53.7662 38.1063L53.6779 44.4848C53.5972 50.317 53.5524 50.9969 53.1558 52.4205C51.7757 57.3755 48.5267 61.3611 44.0164 63.6325C41.1439 65.0788 37.2322 65.7085 34.0279 65.2398C30.3041 64.6953 27.2827 63.1956 24.0966 60.3102C23.085 59.3941 22.6575 59.2265 21.988 59.4834C21.5124 59.6658 21.0731 60.6521 21.2151 61.2181C21.3773 61.8643 23.6185 63.9206 25.3671 65.0278C26.1308 65.5113 26.7578 66.0388 26.7601 66.2C26.7665 66.6519 26.0552 67.7112 25.5711 67.9703C25.3323 68.098 21.2391 69.5055 16.4752 71.0978C11.7111 72.69 7.26427 74.2831 6.59297 74.6379C5.86483 75.0229 4.73402 75.9136 3.78882 76.8469C2.52399 78.0955 2.04221 78.7453 1.39749 80.0713C0.0277426 82.8882 0 83.1181 0 91.6251V99.1893L0.514801 99.5941C1.35196 100.253 2.18073 100.101 2.64473 99.2036C2.88015 98.7484 2.93056 97.4001 2.93056 91.5513C2.93056 83.8238 3.00538 83.1341 4.05863 81.1605C4.80318 79.7652 6.7227 77.8879 8.11452 77.1939C8.75553 76.8743 12.4627 75.5352 16.3527 74.2182L23.4253 71.8236L26.4143 74.1248C28.0581 75.3904 29.5928 76.5943 29.8245 76.8L30.2457 77.1744L28.9287 78.4763C27.5156 79.8732 26.7689 81.1969 26.3975 82.9626C26.259 83.6206 26.1797 86.7389 26.1797 91.5191V99.04L26.6593 99.5195C27.2431 100.103 27.9122 100.132 28.5872 99.6006L29.0938 99.2022L29.1508 91.2485C29.2054 83.6382 29.2257 83.2566 29.6193 82.4058C30.3383 80.8518 31.1421 80.1391 33.3855 79.0667C34.5263 78.5213 38.5624 76.6277 42.3546 74.859L49.2494 71.6432L56.4212 74.023C63.8694 76.4945 65.8895 77.3154 66.9632 78.3071C67.5521 78.851 67.5982 78.9841 67.5982 80.1413V81.3889L66.7833 81.5192C65.7432 81.6857 64.4176 82.9517 64.1052 84.077C63.8207 85.1017 63.8106 96.3004 64.0933 97.3181C64.3728 98.3248 65.2967 99.3226 66.3062 99.708C67.026 99.9829 67.879 100.018 72.3049 99.9587C78.2172 99.8786 78.4887 99.8159 80.3186 98.1044C81.6223 96.8847 82.2084 95.6881 82.4772 93.6961C82.7789 91.4618 82.5876 87.0732 82.1391 85.9324C81.6059 84.5768 80.7445 83.4327 79.6829 82.6699L78.7158 81.975L78.774 77.0382C78.8441 71.0686 78.7074 71.3898 81.2499 71.2251C83.87 71.0554 85.2029 70.328 85.9834 68.6421C86.3172 67.9212 86.3452 67.2329 86.3452 59.7528C86.3452 52.2726 86.3172 51.5843 85.9834 50.8634C85.7845 50.4336 85.3687 49.8448 85.0596 49.555C83.8405 48.4117 83.9402 48.4213 73.1647 48.4213C61.9922 48.4213 62.4926 48.3558 61.083 50.0026C60.0163 51.2487 59.9495 51.8987 60.0169 60.3727C60.0745 67.6133 60.0903 67.8865 60.498 68.6421C61.4466 70.3999 62.6258 71.0505 65.1666 71.2173C67.4616 71.3681 67.5982 71.5002 67.5982 73.57C67.5982 74.3519 67.5513 74.9917 67.4941 74.9917C67.4366 74.9917 66.9312 74.7578 66.3707 74.4718C65.8102 74.1858 61.4831 72.6465 56.7551 71.0509C52.0272 69.4555 47.9535 68.0439 47.7026 67.9146C47.2228 67.6671 46.8311 67.0344 46.6258 66.1756C46.5193 65.7309 46.6133 65.5909 47.3309 65.1227C49.0519 64.0005 50.8626 62.3709 52.0842 60.8445C54.33 58.039 56.0577 54.0286 56.4185 50.7831L56.5598 49.5128L57.2987 49.3597C59.6175 48.8785 61.5417 46.6493 61.5417 44.4443C61.5417 42.2109 59.9803 40.1175 57.8467 39.4905L56.658 39.1412L56.6539 38.0667C56.6518 37.4757 56.3042 34.273 55.8814 30.9495L55.1131 24.9069L56.3724 23.5721C58.675 21.1312 59.7043 18.3422 59.531 15.0129C59.3618 11.7588 58.2939 9.34719 57.022 9.34719C56.4224 9.34719 55.4831 10.0894 55.4878 10.5595C55.4893 10.6986 55.7519 11.5598 56.0713 12.4731C56.7444 14.3971 56.83 16.0265 56.3542 17.8536C55.9473 19.4168 55.2789 20.5038 53.6988 22.1737C52.9714 22.942 52.3208 23.7923 52.2528 24.0629C52.185 24.3335 52.4132 26.8502 52.76 29.6556C53.1068 32.4609 53.3395 34.8071 53.2774 34.8694C53.215 34.9315 51.7742 34.8411 50.0754 34.6684C40.8573 33.731 32.0673 33.7308 22.7021 34.6676C20.9504 34.8428 19.489 34.954 19.4542 34.9145C19.4194 34.8753 19.6748 32.651 20.0216 29.9717C20.4377 26.7555 20.6003 24.8711 20.4998 24.4261C20.3902 23.9402 19.9131 23.3365 18.7917 22.2641C16.4955 20.0687 15.6296 18.2389 15.6296 15.5811C15.6296 13.1219 16.5893 10.9406 18.442 9.18835C20.4817 7.25946 22.982 6.47758 25.9227 6.84937C26.8021 6.96054 27.7493 6.99434 28.0273 6.92459C28.3055 6.85484 29.1464 6.23474 29.896 5.54684C31.4967 4.07804 32.8502 3.38526 34.759 3.05782C37.4666 2.59362 40.1148 3.43136 42.2651 5.43255C43.9709 7.02013 44.0846 7.06311 46.0758 6.87536C48.2421 6.67119 49.4174 6.75735 50.7582 7.21862C52.159 7.7006 52.5912 7.68556 53.1068 7.13676C53.7097 6.49497 53.6679 5.57536 53.0122 5.05978C51.8941 4.18022 48.8633 3.63865 46.5175 3.89928L45.0718 4.05987L43.9111 2.98533C41.1288 0.409373 36.9774 -0.611438 33.2525 0.364438ZM26.4991 18.5439C26.1507 18.8178 25.9843 19.1351 25.9843 19.5252C25.9843 20.2682 28.9959 27.4846 29.4496 27.8288C29.9564 28.2135 30.8131 28.1582 31.2593 27.712C31.8333 27.138 31.8358 26.5478 31.2708 25.1722C28.982 19.6018 28.4936 18.5784 28.0206 18.363C27.3347 18.0504 27.0891 18.0797 26.4991 18.5439ZM35.2265 18.6101L34.6783 19.0813L34.612 22.3544C34.5362 26.1082 34.6513 27.1966 35.1808 27.7261C35.67 28.2153 36.624 28.2085 37.1204 27.712C37.4869 27.3455 37.5111 27.0608 37.5111 23.1351V18.9487L36.9963 18.5439C36.3262 18.0168 35.8982 18.0328 35.2265 18.6101ZM44.2139 18.3721C43.9785 18.486 43.7439 18.6779 43.6927 18.7986C41.7024 23.4881 40.7582 25.7718 40.6236 26.2211C40.2246 27.5524 41.746 28.6572 42.8375 27.8288C43.2912 27.4846 46.3028 20.2682 46.3028 19.5252C46.3028 19.1351 46.1364 18.8178 45.788 18.5439C45.2222 18.0986 44.8614 18.0593 44.2139 18.3721ZM16.2158 44.3185C16.2158 46.7843 16.0724 46.9494 14.9263 45.8033C14.3943 45.2713 14.262 44.9849 14.262 44.3644C14.262 43.3073 15.1279 42.2615 16.0692 42.1817C16.1497 42.1751 16.2158 43.1365 16.2158 44.3185ZM57.4454 42.4658C58.0768 42.7923 58.6116 43.6607 58.6104 44.3576C58.609 45.2444 57.5261 46.4676 56.7424 46.4676C56.6957 46.4676 56.6575 45.5005 56.6575 44.3185C56.6575 43.1365 56.7057 42.1694 56.7649 42.1694C56.8239 42.1694 57.1301 42.3029 57.4454 42.4658ZM26.78 43.4657C26.4321 43.9078 26.375 44.2537 26.375 45.9166C26.375 47.7119 26.41 47.8879 26.8547 48.3324C27.1184 48.5962 27.5619 48.812 27.8403 48.812C28.1187 48.812 28.5622 48.5962 28.8259 48.3324C29.2745 47.884 29.3056 47.7197 29.3056 45.7926C29.3056 43.9928 29.2562 43.683 28.9148 43.3417C28.333 42.7598 27.2874 42.8206 26.78 43.4657ZM43.9584 43.3417C43.6157 43.6843 43.5676 43.9928 43.5676 45.8475C43.5676 47.8057 43.6012 47.994 44.0197 48.3873C44.8653 49.1815 46.116 48.745 46.4157 47.5509C46.4833 47.2817 46.5076 46.3216 46.4695 45.4173C46.4159 44.1413 46.3171 43.681 46.0283 43.362C45.5426 42.8255 44.4849 42.8151 43.9584 43.3417ZM83.119 51.7862C83.3816 52.1609 83.4232 53.2536 83.4232 59.7747C83.4232 68.8764 83.6313 68.1826 80.8621 68.3116C78.716 68.4114 77.9349 68.7306 76.9109 69.9271C75.944 71.0565 75.8038 71.9595 75.8038 77.0583V81.4502L73.2151 81.3957L70.6264 81.3412L70.5288 76.2616C70.4225 70.7396 70.3904 70.5728 69.2274 69.4963C68.3201 68.6564 67.7934 68.4798 65.7717 68.3374C62.7655 68.1256 63.007 68.8742 63.007 59.7678C63.007 52.5747 63.0265 52.1527 63.3792 51.7631C63.7478 51.3558 63.841 51.3519 73.2831 51.3519H82.815L83.119 51.7862ZM32.7222 54.0896C32.2721 54.587 32.2641 55.532 32.706 56.0202C33.1767 56.5403 34.8115 57.2124 35.9277 57.3447C37.0243 57.4746 38.6785 57.0491 39.6725 56.3817C40.4579 55.8542 40.6593 54.9365 40.1576 54.1708C39.7653 53.5724 38.8758 53.5408 37.8042 54.087C36.8432 54.577 36.0855 54.5759 34.9989 54.0827C33.9128 53.59 33.1724 53.5922 32.7222 54.0896ZM66.3097 54.6937C65.9657 55.0739 65.9376 55.4564 65.9376 59.7528C65.9376 64.0492 65.9657 64.4317 66.3097 64.8119C66.5633 65.0921 66.9177 65.2232 67.422 65.2232C68.7198 65.2232 68.7704 65.0176 68.7704 59.7528C68.7704 54.4879 68.7198 54.2824 67.422 54.2824C66.9177 54.2824 66.5633 54.4135 66.3097 54.6937ZM72.1709 54.6937C71.8268 55.0739 71.7987 55.4564 71.7987 59.7528C71.7987 64.0492 71.8268 64.4317 72.1709 64.8119C72.4244 65.0921 72.7788 65.2232 73.2831 65.2232C74.5809 65.2232 74.6315 65.0176 74.6315 59.7528C74.6315 54.4879 74.5809 54.2824 73.2831 54.2824C72.7788 54.2824 72.4244 54.4135 72.1709 54.6937ZM78.032 54.6937C77.6879 55.0739 77.6598 55.4564 77.6598 59.7528C77.6598 64.0492 77.6879 64.4317 78.032 64.8119C78.2856 65.0921 78.64 65.2232 79.1442 65.2232C80.4421 65.2232 80.4927 65.0176 80.4927 59.7528C80.4927 54.4879 80.4421 54.2824 79.1442 54.2824C78.64 54.2824 78.2856 54.4135 78.032 54.6937ZM45.0118 69.4635L45.5409 70.0894L44.7985 70.4618C44.3901 70.6666 41.6583 71.9545 38.7275 73.3238C35.0702 75.0325 33.324 75.7552 33.1595 75.6278C33.0278 75.5258 31.5791 74.4099 29.9405 73.148C28.302 71.8861 26.9611 70.8092 26.9611 70.7547C26.9611 70.7002 27.3945 70.2661 27.9239 69.7899C28.5227 69.2515 29.0141 68.5906 29.2239 68.0412C29.4775 67.3775 29.6387 67.1882 29.8729 67.2789C31.0268 67.7255 33.6494 68.1889 35.5574 68.2834C37.9515 68.4018 40.2272 68.117 42.4931 67.4154L43.6653 67.0526L44.074 67.9451C44.2987 68.4358 44.7207 69.1192 45.0118 69.4635ZM34.3678 84.735C33.4025 85.5167 34.0226 87.3 35.2597 87.3C36.0064 87.3 36.7297 86.5791 36.7297 85.8348C36.7297 84.626 35.3156 83.9676 34.3678 84.735ZM43.1595 84.735C42.1942 85.5167 42.8143 87.3 44.0514 87.3C44.7981 87.3 45.5213 86.5791 45.5213 85.8348C45.5213 84.626 44.1072 83.9676 43.1595 84.735ZM77.8868 85.0072C78.3151 85.3041 78.8787 85.9195 79.1395 86.3748C79.5871 87.156 79.6135 87.3768 79.6135 90.3283C79.6135 94.0481 79.498 94.7038 78.6775 95.6381C77.5103 96.9676 77.0704 97.0594 71.8544 97.0643C67.4712 97.0684 67.2102 97.0482 67.0189 96.6907C66.7081 96.1097 66.7464 84.9087 67.0604 84.5947C67.245 84.4101 68.4875 84.3652 72.206 84.4091L77.1081 84.4672L77.8868 85.0072ZM15.0775 88.729C14.6643 89.1689 14.6528 89.3165 14.6528 94.1853V99.1893L15.1676 99.5941C16.0048 100.253 16.8335 100.101 17.2975 99.2036C17.7142 98.3979 17.7142 89.8781 17.2975 89.0724C16.8214 88.1518 15.7723 87.9895 15.0775 88.729ZM34.3678 93.5267C33.4025 94.3084 34.0226 96.0917 35.2597 96.0917C36.0064 96.0917 36.7297 95.3708 36.7297 94.6264C36.7297 93.4177 35.3156 92.7593 34.3678 93.5267ZM43.1595 93.5267C42.1942 94.3084 42.8143 96.0917 44.0514 96.0917C44.7981 96.0917 45.5213 95.3708 45.5213 94.6264C45.5213 93.4177 44.1072 92.7593 43.1595 93.5267Z" fill="#FFDE9F"></path>
							</svg>
						</div>
						<h3 class="text-center">
							<span class="counter-txt" data-count="36">0</span>
							<span class="counter-txt-K"></span>
						</h3>
						<p class="conter-name">Passionate Chef’s</p>
					</div>
					<div class="counter-wrap">
						<div class="counter-img">
							<svg width="100" height="100" viewbox="0 0 100 100" fill="none" xmlns="http://www.w3.org/2000/svg">
								<mask id="mask0_502_2618" style="mask-type:alpha" maskunits="userSpaceOnUse" x="0" y="0" width="100" height="100">
									<rect width="100" height="100" fill="white"></rect>
								</mask>
								<g mask="url(#mask0_502_2618)">
									<path fill-rule="evenodd" clip-rule="evenodd" d="M49.3746 5.39464C47.9229 6.16116 47.9664 5.81942 47.8549 17.3021C47.7321 29.9536 48.0676 28.5946 44.0416 32.75C41.7537 35.1113 41.1318 35.8804 40.5538 37.0629C39.9041 38.3922 39.2292 40.6369 38.9705 42.3282L38.8635 43.0279L37.788 42.9388C36.1483 42.8028 35.0435 43.2004 33.8602 44.3524C33.0601 45.1317 32.776 45.5809 32.5185 46.4748C31.8739 48.7115 32.513 50.6515 34.573 52.7115C35.3237 53.4622 35.9378 54.1111 35.9378 54.1537C35.9378 54.1965 35.5643 54.2317 35.1074 54.2323C33.8106 54.2341 29.0018 54.9842 26.9498 55.5049C23.7072 56.3277 21.198 57.2824 20.6306 57.9094C20.1167 58.4772 20.2697 59.4661 20.9497 59.9716C21.4844 60.369 21.5138 60.3702 22.4151 60.0308C28.669 57.6763 34.5861 56.7831 42.2881 57.0315C59.052 57.5717 68.0776 63.786 70.5261 76.4739C70.743 77.5978 70.9761 79.4276 71.0441 80.5404L71.168 82.5633H55.4461C39.894 82.5633 39.7193 82.5676 39.2965 82.9617C38.7216 83.4973 38.7216 84.5602 39.2965 85.0958C39.7197 85.4901 39.8895 85.4942 56.159 85.4942H72.5941L73.007 86.4711L73.4197 87.4481H40.122H6.82431V86.7945C6.82431 85.4221 6.05349 85.4942 20.7246 85.4942C33.724 85.4942 33.9163 85.4885 34.3378 85.0958C34.9126 84.5602 34.9126 83.4973 34.3378 82.9617C33.9169 82.5695 33.7186 82.5633 21.6075 82.5633H9.30502L9.4289 80.5404C9.84079 73.8073 12.1624 68.1722 16.1385 64.2542C17.1172 63.2901 17.3755 62.9118 17.3755 62.4435C17.3755 61.648 16.7655 61.0701 15.9259 61.0701C14.2283 61.0701 10.2384 66.2013 8.55667 70.5466C7.3761 73.5971 6.43353 78.4426 6.43353 81.4611C6.43353 82.6799 6.43118 82.6852 5.5906 83.2776C4.59468 83.9795 4.05208 85.0082 3.93211 86.4223L3.84496 87.4481H3.0798C1.9348 87.4481 0.847246 88.0884 0.355637 89.0517C0.0101827 89.7291 -0.0456997 90.1078 0.0291358 91.2719C0.136016 92.9394 0.620395 93.8595 1.80272 94.6419L2.59484 95.1661H50.0061H97.4174L98.2095 94.6419C99.3919 93.8595 99.8762 92.9394 99.9831 91.2719C100.098 89.4874 99.6334 88.4356 98.4686 87.8414C97.791 87.4958 97.3189 87.4481 94.5743 87.4481H91.4509L91.904 86.4223C92.6389 84.7591 92.8599 83.391 92.7528 81.1672C92.6461 78.9454 92.4118 78.2234 91.6918 77.8953C91.0287 77.5933 90.7608 77.622 90.2299 78.0522C89.7838 78.4135 89.7686 78.519 89.7686 81.2274C89.7686 83.8671 89.7379 84.0942 89.2375 85.162C88.9456 85.7853 88.521 86.5561 88.2939 86.8748L87.8815 87.4542L82.3982 87.4022C76.2659 87.3443 76.6884 87.4561 76.4795 85.8351C76.3973 85.1954 76.144 84.6233 75.6663 83.9973L74.9724 83.0885L75.0635 81.3116C75.1401 79.8141 75.3283 79.0167 76.2601 76.2396C78.1427 70.6285 78.9133 66.9045 78.9207 63.382C78.9227 62.4503 78.9776 61.5492 79.0429 61.3792C79.1445 61.1142 79.6306 61.0701 82.4394 61.0701C86.2484 61.0701 85.9486 60.8622 85.9594 63.5125C85.9709 66.4012 87.0893 72.3952 87.8271 73.5232C88.4049 74.4064 89.8393 74.2769 90.2838 73.3013C90.4569 72.9214 90.3975 72.421 89.9876 70.8071C89.3442 68.2734 88.9483 65.5008 88.834 62.7301L88.7455 60.5798L89.8159 60.1074C91.9294 59.1746 93.517 57.062 93.9779 54.5684C94.0885 53.9705 94.1977 52.3682 94.2208 51.0079C94.2618 48.5835 94.253 48.5268 93.7741 48.1353C93.3179 47.7621 93.0987 47.7423 90.4524 47.8359C87.4186 47.9434 85.7712 48.3105 84.6086 49.1384L84.0045 49.5685V48.0059V46.4433L85.0395 46.1424C87.1321 45.5342 89.226 43.7837 90.218 41.8133C91.8987 38.4746 90.4784 33.5412 86.7009 29.5966C85.4631 28.3041 84.3617 27.8533 82.4413 27.8533C80.5388 27.8533 79.4815 28.2863 78.2099 29.5862C74.4322 33.4484 72.9781 38.4631 74.6647 41.8133C75.6567 43.7837 77.7505 45.5342 79.8432 46.1424L80.8782 46.4433V52.2913V58.1392H79.8162C78.5907 58.1392 77.8435 58.3797 77.196 58.9827C76.3271 59.7916 76.1636 60.401 75.9867 63.4853C75.7833 67.0376 75.2775 69.7777 74.2081 73.1233L73.4109 75.6163L72.9642 73.863C72.3802 71.5709 71.6824 69.7559 70.6113 67.7425L69.7408 66.1061L69.7367 56.6028C69.7306 42.8544 69.4942 40.3891 67.8629 37.0629C67.2843 35.8833 66.6548 35.1055 64.3726 32.75C60.3465 28.5946 60.682 29.9536 60.5593 17.3021C60.4473 5.78132 60.4956 6.14905 58.9979 5.38506C58.298 5.02808 57.8592 4.9931 54.166 5.00092C50.5112 5.00873 50.0307 5.0482 49.3746 5.39464ZM57.6264 10.7564V13.5896H54.2071H50.7877V10.7564V7.92321H54.2071H57.6264V10.7564ZM57.6264 21.5112C57.6264 29.4199 58.0387 30.6408 62.0439 34.5943C64.7159 37.2317 65.2227 37.9461 65.9584 40.1105C66.3994 41.4081 66.4883 42.0611 66.5706 44.6082L66.6669 47.588H66.0455C65.2778 47.588 64.4652 48.3414 64.4652 49.0534C64.4652 49.7521 65.2782 50.5189 66.0195 50.5189H66.6145V56.3851V62.2514L64.9785 60.928C60.3893 57.2159 53.7895 54.8738 46.3324 54.3108C45.3439 54.2364 44.5351 54.1354 44.5351 54.0865C44.5351 54.0379 44.9785 53.5994 45.5201 53.1123C46.0619 52.6252 46.7694 51.8424 47.0926 51.3727L47.6802 50.5189H53.6391H59.5982L60.0777 50.0392C60.3414 49.7754 60.5573 49.3318 60.5573 49.0534C60.5573 48.775 60.3414 48.3314 60.0777 48.0676L59.5982 47.588H53.9367H48.2753L47.9516 46.4645C47.6976 45.583 47.4103 45.1295 46.6188 44.3599C45.4885 43.2608 44.5738 42.8985 42.93 42.8985H41.8588L42.0273 41.8241C42.2303 40.529 42.8602 38.7857 43.5097 37.7206C43.7719 37.2908 45.0562 35.8839 46.364 34.5943C50.3764 30.6374 50.7877 29.4209 50.7877 21.5112V16.5205H54.2071H57.6264V21.5112ZM83.8941 31.0439C84.3306 31.3631 84.1575 31.7498 83.1401 32.7287L82.439 33.4032L81.5609 32.5415C80.606 31.6042 80.5005 31.3006 81.0247 30.9952C81.5212 30.706 83.4775 30.7392 83.8941 31.0439ZM85.2538 40.791C85.9936 42.0572 85.8871 42.4956 84.6968 43.0853C81.7749 44.5328 77.6484 42.6535 76.9881 39.5747C76.7155 38.3037 76.9795 36.9535 77.8664 35.0828L78.5612 33.6174L81.6383 36.7437C83.3308 38.4631 84.9578 40.2846 85.2538 40.791ZM87.2402 35.542C87.7707 36.7009 88.1982 38.6685 88.0202 39.1323C87.9358 39.3522 87.7461 39.2056 87.2998 38.5757C86.9664 38.1054 86.2019 37.2155 85.6005 36.5981L84.5072 35.4758L85.3652 34.6014C86.3511 33.5969 86.3492 33.5961 87.2402 35.542ZM38.9156 46.611C39.4385 47.1134 39.9104 47.3926 40.2365 47.3926C40.5626 47.3926 41.0345 47.1134 41.5573 46.611C42.2228 45.9715 42.5095 45.8294 43.1336 45.8294C44.5701 45.8294 45.5504 47.1987 45.1504 48.6472C44.8544 49.7193 44.2659 50.4012 42.1752 52.0943L40.2365 53.6643L38.2978 52.0943C36.2071 50.4012 35.6186 49.7193 35.3226 48.6472C34.9226 47.1987 35.9029 45.8294 37.3394 45.8294C37.9635 45.8294 38.2501 45.9715 38.9156 46.611ZM91.3344 51.5447C91.2864 52.0013 91.1985 52.8872 91.1394 53.5131C90.9501 55.5152 89.7977 57.093 88.1247 57.6407C87.6318 57.8021 86.5032 57.993 85.6165 58.0647L84.0045 58.1954V56.8422C84.0045 52.632 85.8744 50.7889 90.2045 50.7307L91.422 50.7142L91.3344 51.5447ZM97.0958 90.9986C97.0958 91.3393 96.9502 91.779 96.7724 91.9755C96.461 92.3198 94.7523 92.3329 50.0401 92.3329C7.1303 92.3329 3.60424 92.3085 3.27383 92.0095C3.0632 91.819 2.91646 91.4177 2.91646 91.0326V90.379H50.0061H97.0958V90.9986Z" fill="#FFDE9F"></path>
								</g>
							</svg>
						</div>
						<h3 class="text-center">
							<span class="counter-txt" data-count="250">0</span>
							<span class="counter-txt-K">+</span>
						</h3>
						<p class="conter-name">Favourite Dishes</p>
					</div>
					<div class="counter-wrap">
						<div class="counter-img">
							<svg width="100" height="100" viewbox="0 0 100 100" fill="none" xmlns="http://www.w3.org/2000/svg">
								<mask id="mask0_502_2625" style="mask-type:alpha" maskunits="userSpaceOnUse" x="0" y="0" width="100" height="100">
									<rect width="100" height="100" fill="white"></rect>
								</mask>
								<g mask="url(#mask0_502_2625)">
									<path fill-rule="evenodd" clip-rule="evenodd" d="M48.699 0.427177C48.1528 0.788745 47.6488 1.64549 45.8545 5.26176C44.6551 7.67905 43.6442 9.71602 43.6081 9.78829C43.572 9.86057 41.3658 10.2325 38.7057 10.6146C36.0455 10.9968 33.6071 11.4449 33.2869 11.6104C32.2975 12.122 31.7983 13.2164 32.0092 14.4107C32.1167 15.0178 32.6964 15.6738 35.8361 18.74L39.5363 22.3537L38.7468 26.8464C38.3123 29.3175 37.951 31.665 37.9433 32.0633C37.915 33.549 39.3019 34.8844 40.6624 34.6814C41.0121 34.6292 43.2096 33.5922 45.5458 32.3768C47.8819 31.1614 49.8831 30.1426 49.9929 30.1127C50.1029 30.0826 52.1246 31.0763 54.4856 32.3208C56.8469 33.5654 59.0098 34.6316 59.2921 34.6902C60.0564 34.849 61.5209 34.1313 61.8902 33.417C62.3354 32.5563 62.2827 31.835 61.4095 26.8464L60.6233 22.3537L64.3157 18.74C67.4798 15.6435 68.0271 15.0214 68.1394 14.3934C68.3174 13.3979 67.715 12.0394 66.9118 11.6239C66.5852 11.4551 64.1384 11 61.474 10.6124C58.8098 10.2251 56.6164 9.89534 56.5996 9.8801C56.5828 9.86467 55.5668 7.83063 54.342 5.35962C52.533 1.71054 51.9925 0.784643 51.4624 0.427372C50.617 -0.142425 49.5592 -0.142425 48.699 0.427177ZM52.2121 7.59681C54.2584 11.793 54.7909 12.5398 55.8928 12.7594C56.1909 12.8187 58.0609 13.0928 60.0484 13.3682C62.036 13.6436 63.9155 13.9197 64.2249 13.9816C64.7726 14.0912 64.6943 14.1879 61.3296 17.5564C58.2248 20.6648 57.8618 21.0969 57.7788 21.7839C57.7261 22.2191 58.0169 24.4442 58.4533 26.9441C58.8752 29.3614 59.1993 31.3634 59.1735 31.3931C59.1477 31.4228 57.2612 30.4658 54.981 29.2667C51.7921 27.5895 50.6623 27.0861 50.0863 27.0861C49.5102 27.0861 48.3804 27.5895 45.1915 29.2667C42.9113 30.4658 41.023 31.4228 40.9953 31.3931C40.9676 31.3634 41.3055 29.2251 41.7464 26.6413C42.45 22.5174 42.517 21.8689 42.2954 21.3341C42.1566 20.9989 40.5198 19.2232 38.6581 17.3883C36.7963 15.5533 35.3317 14.0494 35.4034 14.0462C35.4751 14.0431 37.5921 13.7417 40.1081 13.3762C43.4571 12.8898 44.8176 12.6148 45.1868 12.3495C45.5089 12.1181 46.4673 10.455 47.8399 7.74566C49.0217 5.41295 50.0398 3.50412 50.1023 3.50392C50.165 3.50392 51.1143 5.34556 52.2121 7.59681ZM16.0463 11.6256C15.6463 11.8426 15.1306 12.6691 14.0547 14.817C12.6832 17.5557 12.5674 17.7219 11.9575 17.826C11.6024 17.8866 10.3011 18.078 9.06557 18.2512C6.29609 18.64 5.71262 18.8808 5.26725 19.8192C4.6789 21.059 4.91389 21.5122 7.49174 24.1117L9.81605 26.4558L9.34549 29.1905C9.08647 30.6946 8.87375 32.2194 8.87258 32.5788C8.86926 33.4932 9.51309 34.3097 10.4611 34.5937C11.2424 34.8279 11.2834 34.8136 14.2211 33.3002L17.1914 31.7699L20.0656 33.2636C21.6464 34.0854 23.1189 34.7576 23.3374 34.7576C23.8998 34.7576 24.8099 34.2513 25.1689 33.7385C25.5817 33.1494 25.5506 32.2084 25.0138 29.0471L24.5585 26.3642L26.8631 24.1145C29.4015 21.6368 29.6587 21.1512 29.1188 19.8589C28.7207 18.9062 28.1201 18.6509 25.3762 18.2682C24.087 18.0883 22.7417 17.8907 22.3865 17.8285C21.7775 17.7221 21.6593 17.5527 20.2884 14.8155C19.1481 12.5382 18.7117 11.8509 18.2579 11.6161C17.5356 11.2426 16.7462 11.2459 16.0463 11.6256ZM82.0169 11.5032C81.418 11.746 81.2288 12.0411 79.7821 14.9917C78.5183 17.5687 78.413 17.7188 77.794 17.827C77.4345 17.8899 76.0855 18.0883 74.7963 18.2682C73.5071 18.4481 72.212 18.7171 71.9184 18.8662C70.9671 19.3492 70.5183 20.757 71.005 21.7318C71.1222 21.9664 72.1982 23.0905 73.3962 24.2297L75.5742 26.3011L75.0505 29.4895C74.4742 32.9994 74.534 33.6033 75.5228 34.2513C76.5964 34.9547 76.9683 34.8748 80.0564 33.2775L82.9721 31.7693L85.8772 33.2834C88.3527 34.5736 88.8783 34.7795 89.4323 34.6755C90.2265 34.5265 91.0452 33.8022 91.2237 33.0902C91.2993 32.7894 91.1368 31.2462 90.8467 29.5087L90.3369 26.4558L92.5563 24.2094C94.7679 21.971 95.209 21.4016 95.209 20.7846C95.209 20.1816 94.574 19.1154 94.0594 18.8543C93.7785 18.7117 92.1862 18.4005 90.5209 18.1628C88.8557 17.9252 87.4772 17.7147 87.4578 17.6953C87.4383 17.6758 86.7919 16.3621 86.0215 14.7762C84.9327 12.5347 84.4967 11.8284 84.0645 11.6049C83.4577 11.291 82.6403 11.2504 82.0169 11.5032ZM18.4267 17.6145C19.0502 18.8695 19.7296 19.9591 20.0156 20.1626C20.3248 20.3826 21.2913 20.6277 22.5549 20.8066C25.9319 21.2846 25.8139 21.0285 23.6556 23.196C22.3737 24.4835 21.7335 25.2783 21.6529 25.6822C21.5878 26.009 21.7234 27.3145 21.9541 28.5836C22.1846 29.8527 22.3332 30.9311 22.2842 30.9804C22.235 31.0294 21.1753 30.5369 19.929 29.8859C18.683 29.2348 17.4555 28.7021 17.2015 28.7021C16.9476 28.7021 15.7096 29.2376 14.4506 29.8919C13.1917 30.5463 12.1245 31.0448 12.0794 30.9997C12.0341 30.9546 12.1726 29.9627 12.3871 28.7955C13.0116 25.3963 13.0803 25.633 10.7968 23.3126C8.5282 21.0073 8.4069 21.286 11.8933 20.791C14.526 20.4173 14.6418 20.3232 16.0914 17.3853C16.6747 16.2033 17.1935 15.278 17.2445 15.329C17.2955 15.38 17.8274 16.4084 18.4267 17.6145ZM85.759 20.195C85.987 20.3546 87.2902 20.6558 88.6551 20.8647C90.0201 21.0733 91.1767 21.2838 91.2253 21.3327C91.2739 21.3813 90.5422 22.1488 89.5989 23.0384C88.6557 23.9277 87.777 24.8407 87.6465 25.0673C87.3164 25.6402 87.3526 26.7181 87.7776 28.9952C87.9784 30.0695 88.1128 30.9786 88.0767 31.0151C88.0405 31.0519 86.9808 30.5463 85.7219 29.8919C84.4629 29.2376 83.2108 28.7021 82.9397 28.7021C82.6686 28.7021 81.4413 29.2348 80.2122 29.8859C78.9834 30.5369 77.9328 31.0247 77.8778 30.9696C77.8229 30.9147 77.9723 29.7742 78.21 28.4353C78.4567 27.0463 78.5814 25.8049 78.5003 25.5445C78.4222 25.2937 77.5228 24.236 76.502 23.1942C74.3779 21.0266 74.2611 21.2817 77.5935 20.8102C78.7023 20.6533 79.8235 20.3847 80.0853 20.2132C80.3644 20.0304 81.0549 18.9164 81.7564 17.517L82.9516 15.1325L84.1481 17.5187C84.8062 18.831 85.5311 20.0355 85.759 20.195ZM48.5275 37.9318C47.1068 38.6577 46.7466 39.3367 45.0292 44.5244C44.1578 47.1568 43.4448 49.4983 43.4448 49.7282C43.4448 50.859 44.9874 51.4725 45.7904 50.6613C45.9943 50.4554 46.8788 48.1772 47.7563 45.5988C48.6337 43.0203 49.4397 40.8009 49.5475 40.6665C50.1138 39.961 52.0752 41.0169 53.1794 42.6218C54.5933 44.677 54.654 45.9388 53.6066 51.5059C52.9735 54.8712 52.9497 55.148 53.1778 56.487C53.689 59.487 55.5707 62.1094 58.0802 63.3189C58.7867 63.6594 59.3878 63.9514 59.4159 63.9678C59.444 63.9842 59.2731 64.4288 59.0362 64.9556C58.719 65.6606 58.6031 66.3009 58.5971 67.3788C58.5881 69.0345 58.9883 70.1461 60.015 71.3152L60.6239 72.0087L60.1215 72.4773C59.3501 73.1969 58.6486 74.7498 58.5365 75.9871C58.3972 77.5238 58.7733 78.8913 59.6857 80.1653L60.4592 81.2457L59.8718 81.9792C58.132 84.1525 58.0892 87.1582 59.7669 89.3559L60.4584 90.2621L59.7761 91.0173C59.0694 91.7996 58.4857 93.3466 58.4857 94.4374C58.4857 94.7767 58.6166 95.486 58.7766 96.0134C58.9366 96.5408 59.0684 96.9944 59.0696 97.0211C59.0708 97.0479 58.3207 97.07 57.4026 97.07C55.8907 97.07 55.6881 97.1151 55.2539 97.5495C54.9902 97.8132 54.7743 98.2566 54.7743 98.535C54.7743 98.8133 54.9902 99.2567 55.2539 99.5205L55.7332 100L65.2649 99.9988C71.3133 99.9982 75.0659 99.923 75.5341 99.7929C76.5223 99.5185 77.6096 98.5303 78.0708 97.4876C78.3964 96.7516 78.439 96.27 78.3825 93.9573L78.3173 91.2794L79.059 90.6283C80.4087 89.443 80.6551 88.7193 80.6558 85.9358C80.656 84.5928 80.5894 83.2546 80.5076 82.9622C80.3738 82.4846 80.4337 82.3914 81.0936 82.0521C81.9617 81.6055 82.7215 80.8271 83.2134 79.8803C83.674 78.9937 83.8422 75.3804 83.4827 74.0966C83.1597 72.942 82.3105 71.7967 81.3817 71.2621L80.6316 70.8304L80.718 68.1267C80.8162 65.0459 80.6324 64.0827 79.7389 62.9988C79.417 62.6083 78.7886 62.0936 78.3423 61.8549C77.5482 61.4302 77.3482 61.4189 68.9362 61.3234L60.3414 61.2257L59.2946 60.6459C57.5745 59.6931 56.524 58.2267 56.1036 56.1915C55.9184 55.2943 55.979 54.7032 56.6033 51.3249C57.3862 47.087 57.4612 45.7587 57.0143 44.0429C56.3698 41.569 54.4757 39.1312 52.3861 38.0871C50.9156 37.3522 49.7532 37.3056 48.5275 37.9318ZM41.956 54.9648C41.7341 55.1202 41.3951 55.6695 41.2029 56.1856C40.1372 59.0477 38.0844 62.174 36.1574 63.8704L35.2594 64.6609L34.9348 64.0176C34.4798 63.1164 33.7137 62.3364 32.799 61.8426C32.086 61.4579 31.7273 61.421 28.6969 61.421C25.6422 61.421 25.3113 61.4556 24.5669 61.8539C23.5435 62.4012 22.478 63.6367 22.1846 64.6163C22.0297 65.1334 21.9578 67.7361 21.9578 72.8308V80.2888L22.4373 80.7681C23.0483 81.3793 23.7973 81.3793 24.4083 80.7681L24.8878 80.2888V72.8679V65.4473L25.3592 64.8992L25.8307 64.3511H28.6746C31.3734 64.3511 31.5412 64.3737 31.9633 64.7959L32.4083 65.2408L32.4606 80.581L32.513 95.921L31.9385 96.4955L31.364 97.07H28.6969H26.0298L25.4588 96.499L24.8878 95.928V91.0206V86.1133L24.4083 85.634C24.1446 85.3703 23.7012 85.1544 23.4228 85.1544C23.1445 85.1544 22.701 85.3703 22.4373 85.634L21.9578 86.1133V91.0319C21.9578 94.3225 22.0363 96.2163 22.1953 96.7543C22.5123 97.8273 24.1305 99.4454 25.2035 99.7625C26.2568 100.074 31.137 100.074 32.1903 99.7625C32.7003 99.6119 33.3674 99.154 34.0143 98.511L35.0344 97.497L36.5537 98.2607C39.1603 99.5707 41.6635 99.9957 46.788 99.9984C49.5794 99.9998 49.8819 99.9656 50.3529 99.5951C51.0497 99.0471 51.0645 98.0345 50.3839 97.4991C49.9503 97.1582 49.4791 97.1084 45.8424 97.0196C42.5959 96.9403 41.4854 96.8402 40.2893 96.5197C37.7115 95.8286 36.1394 94.8042 35.6438 93.4924C35.505 93.1247 35.436 88.8101 35.436 80.4796V68.0168L36.2662 67.4727C39.3168 65.4741 42.0224 61.9764 43.6368 57.9442C44.3447 56.1766 44.3693 55.6658 43.7741 55.1066C43.2514 54.6157 42.5343 54.5596 41.956 54.9648ZM77.3445 64.733C77.7959 65.1844 77.824 65.3391 77.824 67.3788C77.824 69.4185 77.7959 69.5732 77.3445 70.0246L76.8651 70.5042H70.4038C63.2471 70.5042 63.0304 70.4723 62.1258 69.2863C60.9499 67.7447 61.4445 65.5612 63.1664 64.6929C64.0175 64.2638 64.1888 64.2534 70.4515 64.2534H76.8651L77.3445 64.733ZM79.7596 73.7181C80.5754 74.14 80.8039 74.9067 80.725 76.9579C80.6607 78.6314 80.6222 78.7718 80.1083 79.2137L79.5602 79.685H71.5912C63.6258 79.685 63.6219 79.6848 62.9632 79.2408C61.5482 78.2874 61.0655 76.7991 61.6881 75.3095C61.9715 74.6313 62.9873 73.7384 63.6621 73.5745C63.877 73.5223 67.4634 73.4694 71.6319 73.4569C77.9098 73.4381 79.3051 73.4829 79.7596 73.7181ZM76.8296 82.8989C77.6453 83.3208 77.8739 84.0875 77.7949 86.1387C77.7307 87.8122 77.6922 87.9526 77.1783 88.3945L76.6301 88.8658H70.2864C63.2578 88.8658 63.0285 88.8316 62.1258 87.6479C60.9499 86.1063 61.4445 83.9228 63.1664 83.0546C64.0149 82.6266 64.1997 82.615 70.1594 82.615C75.1302 82.615 76.3838 82.6684 76.8296 82.8989ZM75.0893 92.1865C75.4251 92.5223 75.48 92.8376 75.48 94.4329C75.48 97.2477 75.9125 97.07 69.0628 97.07C63.5342 97.07 63.4143 97.0616 62.7632 96.6279C61.4128 95.7286 61.0935 94.0694 62.0391 92.8671C62.8241 91.8691 63.2095 91.8117 69.1804 91.8035C74.4437 91.7963 74.7166 91.8138 75.0893 92.1865Z" fill="#FFDE9F"></path>
								</g>
							</svg>
						</div>
						<h3 class="text-center">
							<span class="counter-txt" data-count="4.8">0</span>
							<span class="counter-txt-K"></span>
						</h3>
						<p class="conter-name">Customer Rating</p>
					</div>
				</div>
			</div>
		</section> 
		<!-- Counter Section End -->
		<!-- Menu  Section Start -->
		<section id="Homepage1-menu-section" class="Homepage1-menu-section1">
			<div class="homepage1-menu-back1-img"> 
				<img src="assets/images/Homepage1/pizza.png" alt="back-food-img">
			</div>
			<div class="homepage1-menu-back2-img"> 
				<img src="assets/images/Homepage1/roll.png" alt="back-food-img"> 
			</div> 
			<div class="container line ptb-100">
				<span class="line-3"></span>
				<span class="line-4"></span>
				<span class="line-5"> </span>
				<div class="homepage1-menu-top-sec">
					<p class="homemenu-txt1"><span class="pr-10"><img src="assets/images/Homepage1/yellow-star.png" alt="yellow-star"></span>Our Menu<span class="pf-10"><img src="assets/images/Homepage1/yellow-star.png" alt="yellow-star"></span></p>
					<h2 class="homemenu-txt2 wow fadeInUp" data-wow-duration="1s">Tasty With Good Price</h2>
					<p class="homemenu-txt3 wow fadeInUp" data-wow-duration="1.5s">Diam leo massa pellentesque a neque turpis cum mi gravida. Amet massa adipiscing mi dictum urna commodo. Fringilla ipsum etiam habitasse dolor lacus viverra.</p>
				</div>
				<div class="homepage1-menu-bottom-sec wow fadeInUp" data-wow-duration="2s">
					<h3 class="d-none">Menu List</h3>
					<ul class="nav nav-pills custon-nav-homepage1-menu" id="myTab" role="tablist">
						<li class="nav-item" role="presentation">
							<button class="nav-link menu-tab-homepage active" id="allmenu-tab" data-bs-toggle="tab" data-bs-target="#allmenu" type="button" role="tab" aria-selected="true">
								<span class="menu-tab-img">
									<svg width="80" height="80" viewbox="0 0 80 80" fill="none" xmlns="http://www.w3.org/2000/svg">
										<mask id="mask0_502_2629" style="mask-type:alpha" maskunits="userSpaceOnUse" x="0" y="0" width="80" height="80">
											<rect width="80" height="80" fill="white"></rect>
										</mask>
										<g mask="url(#mask0_502_2629)">
											<path fill-rule="evenodd" clip-rule="evenodd" d="M33.4092 0.409167C33.1512 0.667 33 1.00867 33 1.33333C33 2.18433 33.6303 2.66667 34.7425 2.66667H35.6667V3.97533V5.28417L34.0417 5.397C28.866 5.75633 24.4063 7.252 20.1667 10.0503C12.457 15.1392 7.67717 24.027 7.668 33.2917L7.66667 34.6667H4.7425C1.85983 34.6667 1.81233 34.6725 1.40917 35.0758C1.0235 35.4613 1 35.592 1 37.3482C1 38.3728 1.09117 39.52 1.20267 39.8973C1.47317 40.8128 2.85383 42.1935 3.76933 42.464C4.2185 42.5967 5.7455 42.6667 8.19283 42.6667H11.9303L11.9275 43.875C11.9253 44.809 12.0095 45.2437 12.298 45.7895C12.815 46.7677 22.4148 55.5373 32.9622 64.6667C41.2143 71.8095 41.3302 71.9183 40.7982 72.0283C39.7395 72.2472 39.6667 72.5043 39.6667 76.026C39.6667 79.1543 39.6702 79.1853 40.0758 79.5908L40.4848 80H49H57.5152L57.9242 79.5908C58.33 79.1852 58.3333 79.156 58.3333 76C58.3333 72.844 58.33 72.8148 57.9242 72.4092C57.6992 72.1842 57.3992 72 57.2575 72C57.0533 72 57 71.7892 57 70.9828C57 70.0063 57.031 69.9313 57.7755 69.1078C58.202 68.636 58.7832 67.7625 59.0672 67.1667L59.5833 66.0833L59.6355 61.1667L59.6875 56.25L62.2822 50.5287L64.8768 44.8072L64.791 43.737L64.705 42.6667H69.8228C75.8038 42.6667 76.0612 42.6203 77.2165 41.3353C78.1438 40.304 78.3333 39.6272 78.3333 37.3482C78.3333 35.592 78.3098 35.4613 77.9242 35.0758C77.5213 34.6728 77.4718 34.6667 74.6165 34.6667H71.7178L71.6132 32.375C71.5557 31.1147 71.4283 29.5958 71.3303 29C69.6353 18.6995 62.4725 10.1768 52.7103 6.84517C50.5095 6.094 48.5823 5.7005 45.9583 5.46633L43.6667 5.262V3.96433V2.66667H44.5908C45.703 2.66667 46.3333 2.18433 46.3333 1.33333C46.3333 1.00867 46.1822 0.667 45.9242 0.409167L45.5152 0H39.6667H33.8182L33.4092 0.409167ZM41 4V5.33333H39.6667H38.3333V4V2.66667H39.6667H41V4ZM48.8333 8.53767C53.515 9.563 57.5467 11.6782 60.9397 14.8892C65.9637 19.644 68.6435 25.5202 68.9518 32.4583L69.05 34.6667H39.666H10.2822L10.3902 32.375C10.5132 29.7653 10.906 27.5815 11.6602 25.3163C14.5532 16.6262 22.1703 10.0323 31.1667 8.4305C33.379 8.03667 33.377 8.03667 40.3333 8.0785C46.6725 8.1165 46.9878 8.1335 48.8333 8.53767ZM75.6667 38.2575C75.6667 39.0167 75.5935 39.255 75.2575 39.5908L74.8485 40H39.6667H4.48483L4.07583 39.5908C3.73983 39.255 3.66667 39.0167 3.66667 38.2575V37.3333H39.6667H75.6667V38.2575ZM17.404 43.0417C17.6537 43.2633 18.475 44.8432 19.4132 46.907C20.286 48.8267 21 50.4248 21 50.4583C21 50.6298 14.8842 44.8927 14.6943 44.5432C14.4297 44.0555 14.5512 43.4488 15.0042 42.9958C15.487 42.513 16.8373 42.5387 17.404 43.0417ZM24.079 42.8928C24.2492 43.0173 25.5197 45.3607 26.9025 48.1003L29.4167 53.0817L36.4887 55.9035L43.5608 58.7253L46.4887 58.0063C48.0992 57.611 49.5402 57.2243 49.6912 57.147C49.8422 57.0698 51.6288 53.9488 53.6613 50.2117C55.6938 46.4743 57.5432 43.248 57.771 43.0417C58.1393 42.7082 58.3605 42.6667 59.7668 42.6667C61.2238 42.6667 61.3807 42.6988 61.7575 43.0758C61.9825 43.3008 62.1667 43.679 62.1667 43.9162C62.1667 44.1535 61.0042 46.9055 59.5833 50.032L57 55.7165L56.9963 60.4832C56.992 66.0312 56.9907 66.0372 55.3255 67.7712L54.3333 68.8045V70.4022V72H49.9165H45.4997L35.7883 63.5832L26.0772 55.1665L23.622 49.7535C22.2715 46.7765 21.1667 44.1482 21.1667 43.9128C21.1667 43.6773 21.3508 43.3008 21.5758 43.0758C21.9082 42.7433 22.152 42.6667 22.8772 42.6667C23.368 42.6667 23.9088 42.7685 24.079 42.8928ZM54.6667 42.7522C54.6667 42.863 48.319 54.5392 48.1587 54.7233C48.0917 54.8003 47.0728 55.1048 45.8948 55.4L43.753 55.9368L37.533 53.4468L31.313 50.9568L29.2392 46.8117L27.1653 42.6667H40.916C48.4788 42.6667 54.6667 42.7052 54.6667 42.7522ZM55.6667 76V77.3333H49H42.3333V76V74.6667H49H55.6667V76Z" fill="#931A2A"></path>
										</g>
									</svg>
								</span>
								<span class="homemenu-txt">All</span>
							</button>
						</li>
						<li class="nav-item" role="presentation">
							<button class="nav-link menu-tab-homepage" id="breakfast-tab" data-bs-toggle="tab" data-bs-target="#breakfast" type="button" role="tab" aria-selected="false">
								<span class="menu-tab-img">
									<svg width="80" height="80" viewbox="0 0 80 80" fill="none" xmlns="http://www.w3.org/2000/svg">
										<mask id="mask0_502_2633" style="mask-type:alpha" maskunits="userSpaceOnUse" x="0" y="0" width="80" height="80">
											<rect width="80" height="80" fill="white"></rect>
										</mask>
										<g mask="url(#mask0_502_2633)">
											<path fill-rule="evenodd" clip-rule="evenodd" d="M49.7801 11.3611C49.3234 11.8176 48.8124 13.17 48.6721 14.2927C48.5271 15.4533 48.7816 16.7078 49.472 18.2373C50.1968 19.8427 50.2535 21.0195 49.6816 22.6047L49.3033 23.6537L49.6278 24.0903C50.1194 24.7515 50.9259 24.7719 51.4604 24.1366C52.2367 23.2143 52.6763 20.9196 52.3597 19.4435C52.2605 18.9809 51.9235 18.0355 51.6107 17.3429C50.9057 15.7817 50.8293 14.3755 51.3816 13.1298C51.8018 12.182 51.8039 11.9304 51.3955 11.4115C50.9797 10.8827 50.28 10.861 49.7801 11.3611ZM40.0574 14.3487C39.4806 14.5999 38.9425 15.7255 38.6874 17.214C38.4637 18.5211 38.6949 19.8194 39.4492 21.4899C40.1812 23.1112 40.248 24.3735 39.6764 25.7818C39.2573 26.8146 39.3519 27.3469 40.0213 27.7227C40.9935 28.2685 41.8441 27.3053 42.2807 25.1639C42.5907 23.644 42.4091 22.4137 41.6162 20.6616C41.1056 19.5331 41.0301 19.2148 41.0309 18.1932C41.0315 17.329 41.1211 16.8195 41.3713 16.2576C41.8108 15.2708 41.8011 15.1314 41.2539 14.5842C40.7361 14.0664 40.7151 14.0622 40.0574 14.3487ZM60.321 14.2391C58.9973 14.7142 58.2596 18.0222 58.9861 20.2262C59.142 20.6993 59.4461 21.4382 59.6621 21.8682C60.209 22.9575 60.2239 24.4553 59.702 25.8758C59.3409 26.8581 59.3346 26.9325 59.5813 27.3088C59.8848 27.772 60.6331 27.9842 61.094 27.7376C61.5708 27.4824 62.1707 26.1753 62.3853 24.9243C62.631 23.4914 62.4239 22.2525 61.6537 20.5466C60.9456 18.9784 60.8627 17.6084 61.4019 16.3896C61.5814 15.9834 61.7285 15.4921 61.7285 15.2975C61.7285 14.6368 60.9157 14.0256 60.321 14.2391ZM35.1351 31.0711C33.6238 31.4836 32.5063 32.5949 32.1801 34.0093C32.0936 34.3848 32.021 35.7334 32.0188 37.0066L32.0151 39.3213L31.5068 38.9398C30.6931 38.3291 29.4184 37.746 28.1295 37.3947C26.4094 36.926 22.6084 36.9259 20.8891 37.3944C19.3662 37.8095 18.0798 38.4655 17.0477 39.3535C16.2897 40.0056 16.1544 40.0613 15.0928 40.1579C8.3274 40.773 4.17644 43.4287 3.16525 47.7889C3.03811 48.3374 2.68467 49.3258 2.38003 49.9852C-0.193145 55.5543 -0.713442 61.0686 0.983348 64.7839C2.7244 68.5961 6.8447 70.2218 10.361 68.4838C11.2698 68.0347 11.8914 67.5405 13.3424 66.1137C15.3071 64.1814 15.8879 63.7697 17.4729 63.185C18.4301 62.8317 18.5676 62.8203 19.8951 62.9825C20.9611 63.1128 21.5674 63.2873 22.394 63.7017C23.3083 64.1601 23.6515 64.2489 24.5085 64.2489C25.3649 64.2489 25.7094 64.1599 26.623 63.7025C27.4872 63.2699 28.0224 63.1223 29.1931 62.9941C30.6583 62.8335 30.6828 62.8364 31.8828 63.3203C33.3275 63.9028 33.8054 64.2525 35.6739 66.0935C37.4095 67.8036 38.3551 68.4621 39.6553 68.8662C42.2915 69.6854 45.3518 68.7006 46.9409 66.5218L47.401 65.891H52.365C56.114 65.891 57.5945 65.8351 58.4131 65.663C62.6186 64.7783 65.9252 62.1291 67.9143 58.0507L68.3441 57.1696L69.5756 57.0622C72.5388 56.8037 74.5829 55.8571 76.6824 53.771C77.9019 52.5594 78.2127 52.1387 78.8241 50.8729C79.7537 48.9489 80.1024 47.2636 79.9745 45.3152C79.6098 39.7623 75.2904 35.3709 69.7239 34.8935C69.2251 34.8508 69.1804 34.7965 68.9074 33.9045C68.5553 32.7532 67.8136 31.8501 66.7921 31.3284L66.0291 30.9386L50.9378 30.9078C39.3252 30.8841 35.6825 30.9218 35.1351 31.0711ZM65.9742 33.5658C66.202 33.7204 66.4693 34.0424 66.5683 34.2812C66.6992 34.5975 66.7338 37.4077 66.6953 44.6342C66.6366 55.6366 66.6665 55.2989 65.5623 57.48C64.0777 60.4124 61.5983 62.4162 58.4398 63.2365C57.4206 63.5011 56.715 63.5402 52.9148 63.5425L48.5581 63.5452L48.6461 63.1933C49.5683 59.5052 48.8774 54.9458 46.6376 49.9396C46.2722 49.1225 45.8943 48.0836 45.798 47.6308C45.4127 45.8179 44.1944 44.0881 42.4024 42.8095C40.7663 41.6419 37.8348 40.6175 35.2601 40.3137L34.3609 40.2077V37.4734C34.3609 34.1083 34.486 33.738 35.7683 33.3066C35.8974 33.2632 42.6532 33.2405 50.7814 33.2561C64.7242 33.2829 65.5834 33.3004 65.9742 33.5658ZM71.1833 37.5117C74.229 38.3051 76.7935 41.0141 77.4556 44.1378C77.7579 45.5639 77.7335 46.7083 77.3705 48.1278C76.934 49.834 76.379 50.7812 75.026 52.129C73.4404 53.7083 71.9682 54.4257 69.7199 54.7148L68.8755 54.8234L68.9754 54.2189C69.0303 53.8866 69.0759 53.3583 69.0769 53.0449L69.0786 52.4752L70.0416 52.3055C71.7855 51.9984 73.5699 50.7595 74.466 49.2338C75.8686 46.8461 75.5095 43.6477 73.6074 41.584C72.5751 40.4641 71.4966 39.9262 69.5087 39.5394C69.0886 39.4576 69.0786 39.4304 69.0786 38.364V37.2723H69.6713C69.9972 37.2723 70.6777 37.38 71.1833 37.5117ZM27.5682 39.7022C30.9363 40.5678 32.7992 43.1548 32.7957 46.962C32.7943 48.5807 32.6098 49.7826 32.0825 51.6079C30.6528 56.556 27.1224 61.5473 24.7839 61.9267C23.9687 62.059 22.9456 61.5126 21.6845 60.2717C19.9256 58.5405 18.5235 56.137 17.4152 52.9528C16.6947 50.883 16.4681 50.4657 16.0017 50.3487C15.5207 50.2278 14.8873 50.4575 14.7557 50.8005C14.5608 51.3083 14.6618 52.169 15.0551 53.3525C15.5793 54.9303 17.1127 58.1042 17.938 59.3191C18.2987 59.8505 18.5629 60.3161 18.525 60.3541C18.3002 60.5788 14.2863 59.379 12.8578 58.6601C9.40569 56.9225 6.52489 53.9593 5.72388 51.3219C5.31447 49.9741 5.37233 48.2198 5.86291 47.1084C6.81139 44.9591 10.0577 43.1544 13.8588 42.6628C14.6409 42.5617 14.6951 42.5752 14.5908 42.8451C14.312 43.5678 14.023 45.1765 13.9894 46.1941C13.9561 47.198 13.9886 47.3362 14.3217 47.6068C14.5247 47.7716 14.8942 47.9065 15.1427 47.9065C15.8292 47.9065 16.1799 47.4444 16.29 46.3946C16.5255 44.1503 17.3165 42.2782 18.4842 41.2018C19.5247 40.2427 20.6289 39.7953 22.9447 39.3944C23.6819 39.2667 26.6399 39.4637 27.5682 39.7022ZM70.7207 42.3082C72.0721 42.9783 72.8266 44.1075 72.9499 45.6449C73.0984 47.4945 72.0742 49.1464 70.3874 49.7774C68.9698 50.3079 69.0786 50.6256 69.0786 45.9556V41.8153L69.5869 41.9066C69.8665 41.957 70.3766 42.1376 70.7207 42.3082ZM37.487 43.1554C40.4688 44.0014 42.5793 45.5428 43.2719 47.3803C43.7834 48.7373 43.6771 50.5718 43.0035 52.0112C42.3223 53.467 41.6683 54.3747 40.3944 55.6327C38.5988 57.4059 36.1867 58.8218 33.5007 59.6795C31.9588 60.1718 30.6185 60.4805 30.5069 60.369C30.4609 60.3228 30.7089 59.8645 31.0581 59.3503C34.3795 54.4593 35.8852 47.6807 34.595 43.428C34.468 43.0098 34.3635 42.642 34.3626 42.6105C34.3585 42.4759 36.262 42.8077 37.487 43.1554ZM5.10225 55.158C6.84893 57.6952 10.3393 60.3002 13.6337 61.5254L14.5661 61.8722L14.0247 62.2764C13.7269 62.4986 12.7092 63.4282 11.7631 64.3418C9.771 66.2657 9.05303 66.6898 7.61287 66.7932C6.27108 66.8895 5.24784 66.4654 4.25119 65.4001C2.09275 63.0923 1.72931 58.941 3.26753 54.162C3.44737 53.6029 3.62909 53.0854 3.671 53.0122C3.71307 52.9389 3.93436 53.2204 4.16268 53.6378C4.39116 54.055 4.81387 54.7392 5.10225 55.158ZM45.8415 54.448C47.2967 59.1002 46.9023 63.1159 44.7659 65.4001C43.7795 66.4544 42.7604 66.8801 41.41 66.8019C39.9342 66.7164 39.1822 66.286 37.4725 64.5479C36.6643 63.7263 35.6584 62.7992 35.2374 62.4877L34.4717 61.9213L35.0028 61.689C38.5009 60.1585 39.9823 59.2492 41.9077 57.4511C43.0375 56.3963 44.8243 54.0081 45.075 53.2184C45.2292 52.7322 45.3808 52.975 45.8415 54.448Z" fill="#931A2A"></path>
										</g>
									</svg>
								</span>
								<span class="homemenu-txt">Breakfast</span>
							</button>
						</li>
						<li class="nav-item" role="presentation">
							<button class="nav-link menu-tab-homepage" id="lunch-tab" data-bs-toggle="tab" data-bs-target="#lunch" type="button" role="tab" aria-selected="false">
								<span class="menu-tab-img">
									<svg width="80" height="80" viewbox="0 0 80 80" fill="none" xmlns="http://www.w3.org/2000/svg">
										<mask id="mask0_502_2637" style="mask-type:alpha" maskunits="userSpaceOnUse" x="0" y="0" width="80" height="80">
											<rect width="80" height="80" fill="white"></rect>
										</mask>
										<g mask="url(#mask0_502_2637)">
											<path fill-rule="evenodd" clip-rule="evenodd" d="M38.438 0.198658C37.6186 0.61318 37.626 0.678336 39.4464 9.1791C40.3801 13.5393 41.1756 17.265 41.2142 17.4583L41.2842 17.8099L37.3989 17.8149C33.2162 17.8202 33.127 17.8364 32.8165 18.6531C32.5648 19.3153 32.608 23.9591 32.8717 24.5905C33.1501 25.2567 33.7346 25.466 35.3171 25.466H36.5272L36.6222 26.8331C36.828 29.7966 37.3668 42.5239 37.2894 42.6011C37.2443 42.6462 36.7272 42.574 36.1405 42.4405C34.5337 42.075 31.9503 41.8722 28.9043 41.8722C23.0963 41.8722 20.0185 42.4906 16.4245 44.3798C9.95123 47.7825 5.55257 54.2547 4.8893 61.3529L4.79914 62.3185L3.81838 62.8013C0.703445 64.3348 0.0312712 68.4698 2.50356 70.891C2.87434 71.2542 3.54307 71.7028 3.98963 71.8878C4.77602 72.2138 4.80758 72.2511 4.99117 73.0712C5.27257 74.3289 6.28396 76.2145 7.17753 77.1476C8.18298 78.1975 9.61639 79.1238 10.9246 79.5688L11.9515 79.918L42.2295 79.9589L72.5075 80L72.8781 79.6292C73.162 79.3455 73.2703 79.0247 73.3406 78.2602C73.4231 77.3616 75.784 26.6306 75.7799 25.8392C75.7785 25.5486 75.8924 25.4991 76.7377 25.4224C78.3145 25.2794 78.3469 25.2117 78.4058 21.9202C78.4598 18.9109 78.4209 18.5775 77.9619 18.1184C77.6584 17.815 77.3725 17.8099 60.7891 17.8099C44.8629 17.8099 43.9205 17.7947 43.8448 17.5364C43.8005 17.386 42.9895 13.6346 42.0421 9.19988C41.0948 4.76528 40.2486 0.94958 40.1615 0.720678C40.0166 0.33928 39.4659 -0.00555701 39.0111 6.78724e-05C38.9092 0.00131785 38.6513 0.090691 38.438 0.198658ZM75.9346 21.5598V22.8098H55.6225H35.3104V21.5598V20.3098H55.6225H75.9346V21.5598ZM73.186 27.4581C73.1288 28.5537 72.5814 40.243 71.9693 53.4341L70.8566 77.418L60.6614 77.4582C55.0542 77.4804 50.4663 77.449 50.4663 77.3886C50.4663 77.3283 50.6374 77.0993 50.8465 76.8797C51.7126 75.9702 52.5176 74.286 52.871 72.6442C52.9363 72.3405 53.156 72.1627 53.7908 71.8995C55.807 71.0638 57.0804 68.7185 56.7201 66.5043C56.5639 65.5448 56.2618 64.8775 55.6059 64.0425L55.1634 63.4792L56.6039 63.3896C61.8683 63.0618 66.3968 59.2615 67.8322 53.9669C68.3043 52.226 68.3038 49.328 67.831 47.5839C66.6473 43.2168 63.1183 39.6818 58.7474 38.4849C57.309 38.091 53.7553 38.0985 52.3413 38.4985C48.9359 39.4618 45.9855 41.7866 44.4415 44.7234C44.1365 45.3034 43.8569 45.778 43.8204 45.778C43.7838 45.778 43.376 45.5363 42.9142 45.241C42.4524 44.9456 41.6115 44.4756 41.0456 44.1964L40.0166 43.689L39.9316 42.7414C39.8848 42.2201 39.7052 38.4891 39.5322 34.4501C39.3592 30.4112 39.1817 26.7373 39.1377 26.2862L39.0577 25.466H56.1737H73.2899L73.186 27.4581ZM58.6693 41.1522C60.2215 41.6448 62.0453 42.82 63.1236 44.0221C64.0182 45.0198 65.1703 47.2518 65.4712 48.5706C65.7418 49.7572 65.7017 52.0709 65.3893 53.2779C64.1826 57.9422 59.7655 61.1929 55.0756 60.868C52.9336 60.7196 52.8325 60.683 52.7299 60.0181C52.551 58.8601 51.6926 56.0089 51.153 54.78C50.1624 52.5245 48.5778 50.1973 46.8045 48.3942L45.9202 47.4949L46.3977 46.4941C47.8864 43.375 50.7345 41.2936 54.2944 40.7233C55.3416 40.5555 57.436 40.7608 58.6693 41.1522ZM34.7412 44.7571C40.5297 45.7907 45.61 49.5205 48.2626 54.6841C49.4495 56.9945 49.9953 58.7582 50.3781 61.5199L50.4701 62.184H28.9047H7.33956L7.43971 61.2855C7.49471 60.7913 7.69924 59.7484 7.89424 58.9676C9.8881 50.9811 16.5525 45.2743 24.7637 44.5223C26.9415 44.3228 33.1237 44.4682 34.7412 44.7571ZM30.1543 49.528V50.7779H31.4042H32.6542V49.528V48.278H31.4042H30.1543V49.528ZM16.2483 50.7779V52.0279H17.4983H18.7482V50.7779V49.528H17.4983H16.2483V50.7779ZM14.9983 55.8494V57.1841H16.2545H17.5109L17.4654 55.895L17.4201 54.606L16.2092 54.5604L14.9983 54.5147V55.8494ZM37.8103 55.856V57.1841H39.0603H40.3103V55.856V54.5279H39.0603H37.8103V55.856ZM26.4043 57.1841V58.434H27.6543H28.9043V57.1841V55.9341H27.6543H26.4043V57.1841ZM53.0849 65.1519C54.6206 66.0882 54.6141 68.2924 53.0721 69.4351L52.631 69.7619L29.2444 69.808C13.6951 69.8386 5.67319 69.8008 5.30663 69.6949C4.58696 69.4872 3.75745 68.6193 3.59667 67.906C3.35511 66.8351 3.82198 65.7015 4.73352 65.1458C5.22273 64.8475 5.71631 64.8412 28.9043 64.8412C52.2496 64.8412 52.5827 64.8456 53.0849 65.1519ZM50.3101 72.4903C50.3101 73.0536 49.5664 74.4492 48.8364 75.2559C47.7386 76.469 46.492 77.1404 44.9707 77.3379C43.4079 77.5408 13.9627 77.5413 12.7127 77.3383C11.3543 77.1179 10.4504 76.6713 9.40702 75.7052C8.47266 74.8404 7.7694 73.7397 7.58096 72.8478L7.47362 72.34H28.8919C42.5099 72.34 50.3101 72.3948 50.3101 72.4903Z" fill="#931A2A"></path>
										</g>
									</svg>
								</span>
								<span class="homemenu-txt">Lunch</span>
							</button>
						</li>
						<li class="nav-item" role="presentation">
							<button class="nav-link menu-tab-homepage" id="dinner-tab" data-bs-toggle="tab" data-bs-target="#dinner" type="button" role="tab" aria-selected="false">
								<span class="menu-tab-img">
									<svg width="80" height="80" viewbox="0 0 80 80" fill="none" xmlns="http://www.w3.org/2000/svg">
										<mask id="mask0_502_2641" style="mask-type:alpha" maskunits="userSpaceOnUse" x="0" y="0" width="80" height="80">
											<rect width="80" height="80" fill="white"></rect>
										</mask>
										<g mask="url(#mask0_502_2641)">
											<path fill-rule="evenodd" clip-rule="evenodd" d="M25.7419 4.28615C25.2647 4.8134 25.414 5.51368 26.1922 6.39983C27.7384 8.16024 28.1191 9.96102 27.3077 11.6762C27.0851 12.1468 26.3325 13.1644 25.6355 13.9374C22.9525 16.913 22.4012 19.4917 23.8285 22.3874C24.1265 22.9921 24.7472 23.9014 25.2078 24.4084C25.8956 25.1651 26.1345 25.3297 26.5444 25.3297C27.2256 25.3297 27.6733 24.8907 27.6733 24.2225C27.6733 23.8082 27.5109 23.5006 26.9638 22.8778C25.9048 21.6725 25.4439 20.6294 25.4439 19.4383C25.4439 18.0999 25.9794 17.0494 27.5502 15.3076C30.2008 12.368 30.7498 9.77014 29.3283 6.89438C29.0306 6.29204 28.4252 5.39447 27.9829 4.8996C27.2737 4.10608 27.1095 4 26.5899 4C26.2178 4 25.9054 4.10545 25.7419 4.28615ZM39.8227 4.28615C39.3455 4.8134 39.4948 5.51368 40.2729 6.39983C41.8192 8.16024 42.1998 9.96102 41.3885 11.6762C41.1658 12.1468 40.4133 13.1644 39.7163 13.9374C37.0333 16.913 36.4819 19.4917 37.9093 22.3874C38.2073 22.9921 38.828 23.9014 39.2886 24.4084C39.9763 25.1651 40.2152 25.3297 40.6251 25.3297C41.3063 25.3297 41.7541 24.8907 41.7541 24.2225C41.7541 23.8082 41.5917 23.5006 41.0446 22.8778C39.9855 21.6725 39.5246 20.6294 39.5246 19.4383C39.5246 18.0999 40.0602 17.0494 41.631 15.3076C44.2816 12.368 44.8306 9.77014 43.4091 6.89438C43.1113 6.29204 42.506 5.39447 42.0637 4.8996C41.3545 4.10608 41.1902 4 40.6707 4C40.2986 4 39.9862 4.10545 39.8227 4.28615ZM53.9034 4.28615C53.4263 4.8134 53.5755 5.51368 54.3537 6.39983C55.8999 8.16024 56.2806 9.96102 55.4692 11.6762C55.2466 12.1468 54.4941 13.1644 53.7971 13.9374C51.114 16.913 50.5627 19.4917 51.99 22.3874C52.2881 22.9921 52.9087 23.9014 53.3693 24.4084C54.0571 25.1651 54.296 25.3297 54.7059 25.3297C55.3871 25.3297 55.8349 24.8907 55.8349 24.2225C55.8349 23.8082 55.6725 23.5006 55.1253 22.8778C54.0663 21.6725 53.6054 20.6294 53.6054 19.4383C53.6054 18.0999 54.1409 17.0494 55.7117 15.3076C58.3624 12.368 58.9114 9.77014 57.4898 6.89438C57.1921 6.29204 56.5868 5.39447 56.1445 4.8996C55.4353 4.10608 55.271 4 54.7514 4C54.3794 4 54.0669 4.10545 53.9034 4.28615ZM33.0409 25.2826C32.3664 25.5475 32.1668 26.0976 32.2918 27.3478C32.5109 29.5388 33.1221 31.1418 34.1885 32.3221C34.5729 32.7476 34.681 32.9601 34.5349 33.0026C34.4182 33.0367 33.5833 33.2544 32.6798 33.4862C28.5665 34.5421 24.7071 36.6344 21.0838 39.7728C19.2998 41.3179 17.8819 42.8648 16.1732 45.1298C15.0667 46.5967 14.8043 46.849 13.9195 47.2984C12.9281 47.8018 12.896 47.8068 10.6752 47.8068H8.43227L7.73449 47.2743C5.27692 45.3982 2.87803 45.3147 1.3171 47.0509C0.478667 47.9835 0.150273 48.9198 0.0258924 50.7338C-0.187666 53.8473 0.928939 56.0417 3.03839 56.655C4.40251 57.0516 5.70216 56.7065 7.5214 55.4647C8.37391 54.8827 8.49282 54.8472 9.58407 54.8472H10.7421L10.2277 56.2162C9.94485 56.9692 9.48614 58.5004 9.20843 59.619C8.93073 60.7377 8.68776 61.6715 8.66851 61.6944C8.64927 61.7172 8.21793 61.8432 7.71008 61.9743C4.79286 62.7273 2.45091 64.853 1.81916 67.3212C1.67381 67.8896 1.4346 68.2901 0.973215 68.7379C0.199555 69.4887 -0.0889441 70.2689 0.0315247 71.2856C0.206126 72.7595 1.09603 74.0036 2.45248 74.6697L3.34489 75.1079L14.9224 75.1553C21.29 75.1814 26.7327 75.16 27.0172 75.1076C28.0023 74.9259 28.4633 73.9636 27.9207 73.2212C27.7052 72.9265 27.3498 72.9152 15.7565 72.8393C4.25497 72.7639 3.79563 72.7498 3.30828 72.4551C2.7707 72.1298 2.27334 71.2829 2.35892 70.8383C2.40742 70.5867 4.65815 70.5707 40.0331 70.5707C75.4081 70.5707 77.6588 70.5867 77.7073 70.8383C77.794 71.2887 77.2542 72.2123 76.7393 72.4942C76.2873 72.7417 74.6145 72.7641 53.6933 72.8022L31.1347 72.8434L30.8121 73.2536C30.3915 73.7882 30.405 74.1316 30.8672 74.6689L31.2447 75.1079H53.9831H76.7213L77.6137 74.6697C79.147 73.9168 79.9881 72.6059 79.9997 70.9511C80.0056 70.0931 79.938 69.8193 79.5905 69.2936C78.9772 68.366 78.3822 68.1457 76.4892 68.1457C75.6129 68.1457 74.9229 68.0928 74.9558 68.0284C75.9941 65.9859 75.94 66.2494 75.9275 63.2957C75.9212 61.7898 75.8305 59.8889 75.726 59.0715C73.9235 44.9725 65.9505 36.3995 51.9407 33.4961C50.1259 33.12 49.8643 33.1245 49.3812 33.5394C49.0168 33.8525 49.0168 34.8496 49.3812 35.1697C49.5317 35.3019 50.5702 35.6021 51.6889 35.8368C60.7569 37.7396 67.4075 42.5469 70.7042 49.5818C71.8871 52.106 72.9528 55.824 73.2898 58.6021L73.3942 59.4626L69.8088 55.9033C67.2404 53.3536 66.1223 52.344 65.8671 52.344C65.6712 52.344 65.2979 52.5569 65.0376 52.8172C64.6557 53.1991 64.5845 53.3728 64.669 53.7168C64.7359 53.9895 66.311 55.6943 69.0379 58.4456C73.5794 63.028 73.6705 63.1499 73.6705 64.6548C73.6705 65.5423 72.9499 66.8741 72.1842 67.4013C71.84 67.6383 71.169 67.9035 70.693 67.9907C70.1678 68.0867 67.0028 68.1329 62.6428 68.1082L55.4578 68.0675L55.2677 67.1288C54.8018 64.8278 53.8809 63.3299 52.2637 62.2429C51.113 61.4694 50.1681 61.1537 48.2952 60.9165C47.0918 60.7641 46.8887 60.7751 46.5281 61.0113C45.8599 61.4491 45.7569 61.8641 45.9484 63.3475C46.1501 64.9103 46.5705 66.1794 47.2235 67.197C47.4853 67.6047 47.6993 67.985 47.6993 68.0422C47.6993 68.0991 46.6598 68.1457 45.3894 68.1457H43.0796L41.0244 66.0727C39.894 64.9325 38.8566 63.7744 38.7189 63.4991C38.5812 63.2236 38.4686 62.6782 38.4686 62.287C38.4686 61.6891 38.559 61.4755 39.0354 60.9481C39.7249 60.1849 41.1076 59.5028 42.8648 59.0588C44.5335 58.6373 49.04 58.4768 51.6471 58.746C54.1408 59.0036 56.9998 59.6071 59.2768 60.3569L61.2325 61.0007L62.797 62.5292C63.6575 63.3698 64.5405 64.1254 64.7594 64.2081C65.2363 64.3883 66.0603 64.0959 66.2155 63.6913C66.5078 62.93 66.3375 62.6641 64.077 60.3489C61.6052 57.8173 61.12 57.181 60.2107 55.2789C59.4661 53.7217 58.9958 51.9525 58.8614 50.2049C58.7188 48.3485 58.9124 48.3324 60.6733 50.0554C61.8117 51.1693 62.1382 51.4053 62.5422 51.4053C63.1753 51.4053 63.6575 50.9226 63.6575 50.289C63.6575 49.8816 63.4156 49.5521 62.2282 48.3411C60.6583 46.7403 60.1101 46.3988 59.1105 46.3988C57.5565 46.3988 56.46 47.6656 56.4613 49.4599C56.4627 51.613 57.3019 54.9394 58.3162 56.8118C58.5698 57.2802 58.743 57.6634 58.7011 57.6634C58.6592 57.6634 58.0811 57.5244 57.4163 57.3549C54.2558 56.5479 52.3661 56.3409 48.1687 56.3421C45.1192 56.3431 43.9286 56.4006 43.116 56.587C42.1458 56.8095 42.062 56.809 42.1579 56.5821C42.8863 54.8586 43.0641 53.9446 43.0739 51.8746C43.0824 50.0798 43.0289 49.5863 42.7175 48.5891C41.4223 44.4406 38.3439 41.4993 34.0097 40.2681C32.9472 39.9665 32.3797 39.9122 30.2548 39.9094C27.3995 39.9055 26.1712 40.1539 23.7227 41.2303C22.9697 41.5614 22.3924 41.7696 22.4397 41.693C22.4871 41.6163 23.119 41.0905 23.844 40.5243C27.3406 37.794 31.3795 35.9709 35.6114 35.2127C36.3654 35.0775 38.2391 34.8992 39.7751 34.8161C41.3112 34.7332 42.9959 34.5543 43.5187 34.4188C46.8588 33.5533 48.6604 31.2222 49.029 27.2891C49.1329 26.18 49.1169 26.0885 48.745 25.6567C48.3683 25.2194 48.3007 25.2013 47.2038 25.241C45.8322 25.2909 44.4732 25.6123 43.3693 26.148C42.5551 26.543 41.1622 27.7458 40.8442 28.3284C40.6777 28.6337 40.6669 28.6318 40.405 28.2502C39.8832 27.49 38.809 26.5658 37.979 26.1628C36.5389 25.4638 33.8158 24.9785 33.0409 25.2826ZM36.8471 28.2582C38.1652 28.8945 39.037 30.1181 39.3385 31.7548L39.451 32.3649L38.7831 32.2582C37.8279 32.1054 36.4927 31.4084 35.932 30.7699C35.3506 30.1076 34.9223 29.1783 34.7755 28.2609L34.6668 27.5807L35.2769 27.6876C35.6125 27.7464 36.3191 28.0032 36.8471 28.2582ZM46.5389 28.2828C46.2061 30.3633 44.6363 31.9222 42.5351 32.2581L41.8669 32.3649L41.9716 31.7548C42.0291 31.4192 42.3036 30.687 42.5814 30.1276C43.144 28.9949 44.0248 28.2718 45.3322 27.8692C46.5658 27.4894 46.6605 27.5218 46.5389 28.2828ZM33.6968 42.6436C35.8597 43.3326 37.5985 44.4741 38.7407 45.9551C41.7223 49.8207 41.4623 54.7493 38.0829 58.4192C37.4596 59.0962 36.829 59.8542 36.6816 60.1039L36.4134 60.5578L33.7252 60.5682C31.2599 60.5778 30.9214 60.6139 29.6413 61.0055C27.04 61.8011 25.2999 62.836 23.414 64.7092L22.2054 65.9094L21.7424 64.9197C20.6203 62.522 18.485 61.2028 15.1934 60.8738C14.2634 60.7809 13.9843 60.8073 13.6609 61.0191C13.0977 61.3882 13.0009 61.7951 13.1315 63.2455C13.2754 64.8443 13.7578 66.3184 14.4601 67.3062C14.7577 67.7249 14.9351 68.0894 14.8543 68.1163C14.4732 68.2434 12.8252 67.7887 12.2627 67.4013C11.4175 66.8193 10.7764 65.5513 10.7764 64.4616C10.7764 63.383 11.16 61.1992 11.6541 59.4656C12.2863 57.2464 13.1614 55.0037 13.395 55.0037C13.905 55.0037 14.9138 55.736 16.9233 57.5653C19.1014 59.548 21.0674 60.9871 22.4082 61.5802C23.0423 61.8607 23.1947 61.8765 23.5621 61.7C23.7949 61.588 24.0862 61.3164 24.2096 61.0964C24.574 60.4464 24.1966 59.8919 22.9121 59.1897C21.4875 58.4109 20.5474 57.6892 18.2993 55.6478C14.9656 52.6206 14.6663 52.5004 10.4624 52.5004H7.54565L6.67123 53.1794C6.1903 53.5529 5.42931 54.0165 4.98029 54.2097C4.24011 54.5281 4.11072 54.541 3.59787 54.3491C2.69623 54.0114 2.40617 53.2569 2.40617 51.2488C2.40617 49.8745 2.45858 49.5169 2.7269 49.06C3.46535 47.8029 4.3296 47.8442 6.38774 49.2348L7.78471 50.1788L10.6495 50.1211C14.038 50.0527 14.408 49.9457 16.7257 48.3629C23.4985 43.7375 24.9737 42.9374 27.8406 42.3352C29.0891 42.0728 32.4628 42.2506 33.6968 42.6436ZM35.5351 62.9268C35.8579 62.9801 36.1218 63.0823 36.1218 63.1538C36.1218 63.2254 36.2728 63.6874 36.4574 64.1807C36.7187 64.8791 37.0991 65.394 38.1784 66.5095C38.9403 67.2973 39.5638 67.9877 39.5638 68.0437C39.5638 68.0999 35.9707 68.1457 31.5792 68.1457H23.5946L23.782 67.7953C24.11 67.1828 26.3338 65.1146 27.2504 64.57C28.4465 63.8592 29.8419 63.3119 31.0928 63.0627C32.2076 62.8407 34.5759 62.7681 35.5351 62.9268ZM17.4269 63.7496C18.8057 64.3594 19.8483 65.7675 20.1037 67.3647L20.2105 68.0329L19.6004 67.9222C18.6666 67.7526 17.4823 67.1613 16.8901 66.5691C16.2979 65.977 15.7067 64.7926 15.5371 63.8589L15.4263 63.2487L16.1064 63.3575C16.4805 63.4172 17.0747 63.5937 17.4269 63.7496ZM50.0614 63.672C51.1521 64.1302 51.8788 64.8086 52.3716 65.8285C52.6338 66.3715 52.8965 67.0895 52.955 67.424L53.0616 68.0321L52.4534 67.9256C51.3159 67.7264 49.9003 66.918 49.3657 66.1625C48.8369 65.4152 48.3569 64.2324 48.3373 63.6277C48.3261 63.2824 48.3685 63.2627 48.9271 63.352C49.2582 63.4049 49.7687 63.5488 50.0614 63.672ZM8.47044 65.1639C8.54132 65.9462 8.79618 66.6613 9.49114 68.0284C9.524 68.093 8.31289 68.1457 6.79984 68.1457C5 68.1457 4.04892 68.0896 4.04892 67.983C4.04892 67.6803 4.6738 66.5931 5.17758 66.0194C5.89397 65.2035 7.45021 64.2937 8.21229 64.2454C8.31289 64.2391 8.42163 64.6265 8.47044 65.1639Z" fill="#931A2A"></path>
										</g>
									</svg>
								</span>
								<span class="homemenu-txt">Dinner</span>
							</button>
						</li>
						<li class="nav-item" role="presentation">
							<button class="nav-link menu-tab-homepage" id="dessert-tab" data-bs-toggle="tab" data-bs-target="#desset" type="button" role="tab" aria-selected="false">
								<span class="menu-tab-img">
									<svg width="80" height="80" viewbox="0 0 80 80" fill="none" xmlns="http://www.w3.org/2000/svg">
										<mask id="mask0_502_2645" style="mask-type:alpha" maskunits="userSpaceOnUse" x="0" y="0" width="80" height="80">
											<rect width="80" height="80" fill="white"></rect>
										</mask>
										<g mask="url(#mask0_502_2645)">
											<path fill-rule="evenodd" clip-rule="evenodd" d="M42.6461 0.71068C42.2213 1.10803 41.6792 1.74086 41.4419 2.11665L41.0101 2.79995L39.9945 2.80261C35.6269 2.8137 32.0187 6.09831 31.6162 10.4292L31.518 11.4842L30.1702 12.0099C27.0084 13.2432 25.106 14.4229 22.9939 16.4603C20.7912 18.5852 19.4667 20.5366 18.2894 23.3917C17.6316 24.9869 17.0336 25.7449 15.603 26.7972C14.832 27.3643 14.3215 27.8574 14.2628 28.0916C14.0318 29.0118 14.8576 29.839 15.6909 29.5223C16.3261 29.2807 18.4494 27.6045 19.011 26.901C19.5992 26.1643 19.9337 25.5388 20.6909 23.7601C22.4239 19.6896 25.8724 16.3226 30.0969 14.577C31.0051 14.2016 31.8066 13.8946 31.8782 13.8946C31.9499 13.8946 32.2643 14.3815 32.577 14.9765C34.0162 17.7153 36.806 19.3947 39.9164 19.3947C43.0267 19.3947 45.8165 17.7153 47.2558 14.9765C47.5684 14.3815 47.8825 13.8946 47.9537 13.8946C48.2044 13.8946 51.1207 15.1601 51.9543 15.6306C52.8376 16.129 53.2325 16.1331 53.7839 15.6489C54.1572 15.321 54.1376 14.4437 53.7483 14.0543C53.3596 13.6657 51.4235 12.6969 49.6625 12.01L48.3147 11.4842L48.2166 10.4292C48.0992 9.16698 47.5726 7.64616 46.8781 6.56379C46.279 5.63033 44.8877 4.31811 44.0365 3.88388C43.7041 3.71419 43.4321 3.50356 43.4321 3.41575C43.4321 3.32777 43.7625 2.90261 44.1665 2.47088C45.0362 1.54117 45.1648 0.786463 44.5397 0.280357C43.9597 -0.189341 43.4955 -0.0838701 42.6461 0.71068ZM39.9228 5.49595C39.7664 6.00471 39.6234 9.73324 39.7421 10.2065C39.8001 10.4375 40.0512 10.7155 40.3343 10.8617C40.784 11.0944 40.8701 11.095 41.3436 10.869C41.9653 10.5726 41.9956 10.4534 42.0658 8.03507C42.0958 7.0038 42.1891 6.03784 42.2734 5.88862C42.4127 5.64174 42.4981 5.66533 43.2178 6.15003C44.2383 6.83723 44.7743 7.48194 45.3695 8.73822C45.7935 9.63339 45.8495 9.91137 45.8409 11.082C45.8282 12.8 45.4163 13.8915 44.3333 15.0765C41.9219 17.7148 37.9108 17.7148 35.4994 15.0765C34.4159 13.8908 34.005 12.8011 33.9901 11.0739C33.9795 9.83199 34.0203 9.65355 34.5681 8.54493C35.5674 6.52316 37.4647 5.22235 39.5049 5.16032C39.9809 5.14594 40.0206 5.17782 39.9228 5.49595ZM56.2263 17.0208C56.0872 17.102 55.8875 17.3759 55.7825 17.6294C55.5528 18.1838 55.6625 18.4256 56.7555 19.7732C57.764 21.0163 58.6029 22.4545 59.2945 24.1248C60.3751 26.7355 60.7694 27.1635 64.8749 30.1822C67.0195 31.7588 68.5524 33.0033 68.915 33.4621C70.1793 35.0615 70.4451 37.3759 69.5764 39.2232C68.4899 41.5345 66.4954 42.6453 63.4322 42.6453C61.9416 42.6453 60.9501 42.9881 60.0189 43.8253C59.4578 44.3298 59.1389 44.7806 58.9099 45.3922C58.6059 46.2047 58.5887 46.578 58.5887 52.3439C58.5887 59.1207 58.5848 59.1502 57.5701 59.9241C56.3891 60.8249 54.6545 60.3748 54.0012 58.998C53.78 58.5319 53.7447 57.7639 53.7439 53.4032C53.7434 50.2941 53.6787 48.1167 53.5759 47.7462C53.4839 47.4149 53.1271 46.8385 52.7831 46.4654C51.9735 45.5871 51.0807 45.2421 49.8485 45.3311C49.0016 45.3924 48.7725 45.4943 47.4967 46.3769C44.8215 48.2276 42.99 48.8173 39.9164 48.8173C36.7866 48.8173 34.7973 48.1526 32.1037 46.2071C30.3632 44.95 29.2909 44.3402 27.9028 43.8181C25.9391 43.0794 24.8596 42.9395 19.4471 42.7226C16.6111 42.6089 14.0778 42.4489 13.8176 42.367C12.2662 41.8792 10.9719 40.734 10.2541 39.2138C9.84439 38.3464 9.77767 38.0275 9.78017 36.9481C9.78439 35.1909 10.1949 34.2035 11.4871 32.8429C12.5727 31.6997 12.6809 31.3625 12.1699 30.713C11.9302 30.4083 11.704 30.3012 11.299 30.3012C10.8468 30.3012 10.5897 30.4559 9.81798 31.192C7.91075 33.0111 7.02276 35.8037 7.54418 38.343C7.68481 39.0277 7.97403 39.9397 8.18701 40.3701L8.5742 41.1524L7.99481 41.6254C5.54288 43.6273 4.49317 46.5958 5.23287 49.4358C5.75179 51.4281 7.19042 53.2776 8.94499 54.2077C9.65845 54.586 9.69563 54.6418 10.1419 56.0047C10.3952 56.7783 11.9135 61.4543 13.5162 66.3958C15.1187 71.3374 16.643 75.7828 16.9033 76.2747C17.788 77.9458 19.7592 79.4058 21.6814 79.8141C22.8441 80.061 56.9794 80.0624 58.1513 79.8155C60.0772 79.4101 62.0369 77.9603 62.9236 76.2855C63.4844 75.2262 66.0889 67.321 66.0889 66.6782C66.0889 65.7707 64.9488 65.2832 64.2408 65.888C64.024 66.0733 63.463 67.5781 62.4999 70.5589C60.9844 75.2495 60.694 75.8447 59.5001 76.7095C58.5049 77.4305 57.5485 77.6461 55.3466 77.6461C53.5764 77.6461 53.4182 77.6228 53.4931 77.3727C53.5381 77.2222 54.1408 74.0406 54.8322 70.3022C55.5238 66.5638 56.1239 63.3548 56.1658 63.1712C56.2207 62.9308 56.4063 62.8072 56.8294 62.7292C58.3807 62.4436 59.6925 61.4748 60.4333 60.0676C60.805 59.3616 60.8503 59.0866 60.9039 57.2159L60.9631 55.1456H64.2458C67.1123 55.1456 67.517 55.1756 67.4378 55.382C67.388 55.512 66.8787 57.0739 66.3062 58.853C65.3467 61.8348 65.2826 62.1182 65.4867 62.4817C65.7698 62.9862 66.419 63.2223 66.9873 63.0275C67.3873 62.8903 67.51 62.5989 68.7594 58.8175L70.1016 54.7549L71.0251 54.2376C75.0095 52.0053 76.1825 46.9857 73.5851 43.2828C72.9959 42.4428 71.6998 41.239 71.3845 41.239C71.3174 41.239 71.4385 40.8548 71.6535 40.3851C72.3207 38.9277 72.5745 37.3091 72.3642 35.8525C72.1371 34.2791 71.3634 32.6124 70.3641 31.5442C69.9555 31.1073 68.2273 29.73 66.5239 28.4835C64.8205 27.2371 63.191 25.9744 62.9027 25.6775C62.3606 25.1194 62.3069 25.022 60.8778 22.0117C59.9937 20.1497 58.5621 18.0445 57.6683 17.2925C57.1438 16.8512 56.6694 16.7617 56.2263 17.0208ZM49.526 20.926C49.2692 21.1827 49.2135 21.4468 49.2135 22.4043C49.2135 23.4025 49.2627 23.6159 49.5555 23.8887C50.2261 24.5136 51.2548 24.1414 51.4943 23.1872C51.6573 22.5378 51.4719 21.2634 51.1652 20.9244C50.7929 20.513 49.9382 20.5138 49.526 20.926ZM39.0806 25.5922C38.8527 25.8382 38.4637 26.4436 38.216 26.9377C37.7805 27.8063 37.7738 27.8532 38.0162 28.3613C38.319 28.9965 38.926 29.2045 39.5138 28.8745C39.9867 28.6092 41.0883 26.7877 41.0883 26.2713C41.0883 25.7849 40.4176 25.1449 39.9081 25.1449C39.654 25.1449 39.3353 25.3172 39.0806 25.5922ZM27.9925 26.401C27.6078 26.7593 27.5308 27.5918 27.8458 27.9854C28.3187 28.5763 29.8774 29.6762 30.2418 29.6762C30.7449 29.6762 31.4005 29.0221 31.4005 28.5201C31.4005 28.0723 31.0182 27.6062 29.9189 26.7141C29.0452 26.005 28.5108 25.9182 27.9925 26.401ZM46.0313 27.0313C45.7312 27.2674 45.6196 27.4987 45.6196 27.8849C45.6196 28.3182 45.7942 28.6013 46.577 29.4381C47.8642 30.8142 48.6281 30.9697 49.1494 29.9615C49.4761 29.3298 49.2985 28.9307 48.1359 27.684C47.1286 26.6036 46.7315 26.4805 46.0313 27.0313ZM55.943 31.125C55.3952 31.4017 54.5395 32.9104 54.5322 33.6127C54.523 34.4884 55.4169 34.9632 56.2428 34.5212C56.6588 34.2985 57.4949 32.6783 57.4949 32.0946C57.4949 31.2914 56.6539 30.7659 55.943 31.125ZM22.3673 33.5887C21.9058 34.0187 21.9105 34.8302 22.3769 35.2529C22.9663 35.787 24.1382 36.3951 24.5782 36.3951C25.5296 36.3951 25.991 35.0679 25.2676 34.4123C24.6937 33.8921 23.5108 33.2701 23.0958 33.2701C22.8831 33.2701 22.5553 33.4135 22.3673 33.5887ZM34.873 33.7752C34.3369 34.0335 33.2479 35.7421 33.3631 36.1445C33.4934 36.6001 34.1631 37.1764 34.5625 37.1764C34.9501 37.1764 36.1167 35.9867 36.4003 35.302C36.6627 34.6685 36.4863 34.1037 35.9374 33.8198C35.4088 33.5465 35.3525 33.5441 34.873 33.7752ZM44.0843 36.1317C43.6036 36.6434 43.6355 37.3805 44.1563 37.79C44.5066 38.0656 44.7874 38.1139 46.0384 38.1139C47.3912 38.1139 47.5395 38.0833 47.8923 37.7303C48.1033 37.5194 48.2759 37.1647 48.2759 36.942C48.2759 36.7194 48.1033 36.3647 47.8923 36.1537C47.537 35.7982 47.3958 35.7701 45.9665 35.7701C44.5563 35.7701 44.3949 35.8011 44.0843 36.1317ZM70.4863 43.4701C73.6576 45.8889 73.2558 50.467 69.7193 52.2093L68.675 52.7236L64.8038 52.7725L60.9325 52.8216L60.9331 49.6475C60.9336 46.7751 60.9626 46.426 61.2387 45.9733C61.692 45.2296 62.2172 45.0424 64.1357 44.9406C65.081 44.8903 66.2412 44.7336 66.7139 44.592C67.6428 44.3141 69.0586 43.5676 69.371 43.1912C69.6397 42.8675 69.7238 42.8886 70.4863 43.4701ZM11.113 43.6653C12.7143 44.7236 13.3749 44.8374 19.2909 45.0746C22.2128 45.1916 24.7793 45.3324 24.9941 45.3872C27.2236 45.9569 28.9328 46.761 30.6193 48.0335C32.0995 49.1504 34.5464 50.3656 36.1663 50.7881C38.0499 51.2795 40.9136 51.3547 42.8078 50.9624C45.1143 50.4847 47.2353 49.5329 49.0406 48.1654C49.8724 47.5354 50.4819 47.4934 51.0174 48.029C51.3884 48.3998 51.401 48.4853 51.401 50.6094V52.8065L31.3582 52.7651L11.3152 52.7236L10.2705 52.2093C9.13218 51.6488 8.35388 50.8641 7.77981 49.6979C7.4948 49.1189 7.42246 48.7071 7.41949 47.6454C7.41605 46.5024 7.47652 46.193 7.85309 45.4261C8.28498 44.5469 9.66189 43.114 10.0752 43.114C10.1872 43.114 10.6543 43.362 11.113 43.6653ZM22.3247 55.9659C22.4155 56.417 23.3375 61.3567 24.3735 66.9427C25.4094 72.5288 26.294 77.2224 26.3393 77.3727C26.4145 77.6228 26.2565 77.6461 24.4861 77.6461C22.2425 77.6461 21.2725 77.4189 20.2784 76.6606C19.9115 76.3808 19.4146 75.872 19.1741 75.5298C18.869 75.0957 17.7947 72.0055 15.6178 65.3002C13.9023 60.0159 12.4577 55.5693 12.4076 55.419C12.3221 55.1625 12.6204 55.1456 17.238 55.1456H22.1594L22.3247 55.9659ZM32.5609 55.4971C32.6354 55.8587 34.0667 76.6639 34.0604 77.2945C34.0568 77.6452 34.0497 77.6461 31.4116 77.6461H28.7664L28.6022 76.8258C28.5117 76.3747 27.5922 71.435 26.5584 65.849C25.5248 60.2629 24.6512 55.5693 24.6168 55.419C24.5588 55.1642 24.824 55.1456 28.5216 55.1456H32.4884L32.5609 55.4971ZM44.4254 62.2942C44.1508 66.226 43.8018 71.2886 43.6496 73.5445L43.373 77.6461H39.9164H36.4597L36.1831 73.5445C36.031 71.2886 35.6819 66.226 35.4073 62.2942L34.9083 55.1456H39.9164H44.9244L44.4254 62.2942ZM51.4307 57.1378C51.5063 59.6047 51.7982 60.3884 53.0771 61.5573L53.9309 62.3375L52.5751 69.6403C51.8295 73.6568 51.1823 77.1011 51.1369 77.2945C51.0555 77.6421 51.0238 77.6461 48.4153 77.6461C45.7834 77.6461 45.7759 77.6452 45.7723 77.2945C45.766 76.6639 47.1973 55.8587 47.2718 55.4971C47.3425 55.1545 47.3954 55.1456 49.3571 55.1456H51.3696L51.4307 57.1378Z" fill="#931A2A"></path>
										</g>
									</svg>
								</span>
								<span class="homemenu-txt">Desset</span>
							</button>
						</li>
						<li class="nav-item" role="presentation">
							<button class="nav-link menu-tab-homepage" id="drink-tab" data-bs-toggle="tab" data-bs-target="#drink" type="button" role="tab" aria-selected="false">
								<span class="menu-tab-img">
									<svg width="80" height="80" viewbox="0 0 80 80" fill="none" xmlns="http://www.w3.org/2000/svg">
										<mask id="mask0_502_2649" style="mask-type:alpha" maskunits="userSpaceOnUse" x="0" y="0" width="80" height="80">
											<rect width="80" height="80" fill="white"></rect>
										</mask>
										<g mask="url(#mask0_502_2649)">
											<path fill-rule="evenodd" clip-rule="evenodd" d="M10.4923 0.138897C10.3147 0.658881 9.95717 2.21336 10.0042 2.26058C10.0332 2.2895 12.5103 2.95254 15.5088 3.73392C18.5074 4.5153 21.0196 5.20773 21.0913 5.27245C21.2327 5.40003 23.3841 14.3712 23.3841 14.8335C23.3841 15.097 23.0875 15.1171 18.6621 15.1559L13.9404 15.1973L12.7186 26.6883C11.5632 37.5534 11.5006 38.3282 11.5656 40.9152C11.6208 43.11 11.7111 43.9758 12.0224 45.2927C13.0664 49.7093 15.0859 53.3823 18.1606 56.457C21.9143 60.2106 26.6212 62.4201 32.1813 63.0383L33.0835 63.1386L33.0411 66.269L32.9989 69.3994L30.3809 70.7646C28.941 71.5153 27.7168 72.1755 27.6607 72.2318C27.5849 72.3076 28.3575 73.9949 28.6263 74.3402C28.6463 74.366 29.8765 73.7503 31.36 72.9722C32.8437 72.1943 34.1239 71.5577 34.2049 71.5577C34.2861 71.5577 36.475 72.6631 39.0693 74.0141C43.4194 76.2794 44.6462 77.0435 44.6462 77.4865C44.6462 77.6052 41.5491 77.6549 34.1715 77.6549C28.4104 77.6549 23.6967 77.5983 23.6967 77.5292C23.6967 77.2753 24.7359 76.4256 25.5337 76.0271C25.9852 75.8017 26.3545 75.546 26.3545 75.4591C26.3545 75.2341 25.4315 73.4337 25.3163 73.4337C24.9795 73.4337 22.852 74.7945 22.3911 75.3047C21.4447 76.3523 21.1476 77.1005 21.0701 78.632L21.0007 80H34.2529H47.505L47.4198 78.7579C47.3179 77.2708 46.8504 76.1439 45.9554 75.2281C45.3613 74.62 42.9437 73.269 37.4943 70.4996L35.4234 69.4471L35.4228 66.2925L35.4222 63.1379L36.3211 63.0344C42.0305 62.3771 47.1556 59.8465 50.8483 55.8609C51.8647 54.7639 53.3368 52.8273 53.2247 52.7347C52.9686 52.5234 51.4302 51.5462 51.3535 51.5462C51.2997 51.5462 50.859 52.0644 50.374 52.6974C45.5602 58.9825 37.3156 61.9799 29.7003 60.2138C22.711 58.5929 17.17 53.5075 14.8864 46.6176C14.2632 44.7377 14.0125 43.2538 13.923 40.9152C13.8511 39.0333 13.9654 37.6528 14.9783 28.1735L16.1143 17.5424H20.0941H24.0737L25.1881 22.2717L26.3023 27.001H22.1249H17.9477L17.8542 27.6654C17.8029 28.0309 17.5057 30.6515 17.194 33.489C16.5348 39.4889 16.5139 42.3102 17.1119 44.5626C18.7175 50.6115 22.9713 55.2022 28.7054 57.0744C38.3342 60.2184 48.6543 54.6311 51.2048 44.8935C52.0053 41.8374 51.999 40.71 51.136 32.4728C50.8343 29.5923 50.5874 27.1826 50.5873 27.1182C50.5871 27.0538 47.4564 27.001 43.63 27.001H36.6729V28.2517V29.5024H42.5261H48.3791L48.467 30.1668C48.5153 30.5324 48.6618 31.9217 48.7928 33.2545C48.9237 34.5873 49.0675 35.9065 49.1125 36.1859L49.1943 36.694H34.2567C20.9439 36.694 19.3192 36.6679 19.3192 36.4545C19.3192 36.0682 19.9477 30.2395 20.0309 29.8542L20.1069 29.5024H27.1392H34.1715V28.2517V27.001H31.469H28.7664L27.6962 22.428C27.1077 19.9129 26.5925 17.7668 26.5515 17.6588C26.4918 17.5019 29.087 17.4705 39.4309 17.5024L52.385 17.5424L53.4308 27.8608C54.5439 38.8449 54.6751 41.3468 54.2587 43.6511C54.1344 44.339 54.0313 44.9822 54.0297 45.0804C54.0269 45.2447 56.1655 45.8724 56.281 45.7412C56.4106 45.5941 56.8393 42.7164 56.93 41.3842C57.0195 40.0684 56.6326 34.7629 56.2772 32.4338C56.1945 31.8909 56.2164 31.8475 56.5724 31.8475C56.7839 31.8475 57.625 31.678 58.4417 31.4709C66.8039 29.3496 71.863 20.8962 69.8186 12.4614C69.0855 9.43749 66.8999 6.02929 64.4331 4.06364C59.0022 -0.26399 51.5734 -0.557595 45.7406 3.32494C42.2314 5.6608 39.5746 9.94841 39.054 14.1163L38.9386 15.041H32.4513H25.964L24.5815 9.17828C23.821 5.95378 23.1879 3.30414 23.1743 3.29023C23.1607 3.27631 20.441 2.55293 17.1305 1.68275C13.82 0.812563 10.9879 0.0627595 10.837 0.0166394C10.6849 -0.0299497 10.5312 0.0246127 10.4923 0.138897ZM53.4012 8.19991V13.3188L49.8054 9.72547C47.8277 7.74918 46.2096 6.07745 46.2096 6.01053C46.2096 5.82762 48.2884 4.51953 49.2667 4.08693C50.3174 3.62214 52.2058 3.1034 52.8931 3.09058L53.4012 3.08105V8.19991ZM57.8625 3.39513C59.3218 3.76831 61.3129 4.70322 62.369 5.51103L63.129 6.0923L59.5561 9.66778C57.5911 11.6342 55.93 13.2431 55.8648 13.2431C55.7996 13.2431 55.7463 10.9566 55.7463 8.16208V3.08105H56.1903C56.4345 3.08105 57.187 3.22238 57.8625 3.39513ZM51.5251 15.0007C51.5251 15.0659 49.2321 15.1192 46.4294 15.1192H41.3337L41.4452 14.2984C41.6922 12.4803 42.6981 10.0086 43.8079 8.49273L44.3671 7.72917L47.9461 11.3056C49.9145 13.2727 51.5251 14.9355 51.5251 15.0007ZM66.4487 10.3508C67.1398 11.7472 67.7844 13.8358 67.7844 14.6795V15.1192H62.7034C59.9088 15.1192 57.6224 15.067 57.6224 15.0032C57.6224 14.9394 59.223 13.2834 61.1791 11.3233L64.7358 7.7595L65.2439 8.35156C65.5235 8.67737 66.0655 9.57695 66.4487 10.3508ZM67.7844 17.8681C67.7844 18.4783 67.1972 20.6522 66.7739 21.6094C66.345 22.5792 65.0369 24.6559 64.8549 24.6559C64.788 24.6559 63.1163 23.0378 61.14 21.0601L57.5467 17.4643H62.6656H67.7844V17.8681ZM62.7064 26.7998C61.4458 27.8962 58.2568 29.2602 56.6887 29.3736L55.9896 29.4242L55.4871 24.4995C55.2108 21.791 54.9802 19.2939 54.9746 18.9506L54.9646 18.3263L59.0343 22.39L63.1041 26.4538L62.7064 26.7998ZM49.3986 39.556C49.5493 40.3594 49.2093 43.1244 48.7759 44.6198C46.5084 52.4447 38.5329 57.0555 30.5826 55.1377C29.0107 54.7584 26.6966 53.695 25.3614 52.7382C24.2452 51.9383 22.4174 50.0806 21.6781 48.9945C20.8786 47.82 19.8445 45.5033 19.4679 44.042C19.2567 43.2226 19.0943 42.0088 19.0444 40.8761L18.9636 39.0391H34.1325H49.3015L49.3986 39.556ZM23.027 42.552C22.5295 42.6609 22.0833 42.7892 22.0352 42.8372C21.939 42.9335 22.5914 45.1112 22.7449 45.2061C22.8503 45.2711 24.7855 44.4802 24.8279 44.3546C24.9074 44.1189 24.2764 42.3247 24.1185 42.3382C24.0155 42.3471 23.5243 42.4432 23.027 42.552ZM25.0647 46.8928C24.5704 47.2427 24.1665 47.6062 24.1675 47.7006C24.1684 47.795 24.5144 48.2592 24.9364 48.7321L25.7035 49.592L26.498 48.8162C26.935 48.3894 27.2894 47.9673 27.2855 47.8782C27.2818 47.7889 26.9827 47.3876 26.6211 46.9865L25.9637 46.2568L25.0647 46.8928ZM52.963 48.1618C52.7907 48.6044 52.6018 49.0858 52.5432 49.2313C52.4594 49.4394 52.6391 49.5981 53.3834 49.9739C53.9043 50.2367 54.3915 50.4519 54.466 50.4519C54.6092 50.4519 54.8112 50.0602 55.2865 48.8611L55.576 48.1304L54.426 47.7438L53.276 47.357L52.963 48.1618ZM28.7896 49.7093C28.6302 49.9888 28.3668 50.44 28.2043 50.712L27.909 51.2067L28.93 51.6891C29.4916 51.9544 30.0537 52.1716 30.1789 52.1716C30.3233 52.1716 30.5236 51.7933 30.7258 51.139C30.9012 50.571 31.0447 50.0837 31.0447 50.056C31.0447 49.9921 29.3225 49.2011 29.1835 49.2011C29.1264 49.2011 28.9491 49.4297 28.7896 49.7093Z" fill="#931A2A"></path>
										</g>
									</svg>
								</span>
								<span class="homemenu-txt">Drink</span>
							</button>
						</li>
					</ul>
					<div class="tab-content">
						<div class="tab-pane active" id="allmenu">
							<div class="tab-description">
								<a href="menupage-nonveg.php">
									<div class="homepage1-menu-content">
										<div class="homepage1-menu-left">
											<img src="assets/images/Homepage1/menu-item1.png" alt="menu-item-img">
										</div>
										<div class="homepage1-menu-right">
											<h4 class="tab-menu-txt1">Antipasto Salad</h4>
											<p class="tab-menu-txt2">Virgin olive oil, touch of garlic, prawns, green peas, sun dried tomato,  and Italian herbs.</p>
											<h5 class="tab-menu-txt3">₹20</h5>
										</div>
									</div>
								</a>
								<a href="menupage-nonveg.php">
									<div class="homepage1-menu-content">
										<div class="homepage1-menu-left">
											<img src="assets/images/Homepage1/menu-item2.png" alt="menu-item-img">
										</div>
										<div class="homepage1-menu-right">
											<h4 class="tab-menu-txt1">Chicken Biryani</h4>
											<p class="tab-menu-txt2">Virgin olive oil, touch of garlic, prawns, green peas, sun dried tomato,  and Italian herbs.</p>
											<h5 class="tab-menu-txt3">₹35</h5>
										</div>
									</div>
								</a>
								<a href="menupage-nonveg.php">
									<div class="homepage1-menu-content">
										<div class="homepage1-menu-left">
											<img src="assets/images/Homepage1/menu-item3.png" alt="menu-item-img">
										</div>
										<div class="homepage1-menu-right">
											<h4 class="tab-menu-txt1">Finger Chicken</h4>
											<p class="tab-menu-txt2">Virgin olive oil, touch of garlic, prawns, green peas, sun dried tomato,  and Italian herbs.</p>
											<h5 class="tab-menu-txt3">₹12</h5>
										</div>
									</div>
								</a>
								<a href="menupage-nonveg.php">
									<div class="homepage1-menu-content">
										<div class="homepage1-menu-left">
											<img src="assets/images/Homepage1/menu-item4.png" alt="menu-item-img">
										</div>
										<div class="homepage1-menu-right">
											<h4 class="tab-menu-txt1">Orange Juice</h4>
											<p class="tab-menu-txt2">Virgin olive oil, touch of garlic, prawns, green peas, sun dried tomato,  and Italian herbs.</p>
											<h5 class="tab-menu-txt3">₹10</h5>
										</div>
									</div>
								</a>
								<a href="menupage-nonveg.php">
									<div class="homepage1-menu-content">
										<div class="homepage1-menu-left">
											<img src="assets/images/Homepage1/menu-item5.png" alt="menu-item-img">
										</div>
										<div class="homepage1-menu-right">
											<h4 class="tab-menu-txt1">Le Pigeon Burger</h4>
											<p class="tab-menu-txt2">Virgin olive oil, touch of garlic, prawns, green peas, sun dried tomato,  and Italian herbs.</p>
											<h5 class="tab-menu-txt3">₹15</h5>
										</div>
									</div>
								</a>
								<a href="menupage-nonveg.php">
									<div class="homepage1-menu-content">
										<div class="homepage1-menu-left">
											<img src="assets/images/Homepage1/menu-item6.png" alt="menu-item-img">
										</div>
										<div class="homepage1-menu-right">
											<h4 class="tab-menu-txt1">Broccoli Rabe</h4>
											<p class="tab-menu-txt2">Virgin olive oil, touch of garlic, prawns, green peas, sun dried tomato,  and Italian herbs.</p>
											<h5 class="tab-menu-txt3">₹20</h5>
										</div>
									</div>
								</a>
								<a href="menupage-nonveg.php">
									<div class="homepage1-menu-content">
										<div class="homepage1-menu-left">
											<img src="assets/images/Homepage1/menu-item7.png" alt="menu-item-img">
										</div>
										<div class="homepage1-menu-right">
											<h4 class="tab-menu-txt1">Pineapple Cake</h4>
											<p class="tab-menu-txt2">Virgin olive oil, touch of garlic, prawns, green peas, sun dried tomato,  and Italian herbs.</p>
											<h5 class="tab-menu-txt3">₹30</h5>
										</div>
									</div>
								</a>
								<a href="menupage-nonveg.php">
									<div class="homepage1-menu-content">
										<div class="homepage1-menu-left">
											<img src="assets/images/Homepage1/menu-item8.png" alt="menu-item-img">
										</div>
										<div class="homepage1-menu-right">
											<h4 class="tab-menu-txt1">Beef Grilled</h4>
											<p class="tab-menu-txt2">Virgin olive oil, touch of garlic, prawns, green peas, sun dried tomato,  and Italian herbs.</p>
											<h5 class="tab-menu-txt3">₹25</h5>
										</div>
									</div>
								</a>
							</div>
						</div>
						<div class="tab-pane " id="breakfast">
							<div class="tab-description">
								<a href="menupage-nonveg.php">
									<div class="homepage1-menu-content">
										<div class="homepage1-menu-left">
											<img src="assets/images/Homepage1/menu-item3.png" alt="menu-item-img">
										</div>
										<div class="homepage1-menu-right">
											<h4 class="tab-menu-txt1">Finger Chicken</h4>
											<p class="tab-menu-txt2">Virgin olive oil, touch of garlic, prawns, green peas, sun dried tomato,  and Italian herbs.</p>
											<h5 class="tab-menu-txt3">₹12</h5>
										</div>
									</div>
								</a>
								<a href="menupage-nonveg.php">
									<div class="homepage1-menu-content">
										<div class="homepage1-menu-left">
											<img src="assets/images/Homepage1/menu-item4.png" alt="menu-item-img">
										</div>
										<div class="homepage1-menu-right">
											<h4 class="tab-menu-txt1">Orange Juice</h4>
											<p class="tab-menu-txt2">Virgin olive oil, touch of garlic, prawns, green peas, sun dried tomato,  and Italian herbs.</p>
											<h5 class="tab-menu-txt3">₹10</h5>
										</div>
									</div>
								</a>
							</div>
						</div>
						<div class="tab-pane" id="lunch">
							<div class="tab-description">
								<a href="menupage-nonveg.php">
									<div class="homepage1-menu-content">
										<div class="homepage1-menu-left">
											<img src="assets/images/Homepage1/menu-item5.png" alt="menu-item-img">
										</div>
										<div class="homepage1-menu-right">
											<h4 class="tab-menu-txt1">Le Pigeon Burger</h4>
											<p class="tab-menu-txt2">Virgin olive oil, touch of garlic, prawns, green peas, sun dried tomato,  and Italian herbs.</p>
											<h5 class="tab-menu-txt3">₹15</h5>
										</div>
									</div>
								</a>
								<a href="menupage-nonveg.php">
									<div class="homepage1-menu-content">
										<div class="homepage1-menu-left">
											<img src="assets/images/Homepage1/menu-item6.png" alt="menu-item-img">
										</div>
										<div class="homepage1-menu-right">
											<h4 class="tab-menu-txt1">Broccoli Rabe</h4>
											<p class="tab-menu-txt2">Virgin olive oil, touch of garlic, prawns, green peas, sun dried tomato,  and Italian herbs.</p>
											<h5 class="tab-menu-txt3">₹20</h5>
										</div>
									</div>
								</a>
							</div>
						</div>
						<div class="tab-pane" id="dinner">
							<div class="tab-description">
								<a href="menupage-nonveg.php">
									<div class="homepage1-menu-content">
										<div class="homepage1-menu-left">
											<img src="assets/images/Homepage1/menu-item7.png" alt="menu-item-img">
										</div>
										<div class="homepage1-menu-right">
											<h4 class="tab-menu-txt1">Pineapple Cake</h4>
											<p class="tab-menu-txt2">Virgin olive oil, touch of garlic, prawns, green peas, sun dried tomato,  and Italian herbs.</p>
											<h5 class="tab-menu-txt3">₹30</h5>
										</div>
									</div>
								</a>
								<a href="menupage-nonveg.php">
									<div class="homepage1-menu-content">
										<div class="homepage1-menu-left">
											<img src="assets/images/Homepage1/menu-item8.png" alt="menu-item-img">
										</div>
										<div class="homepage1-menu-right">
											<h4 class="tab-menu-txt1">Beef Grilled</h4>
											<p class="tab-menu-txt2">Virgin olive oil, touch of garlic, prawns, green peas, sun dried tomato,  and Italian herbs.</p>
											<h5 class="tab-menu-txt3">₹25</h5>
										</div>
									</div>
								</a>
							</div>
						</div>
						<div class="tab-pane" id="desset">
							<div class="tab-description">
								<a href="menupage-nonveg.php">
									<div class="homepage1-menu-content">
										<div class="homepage1-menu-left">
											<img src="assets/images/Homepage1/menu-item1.png" alt="menu-item-img">
										</div>
										<div class="homepage1-menu-right">
											<h4 class="tab-menu-txt1">Antipasto Salad</h4>
											<p class="tab-menu-txt2">Virgin olive oil, touch of garlic, prawns, green peas, sun dried tomato,  and Italian herbs.</p>
											<h5 class="tab-menu-txt3">₹20</h5>
										</div>
									</div>
								</a>
								<a href="menupage-nonveg.php">
									<div class="homepage1-menu-content">
										<div class="homepage1-menu-left">
											<img src="assets/images/Homepage1/menu-item2.png" alt="menu-item-img">
										</div>
										<div class="homepage1-menu-right">
											<h4 class="tab-menu-txt1">Chicken Biryani</h4>
											<p class="tab-menu-txt2">Virgin olive oil, touch of garlic, prawns, green peas, sun dried tomato,  and Italian herbs.</p>
											<h5 class="tab-menu-txt3">₹35</h5>
										</div>
									</div>
								</a>
							</div>
						</div>
						<div class="tab-pane" id="drink">
							<div class="tab-description">
								<a href="menupage-nonveg.php">
									<div class="homepage1-menu-content">
										<div class="homepage1-menu-left">
											<img src="assets/images/Homepage1/menu-item3.png" alt="menu-item-img">
										</div>
										<div class="homepage1-menu-right">
											<h4 class="tab-menu-txt1">Finger Chicken</h4>
											<p class="tab-menu-txt2">Virgin olive oil, touch of garlic, prawns, green peas, sun dried tomato,  and Italian herbs.</p>
											<h5 class="tab-menu-txt3">₹12</h5>
										</div>
									</div>
								</a>
								<a href="menupage-nonveg.php">
									<div class="homepage1-menu-content">
										<div class="homepage1-menu-left">
											<img src="assets/images/Homepage1/menu-item4.png" alt="menu-item-img">
										</div>
										<div class="homepage1-menu-right">
											<h4 class="tab-menu-txt1">Orange Juice</h4>
											<p class="tab-menu-txt2">Virgin olive oil, touch of garlic, prawns, green peas, sun dried tomato,  and Italian herbs.</p>
											<h5 class="tab-menu-txt3">₹10</h5>
										</div>
									</div>
								</a>
							</div>
						</div>
					</div>
				</div>
				<div class="view-all-homepage1">
					<a href="menupage-nonveg.php">View All</a>
				</div>
			</div>
		</section> 
		<!-- Menu  Section End -->
		<!-- Booking Section Start -->
		<section id="reservation-sec">
			<div class="menupage-1-reser-overlay"></div>
			<div class="container">
				<div class="reservation-sec-full" data-aos="fade-down">
					<div class="reser-top">
						<p class="reser-txt1-menu1"><span class="pr-10"><img src="assets/images/Homepage1/yellow-star.png" alt="yellow-star"></span>RESERVATION<span class="pf-10"><img src="assets/images/Homepage1/yellow-star.png" alt="yellow-star"></span></p>
						<h2 class="reser-txt2-menu1">Book A Table</h2>
						<p class="reser-txt3-menu1">You can Call Us directly at <a href="tel:+01(234)5678899"><span class="menupage1-no">+01 (234) 567 8899</span></a></p>
					</div>
					<div class="reser-bottom-sec">
    <form class="menupage1-form" method="POST" action="reservation.php">
        <div class="form-menupage1">
            <div class="single-input-form-menupage1">
                <input type="text" name="name" placeholder="Name" class="menupage1-form-custom name-icon" required>
            </div>
            <div class="single-input-form-menupage1">
                <input type="email" name="email" placeholder="Email Address" class="menupage1-form-custom email-icon" required>
            </div>
            <div class="single-input-form-menupage1">
                <input type="tel" name="number" placeholder="Phone Number" class="menupage1-form-custom mobile-icon" required>
            </div>
            <div class="single-input-form-menupage1">
                <select name="guests" class="menupage1-form-custom arrow-icon">
                    <option value="1 Person">1 Person</option>
                    <option value="2 Persons">2 Persons</option>
                    <option value="3 Persons">3 Persons</option>
                    <option value="4 Persons">4 Persons</option>
                </select>
            </div>
            <div class="single-input-form-menupage1">
                <input type="text" name="reservation_date" id="datepicker" autocomplete="off" placeholder="dd/mm/yy" class="menupage1-form-custom arrow-icon" required>
            </div>
            <div class="single-input-form-menupage1">
                <select name="reservation_time" class="menupage1-form-custom arrow-icon">
                    <option value="08:00 am">08:00 am</option>
                    <option value="09:00 am">09:00 am</option>
                    <option value="10:00 am">10:00 am</option>
                    <option value="07:00 pm">07:00 pm</option>
                </select>
            </div>
        </div>
      
<div class="menupage-1-book-now-btn">
    <?php if (isset($_SESSION['user_id'])): ?>
        <button type="submit" class="btn-book-now">
            Book Now
        </button>
    <?php else: ?>
        <button type="button" class="btn-book-now" onclick="promptLogin()">
            Book Now
        </button>
    <?php endif; ?>
</div>

<script>
function promptLogin() {
    Swal.fire({
        title: 'Login Required',
        text: "You must be signed in to book a table!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#78350f', // Matches your restaurant brown theme
        cancelButtonColor: '#d33',
        confirmButtonText: 'Go to Sign In'
    }).then((result) => {
        if (result.isConfirmed) {
            // CHANGE: Redirect to the login page
            window.location.href = 'login.php'; 
        }
    });
}
</script><style>/* Style for both the real and the placeholder button */
.btn-book-now {
    position: relative;
    padding: 15px 20px;
    background: transparent;
    color: #EAB308; /* Gold Text */
    border: 2px solid #EAB308; /* Gold Border */
    font-weight: 700;
    text-transform: uppercase;
    letter-spacing: 2px;
    cursor: pointer;
    overflow: hidden;
    transition: 0.4s;
    z-index: 1;
}

/* The sliding background layer */
.btn-book-now::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 0%; /* Starts empty */
    height: 100%;
    background: #EAB308;
    z-index: -1; /* Puts it behind text */
    transition: 0.4s cubic-bezier(0.4, 0, 0.2, 1);
}

.btn-book-now:hover {
    color: #000; /* Text turns black for contrast */
}

.btn-book-now:hover::before {
    width: 100%; /* Slides to fill */
}</style>
			</div>
				</section>
		<!-- Booking Section End -->
		<!-- Mobile App Section Start -->
		<section id="home2-services-sec">
			<div class="homepage2-hero-overlay"></div>
			<div class="container">
				<div class="home2-services-top">
					<p class="homemenu-txt1"><span class="pr-10"><img src="assets/images/Homepage1/yellow-star.png" alt="yellow-star"></span>SERVICES<span class="pf-10"><img src="assets/images/Homepage1/yellow-star.png" alt="yellow-star"></span></p>
					<h2 class="homemenu-txt2 wow fadeInUp " data-wow-duration="1s">Why Choose Us</h2>
				</div>
				<div class="home2-services-bottom">
					<div class="home2-services-bottom-full">
						<div class="home2-services-sec wow fadeInUp" data-wow-duration="1.2s">
							<div class="home2-ser-img">
								<svg width="60" height="60" viewbox="0 0 60 60" fill="none" xmlns="http://www.w3.org/2000/svg">
									<mask id="mask0_502_3436" style="mask-type:alpha" maskunits="userSpaceOnUse" x="0" y="0" width="60" height="60">
										<rect width="60" height="60" fill="white"></rect>
									</mask>
									<g mask="url(#mask0_502_3436)">
										<path fill-rule="evenodd" clip-rule="evenodd" d="M40.6645 1.17139C39.5407 1.4721 38.5708 2.17054 37.7932 3.23895C37.571 3.54423 37.5348 3.55407 37.0902 3.42985C36.2777 3.20297 34.8119 3.36434 33.9281 3.7779C32.9121 4.25345 31.9808 5.18792 31.4896 6.22492C31.1407 6.96157 31.1136 7.10735 31.1136 8.24923C31.1136 9.39053 31.1408 9.53714 31.4887 10.2718C31.6951 10.7074 32.1302 11.3452 32.4555 11.6893L33.0472 12.3149V14.0321V15.7493L32.7249 15.75C31.782 15.7519 30.8421 16.3574 30.4532 17.2131C30.2853 17.583 30.2392 17.9833 30.2372 19.0936C30.235 20.3287 30.2675 20.5687 30.4983 21.0204C30.8996 21.8057 31.4582 22.1862 32.4574 22.3546L33.3028 22.497L33.5083 23.0783C33.9592 24.3533 34.875 25.7068 35.7994 26.4643C36.3203 26.8912 36.3285 26.9088 36.3285 27.6045C36.3285 28.8183 36.4037 28.7635 32.3347 30.5173C27.5635 32.5737 27.5263 32.6103 27.4442 35.343L27.3959 36.9483L26.7938 36.4956C25.6007 35.5985 23.7156 34.8181 22.3244 34.6453L21.6213 34.558L21.559 33.6205C21.4869 32.5388 21.2502 32.039 20.6252 31.6496C20.2321 31.4046 20.0926 31.394 17.2853 31.394C14.541 31.394 14.3297 31.4092 13.9458 31.6347C13.2355 32.052 13.0079 32.5233 13.0079 33.5771C13.0079 34.4361 12.9911 34.4982 12.7443 34.545C10.5321 34.9636 9.4481 35.3446 8.22945 36.1324C7.30683 36.7286 6.06545 37.9073 5.44681 38.7742C4.95708 39.4605 4.08578 41.1307 3.95336 41.6367C3.89195 41.8715 3.8159 41.8824 2.23221 41.8824C0.629303 41.8824 0.565904 41.8917 0.287698 42.1701C0.129493 42.3283 0 42.5943 0 42.7613C0 43.1498 0.487387 43.6402 0.873641 43.6402C1.16568 43.6402 1.17189 43.6578 1.17235 44.4898C1.17271 45.1257 1.23036 45.4339 1.40158 45.7146C1.64627 46.116 2.18041 46.4527 2.57229 46.4527C2.80268 46.4527 2.81253 46.518 2.81253 48.0464C2.81253 49.8095 2.92093 50.2117 3.535 50.7284C3.72355 50.887 4.08637 51.0731 4.34125 51.1417L4.80473 51.2665V52.1995V53.1325H2.98245C0.94747 53.1325 0.627311 53.2184 0.22969 53.8706C0.0324613 54.1941 0.00082032 54.4656 0.000468755 55.8398C0 57.3054 0.0215627 57.4658 0.26719 57.8303C0.414145 58.0483 0.664694 58.2926 0.823836 58.3733C1.05259 58.4891 6.27815 58.5201 25.7522 58.5214C50.2361 58.5232 50.3926 58.5216 50.6255 58.2888C50.9745 57.9398 50.938 57.3126 50.5511 57.0083L50.2423 56.7653H26.0001H1.75783V55.8278V54.8903H30.0003H58.2427V55.8278V56.7653H56.1492C54.2085 56.7653 54.033 56.783 53.7468 57.0083C53.3598 57.3126 53.3234 57.9398 53.6724 58.2888C53.8922 58.5086 54.0618 58.523 56.397 58.5214C59.1349 58.5195 59.2906 58.4873 59.7334 57.8303C59.9791 57.4656 60.0006 57.3056 60 55.8398C59.9994 54.5089 59.9644 54.1881 59.7872 53.8963C59.5823 53.559 59.5823 53.5275 59.7878 52.9869C60.0561 52.2808 60.0559 51.878 59.7872 51.4354C59.5823 51.0981 59.5823 51.0666 59.7878 50.526C60.0619 49.8047 60.0571 49.3686 59.771 49.005C59.5431 48.7153 59.5431 48.709 59.771 48.1091C60.064 47.3381 60.0613 46.913 59.761 46.5314C59.5301 46.2377 59.5287 46.213 59.7237 45.8417C59.8352 45.6292 59.9294 45.1822 59.9339 44.8443C59.9407 44.3258 59.8923 44.1821 59.6174 43.9068C59.3041 43.593 59.2435 43.5802 57.8888 43.5425L56.4849 43.5034V42.1602C56.4849 40.8904 56.4692 40.8013 56.1972 40.5294C55.8307 40.1627 55.3814 40.1627 55.0148 40.5294C54.7426 40.8015 54.7271 40.8898 54.7271 42.1701V43.523H49.6763H44.6254L44.227 43.9215C43.7692 44.3792 43.7146 44.8114 44.0093 45.6462C44.1743 46.1142 44.173 46.196 43.9932 46.5945C43.7741 47.0805 43.8126 47.7437 44.0926 48.3049C44.2473 48.6151 44.2432 48.6743 44.0486 48.9272C43.7714 49.2878 43.7718 50.0079 44.0497 50.6197C44.2598 51.0824 44.2598 51.1024 44.0471 51.365C43.8074 51.6611 43.7586 52.3473 43.9428 52.8319L44.0571 53.1325H41.1276H38.198L38.23 43.9625L38.2621 34.7925L38.5177 34.3237C38.6583 34.0659 40.0294 32.6089 41.5646 31.0859C44.093 28.5777 44.4069 28.3048 44.8974 28.1876C45.1953 28.1165 45.5177 28.0281 45.6139 27.9912C45.7453 27.9408 45.8081 28.0447 45.8665 28.41C45.9092 28.6773 46.0436 29.0889 46.1652 29.3247C46.62 30.2069 47.0176 30.4449 50.6895 32.0324C53.0849 33.0683 54.2835 33.6472 54.4634 33.8557C54.7087 34.1397 54.7271 34.2711 54.7271 35.7418C54.7271 37.264 54.7378 37.3333 55.0148 37.6103C55.3814 37.9769 55.8307 37.9769 56.1972 37.6103C56.4751 37.3325 56.4849 37.2671 56.4849 35.6914C56.4849 33.9249 56.3702 33.3881 55.8454 32.7001C55.4524 32.1848 54.9916 31.9495 51.3286 30.3937C49.6206 29.6681 48.0948 28.9528 47.938 28.8039C47.7144 28.5917 47.642 28.3822 47.6023 27.8326L47.5515 27.1321L48.4849 26.2161C49.4687 25.2507 50.2369 24.0874 50.5645 23.067L50.7547 22.4746L51.5319 22.3415C52.3789 22.1964 52.7086 22.0021 53.2554 21.3265L53.6138 20.8838V19.0976C53.6138 17.3377 53.609 17.3044 53.2899 16.844C52.8986 16.2793 52.2448 15.8912 51.5168 15.7914L50.9771 15.7174V14.0237V12.3301L51.5093 11.7252C51.8021 11.3926 52.2107 10.7786 52.4175 10.3611C52.775 9.63921 52.7935 9.53538 52.7935 8.25169C52.7935 6.95219 52.7787 6.87203 52.3982 6.11382C51.6046 4.5326 49.9892 3.44755 48.2907 3.35497C47.8023 3.32837 47.1655 3.36282 46.8755 3.43161C46.3889 3.54692 46.3345 3.53638 46.1727 3.29544C44.933 1.4503 42.7574 0.611465 40.6645 1.17139ZM42.9628 2.91446C43.7735 3.15528 44.4547 3.77696 44.8767 4.66115C45.3604 5.67472 45.6045 5.77362 46.6203 5.36733C48.3206 4.68705 50.0885 5.33288 50.8187 6.90074C51.0067 7.30446 51.0924 7.70267 51.0931 8.17705C51.0948 9.25377 50.8923 9.74444 50.1198 10.5344C49.7416 10.9211 49.3843 11.3597 49.3257 11.5088C49.2672 11.658 49.2192 12.4359 49.2192 13.2374V14.6946H42.0121H34.805V13.1042V11.5139L34.0578 10.7898C33.1517 9.91167 32.9169 9.47632 32.8413 8.53424C32.7588 7.5072 33.0357 6.7484 33.756 6.02827C34.7352 5.04893 36.1747 4.81865 37.5195 5.42616C38.2974 5.77761 38.5378 5.6514 39.1029 4.59541C39.9354 3.03985 41.334 2.43082 42.9628 2.91446ZM20.9014 8.94322C20.6026 9.07354 20.2736 9.51346 20.2736 9.783C20.2736 9.88882 20.3777 10.1077 20.5048 10.2693C20.7221 10.5457 20.8154 10.5663 22.0595 10.614C23.5875 10.6725 23.9657 10.8268 24.378 11.5606C24.8003 12.3118 24.562 13.2409 23.8227 13.7262C23.5472 13.907 23.1034 13.9403 20.2794 13.9915L17.0509 14.0501L16.4352 14.3912C15.3691 14.982 14.883 15.8438 14.883 17.1433C14.883 17.8848 14.911 17.9809 15.1917 18.2017C15.589 18.5143 15.8503 18.5085 16.2337 18.1787C16.4807 17.9663 16.5602 17.7651 16.6295 17.1769C16.6972 16.6033 16.7861 16.371 17.0325 16.1243L17.3487 15.8079L20.5984 15.7481C24.3674 15.6788 24.4808 15.6522 25.429 14.6148C26.4502 13.4973 26.6322 12.0875 25.9319 10.7182C25.5558 9.98292 24.7489 9.30088 23.9831 9.07096C23.3682 8.88627 21.2348 8.79791 20.9014 8.94322ZM8.49618 15.2873C7.83359 15.4813 6.86362 16.1596 6.43354 16.7297C4.87798 18.792 5.63771 21.7714 7.99332 22.8464C8.6811 23.1602 8.85032 23.1859 10.5143 23.2285L12.2979 23.2742L12.6649 22.9073C12.9607 22.6114 13.0172 22.4785 12.9563 22.221C12.8059 21.5854 12.5436 21.4917 10.9148 21.4908C9.25075 21.4901 8.72352 21.3841 8.20168 20.945C6.96675 19.9059 7.17476 17.852 8.58407 17.1697C9.03759 16.9503 9.30349 16.9212 10.8612 16.9212C12.4679 16.9212 12.6523 16.8996 12.9335 16.6783C13.3205 16.3739 13.3569 15.7467 13.0079 15.3977C12.7913 15.1811 12.6252 15.1642 10.8107 15.1739C9.73099 15.1798 8.68954 15.2307 8.49618 15.2873ZM49.2192 18.8888C49.2192 20.6984 49.173 21.5023 49.0398 22.014C48.4799 24.1638 46.7168 25.9094 44.538 26.4714C43.3792 26.7702 39.9344 26.6803 38.983 26.3265C37.2347 25.6761 35.8825 24.341 35.1856 22.5767C34.8849 21.8156 34.871 21.6799 34.8293 19.1185L34.7858 16.4524H42.0025H49.2192V18.8888ZM37.5373 17.508C37.1702 17.6558 37.0316 17.9874 37.0316 18.7169C37.0316 19.4679 37.2568 19.8145 37.8149 19.9223C38.1158 19.9804 38.2461 19.9361 38.4887 19.6935C38.7457 19.4365 38.7894 19.2891 38.7894 18.679C38.7894 18.0774 38.7442 17.92 38.5017 17.6776C38.2009 17.3767 37.9657 17.3353 37.5373 17.508ZM45.629 17.5271C44.8432 17.9076 44.9829 19.7255 45.8118 19.9075C46.518 20.0627 46.8755 19.6309 46.8755 18.6228C46.8755 18.0809 46.8248 17.9146 46.5878 17.6776C46.2812 17.371 46.032 17.3318 45.629 17.5271ZM33.0472 19.1038V20.7005L32.6663 20.6258C32.083 20.5111 31.9925 20.2948 31.9925 19.0149C31.9925 17.9667 32.0141 17.8568 32.253 17.6896C32.3962 17.5893 32.6335 17.5071 32.7804 17.5071C33.045 17.5071 33.0472 17.5204 33.0472 19.1038ZM51.6541 17.6896C51.8949 17.8582 51.9146 17.9641 51.9146 19.0932C51.9146 20.2653 51.9028 20.3219 51.6225 20.5056C51.0565 20.8764 50.9771 20.7049 50.9771 19.1124C50.9771 17.4051 51.0448 17.2628 51.6541 17.6896ZM40.9415 17.7589C40.5443 17.9553 40.4301 18.3727 40.4301 19.6279C40.4301 21.447 40.7363 21.8431 42.1424 21.8431C43.159 21.8431 43.516 21.6298 43.516 21.0226C43.516 20.5417 43.0373 20.0853 42.5329 20.0853H42.1879V19.1608C42.1879 18.4507 42.1403 18.18 41.9828 17.9938C41.731 17.6963 41.2758 17.5935 40.9415 17.7589ZM14.7658 21.7259C14.4499 22.0417 14.4562 22.6762 14.778 22.9675C14.9868 23.1567 15.2687 23.1999 16.6237 23.2509C18.3856 23.3171 18.6642 23.4144 19.0871 24.1111C19.574 24.9136 19.4981 25.7845 18.8825 26.4572C18.3844 27.0015 17.9622 27.1166 16.4635 27.1166C15.1792 27.1166 15.0913 27.132 14.8191 27.4043C14.4478 27.7756 14.4525 28.2203 14.8319 28.5996C15.1314 28.899 15.138 28.9 16.7948 28.8519C18.3186 28.8079 18.5079 28.7776 19.0651 28.4893C19.8594 28.0784 20.4692 27.4463 20.8416 26.6478C21.7072 24.7928 20.7297 22.4547 18.7844 21.7269C18.269 21.5341 17.8706 21.4915 16.5777 21.4915C15.1564 21.4915 14.9769 21.5148 14.7658 21.7259ZM38.5551 22.7806C38.4127 22.923 38.3207 23.1712 38.3207 23.413C38.3207 23.9151 38.8594 24.417 39.9558 24.9365C40.6693 25.2747 40.8133 25.3002 42.0121 25.3002C43.209 25.3002 43.3557 25.2744 44.0629 24.9391C45.5361 24.2409 46.0728 23.4028 45.4324 22.801C45.0508 22.4426 44.621 22.4835 43.9753 22.9396C43.2752 23.4343 42.7824 23.6011 42.024 23.6002C41.197 23.5994 40.6861 23.4361 40.0121 22.9568C39.358 22.4918 38.8994 22.4363 38.5551 22.7806ZM38.9002 28.1296C39.4428 28.2805 39.7146 28.4455 40.1521 28.8897L40.7109 29.457L38.8889 31.3043C37.3298 32.8853 37.0263 33.2533 36.7856 33.8549L36.5043 34.5581L36.4716 43.8453L36.4389 53.1325H33.0438H29.6487V52.1966V51.2609L30.1712 51.1293C30.8174 50.9666 31.4697 50.3577 31.6348 49.763C31.702 49.5214 31.7571 48.6838 31.7574 47.9013L31.7581 46.4789L32.154 46.4046C32.969 46.2516 33.3968 45.5128 33.3981 44.2554C33.3986 43.7273 33.4306 43.6402 33.6235 43.6402C34.0046 43.6402 34.2207 43.5082 34.3967 43.1678C34.5976 42.7794 34.445 42.1832 34.0973 41.9971C33.9794 41.934 33.1541 41.8824 32.2633 41.8824H30.6437L30.3638 41.1499C30.2098 40.7472 29.8805 40.0655 29.632 39.6354L29.18 38.8532L29.1804 36.5885C29.1808 34.5807 29.2057 34.2828 29.4006 33.9633C29.5885 33.6553 30.0346 33.4258 32.4764 32.3813C36.6375 30.6013 37.1292 30.3391 37.5854 29.6564C37.8196 29.306 37.9926 28.8714 38.04 28.5138C38.0821 28.1965 38.1368 27.9369 38.1618 27.9369C38.1866 27.9369 38.519 28.0236 38.9002 28.1296ZM19.7814 33.8256L19.8166 34.4995H17.2912H14.7658V33.794V33.0885L17.256 33.1202L19.7463 33.1518L19.7814 33.8256ZM39.3649 36.2422C38.7859 36.7111 39.1579 37.7808 39.8999 37.7808C40.3478 37.7808 40.7816 37.3483 40.7816 36.9019C40.7816 36.1768 39.9334 35.7819 39.3649 36.2422ZM43.903 36.2659C43.4759 36.6017 43.4759 37.202 43.903 37.5378C44.5298 38.031 45.2817 37.6841 45.2817 36.9019C45.2817 36.1196 44.5298 35.7727 43.903 36.2659ZM22.9104 36.5286C24.6052 37.0101 26.2858 38.1015 27.3653 39.4214C27.8775 40.0477 28.7112 41.4919 28.7112 41.753C28.7112 41.8465 25.5243 41.8824 17.2252 41.8824H5.73908L5.92142 41.4429C6.64377 39.7018 8.15586 38.0967 9.90244 37.217C11.6706 36.3265 12.1191 36.273 17.5783 36.3033C21.5341 36.3251 22.3095 36.3579 22.9104 36.5286ZM39.3115 41.3497C38.9924 41.6687 38.9613 41.8513 39.1539 42.2741C39.2843 42.5602 39.7015 42.8199 40.0308 42.8199C40.339 42.8199 40.7816 42.2704 40.7816 41.8876C40.7816 41.1191 39.8741 40.787 39.3115 41.3497ZM43.8285 41.2964C43.4046 41.7204 43.5809 42.4971 44.1502 42.7136C44.552 42.8663 45.043 42.6668 45.2196 42.2791C45.4146 41.8512 45.3842 41.6696 45.0643 41.3497C44.7092 40.9945 44.1543 40.9706 43.8285 41.2964ZM31.6409 44.1675V44.6949H17.2853H2.92972V44.1675V43.6402H17.2853H31.6409V44.1675ZM57.7154 45.6324L57.3786 45.984H51.9085C46.5519 45.984 46.4319 45.9789 46.1295 45.741C45.9597 45.6076 45.8208 45.4494 45.8208 45.3895C45.8208 45.3241 48.2565 45.2808 51.9365 45.2808H58.0522L57.7154 45.6324ZM39.6409 46.1125C39.3566 46.2178 39.0238 46.6596 39.0238 46.9318C39.0238 47.0376 39.1331 47.2632 39.2667 47.433C39.7442 48.04 40.7816 47.7076 40.7816 46.9476C40.7816 46.3059 40.2232 45.8971 39.6409 46.1125ZM30.0003 47.8355C30.0003 48.7548 29.9532 49.2655 29.8597 49.359C29.7533 49.4654 27.9071 49.4996 22.2685 49.4996C13.9123 49.4996 14.297 49.4606 14.297 50.3085C14.297 50.6108 14.3756 50.8235 14.5436 50.9756C14.7773 51.1871 15.0685 51.2006 20.11 51.2316L25.4299 51.2644V52.1984V53.1325H17.2267H9.02352V52.206V51.2794L10.1833 51.2392C11.557 51.1915 11.8361 51.0343 11.8361 50.3085C11.8361 49.5169 11.7569 49.4996 8.12809 49.4996C6.3753 49.4996 4.8577 49.4676 4.75575 49.4285C4.60047 49.369 4.57036 49.1212 4.57036 47.905V46.4527H17.2853H30.0003V47.8355ZM57.6842 48.0968L57.3015 48.4449H51.9086C47.22 48.4449 46.4792 48.421 46.2367 48.2621C46.0831 48.1616 45.9284 48.0034 45.8928 47.9106C45.837 47.765 46.6685 47.7423 51.9475 47.7452L58.067 47.7487L57.6842 48.0968ZM57.6842 50.5577L57.3015 50.9059H51.9146H46.5276L46.1449 50.5577L45.7622 50.2097H51.9146H58.067L57.6842 50.5577ZM39.5302 51.1624C38.9666 51.4349 38.935 52.3652 39.4792 52.6566C40.3986 53.1485 41.2864 51.9059 40.4728 51.266C40.1338 50.9993 39.9169 50.9754 39.5302 51.1624ZM7.26569 52.195V53.1325H6.91413H6.56256V52.195V51.2575H6.91413H7.26569V52.195ZM27.8909 52.2027V53.1481L27.5686 53.1109C27.2514 53.0745 27.2458 53.0597 27.2121 52.1657L27.1779 51.2575H27.5344H27.8909V52.2027ZM57.8326 52.8981C57.626 53.1264 57.4716 53.1325 51.9146 53.1325C46.3575 53.1325 46.2031 53.1264 45.9965 52.8981C45.7847 52.664 45.7918 52.6637 51.9146 52.6637C58.0373 52.6637 58.0445 52.664 57.8326 52.8981Z" fill="#FFDE9F"></path>
									</g>
								</svg>
							</div>
							<h3 class="home2-ser-txt1">Catering</h3>
							<p class="home2-ser-txt2">Lacus, risus, diam sit gravida phasellus pretium sodales. Cursus rutrum lorem nulla eu amet mattis.</p>
						</div>
						<div class="home2-services-sec wow fadeInUp" data-wow-duration="1.4s">
							<div class="home2-ser-img">
								<svg width="60" height="60" viewbox="0 0 60 60" fill="none" xmlns="http://www.w3.org/2000/svg">
									<mask id="mask0_502_3442" style="mask-type:alpha" maskunits="userSpaceOnUse" x="0" y="0" width="60" height="60">
										<rect width="60" height="60" fill="white"></rect>
									</mask>
									<g mask="url(#mask0_502_3442)">
										<path fill-rule="evenodd" clip-rule="evenodd" d="M29.6248 3.23678C28.7537 3.6967 28.7799 3.49165 28.7129 10.3812C28.6393 17.9721 28.8406 17.1568 26.4249 19.65C25.0522 21.0668 24.6791 21.5282 24.3323 22.2378C23.9425 23.0353 23.5375 24.3821 23.3823 25.3969L23.3181 25.8167L22.6728 25.7633C21.689 25.6817 21.0261 25.9202 20.3161 26.6115C19.8361 27.079 19.6656 27.3485 19.5111 27.8849C19.1243 29.2269 19.5078 30.3909 20.7438 31.6269C21.1942 32.0774 21.5627 32.4667 21.5627 32.4922C21.5627 32.5179 21.3386 32.539 21.0645 32.5394C20.2864 32.5404 17.4011 32.9905 16.1699 33.3029C14.2243 33.7966 12.7188 34.3694 12.3783 34.7456C12.07 35.0863 12.1618 35.6796 12.5698 35.9829C12.8907 36.2214 12.9083 36.2221 13.4491 36.0185C17.2014 34.6058 20.7517 34.0699 25.3729 34.2189C35.4312 34.5431 40.8466 38.2716 42.3157 45.8843C42.4458 46.5587 42.5857 47.6566 42.6264 48.3242L42.7008 49.538H33.2676C23.9364 49.538 23.8316 49.5405 23.5779 49.777C23.233 50.0984 23.233 50.7361 23.5779 51.0575C23.8318 51.294 23.9337 51.2965 33.6954 51.2965H43.5565L43.8042 51.8827L44.0518 52.4689H24.0732H4.09459V52.0767C4.09459 51.2532 3.63209 51.2965 12.4347 51.2965C20.2344 51.2965 20.3498 51.2931 20.6027 51.0575C20.9476 50.7361 20.9476 50.0984 20.6027 49.777C20.3501 49.5417 20.2311 49.538 12.9645 49.538H5.58301L5.65734 48.3242C5.90447 44.2844 7.29747 40.9033 9.6831 38.5525C10.2703 37.9741 10.4253 37.7471 10.4253 37.4661C10.4253 36.9888 10.0593 36.642 9.55554 36.642C8.537 36.642 6.14305 39.7208 5.134 42.328C4.42566 44.1583 3.86012 47.0656 3.86012 48.8766C3.86012 49.608 3.85871 49.6111 3.35436 49.9666C2.75681 50.3877 2.43125 51.0049 2.35926 51.8534L2.30698 52.4689H1.84788C1.16088 52.4689 0.508347 52.853 0.213382 53.431C0.00610962 53.8375 -0.0274198 54.0647 0.0174815 54.7632C0.0816094 55.7637 0.372237 56.3157 1.08163 56.7851L1.5569 57.0997H30.0037H58.4505L58.9257 56.7851C59.6351 56.3157 59.9257 55.7637 59.9899 54.7632C60.0586 53.6924 59.78 53.0614 59.0812 52.7049C58.6746 52.4975 58.3914 52.4689 56.7446 52.4689H54.8705L55.1424 51.8534C55.5833 50.8555 55.7159 50.0346 55.6517 48.7003C55.5877 47.3672 55.4471 46.934 55.0151 46.7372C54.6172 46.556 54.4565 46.5732 54.1379 46.8313C53.8703 47.0481 53.8611 47.1114 53.8611 48.7364C53.8611 50.3203 53.8427 50.4565 53.5425 51.0972C53.3673 51.4712 53.1126 51.9337 52.9764 52.1249L52.7289 52.4725L49.4389 52.4413C45.7596 52.4066 46.013 52.4737 45.8877 51.5011C45.8384 51.1172 45.6864 50.774 45.3998 50.3984L44.9835 49.8531L45.0381 48.787C45.0841 47.8885 45.197 47.41 45.7561 45.7437C46.8856 42.3771 47.348 40.1427 47.3525 38.0292C47.3536 37.4702 47.3866 36.9295 47.4257 36.8275C47.4867 36.6685 47.7784 36.642 49.4636 36.642C51.749 36.642 51.5692 36.5173 51.5756 38.1075C51.5826 39.8407 52.2536 43.4371 52.6963 44.1139C53.043 44.6438 53.9036 44.5661 54.1703 43.9808C54.2742 43.7529 54.2385 43.4526 53.9926 42.4842C53.6065 40.9641 53.369 39.3005 53.3004 37.6381L53.2473 36.3479L53.8895 36.0644C55.1577 35.5047 56.1102 34.2372 56.3868 32.741C56.4531 32.3823 56.5186 31.4209 56.5325 30.6048C56.5571 29.1501 56.5518 29.1161 56.2645 28.8812C55.9907 28.6572 55.8592 28.6454 54.2715 28.7015C52.4512 28.766 51.4627 28.9863 50.7652 29.483L50.4027 29.7411V28.8035V27.866L51.0237 27.6855C52.2793 27.3205 53.5356 26.2702 54.1308 25.088C55.1392 23.0848 54.2871 20.1247 52.0205 17.7579C51.2779 16.9824 50.617 16.712 49.4648 16.712C48.3233 16.712 47.6889 16.9718 46.9259 17.7517C44.6593 20.069 43.7868 23.0779 44.7988 25.088C45.394 26.2702 46.6503 27.3205 47.9059 27.6855L48.5269 27.866V31.3748V34.8835H47.8897C47.1544 34.8835 46.7061 35.0278 46.3176 35.3896C45.7963 35.875 45.6981 36.2406 45.592 38.0912C45.47 40.2225 45.1665 41.8666 44.5248 43.874L44.0465 45.3698L43.7785 44.3178C43.4281 42.9425 43.0095 41.8535 42.3668 40.6455L41.8445 39.6637L41.842 33.9617C41.8384 25.7126 41.6965 24.2335 40.7177 22.2378C40.3706 21.53 39.9929 21.0633 38.6236 19.65C36.2079 17.1568 36.4092 17.9721 36.3356 10.3812C36.2684 3.46879 36.2974 3.68943 35.3988 3.23104C34.9788 3.01685 34.7155 2.99586 32.4996 3.00055C30.3067 3.00524 30.0185 3.02892 29.6248 3.23678ZM34.5759 6.45385V8.15376H32.5242H30.4726V6.45385V4.75393H32.5242H34.5759V6.45385ZM34.5759 12.9067C34.5759 17.652 34.8232 18.3845 37.2263 20.7566C38.8295 22.3391 39.1336 22.7677 39.575 24.0663C39.8396 24.8448 39.893 25.2366 39.9423 26.7649L40.0001 28.5528H39.6273C39.1667 28.5528 38.6791 29.0048 38.6791 29.432C38.6791 29.8513 39.1669 30.3113 39.6117 30.3113H39.9687V33.8311V37.3508L38.9871 36.5568C36.2336 34.3296 32.2737 32.9243 27.7994 32.5865C27.2063 32.5418 26.7211 32.4812 26.7211 32.4519C26.7211 32.4227 26.9871 32.1597 27.3121 31.8674C27.6372 31.5751 28.0617 31.1055 28.2556 30.8236L28.6081 30.3113H32.1834H35.7589L36.0466 30.0235C36.2049 29.8652 36.3344 29.5991 36.3344 29.432C36.3344 29.265 36.2049 28.9989 36.0466 28.8406L35.7589 28.5528H32.362H28.9652L28.7709 27.8787C28.6185 27.3498 28.4462 27.0777 27.9713 26.6159C27.2931 25.9565 26.7443 25.7391 25.758 25.7391H25.1153L25.2164 25.0944C25.3382 24.3174 25.7161 23.2714 26.1058 22.6324C26.2632 22.3745 27.0337 21.5304 27.8184 20.7566C30.2258 18.3825 30.4726 17.6526 30.4726 12.9067V9.9123H32.5242H34.5759V12.9067ZM50.3365 18.6263C50.5984 18.8179 50.4945 19.0499 49.884 19.6372L49.4634 20.0419L48.9365 19.5249C48.3636 18.9625 48.3003 18.7804 48.6148 18.5971C48.9127 18.4236 50.0865 18.4435 50.3365 18.6263ZM51.1523 24.4746C51.5962 25.2343 51.5323 25.4974 50.8181 25.8512C49.0649 26.7197 46.589 25.5921 46.1929 23.7448C46.0293 22.9822 46.1877 22.1721 46.7198 21.0497L47.1367 20.1704L48.983 22.0462C49.9985 23.0779 50.9747 24.1707 51.1523 24.4746ZM52.3441 21.3252C52.6624 22.0205 52.9189 23.2011 52.8121 23.4794C52.7615 23.6113 52.6476 23.5234 52.3799 23.1454C52.1799 22.8632 51.7211 22.3293 51.3603 21.9589L50.7043 21.2855L51.2191 20.7608C51.8107 20.1581 51.8095 20.1576 52.3441 21.3252ZM23.3494 27.9666C23.6631 28.268 23.9462 28.4355 24.1419 28.4355C24.3376 28.4355 24.6207 28.268 24.9344 27.9666C25.3337 27.5829 25.5057 27.4977 25.8801 27.4977C26.7421 27.4977 27.3302 28.3192 27.0903 29.1883C26.9126 29.8316 26.5595 30.2407 25.3051 31.2566L24.1419 32.1986L22.9787 31.2566C21.7243 30.2407 21.3711 29.8316 21.1935 29.1883C20.9536 28.3192 21.5417 27.4977 22.4036 27.4977C22.7781 27.4977 22.9501 27.5829 23.3494 27.9666ZM54.8007 30.9268C54.7718 31.2008 54.7191 31.7323 54.6837 32.1078C54.5701 33.3091 53.8786 34.2558 52.8748 34.5844C52.5791 34.6813 51.9019 34.7958 51.3699 34.8388L50.4027 34.9173V34.1053C50.4027 31.5792 51.5246 30.4733 54.1227 30.4384L54.8532 30.4285L54.8007 30.9268ZM58.2575 54.5991C58.2575 54.8036 58.1701 55.0674 58.0635 55.1853C57.8766 55.3919 56.8514 55.3998 30.0241 55.3998C4.27818 55.3998 2.16254 55.3851 1.9643 55.2057C1.83792 55.0914 1.74987 54.8506 1.74987 54.6195V54.2274H30.0037H58.2575V54.5991Z" fill="#FFDE9F"></path>
									</g>
								</svg>
							</div>
							<h3 class="home2-ser-txt1">Dinner</h3>
							<p class="home2-ser-txt2">Amet, ac enim sed morbi pretium. Scelerisque id in nisi ullamcorper. Bibendum sit viverra enim.</p>
						</div>
						<div class="home2-services-sec wow fadeInUp" data-wow-duration="1.6s">
							<div class="home2-ser-img">
								<svg width="60" height="60" viewbox="0 0 60 60" fill="none" xmlns="http://www.w3.org/2000/svg">
									<path fill-rule="evenodd" clip-rule="evenodd" d="M19.2827 0.672702L18.708 1.34528L20.0879 2.72915C20.8469 3.49016 21.5252 4.1129 21.5953 4.1129C21.7552 4.1129 22.8629 2.99758 22.8629 2.83657C22.8629 2.66867 20.1671 0 19.9974 0C19.9204 0 19.5988 0.302661 19.2827 0.672702ZM38.4674 1.39149L37.0799 2.78286L37.7735 3.47649L38.4671 4.17012L39.8585 2.78262C40.6239 2.01944 41.25 1.33766 41.25 1.26762C41.25 1.1077 40.1347 0 39.9737 0C39.9083 0 39.2306 0.626129 38.4674 1.39149ZM26.2103 3.67548C25.0787 3.99109 24.0802 5.01181 23.5343 6.41129C23.2537 7.13069 23.16 8.59827 23.3395 9.46198C23.6474 10.9431 24.0276 11.4659 26.905 14.3654C29.3573 16.8364 29.6107 17.0573 29.993 17.0569C30.3714 17.0565 30.6232 16.8445 32.7595 14.7278C34.0521 13.447 35.3447 12.0848 35.632 11.7006C38.0177 8.50935 36.3627 3.57024 32.9116 3.58186C31.9658 3.58512 31.2305 3.87617 30.4994 4.53677L30 4.98786L29.5006 4.53677C28.5658 3.69206 27.3203 3.36605 26.2103 3.67548ZM17.4194 6.41129V7.37903H19.3548H21.2903V6.41129V5.44355H19.3548H17.4194V6.41129ZM28.6667 6.46173C29.9274 7.68859 30.0525 7.68931 31.3246 6.47746C32.6286 5.23536 33.1529 5.15177 34.0071 6.04972C34.6071 6.68032 34.887 7.55347 34.8074 8.5454C34.7037 9.83685 34.3652 10.3413 32.0606 12.6398L30 14.6949L27.9394 12.6398C25.6348 10.3413 25.2963 9.83685 25.1926 8.5454C25.1175 7.60887 25.3593 6.78738 25.9054 6.12496C26.3672 5.56464 26.6533 5.43169 27.2592 5.49556C27.6451 5.53621 27.8845 5.70061 28.6667 6.46173ZM38.7097 6.41129V7.37903H40.6452H42.5806V6.41129V5.44355H40.6452H38.7097V6.41129ZM12.8776 22.1921C12.5829 22.4867 12.5806 22.5071 12.5806 24.8092C12.5806 26.2375 12.6353 27.3117 12.7229 27.604C12.8966 28.1838 13.6507 29.066 14.1491 29.2725L14.5161 29.4246V30.4985V31.5726H12.3937C9.50214 31.5726 9.67742 31.3852 9.67742 34.4758C9.67742 36.7665 9.67984 36.7876 9.9744 37.0821L10.2712 37.379L14.7829 37.3795L19.2944 37.3801L23.1653 39.5295L27.0363 41.6788L27.0676 47.8152C27.0939 52.9561 27.072 53.9516 26.9327 53.9516C26.5354 53.9516 25.035 54.8376 24.5604 55.3525C23.8681 56.1035 23.359 57.2309 23.2669 58.2167C23.1977 58.958 23.2136 59.0309 23.5062 59.3237L23.8196 59.6371H30H36.1804L36.4938 59.3237C36.7864 59.0309 36.8023 58.958 36.7331 58.2167C36.641 57.2309 36.1319 56.1035 35.4396 55.3525C34.965 54.8376 33.4646 53.9516 33.0673 53.9516C32.928 53.9516 32.9061 52.9561 32.9324 47.8152L32.9637 41.6788L36.8347 39.5295L40.7056 37.3801L45.2171 37.3795L49.7287 37.379L50.0256 37.0821C50.3202 36.7876 50.3226 36.7665 50.3226 34.4758C50.3226 31.3852 50.4979 31.5726 47.6063 31.5726H45.4839V30.492C45.4839 29.5062 45.5058 29.4045 45.7338 29.3321C46.1819 29.1899 46.8468 28.5027 47.135 27.8839C47.4004 27.314 47.4171 27.1367 47.4181 24.8837C47.4197 21.6749 47.6336 21.8952 44.5161 21.8952C41.4057 21.8952 41.6129 21.6872 41.6129 24.8092C41.6129 26.2375 41.6676 27.3117 41.7552 27.604C41.9289 28.1838 42.683 29.066 43.1814 29.2725L43.5484 29.4246V30.4985V31.5726H41.129H38.7097V29.9341C38.7097 28.3556 38.6988 28.2846 38.4127 27.9986C38.1656 27.7513 37.9979 27.7016 37.4127 27.7016H36.7095L36.4969 26.8915C35.9187 24.6866 34.2515 22.9661 31.9355 22.1839C31.0124 21.8722 28.9876 21.8722 28.0645 22.1839C25.7162 22.977 23.9624 24.828 23.4382 27.0665L23.2896 27.7016H22.5869C22.0021 27.7016 21.8343 27.7515 21.5873 27.9986C21.3012 28.2846 21.2903 28.3556 21.2903 29.9341V31.5726H18.871H16.4516V30.492C16.4516 29.5062 16.4735 29.4045 16.7015 29.3321C17.1496 29.1899 17.8146 28.5027 18.1027 27.8839C18.3681 27.314 18.3848 27.1367 18.3859 24.8837C18.3875 21.6749 18.6013 21.8952 15.4839 21.8952C13.1932 21.8952 13.1721 21.8976 12.8776 22.1921ZM16.4516 25.4692C16.4516 27.0477 16.4407 27.1187 16.1546 27.4046C15.9675 27.5919 15.7195 27.7016 15.4839 27.7016C15.2482 27.7016 15.0002 27.5919 14.8131 27.4046C14.527 27.1187 14.5161 27.0477 14.5161 25.4692V23.8306H15.4839H16.4516V25.4692ZM31.9874 24.2927C33.0486 24.7893 33.7799 25.4965 34.2931 26.5224C34.5266 26.9892 34.7177 27.4455 34.7177 27.5364C34.7177 27.6732 33.9067 27.7016 30 27.7016C26.0933 27.7016 25.2823 27.6732 25.2823 27.5364C25.2823 27.1489 26.168 25.6401 26.6637 25.1832C27.2462 24.6462 28.1711 24.1335 28.8806 23.9543C29.7334 23.7387 31.1283 23.8908 31.9874 24.2927ZM45.4839 25.4692C45.4839 27.0477 45.473 27.1187 45.1869 27.4046C44.9998 27.5919 44.7518 27.7016 44.5161 27.7016C44.2805 27.7016 44.0325 27.5919 43.8454 27.4046C43.5593 27.1187 43.5484 27.0477 43.5484 25.4692V23.8306H44.5161H45.4839V25.4692ZM0.296976 29.9341L0 30.2309V44.6371V59.0433L0.296976 59.3401C0.591411 59.6347 0.612581 59.6371 2.90323 59.6371C5.19387 59.6371 5.21504 59.6347 5.50948 59.3401L5.80645 59.0433V55.953V52.8629H7.74194H9.67742V55.953V59.0433L9.9744 59.3401C10.2688 59.6347 10.29 59.6371 12.5806 59.6371C14.8821 59.6371 14.8911 59.636 15.1921 59.335L15.4943 59.0329L15.4588 52.8935L15.4234 46.754L15.0394 45.9434C14.5508 44.9122 13.7572 44.1185 12.7259 43.6299L11.9153 43.246L8.86089 43.2065L5.80645 43.1671V36.6991V30.2309L5.50948 29.9341C5.21504 29.6395 5.19387 29.6371 2.90323 29.6371C0.612581 29.6371 0.591411 29.6395 0.296976 29.9341ZM36.7742 30.6048V31.5726H30H23.2258V30.6048V29.6371H30H36.7742V30.6048ZM54.4905 29.9341L54.1935 30.2309V36.6991V43.1671L51.1391 43.2065L48.0847 43.246L47.2741 43.6299C46.2428 44.1185 45.4492 44.9122 44.9606 45.9434L44.5766 46.754L44.5412 52.8935L44.5057 59.0329L44.8079 59.335C45.1089 59.636 45.1179 59.6371 47.4194 59.6371C49.71 59.6371 49.7312 59.6347 50.0256 59.3401L50.3226 59.0433V55.953V52.8629H52.2581H54.1935V55.953V59.0433L54.4905 59.3401C54.785 59.6347 54.8061 59.6371 57.0968 59.6371C59.3874 59.6371 59.4086 59.6347 59.703 59.3401L60 59.0433V44.6371V30.2309L59.703 29.9341C59.4086 29.6395 59.3874 29.6371 57.0968 29.6371C54.8061 29.6371 54.785 29.6395 54.4905 29.9341ZM3.87097 39.9853V48.3981L4.16794 48.695L4.4648 48.9919H9.00665H13.5484V53.3468V57.7016H12.5806H11.6129V54.6115V51.5213L11.3159 51.2244L11.0191 50.9274H7.74194H4.4648L4.16794 51.2244L3.87097 51.5213V54.6115V57.7016H2.90323H1.93548V44.6371V31.5726H2.90323H3.87097V39.9853ZM58.0645 44.6371V57.7016H57.0968H56.129V54.6115V51.5213L55.8321 51.2244L55.5352 50.9274H52.2581H48.9809L48.6841 51.2244L48.3871 51.5213V54.6115V57.7016H47.4194H46.4516V53.3468V48.9919H50.9933H55.5352L55.8321 48.695L56.129 48.3981V39.9853V31.5726H57.0968H58.0645V44.6371ZM14.0015 34.4333C14.9167 34.9423 15.6879 35.3777 15.7158 35.4011C15.7435 35.4244 14.8316 35.4435 13.6896 35.4435H11.6129V34.4758V33.5081H11.9753C12.2014 33.5081 12.964 33.8563 14.0015 34.4333ZM43.5313 33.5654C43.4999 33.597 40.4424 35.3072 36.7371 37.3661L30 41.1094L23.2629 37.3661C19.5576 35.3072 16.5001 33.597 16.4687 33.5654C16.4371 33.5338 22.5262 33.5081 30 33.5081C37.4737 33.5081 43.5629 33.5338 43.5313 33.5654ZM48.3871 34.4758V35.4435L46.3004 35.4414L44.2137 35.4392L45.5444 34.7003C46.2762 34.294 47.0383 33.8603 47.2379 33.7368C47.4375 33.6132 47.7777 33.5112 47.994 33.5101L48.3871 33.5081V34.4758ZM30 43.1855C30.1397 43.1855 30.4146 43.1024 30.6109 43.0009L30.9677 42.8164V48.9944V55.1723L31.2647 55.4692C31.4554 55.6599 31.6991 55.7661 31.9462 55.7661C32.7034 55.7661 33.3116 56.0453 33.9617 56.6917C35.0327 57.7563 35.2473 57.7016 30 57.7016C24.7527 57.7016 24.9673 57.7563 26.0383 56.6917C26.6884 56.0453 27.2966 55.7661 28.0537 55.7661C28.3009 55.7661 28.5446 55.6599 28.7353 55.4692L29.0323 55.1723V48.9944V42.8164L29.3891 43.0009C29.5854 43.1024 29.8603 43.1855 30 43.1855ZM11.8548 45.3731C12.5298 45.6791 12.8993 46.0169 13.1998 46.6028L13.4324 47.0565H9.61935H5.80645V46.0887V45.121L8.55847 45.1236C11.0666 45.1261 11.3587 45.1482 11.8548 45.3731ZM54.1935 46.0887V47.0565H50.3806H46.5676L46.8002 46.6028C47.1007 46.0169 47.4702 45.6791 48.1452 45.3731C48.6412 45.1482 48.9334 45.1261 51.4415 45.1236L54.1935 45.121V46.0887Z" fill="#FFDE9F"></path>
								</svg>
							</div>
							<h3 class="home2-ser-txt1">Wedding</h3>
							<p class="home2-ser-txt2">Nullam quis tristique scelerisque proin. Ultricies augue hac eu aliquet in. Urna mattis a gravida.</p>
						</div>
						<div class="home2-services-sec wow fadeInUp" data-wow-duration="1.8s">
							<div class="home2-ser-img">
								<svg width="60" height="60" viewbox="0 0 60 60" fill="none" xmlns="http://www.w3.org/2000/svg">
									<path fill-rule="evenodd" clip-rule="evenodd" d="M14.1044 0.101289C13.0232 0.385342 12.0737 1.16517 11.587 2.16832C11.3559 2.64498 11.3021 2.94052 11.299 3.75095C11.2955 4.66465 11.3283 4.80885 11.6935 5.48609C12.1371 6.30883 12.505 6.66404 13.3884 7.12312C13.899 7.38841 14.1338 7.43425 14.9836 7.43425C15.8334 7.43425 16.0682 7.38841 16.5788 7.12312C17.4622 6.66404 17.8301 6.30883 18.2737 5.48609C18.6384 4.80967 18.6718 4.66348 18.6695 3.75095C18.6672 2.90418 18.6201 2.66456 18.3558 2.15578C17.8989 1.27665 17.5409 0.903741 16.7482 0.481237C15.9925 0.0784293 14.828 -0.0889776 14.1044 0.101289ZM51.5768 0.183C51.425 0.292377 51.2264 0.559665 51.1356 0.776896C50.9025 1.33492 51.1097 1.75789 52.0616 2.66655C52.7163 3.29152 52.8921 3.39925 53.2573 3.39925C53.8143 3.39925 54.0935 3.24111 54.324 2.79539C54.6327 2.19845 54.4702 1.78907 53.5698 0.895652C52.9167 0.247595 52.682 0.0883939 52.3101 0.0416185C51.9931 0.00164249 51.7683 0.0450182 51.5768 0.183ZM58.1835 0.215004C57.99 0.333057 57.5548 0.732817 57.2163 1.10327C56.6769 1.69365 56.6009 1.83819 56.6009 2.27301C56.6009 2.95424 57.0523 3.39925 57.7436 3.39925C58.1707 3.39925 58.3144 3.31989 58.9456 2.7356C59.9652 1.79154 60.1706 1.32144 59.8605 0.641024C59.7039 0.297184 59.2134 -0.000702147 58.8048 1.24315e-06C58.6565 0.000235707 58.3769 0.0969519 58.1835 0.215004ZM40.8332 1.21804C40.3319 1.43515 40.1652 1.68345 40.0557 2.3757C39.882 3.47498 39.2876 3.95458 37.9073 4.10932C35.8483 4.34027 34.3648 5.83732 34.2352 7.81525C34.1839 8.59578 34.2013 8.67702 34.4778 8.95346C34.8909 9.3667 35.3194 9.45134 35.8111 9.21688C36.2283 9.01782 36.5539 8.46155 36.5547 7.94573C36.5553 7.58958 36.939 6.9767 37.3162 6.72957C37.4835 6.61996 38.0689 6.45841 38.6169 6.37072C39.8821 6.16815 40.5825 5.81106 41.3395 4.98282C42.1843 4.05845 42.6152 2.64956 42.3039 1.83034C42.095 1.28099 41.3775 0.982286 40.8332 1.21804ZM15.9692 2.80665C16.277 3.11461 16.3318 3.25705 16.3318 3.75095C16.3318 4.25153 16.2784 4.38599 15.9485 4.71588C15.6186 5.04577 15.4842 5.09911 14.9836 5.09911C14.483 5.09911 14.3486 5.04577 14.0187 4.71588C13.6901 4.38728 13.6354 4.25059 13.6354 3.7581C13.6354 3.15553 13.9343 2.67921 14.4561 2.45003C14.8944 2.25753 15.5821 2.41955 15.9692 2.80665ZM25.5473 4.85246C25.222 5.03264 24.9584 5.4603 24.9524 5.81716C24.9502 5.9542 25.1322 6.46978 25.357 6.96298C27.3692 11.3787 27.1474 16.1182 24.7377 20.1923L24.2006 21.1005L21.5417 18.4642C19.7066 16.6449 18.7235 15.7557 18.3692 15.595C17.1762 15.0537 15.5436 15.4615 14.8432 16.4756C14.4491 17.0462 0.112283 56.0975 0.0181463 56.8569C-0.115849 57.937 0.503368 59.1069 1.50746 59.6705C1.93254 59.909 2.18189 59.9619 2.85011 59.9549C3.60016 59.9469 3.99828 59.8245 7.48077 58.531C10.8233 57.2894 20.938 53.5781 37.961 47.3472C40.7796 46.3156 43.2681 45.3366 43.5245 45.1586C44.5396 44.454 44.9463 42.8236 44.4047 41.6298C44.2423 41.2719 43.3292 40.2666 41.405 38.3271L38.6388 35.539L39.3488 35.0164C40.3527 34.2774 42.1873 33.3625 43.6069 32.893C45.2458 32.3509 46.7226 32.1209 48.5618 32.1215C51.0731 32.1223 52.8914 32.516 55.4073 33.6038C56.5096 34.0803 56.6528 34.115 57.0189 33.9941C57.5226 33.8279 57.7732 33.4783 57.7732 32.9416C57.7732 32.3659 57.5197 32.0568 56.7141 31.6501C53.9534 30.2565 51.2763 29.7001 47.8671 29.8113C45.805 29.8785 44.4411 30.1138 42.6503 30.7111C41.4091 31.125 38.9101 32.4179 37.9024 33.1673L36.9645 33.8647L36.028 32.9347L35.0914 32.0046L36.5685 30.5094C37.3811 29.6872 38.1322 28.8839 38.2378 28.7245C38.5233 28.2939 38.4794 27.743 38.1264 27.3235C37.8689 27.0173 37.7417 26.9628 37.2856 26.9628C36.7513 26.9628 36.7388 26.9723 35.0661 28.6307L33.3839 30.2984L29.625 26.5395L25.8662 22.7807L26.4159 21.9308C27.4697 20.3018 28.3318 18.1961 28.7734 16.1728C29.1119 14.6222 29.084 11.251 28.7194 9.62203C28.221 7.39603 27.2274 5.09126 26.6532 4.82971C26.2575 4.64941 25.9003 4.6568 25.5473 4.85246ZM52.5527 5.83345C51.9061 6.30367 51.0939 7.24773 51.0775 7.5482C51.0531 7.99403 51.1075 8.26038 51.277 8.52497C51.4609 8.81219 52.0525 9.01172 52.4786 8.93024C52.8194 8.86518 54.0899 7.70295 54.332 7.23472C54.695 6.53274 54.2361 5.68386 53.4231 5.55362C53.1071 5.50309 52.9281 5.56065 52.5527 5.83345ZM57.1606 5.68633C56.7544 5.91422 56.6009 6.2039 56.6009 6.74282C56.6009 7.10799 56.7086 7.28384 57.3336 7.93846C58.2454 8.89367 58.6647 9.09789 59.2294 8.8619C59.7866 8.62908 60.0485 8.19508 59.9602 7.65101C59.9063 7.31901 59.7036 7.03156 59.091 6.41902C58.2062 5.53416 57.7444 5.3589 57.1606 5.68633ZM50.6037 12.1206C48.9035 12.7278 47.8982 14.0119 47.6894 15.8427C47.5214 17.3154 47.0714 17.8584 45.8548 18.0564C45.13 18.1743 44.9424 18.2915 44.6867 18.7859C44.449 19.2456 44.5745 19.733 45.0291 20.1156C45.3652 20.3984 45.4635 20.4206 46.1405 20.3662C47.5738 20.2512 48.9314 19.3074 49.5745 17.9791C49.7135 17.6919 49.8974 16.9872 49.9831 16.4135C50.0689 15.8396 50.2267 15.2363 50.334 15.0725C50.6083 14.654 51.1719 14.3429 51.8259 14.2495C52.6493 14.1317 53.0253 13.7623 53.0253 13.0709C53.0253 12.616 52.9695 12.475 52.6963 12.24C52.4297 12.0107 52.2411 11.9581 51.6999 11.9623C51.3327 11.9651 50.8395 12.0363 50.6037 12.1206ZM35.7336 12.6008C34.8437 12.8915 34.0866 13.5622 33.6234 14.4703C33.2599 15.183 33.2134 15.3761 33.2156 16.1657C33.2185 17.2665 33.5164 17.9897 34.2922 18.7795C35.0375 19.5382 35.7968 19.8528 36.9059 19.8626C37.9601 19.8717 38.8417 19.5172 39.5659 18.7929C40.319 18.0399 40.5926 17.3441 40.5947 16.1775C40.5967 15.0237 40.3691 14.3978 39.6636 13.6168C38.7665 12.6239 37.0338 12.1759 35.7336 12.6008ZM37.6132 14.9486C38.3913 15.3509 38.5248 16.4884 37.8709 17.1424C37.1856 17.8275 36.0864 17.6172 35.658 16.7189C35.0946 15.5374 36.424 14.3336 37.6132 14.9486ZM29.8425 30.1572C38.9207 39.2351 42.2986 42.6837 42.2986 42.8741C42.2986 43.0183 42.1803 43.209 42.0348 43.2995C41.8897 43.3898 40.1999 44.0343 38.2795 44.7319L34.788 46.0001L31.2998 42.5189C27.8473 39.0734 27.8064 39.0377 27.3242 39.0377C26.595 39.0377 26.1792 39.4382 26.1792 40.1404V40.6773L29.2793 43.779C32.2215 46.7228 32.3647 46.8862 32.0929 46.9893C31.9353 47.049 31.1831 47.3251 30.4215 47.603L29.0366 48.1081L20.4643 39.5358L11.892 30.9635L12.3971 29.5786C12.675 28.817 12.9511 28.0648 13.0108 27.9072C13.1139 27.6354 13.2773 27.7786 16.2211 30.7208L19.3228 33.8209H19.8597C20.5619 33.8209 20.9624 33.4051 20.9624 32.6759C20.9624 32.1937 20.9265 32.1528 17.4817 28.7009L14.0011 25.213L15.2694 21.721C15.9671 19.8004 16.6114 18.1104 16.7013 17.9653C16.7914 17.8197 16.9816 17.7015 17.1255 17.7015C17.3154 17.7015 20.7764 21.0913 29.8425 30.1572ZM54.853 19.1993C54.1146 19.488 53.269 20.2949 52.8846 21.0774C52.6074 21.642 52.5566 21.8919 52.5581 22.6839C52.5601 23.7819 52.8016 24.4217 53.5103 25.2078C54.923 26.7744 57.5753 26.7744 58.988 25.2078C59.698 24.4203 59.9384 23.7819 59.9384 22.6839C59.9384 21.5745 59.6903 20.9263 58.9638 20.1382C58.2356 19.3483 57.5582 19.0579 56.3664 19.0248C55.6472 19.0048 55.2261 19.0533 54.853 19.1993ZM57.0443 21.5187C57.3736 21.7493 57.6559 22.2872 57.6559 22.6839C57.6559 23.0806 57.3736 23.6184 57.0443 23.849C56.9005 23.9499 56.5433 24.032 56.2492 24.032C55.6433 24.032 55.2721 23.8197 55.0175 23.3274C54.6957 22.705 54.886 21.9165 55.454 21.5187C55.5978 21.4179 55.955 21.3357 56.2492 21.3357C56.5433 21.3357 56.9005 21.4179 57.0443 21.5187ZM40.4076 23.2957C39.531 24.1156 39.3273 24.6129 39.6122 25.2381C39.7668 25.5774 40.2971 25.9077 40.6871 25.9077C41.381 25.9077 42.6503 24.564 42.6503 23.8296C42.6503 23.2353 42.1205 22.7425 41.4819 22.7425C41.068 22.7425 40.9145 22.8215 40.4076 23.2957ZM26.4988 49.012C26.4256 49.0761 24.8416 49.6639 19.7217 51.5272L18.6571 51.9148L13.3688 46.6192L8.08076 41.3237L9.48097 37.5137C10.2512 35.4182 10.9099 33.6271 10.9448 33.5335C10.9874 33.4196 13.5848 35.9395 18.7962 41.1504C23.0795 45.4334 26.5457 48.9711 26.4988 49.012ZM22.9355 35.4656C22.3344 35.792 22.2378 36.777 22.7602 37.2546C23.5635 37.9893 24.7138 37.4498 24.7138 36.3382C24.7138 35.5241 23.723 35.038 22.9355 35.4656ZM51.6771 40.9454C51.3071 41.1293 50.97 41.8136 51.0508 42.2164C51.0853 42.3886 51.4866 42.895 51.9661 43.3712C52.7129 44.1129 52.8736 44.2193 53.2477 44.2193C53.7826 44.2193 54.1765 43.968 54.3688 43.5039C54.5875 42.9757 54.4388 42.6056 53.6934 41.8242C52.7384 40.8229 52.3041 40.6336 51.6771 40.9454ZM58.0475 41.1324C57.7922 41.3174 57.3626 41.7263 57.0929 42.0409C56.4799 42.7562 56.4143 43.3912 56.903 43.8798C57.4912 44.4681 58.1425 44.3414 59.0375 43.4644C60.1231 42.4007 60.2595 41.8523 59.602 41.1948C59.1005 40.6932 58.6773 40.6762 58.0475 41.1324ZM11.7552 48.2944C14.2021 50.742 16.1781 52.7707 16.1461 52.8027C16.1142 52.8346 15.378 53.1225 14.5101 53.4423L12.932 54.0239L9.45565 50.5581L5.97938 47.0921L6.39121 45.9664C6.61771 45.3472 6.88136 44.6164 6.97702 44.3424C7.0728 44.0685 7.18593 43.8442 7.2286 43.8442C7.27115 43.8442 9.30817 45.8467 11.7552 48.2944ZM52.7599 46.4953C52.2571 46.7493 51.1373 47.9652 51.0668 48.3336C50.9015 49.1989 51.7287 49.9789 52.5309 49.7142C52.9311 49.5821 54.123 48.4485 54.3709 47.9643C54.5596 47.5953 54.433 46.989 54.1023 46.6783C53.7325 46.331 53.2226 46.2615 52.7599 46.4953ZM57.2256 46.477C56.7749 46.673 56.6009 46.9703 56.6009 47.544C56.6009 47.9242 56.7068 48.0853 57.472 48.8679C58.2817 49.6963 58.3775 49.7591 58.8321 49.7591C59.2394 49.7591 59.3802 49.693 59.6741 49.364C59.9775 49.0245 60.0182 48.9033 59.964 48.4999C59.9141 48.1275 59.7602 47.8873 59.2182 47.3354C58.5437 46.6486 58.0466 46.3017 57.7497 46.3106C57.6659 46.3132 57.43 46.388 57.2256 46.477ZM7.82812 52.2218C9.27535 53.6702 10.4339 54.8806 10.4029 54.9118C10.3717 54.9429 8.67219 55.5813 6.62626 56.3304C4.30168 57.1815 2.82104 57.6655 2.67895 57.6204C2.55399 57.5808 2.41952 57.4468 2.38025 57.3228C2.3105 57.1031 4.98056 49.5885 5.12828 49.5885C5.16591 49.5885 6.38078 50.7735 7.82812 52.2218Z" fill="#FFDE9F"></path>
								</svg>
							</div>
							<h3 class="home2-ser-txt1">Birthday</h3>
							<p class="home2-ser-txt2">Lacus, risus, diam sit gravida phasellus pretium sodales. Cursus rutrum lorem nulla eu amet mattis.</p>
						</div>
					</div>
				</div>
			</div>	
		</section> 
		<!-- Mobile App Section End -->
		<!-- Gallery Section Start -->
		<section id="homepage1-gallery-sec">
			<div class="container line index-gallery-top">
				<span class="line-3"></span>
				<span class="line-4"></span>
				<span class="line-5"> </span>
				<div class="gallery-top-sec">
					<p class="gallery-txt1"><span class="pr-10"><img src="assets/images/Homepage1/yellow-star.png" alt="yellow-star"></span>OUR GALLERY<span class="pf-10"><img src="assets/images/Homepage1/yellow-star.png" alt="yellow-star"></span></p>
					<h2 class="gallery-txt">Bermiz Hot Dishes</h2>
				</div>
			</div>

			<div class="gallery-food-slider" id="gallery">
				<div class="swiper-wrapper gallery-item-sec">
					<div class="swiper-slide gallery-slide">
						<div class="gallery-item">
							<a class="gallery-popup" href="assets/images/Homepage1/gallery-1.png" data-caption="Kebab" data-width="600" data-height="800">
								<img src="assets/images/Homepage1/gallery-1.png" class="img-fluid" alt="gallery item">
								<div class="content-overlay-home2"></div>
							</a>		
						</div>
						<div class="home2-gallery-overlay fadeIn-bottom fadeIn-right">
							<a class="gallery-popup" href="assets/images/Homepage1/gallery-1.png" data-caption="Kebab" data-width="600" data-height="800">
								<p class="gallery-overlay-txt1">Kebab</p>
								<div class="home2-search-icon">
									<svg width="40" height="40" viewbox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
										<mask style="mask-type:alpha" maskunits="userSpaceOnUse" x="0" y="0" width="40" height="40">
											<rect width="40" height="40" fill="white"></rect>
										</mask>
										<g mask="url(#mask0_540_5055)">
											<circle cx="19.6111" cy="19.6108" r="14.9809" stroke="#0B1315" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></circle>
											<path d="M30.0305 30.8086L35.9039 36.6667" stroke="#0B1315" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
										</g>
									</svg>
								</div>
							</a>
						</div>
					</div>
					<div class="swiper-slide gallery-slide">
						<div class="gallery-item">
							<a class="gallery-popup" href="assets/images/Homepage1/gallery-2.png" data-caption="Finger Roll" data-width="600" data-height="800">
								<img src="assets/images/Homepage1/gallery-2.png" class="img-fluid" alt="gallery item">
								<div class="content-overlay-home2"></div>
							</a>		
						</div>
						<div class="home2-gallery-overlay fadeIn-bottom fadeIn-right">
							<a class="gallery-popup" href="assets/images/Homepage1/gallery-2.png" data-caption="Finger Roll" data-width="600" data-height="800">
								<p class="gallery-overlay-txt1">Finger Roll</p>
								<div class="home2-search-icon">
									<svg width="40" height="40" viewbox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
										<mask style="mask-type:alpha" maskunits="userSpaceOnUse" x="0" y="0" width="40" height="40">
											<rect width="40" height="40" fill="white"></rect>
										</mask>
										<g mask="url(#mask0_540_5055)">
											<circle cx="19.6111" cy="19.6108" r="14.9809" stroke="#0B1315" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></circle>
											<path d="M30.0305 30.8086L35.9039 36.6667" stroke="#0B1315" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
										</g>
									</svg>
								</div>
							</a>
						</div>	
					</div>
					<div class="swiper-slide gallery-slide">
						<div class="gallery-item">
							<a class="gallery-popup" href="assets/images/Homepage1/gallery-3.png" data-caption="Chicken" data-width="600" data-height="800">
								<img src="assets/images/Homepage1/gallery-3.png" class="img-fluid" alt="gallery item">
								<div class="content-overlay-home2"></div>
							</a>		
						</div>
						<div class="home2-gallery-overlay fadeIn-bottom fadeIn-right">
							<a class="gallery-popup" href="assets/images/Homepage1/gallery-3.png" data-caption="Chicken" data-width="600" data-height="800">
								<p class="gallery-overlay-txt1">Chicken</p>
								<div class="home2-search-icon">
									<svg width="40" height="40" viewbox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
										<mask style="mask-type:alpha" maskunits="userSpaceOnUse" x="0" y="0" width="40" height="40">
											<rect width="40" height="40" fill="white"></rect>
										</mask>
										<g mask="url(#mask0_540_5055)">
											<circle cx="19.6111" cy="19.6108" r="14.9809" stroke="#0B1315" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></circle>
											<path d="M30.0305 30.8086L35.9039 36.6667" stroke="#0B1315" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
										</g>
									</svg>
								</div>
							</a>
						</div>	
					</div>
					<div class="swiper-slide gallery-slide">
						<div class="gallery-item">
							<a class="gallery-popup" href="assets/images/Homepage1/gallery-4.png" data-caption="Pasta" data-width="600" data-height="800">
								<img src="assets/images/Homepage1/gallery-4.png" class="img-fluid" alt="gallery item">
								<div class="content-overlay-home2"></div>
							</a>		
						</div>
						<div class="home2-gallery-overlay fadeIn-bottom fadeIn-right">
							<a class="gallery-popup" href="assets/images/Homepage1/gallery-4.png" data-caption="Pasta" data-width="600" data-height="800">
								<p class="gallery-overlay-txt1">Pasta</p>
								<div class="home2-search-icon">
									<svg width="40" height="40" viewbox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
										<mask style="mask-type:alpha" maskunits="userSpaceOnUse" x="0" y="0" width="40" height="40">
											<rect width="40" height="40" fill="white"></rect>
										</mask>
										<g mask="url(#mask0_540_5055)">
											<circle cx="19.6111" cy="19.6108" r="14.9809" stroke="#0B1315" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></circle>
											<path d="M30.0305 30.8086L35.9039 36.6667" stroke="#0B1315" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
										</g>
									</svg>
								</div>
							</a>
						</div>
					</div>
					<div class="swiper-slide gallery-slide">
						<div class="gallery-item">
							<a class="gallery-popup" href="assets/images/Homepage1/gallery-5.png" data-caption="Roll" data-width="600" data-height="800">
								<img src="assets/images/Homepage1/gallery-5.png" class="img-fluid" alt="gallery item">
								<div class="content-overlay-home2"></div>
							</a>		
						</div>
						<div class="home2-gallery-overlay fadeIn-bottom fadeIn-right">
							<a class="gallery-popup" href="assets/images/Homepage1/gallery-5.png" data-caption="Roll" data-width="600" data-height="800">
								<p class="gallery-overlay-txt1">Roll</p>
								<div class="home2-search-icon">
									<svg width="40" height="40" viewbox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
										<mask style="mask-type:alpha" maskunits="userSpaceOnUse" x="0" y="0" width="40" height="40">
											<rect width="40" height="40" fill="white"></rect>
										</mask>
										<g mask="url(#mask0_540_5055)">
											<circle cx="19.6111" cy="19.6108" r="14.9809" stroke="#0B1315" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></circle>
											<path d="M30.0305 30.8086L35.9039 36.6667" stroke="#0B1315" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
										</g>
									</svg>
								</div>
							</a>
						</div>
					</div>
					<div class="swiper-slide gallery-slide">
						<div class="gallery-item">
							<a class="gallery-popup" href="assets/images/Homepage1/gallery-1.png" data-caption="Kebab" data-width="600" data-height="800">
								<img src="assets/images/Homepage1/gallery-1.png" class="img-fluid" alt="gallery item">
								<div class="content-overlay-home2"></div>
							</a>		
						</div>
						<div class="home2-gallery-overlay fadeIn-bottom fadeIn-right">
							<a class="gallery-popup" href="assets/images/Homepage1/gallery-1.png" data-caption="Kebab" data-width="600" data-height="800">
								<p class="gallery-overlay-txt1">Kebab</p>
								<div class="home2-search-icon">
									<svg width="40" height="40" viewbox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
										<mask style="mask-type:alpha" maskunits="userSpaceOnUse" x="0" y="0" width="40" height="40">
											<rect width="40" height="40" fill="white"></rect>
										</mask>
										<g mask="url(#mask0_540_5055)">
											<circle cx="19.6111" cy="19.6108" r="14.9809" stroke="#0B1315" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></circle>
											<path d="M30.0305 30.8086L35.9039 36.6667" stroke="#0B1315" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
										</g>
									</svg>
								</div>
							</a>
						</div>
					</div>
				</div>
			</div>
			<div class="pswp" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="pswp__bg"></div>
				<div class="pswp__scroll-wrap">
					<div class="pswp__container">
						<div class="pswp__item"></div>
						<div class="pswp__item"></div>
						<div class="pswp__item"></div>
					</div>
					<div class="pswp__ui pswp__ui--hidden">
						<div class="pswp__top-bar">
							<!--  Controls are self-explanatory. Order can be changed. -->
							<div class="pswp__counter"></div>
							<button class="pswp__button pswp__button--close" title="Close (Esc)"></button>
							<button class="pswp__button pswp__button--share" title="Share"></button>
							<button class="pswp__button pswp__button--fs" title="Toggle fullscreen"></button>
							<button class="pswp__button pswp__button--zoom" title="Zoom in/out"></button>
							<div class="pswp__preloader">
								<div class="pswp__preloader__icn">
									<div class="pswp__preloader__cut">
										<div class="pswp__preloader__donut"></div>
									</div>
								</div>
							</div>
						</div>
						<div class="pswp__share-modal pswp__share-modal--hidden pswp__single-tap">
							<div class="pswp__share-tooltip"></div>
						</div>
						<button class="pswp__button pswp__button--arrow--left" title="Previous (arrow left)">
						</button>
						<button class="pswp__button pswp__button--arrow--right" title="Next (arrow right)">
						</button>
						<div class="pswp__caption">
							<div class="pswp__caption__center"></div>
						</div>
					</div>
				</div>
			</div>
		</section>
		<!-- Gallery Section End -->
		<!-- Testimonial Section Start -->
		<section id="homepage1-testimonial-sec" class="reveal">
			<div class="container line ptb-100">
				<span class="line-3"></span>
				<span class="line-4"></span>
				<span class="line-5"> </span>
				<div class="tesimonila-deatils">
					<div class="tesimonila-left pbmit-animation-style1 reveal">
						<img src="assets/images/Homepage1/testimonial-1.png" alt="client-img" class="img-fluid">
					</div>
					<div class="tesimonila-right">
						<div class="tesimonila-right-top">
							<p class="tesimonial-txt1 wow fadeInUp" data-wow-duration="1s"><span class="pr-10"><img src="assets/images/Homepage1/yellow-star.png" alt="yellow-star"></span>TESTIMONIALS<span class="pf-10"><img src="assets/images/Homepage1/yellow-star.png" alt="yellow-star"></span></p>
							<h2 class="tesimonial-txt2 wow fadeInUp " data-wow-duration="1.4s">What Clients Said</h2>
						</div>
						<div class="tesimonial-slider-section wow fadeInUp " data-wow-duration="1.6s">
							<div class="tesimonila-slide">
								<h3 class="d-none">Client Name</h3>
								<p class="tesimonial-txt3">“ This bermiz restaurant has left the best 
									impressions! Hospitable hosts, delicious 
									dishes, beautiful presentation, wide wine
									list and wonderful dessert. I recommend 
									to everyone! I would like to come back 
									here again and again.”
								</p>
								<h4 class="tesimonial-txt4">PAUL SERGEO</h4>
							</div>
							<div class="tesimonila-slide">
								<p class="tesimonial-txt3">“ This bermiz restaurant has left the best 
									impressions! Hospitable hosts, delicious 
									dishes, beautiful presentation, wide wine
									list and wonderful dessert. I recommend 
									to everyone! I would like to come back 
									here again and again.”
								</p>
								<h4 class="tesimonial-txt4">PAUL SERGEO</h4>
							</div>
							<div class="tesimonila-slide">
								<p class="tesimonial-txt3">“ This bermiz restaurant has left the best 
									impressions! Hospitable hosts, delicious 
									dishes, beautiful presentation, wide wine
									list and wonderful dessert. I recommend 
									to everyone! I would like to come back 
									here again and again.”
								</p>
								<h4 class="tesimonial-txt4">PAUL SERGEO</h4>
							</div>
							<div class="tesimonila-slide">
								<p class="tesimonial-txt3">“ This bermiz restaurant has left the best 
									impressions! Hospitable hosts, delicious 
									dishes, beautiful presentation, wide wine
									list and wonderful dessert. I recommend 
									to everyone! I would like to come back 
									here again and again.”
								</p>
								<h4 class="tesimonial-txt4">PAUL SERGEO</h4>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
		<!-- Testimonial Section End -->
		<!-- Visit Section Start -->
		<section id="visit-restaurant-sec" class="reveal">
			<div class="container line visit-restaurant-sec1">
				<span class="line-3"></span>
				<span class="line-4"></span>
				<span class="line-5"> </span>
				<div class="visit-restaurant-full">
					<div class="visit-restaurant-left" data-aos="fade-right">
						<div class="gallery-top-sec">
							<p class="visit-txt1"><span class="pr-10"><img src="assets/images/Homepage1/yellow-star.png" alt="yellow-star"></span>RIGHT HERE WAITING<span class="pf-10"><img src="assets/images/Homepage1/yellow-star.png" alt="yellow-star"></span></p>
							<h2 class="visit-txt2">Visit Our Restaurant</h2>
							<p class="visit-txt3">We see our customers as invited guests to a party, and we are the hosts. Piazza della Signoria - 1050122, USA.</p>
							<div class="homepage-calling">
								<p class="visit-no-txt">M:<a href="mailto:booking@bermiz.com" class="Visit-no">booking@bermiz.com</a></p>
								<p class="visit-no-txt">T:<a href="tel:1300748133" class="Visit-no">+1(234)567 8899</a></p>
							</div>
							<div class="direction-btn">
								<a href="contact-us.php">Get Directions</a>
							</div>
						</div>
					</div>
					<div class="visit-restaurant-right" data-aos="fade-left">
						<div class="visit-restaurant-right-full">
							<div class="visit-restaurant-right-img1 pbmit-animation-style1 reveal">
								<img src="assets/images/Homepage1/visit-1.png" alt="food-img">
							</div>
							<div class="visit-restaurant-right-img2 pbmit-animation-style1 reveal">
								<img src="assets/images/Homepage1/visit-2.png" alt="food-img">
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>	
		<!-- Visit Section End -->
		<!-- Footer Section Start -->
<footer class="restaurant-footer">
    <div class="footer-container">

        <!-- Left Top Logo + Text -->
        <div class="footer-brand">
            <img src="assets/images/Homepage1/footer-logo.png" alt="Restaurant Logo" class="footer-logo">
            <p class="footer-desc">
                A premium dining experience with handcrafted dishes, fresh ingredients, 
                and an elegant ambiance. Your comfort is our priority.
            </p>
        </div>

        <!-- Quick Links -->
        <div class="footer-links">
            <h4>Quick Links</h4>
            <ul>
                <li><a href="reservation-1.php">Reserve a Table</a></li>
                
                <li><a href="#menupage-veg.php">Explore Menu</a></li>
                <li><a href="#weekly.php">Special Offers</a></li>
                <li><a href="#catering-events.php">Catering Service</a></li>
            </ul>
        </div>

        <!-- Contact Section -->
        <div class="footer-contact">
            <h4>Contact Us</h4>
            <p> 123 Food Street, Chennai</p>
            <p> +91 98765 43210</p>
            <p>✉ support@restaurant.com</p>

            <div class="footer-social">
                <a href="#"><i class="fa fa-facebook"></i></a>
                <a href="#"><i class="fa fa-instagram"></i></a>
                <a href="#"><i class="fa fa-twitter"></i></a>
                <a href="#"><i class="fa fa-youtube"></i></a>
            </div>
        </div>

        <!-- Working Hours -->
        <div class="footer-hours">
            <h4>Working Hours</h4>
            <p>Mon – Fri : 09:00 - 22:00</p>
            <p>Saturday : 11:00 - 23:30</p>
            <p>Sunday : 11:00 - 23:00</p>
        </div>

    </div>

    <div class="footer-bottom">
        <p>© 2025 Your Restaurant Name. All Rights Reserved.</p>
        <div class="footer-bottom-links">
            <a href="#">Privacy Policy</a>
            <a href="#">Terms of Service</a>
        </div>
    </div>
</footer>
			<!-- Footer Section End -->
			<!-- Fixed Search Bar Start -->
			<div>
				<div class="fixed-serach-icon ">
					<div class="fixed-search ">
						<a href="javascript:void(0)">
							<svg width="24" height="24" viewbox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
								<mask id="mask0_504_17203" style="mask-type:alpha" maskunits="userSpaceOnUse" x="0" y="0" width="24" height="24">
									<rect width="24" height="24" fill="white"></rect>
								</mask>
								<g mask="url(#mask0_504_17203)">
									<circle cx="11.7666" cy="11.7666" r="8.98856" stroke="#0B1315" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></circle>
									<path d="M18.0183 18.4851L21.5423 22" stroke="#0B1315" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
								</g>
							</svg>
						</a>
					</div>
				</div> 
				<div class="search-popup">
					<span class="search-back-drop"></span>
					<button class="close-search"><span class="fa fa-times"></span></button>
					<div class="search-inner">
						<form method="post" action="index.php">
							<div class="form-group">
								<input type="search" name="search-field" value="" placeholder="Search...">
								<button type="submit"><i class="fa fa-search"></i></button>
							</div>
						</form>
					</div>
				</div>
			</div>
			<!-- Fixed Search Bar End -->
			<!-- Hero Video Modal Start -->
			<div class="modal fade homepage-video-modal" id="hero-video-modal">
				<div class="modal-dialog modal-dialog-centered">
					<div class="modal-content">
						<div class="modal-header">
							<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
						</div>
						<div class="modal-body">
							<video class="video-sec" controls="" loop="" muted="" autoplay="">
								<source src="assets/images/Homepage1/video.mp4" type="video/mp4">
								</video>
							</div>
						</div>
					</div>
				</div>
				<!-- Hero Video Modal End -->
				<!--Scroll Top to Bottom Start -->
				<div class="scroll-top" data-scroll="up">		
				</div>
				<!--Scroll Top to Bottom  End -->
			</div>
			
<script>document.addEventListener("DOMContentLoaded", function() {
    updateHeaderState();
});

function updateHeaderState() {
    // 1. Get the container
    const authContainer = document.getElementById('authContainer');
    
    // 2. Check if user is logged in (retrieve data from LocalStorage)
    // Note: You must set these items in your login logic previously
    const storedUser = localStorage.getItem('username'); 
    
    // 3. If a user is found, swap the HTML content
    if (storedUser) {
        authContainer.innerHTML = `
            <div class="user-logged-in" style="display: flex; align-items: center; gap: 15px;">
                <span style="color: #333; font-weight: bold;">Hello, ${storedUser}</span>
                <button onclick="logoutUser()" class="btn-auth btn-login" style="background-color: #dc3545; border: none; color: white;">Logout</button>
            </div>
        `;
    }
}

// 4. Logout Function to clear the state
function logoutUser() {
    localStorage.removeItem('username'); // Delete the name from memory
    window.location.reload(); // Refresh the page to show "Sign In" again
}

</script>
			<script src="assets/js/jquery-min-3.6.0.js"></script>
			<script src="assets/js/slick.min.js"></script>
			<script src="assets/js/bootstrap.bundle.min.js"></script>
			<script src="assets/js/aos.js"></script>
			<script src="assets/js/jquery-ui.min.js"></script>
			<script src="assets/js/datepicker.js"></script>
			<script src="assets/js/wow.min.js"></script>
			<script src="assets/js/photoswipe.min.js"></script>
			<script src="assets/js/photoswipe-ui-default.min.js"></script>
			<script src="assets/js/gallery-popup.js"></script>
			<script src="assets/js/TweenMax.min.js"></script>
			<script src="assets/js/ScrollMagic.js"></script>
			<script src="assets/js/animation.gsap.min.js"></script>
			<script src="assets/js/scolling.js"></script>
			<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
			<script src="assets/js/custom.js"></script>
	</body>
	</html>