<?php

/* ===============================
   LOAD PHPMailer (Already Verified)
================================ */
require_once __DIR__ . '/PHPMailer/src/PHPMailer.php';
require_once __DIR__ . '/PHPMailer/src/SMTP.php';
require_once __DIR__ . '/PHPMailer/src/Exception.php';

/* ===============================
   DATABASE CONNECTION
================================ */
$conn = new mysqli("localhost", "root", "", "bermiz_db");
if ($conn->connect_error) {
    die("Database connection failed");
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {

    /* ===============================
       COLLECT FORM DATA
    ================================ */
    $name       = $_POST['name'];
    $phone      = $_POST['phone'];
    $eventType  = $_POST['event_type'];
    $eventDate  = $_POST['date'];
    $guests     = $_POST['guests'];
    $foodPref   = $_POST['food_pref'];
    $address    = $_POST['address'];
    $gps        = $_POST['gps_coordinates'];

    /* ===============================
       SAVE TO DATABASE
    ================================ */
    $stmt = $conn->prepare(
        "INSERT INTO catering_bookings 
        (name, phone, event_type, event_date, guests, food_preference, address, gps_coordinates)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?)"
    );

    $stmt->bind_param(
        "ssssisss",
        $name,
        $phone,
        $eventType,
        $eventDate,
        $guests,
        $foodPref,
        $address,
        $gps
    );

    $stmt->execute();

    /* ===============================
       SEND EMAIL TO ADMIN
    ================================ */
    $mail = new \PHPMailer\PHPMailer\PHPMailer(true);

    try {
        $mail->isSMTP();
        $mail->Host       = 'smtp.gmail.com';
        $mail->SMTPAuth   = true;
        $mail->Username   = 'pradeepnatarajan400@gmail.com';
        $mail->Password   = 'jhaz xdav sibf gufm'; // already verified
        $mail->SMTPSecure = 'tls';
        $mail->Port       = 587;

        $mail->setFrom('pradeepnatarajan400@gmail.com', 'Bermiz Catering');
        $mail->addAddress('badpradii@gmail.com');
        $mail->addReplyTo('no-reply@bermiz.com', 'Booking System');

        $mail->isHTML(true);
        $mail->Subject = "📢 New Catering Booking Request";

        $mail->Body = "
        <h2>New Catering Booking</h2>
        <table border='1' cellpadding='10' cellspacing='0'>
            <tr><th>Name</th><td>$name</td></tr>
            <tr><th>Phone</th><td>$phone</td></tr>
            <tr><th>Event Type</th><td>$eventType</td></tr>
            <tr><th>Date</th><td>$eventDate</td></tr>
            <tr><th>Guests</th><td>$guests</td></tr>
            <tr><th>Food Preference</th><td>$foodPref</td></tr>
            <tr><th>Address</th><td>$address</td></tr>
            <tr><th>GPS</th><td>$gps</td></tr>
        </table>
        ";

        $mail->send();

        echo "<script>
                alert('Booking confirmed! We will contact you shortly.');
                window.location.href='index.php';
              </script>";

    } catch (Exception $e) {
        echo "Mailer Error: " . $e->getMessage();
    }
}

$conn->close();
?>
