<?php
// SESSION & DATABASE INITIALIZATION
session_start();

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

// Database connection
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "bermiz_db";

$conn = new mysqli($servername, $username, $password, $dbname);
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Fetch current user details
$user_id = $_SESSION['user_id'];
$stmt = $conn->prepare("SELECT * FROM users WHERE id = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();
$stmt->close();

// Set user variables with defaults
$u_name = !empty($user['name']) ? htmlspecialchars($user['name']) : "Guest";
$u_email = !empty($user['email']) ? htmlspecialchars($user['email']) : "No Email";
$u_phone = !empty($user['phone']) ? htmlspecialchars($user['phone']) : "Not Provided"; 
$u_address = !empty($user['address']) ? htmlspecialchars($user['address']) : "Not Provided";
$u_image = !empty($user['profile_image']) ? "assets/uploads/" . htmlspecialchars($user['profile_image']) : "assets/images/default-user.png";

// Fetch user orders (using email as primary key)
$orders = [];
if (!empty($u_email) && $u_email !== "No Email") {
   // Change 'items' to whatever your actual column name is (e.g., 'order_items')
$stmt = $conn->prepare("SELECT id, items, total_amount, status FROM orders WHERE user_id = ? ORDER BY id DESC LIMIT 10");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $orders_result = $stmt->get_result();
    while ($row = $orders_result->fetch_assoc()) {
        $orders[] = $row;
    }
    $stmt->close();
}

// Fetch user reservations
$reservations = [];
if (!empty($u_email) && $u_email !== "No Email") {
    $stmt = $conn->prepare("SELECT id, name, email, phone, res_date, res_time, guests, status FROM reservations WHERE email = ? ORDER BY res_date DESC LIMIT 10");
    $stmt->bind_param("s", $u_email);
    $stmt->execute();
    $reservations_result = $stmt->get_result();
    while ($row = $reservations_result->fetch_assoc()) {
        $reservations[] = $row;
    }
    $stmt->close();
}

// Calculate statistics
$orders_count = count($orders);
$total_spent = 0;
foreach ($orders as $order) {
    $total_spent += floatval($order['total_amount']);
}
$reservations_count = count($reservations);

$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title>Bermiz</title>
	<link rel="icon" href="assets/images/favicon/icon.png">
	<link href="../../../css2?family=Elsie&display=swap" rel="stylesheet">
	<link href="../../../css2-1?family=Elsie&family=Lexend:wght@400;500&display=swap" rel="stylesheet">
	<link rel="stylesheet" href="assets/css/all.min.css">
	<link rel="stylesheet" href="assets/css/slick.css">
	<link rel="stylesheet" href="assets/css/aos.css">
	<link rel="stylesheet" href="assets/css/animate.css">
	<link rel="stylesheet" href="assets/css/bootstrap.min.css">
	<link rel="stylesheet" href="assets/css/photoswipe.min.css">
	<link rel="stylesheet" href="assets/css/default-skin.min.css">
	<link rel="stylesheet" href="assets/css/style.css">
	<link rel="stylesheet" href="assets/css/media-query.css">
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
	<link rel="stylesheet" href="assets/css/profile-styles.css">
</head>
<body>
	<div class="site_content">
		<!-- Preloader Start -->
<!-- ===== RESTAURANT PRELOADER ===== -->
<div id="preloader">

  <!-- INLINE SVG COFFEE -->
  <svg width="140" height="140"
       viewBox="0 0 140 140"
       xmlns="http://www.w3.org/2000/svg">

    <!-- Cup body -->
    <rect x="40" y="65" width="60" height="35"
          rx="8" fill="#78350f"/>

    <!-- Cup handle -->
    <path d="M100 72 Q115 82 100 92"
          fill="none"
          stroke="#78350f"
          stroke-width="5"/>

    <!-- Saucer -->
    <ellipse cx="70" cy="105" rx="40" ry="6"
             fill="#e5e7eb"/>

    <!-- Steam 1 -->
    <path d="M55 60 C45 50 65 40 55 30"
          stroke="#d97706"
          stroke-width="4"
          fill="none">
      <animate attributeName="opacity"
               values="0;1;0"
               dur="1.2s"
               repeatCount="indefinite"/>
    </path>

    <!-- Steam 2 -->
    <path d="M70 60 C60 50 80 40 70 30"
          stroke="#f59e0b"
          stroke-width="4"
          fill="none">
      <animate attributeName="opacity"
               values="0;1;0"
               dur="1.2s"
               begin="0.3s"
               repeatCount="indefinite"/>
    </path>

    <!-- Steam 3 -->
    <path d="M85 60 C75 50 95 40 85 30"
          stroke="#d97706"
          stroke-width="4"
          fill="none">
      <animate attributeName="opacity"
               values="0;1;0"
               dur="1.2s"
               begin="0.6s"
               repeatCount="indefinite"/>
    </path>

    <!-- Text -->
    <text x="70" y="130"
          text-anchor="middle"
          font-size="11"
          fill="#92400e">
      Brewing Coffee…
    </text>

  </svg>

</div>



		<!-- Preloader End --><!-- ================= TOP INFO HEADER ================= -->
<div class="top-header">
    <div class="container-fluid top-header-inner">

        <div class="welcome-text">
            Welcome to Bermiz Restaurant & Catering Services
        </div>

        <div class="social-icons">
            <a href="#"><i class="fa-brands fa-facebook-f"></i></a>
            <a href="#"><i class="fa-brands fa-twitter"></i></a>
            <a href="#"><i class="fa-brands fa-instagram"></i></a>
            <a href="#"><i class="fa-brands fa-whatsapp"></i></a>
            <a href="#"><i class="fa-brands fa-youtube"></i></a>
        </div>

    </div>
</div>

<!-- ================= CONTACT STRIP ================= -->
<div class="top-header-container">
    
    <div class="logo-area">
        <a href="index.php">
        <img src="assets/images/Homepage1/logo.png" class="strip-logo">
		</a>
    </div>

    <div class="header-right-side">
        
        <div class="contact-group">
            
            <div class="contact-item">
                <i class="fas fa-phone-alt contact-icon"></i> <div>
                    <h5 class="contact-title">Call Us:</h5>
                    <p class="contact-text">+91 98765 43210</p>
                </div>
            </div>

            <div class="contact-item">
                <i class="fas fa-envelope contact-icon"></i>
                <div>
                    <h5 class="contact-title">Mail Us:</h5>
                    <p class="contact-text">bermizrestaurant@gmail.com</p>
                </div>
            </div>

            <div class="contact-item">
                <i class="fas fa-map-marker-alt contact-icon"></i>
                <div>
                    <h5 class="contact-title">Location:</h5>
                    <p class="contact-text">Coimbatore, Tamil Nadu</p>
                </div>
            </div>

        </div> 
<div class="auth-actions" id="authContainer">
    <?php if (isset($_SESSION['user_name'])): ?>
        
        <div class="user-menu-dropdown">
            <button class="user-btn">
                <i class="fa fa-user-circle"></i> <span class="u-name"><?php echo htmlspecialchars($_SESSION['user_name']); ?></span>
                <i class="fa fa-caret-down"></i> </button>

            <div class="dropdown-content">
                <a href="profile.php">
                    <i class="fa fa-id-card"></i> View Profile
                </a>
                <a href="logout.php" class="logout-item">
                    <i class="fa fa-sign-out"></i> Logout
                </a>
            </div>
        </div>

    <?php else: ?>

        <a href="login.php" class="btn-auth btn-login">Sign In</a>
        <a href="login.php?show=signup" class="btn-auth btn-signup">Sign Up</a>

    <?php endif; ?>
</div>

    </div>
	<style>/* ========================================= */
/* TOP HEADER LAYOUT                        */
/* ========================================= */
</style>
</div>
	
		<!-- Header Section Start -->
<header id="header-homepage1" class="menupage1-header">
	<div class="header-full-section">
		<!-- Logo -->
		<div class="header-logo">
			<a href="index.php">
				<img src="assets/images/Homepage1/logo.png" alt="header-logo" class="homepage1-logo">
			</a>
		</div>


		<!-- Desktop Menu -->
		<div class="header-menu-wrap">
			<div class="header-nav-wrap">
				<nav class="navbar navbar-expand-xl p-0">
					<div class="navbar-collapse" id="navbarSupportedContent">
						<ul class="navbar-nav mx-auto align-items-center">

							<!-- HOME -->
							<li class="nav-item">
								<a class="nav-link" href="index.php">Home</a>
							</li>

							<!-- ABOUT US DROPDOWN -->
							<li class="nav-item dropdown">
								<a class="nav-link dropdown-toggle" href="javascript:void(0);">About Us</a>
								<ul class="dropdown-menu">
									<li><a class="dropdown-item" href="about-us.php">About</a></li>
									<li><a class="dropdown-item" href="chefspage2.php">Chefs</a></li>
									<li><a class="dropdown-item" href="blogpage-1.php">Blog</a></li>
									<li><a class="dropdown-item" href="faq.php">FAQ</a></li>
								</ul>
							</li>

							<!-- MENU -->
							<li class="nav-item dropdown">
								<a class="nav-link dropdown-toggle" href="javascript:void(0);">Menu</a>
								<ul class="dropdown-menu">
									<li><a class="dropdown-item" href="menupage-veg.php">Veg</a></li>
									<li><a class="dropdown-item" href="menupage-nonveg.php">Non-Veg</a></li>
									<li><a class="dropdown-item" href="drinks.php">Drinks</a></li>
                                </ul>
							</li>

							<!-- WEEKLY SPECIAL -->
							<li class="nav-item">
								<a class="nav-link" href="weekly.php">Weekly Special</a>
							</li>

							<!-- Catering & Events -->
							<li class="nav-item">
								<a class="nav-link" href="catering-events.php">Catering & Events</a>
							</li>

							<!-- RESERVATION -->
							<li class="nav-item">
								<a class="nav-link" href="online-delivery.php">Online Delivery</a>
							</li>

							<!-- GALLERY -->
							<li class="nav-item">
								<a class="nav-link" href="gallery.php">Gallery</a>
							</li>

							<!-- CONTACT -->
							<li class="nav-item">
								<a class="nav-link" href="contact-us.php">Contact Us</a>
							</li>

						</ul>
					</div>
				</nav>
			</div>
		</div>

		<!-- CART ICON -->
<div class="header-cart-sec">

    <!-- Mobile Toggle -->
    <div class="mobile-menu-icon d-xl-none">
        <a data-bs-toggle="collapse" href="#navbarSupportedmobile" role="button">
            <i class="fa-solid fa-bars"></i>
        </a>
    </div>

    <!-- CART (DESKTOP ONLY) -->
    <div class="header-cart-btn d-none d-xl-flex">
        <a href="cart-view.php">
            <i class="fa fa-shopping-cart"></i>
            <span class="cart-count">0</span>
        </a>
    </div>

    <!-- BOOKING (DESKTOP ONLY) -->
    <div class="header-cart-sec-first d-none d-xl-block">
        <a href="reservation-1.php" class="booking-btn-text">
            Booking
        </a>
    </div>

</div>



</div>

	</div>

	<!-- MOBILE MENU -->
<div class="mobile-menu-wrap d-lg-none d-block">
    <div class="mb-header-left">
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedmobile">
            <span class="navbar-toggler-icon"><i class="fa-solid fa-bars"></i></span>
        </button>

        <div class="collapse navbar-collapse" id="navbarSupportedmobile">
            <span class="close-menu"><i class="fa-regular fa-xmark"></i></span>

            <nav id='cssmenu'>
                <ul class="open-detail-menu">

                    <?php if (isset($_SESSION['user_name'])): ?>
                        <li style="border-bottom: 1px solid #ffffffff; background: #931A2A;">
                            <a href="profile.php" style="color: #ffffffff; font-weight: 700;">
                                <i class="fa fa-user-circle" style="margin-right:8px;"></i> 
                                Hello, <?php echo htmlspecialchars($_SESSION['user_name']); ?>
                            </a>
                        </li>
                    <?php endif; ?>
                    <li><a href="index.php">Home</a></li>

                    <li><a href="javascript:void(0);">About Us</a>
                        <ul class="sub-back-wrap">
                            <li><a href="about-us.php">About</a></li>
                            <li><a href="chefspage2.php">Chefs</a></li>
                            <li><a href="blogpage-1.php">Blog</a></li>
                            <li><a href="faq.php">FAQ</a></li>
                        </ul>
                    </li>

                    <li><a href="javascript:void(0);">Menu</a>
                        <ul class="sub-back-wrap">
                            <li><a href="menupage-veg.php">Veg</a></li>
                            <li><a href="menupage-nonveg.php">Non-Veg</a></li>
                            <li><a href="drinks.php">Drinks</a></li>
                        </ul>
                    </li>

                    <li><a href="weekly-special.php">Weekly Special</a></li>
                    <li><a href="catering-events.php">Catering & Events</a></li>
                    <li><a href="online-delivery.php">Online Delivery</a></li>
                    <li><a href="gallery.php">Gallery</a></li>
                    <li><a href="contact-us.php">Contact Us</a></li>
                    
                    <li class="mobile-extra">
                        <a href="cart-view.php" class="mobile-cart">
                            <i class="fa fa-shopping-cart"></i>
                            Cart <span class="mobile-cart-count">0</span>
                        </a>
                    </li>

                    <li class="mobile-extra">
                        <a href="reservation-1.php" class="booking-link">Booking</a>
                    </li>

                    <li class="mobile-auth-text">
                        <?php if (isset($_SESSION['user_name'])): ?>
                            <a href="logout.php" class="mobile-login-link" style="color: #dc3545;">
                                <i class="fa fa-sign-out"></i> Logout
                            </a>
                        <?php else: ?>
                            <a href="login.php" class="mobile-login-link">Sign In</a>
                            <a href="login.php?show=signup" class="mobile-signup-link">Sign Up</a>
                        <?php endif; ?>
                    </li>
                    </ul>
            </nav>
        </div>
    </div>
</div>
					</ul>
				</nav>
			</div>
		</div>
	</div>
	<div class="header-boder"></div>
</header>

<div class="container profile-wrapper">
    <div class="row">
        
        <div class="col-lg-4 mb-4">
            <div class="card-profile">
                <div class="card-header-color"></div>
                
                <div class="profile-avatar-wrap">
                    <img src="<?php echo $u_image; ?>" alt="Profile" class="profile-img">
                    
                    <form id="avatarForm" action="upload_avatar.php" method="POST" enctype="multipart/form-data">
                        <label for="fileUpload" class="camera-icon" title="Change Photo">
                            <i class="fas fa-camera"></i>
                        </label>
                        <input type="file" id="fileUpload" name="avatar" style="display:none" onchange="document.getElementById('avatarForm').submit();">
                    </form>
                </div>

                <h3 class="profile-name"><?php echo $u_name; ?></h3>
                <p class="profile-role">Food Lover / Customer</p>

                <span class="badge bg-success mb-3" style="padding: 8px 15px; border-radius: 20px;">Active Account</span>

                <div class="profile-stats">
                    <div class="text-start">
                        <div class="stat-label">Total Orders</div>
                        <div class="stat-val"><?php echo $orders_count; ?></div>
                    </div>
                    <div class="text-center">
                        <div class="stat-label">Total Spent</div>
                        <div class="stat-val">₹<?php echo number_format($total_spent, 2); ?></div>
                    </div>
                    <div class="text-end">
                        <div class="stat-label">Reservations</div>
                        <div class="stat-val"><?php echo $reservations_count; ?></div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-8">
            <div class="card-details">
                
                <ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">
                    <li class="nav-item" role="presentation">
                        <button class="nav-link active" id="pills-overview-tab" data-bs-toggle="pill" data-bs-target="#pills-overview" type="button">
                            <i class="far fa-user me-2"></i> Overview
                        </button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="pills-edit-tab" data-bs-toggle="pill" data-bs-target="#pills-edit" type="button">
                            <i class="far fa-edit me-2"></i> Edit Details
                        </button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="pills-orders-tab" data-bs-toggle="pill" data-bs-target="#pills-orders" type="button">
                            <i class="fas fa-history me-2"></i> History
                        </button>
                    </li>
                </ul>

                <hr style="border-color: #eee;">

                <div class="tab-content" id="pills-tabContent">
                    
                    <div class="tab-pane fade show active" id="pills-overview">
                        <h4 class="section-title">Personal Information</h4>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <span class="info-label">Full Name</span>
                                <div class="info-value"><?php echo $u_name; ?></div>
                            </div>
                            <div class="col-md-6">
                                <span class="info-label">Occupation</span>
                                <div class="info-value">Customer</div>
                            </div>
                            <div class="col-md-6">
                                <span class="info-label">Phone Number</span>
                                <div class="info-value"><?php echo $u_phone; ?></div>
                            </div>
                            <div class="col-md-6">
                                <span class="info-label">Email Address</span>
                                <div class="info-value"><?php echo $u_email; ?></div>
                            </div>
                            <div class="col-md-12">
                                <span class="info-label">Residential Address</span>
                                <div class="info-value"><?php echo $u_address; ?></div>
                            </div>
                        </div>

                    </div>

                    <div class="tab-pane fade" id="pills-edit">
                        <h4 class="section-title">Update Your Details</h4>
                        
                        <form action="update_profile.php" method="POST">
                            <div class="row">
                                <div class="col-md-6">
                                    <label class="info-label">Full Name</label>
                                    <input type="text" name="name" class="form-control-custom" value="<?php echo $u_name; ?>" required>
                                </div>
                                <div class="col-md-6">
                                    <label class="info-label">Phone Number</label>
                                    <input type="text" name="phone" class="form-control-custom" value="<?php echo $u_phone; ?>" required>
                                </div>
                                <div class="col-md-12">
                                    <label class="info-label">Email (Read Only)</label>
                                    <input type="email" class="form-control-custom" value="<?php echo $u_email; ?>" style="background:#eee;" readonly>
                                </div>
                                <div class="col-md-12">
                                    <label class="info-label">Address</label>
                                    <textarea name="address" class="form-control-custom" rows="3"><?php echo $u_address; ?></textarea>
                                </div>
                                <div class="col-12 mt-3">
                                    <button type="submit" class="btn-update">Save Changes</button>
                                </div>
                            </div>
                        </form>
                    </div>

                    <div class="tab-pane fade" id="pills-orders">
                        <h4 class="section-title">🎫 Reservation History</h4>
                        
                        <?php if (!empty($reservations)): ?>
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead style="background:#f8f9fa; border-bottom: 2px solid #78350f;">
                                        <tr>
                                            <th style="color:#78350f; font-weight:600;">Date & Time</th>
                                            <th style="color:#78350f; font-weight:600;">Guests</th>
                                            <th style="color:#78350f; font-weight:600;">Status</th>
                                            <th style="color:#78350f; font-weight:600;">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($reservations as $res): ?>
                                        <tr>
                                            <td>
                                                <strong><?php echo date('M d, Y', strtotime($res['reservation_date'])); ?></strong><br>
                                                <small class="text-muted"><?php echo $res['reservation_time']; ?></small>
                                            </td>
                                            <td><?php echo $res['number_of_guests']; ?> Guests</td>
                                            <td>
                                                <?php 
                                                $res_status_color = [
                                                    'pending' => 'warning',
                                                    'approved' => 'success',
                                                    'rejected' => 'danger',
                                                    'completed' => 'success'
                                                ];
                                                $res_color = $res_status_color[$res['status']] ?? 'secondary';
                                                ?>
                                                <span class="badge bg-<?php echo $res_color; ?>"><?php echo ucfirst($res['status']); ?></span>
                                            </td>
                                            <td>
                                                <button class="btn btn-sm btn-outline-primary" onclick="showReservationDetails(<?php echo htmlspecialchars(json_encode($res)); ?>)" data-bs-toggle="modal" data-bs-target="#reservationDetailsModal">
                                                    View
                                                </button>
                                            </td>
                                        </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php else: ?>
                            <div class="alert alert-light border text-center p-4">
                                <i class="fas fa-calendar-alt fa-2x text-muted mb-3"></i>
                                <p>No reservations yet. <a href="reservation-1.php">Make a reservation</a></p>
                            </div>
                        <?php endif; ?>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

<!-- ORDER DETAILS MODAL -->
<div class="modal fade" id="orderDetailsModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header" style="background: #78350f; color: white;">
                <h5 class="modal-title">Order Details</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="orderModalContent">
                <!-- Content will be populated by JavaScript -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<!-- RESERVATION DETAILS MODAL -->
<div class="modal fade" id="reservationDetailsModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header" style="background: #78350f; color: white;">
                <h5 class="modal-title">Reservation Details</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="reservationModalContent">
                <!-- Content will be populated by JavaScript -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<script>
function showOrderDetails(order) {
    const html = `
        <div class="order-detail">
            <div class="row mb-3">
                <div class="col-md-6">
                    <h6 class="text-uppercase text-muted border-bottom pb-2">Order Info</h6>
                    <p><strong>Order ID:</strong> #${order.id}</p>
                    <p><strong>Status:</strong> <span class="badge bg-${['Pending', 'Processing', 'Completed', 'Cancelled'].includes(order.status) ? {'Pending':'warning','Processing':'info','Completed':'success','Cancelled':'danger'}[order.status] : 'secondary'}">${order.status}</span></p>
                    <p><strong>Total Amount:</strong> ₹${parseFloat(order.total_amount).toFixed(2)}</p>
                </div>
                <div class="col-md-6">
                    <h6 class="text-uppercase text-muted border-bottom pb-2">Delivery Info</h6>
                    <p><strong>Name:</strong> ${order.name || 'N/A'}</p>
                    <p><strong>Phone:</strong> ${order.phone || 'N/A'}</p>
                    <p><strong>Address:</strong> ${order.address || 'N/A'}</p>
                </div>
            </div>
            
            <div class="bg-light p-3 rounded">
                <div class="row">
                    <div class="col-md-6">
                        <p><strong>Order Date:</strong> ${new Date(order.order_date).toLocaleDateString('en-IN')}</p>
                    </div>
                    <div class="col-md-6 text-end">
                        <div class="d-flex justify-content-end"><span>Total Amount:</span> <strong class="text-primary ms-3">₹${parseFloat(order.total_amount).toFixed(2)}</strong></div>
                    </div>
                </div>
            </div>
        </div>
    `;
    document.getElementById('orderModalContent').innerHTML = html;
}}

function showReservationDetails(reservation) {
    const html = `
        <div class="reservation-detail">
            <div class="row">
                <div class="col-md-6">
                    <h6 class="text-uppercase text-muted border-bottom pb-2">Reservation Info</h6>
                    <p><strong>Date:</strong> ${new Date(reservation.reservation_date).toLocaleDateString('en-IN')}</p>
                    <p><strong>Time:</strong> ${reservation.reservation_time}</p>
                    <p><strong>Number of Guests:</strong> ${reservation.number_of_guests}</p>
                </div>
                <div class="col-md-6">
                    <h6 class="text-uppercase text-muted border-bottom pb-2">Status</h6>
                    <p><span class="badge bg-${['pending','approved','rejected','completed'].includes(reservation.status) ? {'pending':'warning','approved':'success','rejected':'danger','completed':'success'}[reservation.status] : 'secondary'}" style="font-size: 14px; padding: 8px 12px;">${reservation.status.toUpperCase()}</span></p>
                </div>
            </div>
            
            <div class="bg-light p-3 rounded mt-3">
                <h6 class="text-uppercase text-muted border-bottom pb-2 mb-3">Guest Details</h6>
                <p><strong>Name:</strong> ${reservation.name}</p>
                <p><strong>Email:</strong> ${reservation.email}</p>
                <p><strong>Phone:</strong> ${reservation.phone}</p>
            </div>
        </div>
    `;
    document.getElementById('reservationModalContent').innerHTML = html;
}
</script>
<footer class="restaurant-footer">
    <div class="footer-container">

        <!-- Left Top Logo + Text -->
        <div class="footer-brand">
            <img src="assets/images/Homepage1/footer-logo.png" alt="Restaurant Logo" class="footer-logo">
            <p class="footer-desc">
                A premium dining experience with handcrafted dishes, fresh ingredients, 
                and an elegant ambiance. Your comfort is our priority.
            </p>
        </div>

        <!-- Quick Links -->
        <div class="footer-links">
            <h4>Quick Links</h4>
            <ul>
                <li><a href="reservation-1.html">Reserve a Table</a></li>
                
                <li><a href="#menupage-veg.html">Explore Menu</a></li>
                <li><a href="#weekly.html">Special Offers</a></li>
                <li><a href="#catering-events.html">Catering Service</a></li>
            </ul>
        </div>

        <!-- Contact Section -->
        <div class="footer-contact">
            <h4>Contact Us</h4>
            <p> 123 Food Street, Chennai</p>
            <p> +91 98765 43210</p>
            <p>✉ support@restaurant.com</p>

            <div class="footer-social">
                <a href="#"><i class="fa fa-facebook"></i></a>
                <a href="#"><i class="fa fa-instagram"></i></a>
                <a href="#"><i class="fa fa-twitter"></i></a>
                <a href="#"><i class="fa fa-youtube"></i></a>
            </div>
        </div>

        <!-- Working Hours -->
        <div class="footer-hours">
            <h4>Working Hours</h4>
            <p>Mon – Fri : 09:00 - 22:00</p>
            <p>Saturday : 11:00 - 23:30</p>
            <p>Sunday : 11:00 - 23:00</p>
        </div>

    </div>

    <div class="footer-bottom">
        <p>© 2025 Your Restaurant Name. All Rights Reserved.</p>
        <div class="footer-bottom-links">
            <a href="#">Privacy Policy</a>
            <a href="#">Terms of Service</a>
        </div>
    </div>
</footer>

			<!-- Footer Section End -->
			<!-- Fixed Search Bar Start -->
			<div>
				<div class="fixed-serach-icon ">
					<div class="fixed-search ">
						<a href="javascript:void(0)">
							<svg width="24" height="24" viewbox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
								<mask id="mask0_504_17203" style="mask-type:alpha" maskunits="userSpaceOnUse" x="0" y="0" width="24" height="24">
									<rect width="24" height="24" fill="white"></rect>
								</mask>
								<g mask="url(#mask0_504_17203)">
									<circle cx="11.7666" cy="11.7666" r="8.98856" stroke="#0B1315" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></circle>
									<path d="M18.0183 18.4851L21.5423 22" stroke="#0B1315" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
								</g>
							</svg>
						</a>
					</div>
				</div> 
				<div class="search-popup">
					<span class="search-back-drop"></span>
					<button class="close-search"><span class="fa fa-times"></span></button>
					<div class="search-inner">
						<form method="post" action="index.html">
							<div class="form-group">
								<input type="search" name="search-field" value="" placeholder="Search..." required="">
								<button type="submit"><i class="fa fa-search"></i></button>
							</div>
						</form>
					</div>
				</div>
			</div>
			<!-- Fixed Search Bar End -->
			<!-- Hero Video Modal Start -->
			<div class="modal fade homepage-video-modal" id="hero-video-modal">
				<div class="modal-dialog modal-dialog-centered">
					<div class="modal-content">
						<div class="modal-header">
							<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
						</div>
						<div class="modal-body">
							<video class="video-sec" controls="" loop="" muted="" autoplay="">
								<source src="assets/images/Homepage1/video.mp4" type="video/mp4">
								</video>
							</div>
						</div>
					</div>
				</div>
				<!-- Hero Video Modal End -->
				<!--Scroll Top to Bottom Start -->
				<div class="scroll-top" data-scroll="up">		
				</div>
				<!--Scroll Top to Bottom  End -->
			</div>
        
			<script src="assets/js/jquery-min-3.6.0.js"></script>
			<script src="assets/js/bootstrap.bundle.min.js"></script>
			
			<!-- Deferred non-critical scripts for performance -->
			<script src="assets/js/slick.min.js" defer></script>
			<script src="assets/js/aos.js" defer></script>
			<script src="assets/js/jquery-ui.min.js" defer></script>
			<script src="assets/js/datepicker.js" defer></script>
			<script src="assets/js/wow.min.js" defer></script>
			<script src="assets/js/photoswipe.min.js" defer></script>
			<script src="assets/js/photoswipe-ui-default.min.js" defer></script>
			<script src="assets/js/gallery-popup.js" defer></script>
			<script src="assets/js/TweenMax.min.js" defer></script>
			<script src="assets/js/ScrollMagic.js" defer></script>
			<script src="assets/js/animation.gsap.min.js" defer></script>
			<script src="assets/js/scolling.js" defer></script>
			<script src="assets/js/custom.js" defer></script>
  
<!-- <div style="height:120px"></div> -->

<script>
// Mobile Menu Toggle Functionality
document.addEventListener('DOMContentLoaded', function() {
    const toggler = document.querySelector('.mobile-menu-icon a');
    const mobileMenu = document.getElementById('navbarSupportedmobile');
    const navbarToggler = document.querySelector('.navbar-toggler');
    
    if (toggler) {
        toggler.addEventListener('click', function(e) {
            e.preventDefault();
            if (mobileMenu) {
                mobileMenu.classList.toggle('show');
                // Toggle active state on the button
                if (navbarToggler) {
                    navbarToggler.classList.toggle('active');
                }
            }
        });
    }
    
    // Also handle the navbar-toggler button for compatibility
    if (navbarToggler) {
        navbarToggler.addEventListener('click', function() {
            if (mobileMenu) {
                mobileMenu.classList.toggle('show');
                this.classList.toggle('active');
            }
        });
    }
    
    // Close menu when a link is clicked
    const menuLinks = document.querySelectorAll('.mobile-menu-wrap a');
    menuLinks.forEach(link => {
        link.addEventListener('click', function(e) {
            // Don't close for toggle buttons
            if (!this.classList.contains('navbar-toggler') && 
                !this.closest('.mobile-menu-icon')) {
                if (mobileMenu) {
                    mobileMenu.classList.remove('show');
                    if (navbarToggler) {
                        navbarToggler.classList.remove('active');
                    }
                }
            }
        });
    });
});

function toggleSidebar(){
    document.getElementById("sidebar").classList.toggle("hidden");
}
</script>

</body>
</html>
