<?php
require_once 'db_connect.php';

// Create cart table
$cartTableSQL = "
CREATE TABLE IF NOT EXISTS `cart` (
  `id` INT PRIMARY KEY AUTO_INCREMENT,
  `user_id` INT DEFAULT NULL,
  `session_id` VARCHAR(255) NOT NULL,
  `product_name` VARCHAR(255) NOT NULL,
  `product_price` DECIMAL(10, 2) NOT NULL,
  `product_image` VARCHAR(500),
  `quantity` INT NOT NULL DEFAULT 1,
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  FOREIGN KEY (`user_id`) REFERENCES `users`(`id`) ON DELETE CASCADE,
  INDEX `idx_user_id` (`user_id`),
  INDEX `idx_session_id` (`session_id`),
  INDEX `idx_product_name` (`product_name`)
)";

if ($conn->query($cartTableSQL)) {
    echo "✅ Cart table created/verified successfully!<br>";
} else {
    echo "❌ Error creating cart table: " . $conn->error . "<br>";
}

// Verify table structure
$checkTable = $conn->query("DESCRIBE cart");
if ($checkTable) {
    echo "✅ Cart table structure verified<br>";
    echo "<pre>";
    while ($row = $checkTable->fetch_assoc()) {
        echo $row['Field'] . " - " . $row['Type'] . "<br>";
    }
    echo "</pre>";
} else {
    echo "❌ Error checking cart table: " . $conn->error . "<br>";
}

$conn->close();
?>
