<?php
session_start();
?>
<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title>Bermiz</title>
	<link rel="icon" href="assets/images/favicon/icon.png">
	<link href="../../../css2?family=Elsie&display=swap" rel="stylesheet">
	<link href="../../../css2-1?family=Elsie&family=Lexend:wght@400;500&display=swap" rel="stylesheet">
	<link rel="stylesheet" href="assets/css/all.min.css">
	<link rel="stylesheet" href="assets/css/slick.css">
	<link rel="stylesheet" href="assets/css/aos.css">
	<link rel="stylesheet" href="assets/css/animate.css">
	<link rel="stylesheet" href="assets/css/bootstrap.min.css">
	<link rel="stylesheet" href="assets/css/photoswipe.min.css">
	<link rel="stylesheet" href="assets/css/default-skin.min.css">
	<link rel="stylesheet" href="assets/css/style.css">
	<link rel="stylesheet" href="assets/css/media-query.css">
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
</head>
<body>
	<div class="site_content">
		<!-- Preloader Start -->
<!-- ===== RESTAURANT PRELOADER ===== -->
<div id="preloader">

  <!-- INLINE SVG COFFEE -->
  <svg width="140" height="140"
       viewBox="0 0 140 140"
       xmlns="http://www.w3.org/2000/svg">

    <!-- Cup body -->
    <rect x="40" y="65" width="60" height="35"
          rx="8" fill="#78350f"/>

    <!-- Cup handle -->
    <path d="M100 72 Q115 82 100 92"
          fill="none"
          stroke="#78350f"
          stroke-width="5"/>

    <!-- Saucer -->
    <ellipse cx="70" cy="105" rx="40" ry="6"
             fill="#e5e7eb"/>

    <!-- Steam 1 -->
    <path d="M55 60 C45 50 65 40 55 30"
          stroke="#d97706"
          stroke-width="4"
          fill="none">
      <animate attributeName="opacity"
               values="0;1;0"
               dur="1.2s"
               repeatCount="indefinite"/>
    </path>

    <!-- Steam 2 -->
    <path d="M70 60 C60 50 80 40 70 30"
          stroke="#f59e0b"
          stroke-width="4"
          fill="none">
      <animate attributeName="opacity"
               values="0;1;0"
               dur="1.2s"
               begin="0.3s"
               repeatCount="indefinite"/>
    </path>

    <!-- Steam 3 -->
    <path d="M85 60 C75 50 95 40 85 30"
          stroke="#d97706"
          stroke-width="4"
          fill="none">
      <animate attributeName="opacity"
               values="0;1;0"
               dur="1.2s"
               begin="0.6s"
               repeatCount="indefinite"/>
    </path>

    <!-- Text -->
    <text x="70" y="130"
          text-anchor="middle"
          font-size="11"
          fill="#92400e">
      Brewing Coffee…
    </text>

  </svg>

</div>

		<!-- Preloader End --><!-- ================= TOP INFO HEADER ================= -->
<div class="top-header">
    <div class="container-fluid top-header-inner">

        <div class="welcome-text">
            Welcome to Bermiz Restaurant & Catering Services
        </div>

        <div class="social-icons">
            <a href="#"><i class="fa-brands fa-facebook-f"></i></a>
            <a href="#"><i class="fa-brands fa-twitter"></i></a>
            <a href="#"><i class="fa-brands fa-instagram"></i></a>
            <a href="#"><i class="fa-brands fa-whatsapp"></i></a>
            <a href="#"><i class="fa-brands fa-youtube"></i></a>
        </div>

    </div>
</div>

<!-- ================= CONTACT STRIP ================= -->
<div class="top-header-container">
    
    <div class="logo-area">
        <a href="index.php">
        <img src="assets/images/Homepage1/logo.png" class="strip-logo">
		</a>
    </div>

    <div class="header-right-side">
        
        <div class="contact-group">
            
            <div class="contact-item">
                <i class="fas fa-phone-alt contact-icon"></i> <div>
                    <h5 class="contact-title">Call Us:</h5>
                    <p class="contact-text">+91 98765 43210</p>
                </div>
            </div>

            <div class="contact-item">
                <i class="fas fa-envelope contact-icon"></i>
                <div>
                    <h5 class="contact-title">Mail Us:</h5>
                    <p class="contact-text">bermizrestaurant@gmail.com</p>
                </div>
            </div>

            <div class="contact-item">
                <i class="fas fa-map-marker-alt contact-icon"></i>
                <div>
                    <h5 class="contact-title">Location:</h5>
                    <p class="contact-text">Coimbatore, Tamil Nadu</p>
                </div>
            </div>

        </div> 
 <div class="auth-actions" id="authContainer">
    <?php if (isset($_SESSION['user_name'])): ?>
        
        <div class="user-menu-dropdown">
            <button class="user-btn">
                <i class="fa fa-user-circle"></i> <span class="u-name"><?php echo htmlspecialchars($_SESSION['user_name']); ?></span>
                <i class="fa fa-caret-down"></i> </button>

            <div class="dropdown-content">
                <a href="profile.php">
                    <i class="fa fa-id-card"></i> View Profile
                </a>
                <a href="logout.php" class="logout-item">
                    <i class="fa fa-sign-out"></i> Logout
                </a>
            </div>
        </div>

    <?php else: ?>

        <a href="login.php" class="btn-auth btn-login">Sign In</a>
        <a href="login.php?show=signup" class="btn-auth btn-signup">Sign Up</a>

    <?php endif; ?>
</div>

    </div>
	<style>/* ========================================= */
/* TOP HEADER LAYOUT                        */
/* ========================================= */
</style>
</div>
	
		<!-- Header Section Start -->
<header id="header-homepage1" class="menupage1-header">
	<div class="header-full-section">
		<!-- Logo -->
		<div class="header-logo">
			<a href="index.php">
				<img src="assets/images/Homepage1/logo.png" alt="header-logo" class="homepage1-logo">
			</a>
		</div>


		<!-- Desktop Menu -->
		<div class="header-menu-wrap">
			<div class="header-nav-wrap">
				<nav class="navbar navbar-expand-xl p-0">
					<div class="navbar-collapse" id="navbarSupportedContent">
						<ul class="navbar-nav mx-auto align-items-center">

							<!-- HOME -->
							<li class="nav-item">
								<a class="nav-link" href="index.php">Home</a>
							</li>

							<!-- ABOUT US DROPDOWN -->
							<li class="nav-item dropdown">
								<a class="nav-link dropdown-toggle" href="javascript:void(0);">About Us</a>
								<ul class="dropdown-menu">
									<li><a class="dropdown-item" href="about-us.php">About</a></li>
									<li><a class="dropdown-item" href="chefspage2.php">Chefs</a></li>
									<li><a class="dropdown-item" href="blogpage-1.php">Blog</a></li>
									<li><a class="dropdown-item" href="faq.php">FAQ</a></li>
								</ul>
							</li>

							<!-- MENU -->
							<li class="nav-item dropdown">
								<a class="nav-link dropdown-toggle" href="javascript:void(0);">Menu</a>
								<ul class="dropdown-menu">
									<li><a class="dropdown-item" href="menupage-veg.php">Veg</a></li>
									<li><a class="dropdown-item" href="menupage-nonveg.php">Non-Veg</a></li>
									<li><a class="dropdown-item" href="drinks.php">Drinks</a></li>
                                </ul>
							</li>

							<!-- WEEKLY SPECIAL -->
							<li class="nav-item">
								<a class="nav-link" href="weekly.php">Weekly Special</a>
							</li>

							<!-- Catering & Events -->
							<li class="nav-item">
								<a class="nav-link" href="catering-events.php">Catering & Events</a>
							</li>

							<!-- RESERVATION -->
							<li class="nav-item">
								<a class="nav-link" href="online-delivery.php">Online Delivery</a>
							</li>

							<!-- GALLERY -->
							<li class="nav-item">
								<a class="nav-link" href="gallery.php">Gallery</a>
							</li>

							<!-- CONTACT -->
							<li class="nav-item">
								<a class="nav-link" href="contact-us.php">Contact Us</a>
							</li>

						</ul>
					</div>
				</nav>
			</div>
		</div>

		<!-- CART ICON -->
<div class="header-cart-sec">

    <!-- Mobile Toggle -->
    <div class="mobile-menu-icon d-xl-none">
        <a data-bs-toggle="collapse" href="#navbarSupportedmobile" role="button">
            <i class="fa-solid fa-bars"></i>
        </a>
    </div>

    <!-- CART (DESKTOP ONLY) -->
    <div class="header-cart-btn d-none d-xl-flex">
        <a href="cart-view.php">
            <i class="fa fa-shopping-cart"></i>
            <span class="cart-count">0</span>
        </a>
    </div>

    <!-- BOOKING (DESKTOP ONLY) -->
    <div class="header-cart-sec-first d-none d-xl-block">
        <a href="reservation-1.php" class="booking-btn-text">
            Booking
        </a>
    </div>

</div>



</div>

	</div>

	<!-- MOBILE MENU -->
<div class="mobile-menu-wrap d-lg-none d-block">
    <div class="mb-header-left">
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedmobile">
            <span class="navbar-toggler-icon"><i class="fa-solid fa-bars"></i></span>
        </button>

        <div class="collapse navbar-collapse" id="navbarSupportedmobile">
            <span class="close-menu"><i class="fa-regular fa-xmark"></i></span>

            <nav id='cssmenu'>
                <ul class="open-detail-menu">

                    <?php if (isset($_SESSION['user_name'])): ?>
                        <li style="border-bottom: 1px solid #ffffffff; background: #931A2A;">
                            <a href="profile.php" style="color: #ffffffff; font-weight: 700;">
                                <i class="fa fa-user-circle" style="margin-right:8px;"></i> 
                                Hello, <?php echo htmlspecialchars($_SESSION['user_name']); ?>
                            </a>
                        </li>
                    <?php endif; ?>
                    <li><a href="index.php">Home</a></li>

                    <li><a href="javascript:void(0);">About Us</a>
                        <ul class="sub-back-wrap">
                            <li><a href="about-us.php">About</a></li>
                            <li><a href="chefspage2.php">Chefs</a></li>
                            <li><a href="blogpage-1.php">Blog</a></li>
                            <li><a href="faq.php">FAQ</a></li>
                        </ul>
                    </li>

                    <li><a href="javascript:void(0);">Menu</a>
                        <ul class="sub-back-wrap">
                            <li><a href="menupage-veg.php">Veg</a></li>
                            <li><a href="menupage-nonveg.php">Non-Veg</a></li>
                            <li><a href="drinks.php">Drinks</a></li>
                        </ul>
                    </li>

                    <li><a href="weekly-special.php">Weekly Special</a></li>
                    <li><a href="catering-events.php">Catering & Events</a></li>
                    <li><a href="online-delivery.php">Online Delivery</a></li>
                    <li><a href="gallery.php">Gallery</a></li>
                    <li><a href="contact-us.php">Contact Us</a></li>
                    
                    <li class="mobile-extra">
                        <a href="cart-view.php" class="mobile-cart">
                            <i class="fa fa-shopping-cart"></i>
                            Cart <span class="mobile-cart-count">0</span>
                        </a>
                    </li>

                    <li class="mobile-extra">
                        <a href="reservation-1.php" class="booking-link">Booking</a>
                    </li>

                    <li class="mobile-auth-text">
                        <?php if (isset($_SESSION['user_name'])): ?>
                            <a href="logout.php" class="mobile-login-link" style="color: #dc3545;">
                                <i class="fa fa-sign-out"></i> Logout
                            </a>
                        <?php else: ?>
                            <a href="login.php" class="mobile-login-link">Sign In</a>
                            <a href="login.php?show=signup" class="mobile-signup-link">Sign Up</a>
                        <?php endif; ?>
                    </li>
                    </ul>
            </nav>
        </div>
    </div>
</div>				</ul>
				</nav>
			</div>
		</div>
	</div>
	<div class="header-boder"></div>
</header>

<section id="menupage-1-section">
    <div class="menupage-1-section-img">
        <div class="menupage-1-overlay"></div>
        
        <div class="menupage-1-conten text-center"> <h1 class="menupage-1-hero-txt1 wow fadeInDown" data-wow-duration="1s" data-wow-delay="0.5s">
                Tracking
            </h1>

            <nav aria-label="breadcrumb">
                <ol class="breadcrumb justify-content-center transparent-breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="index.php">
                            <span class="home-icon">
                                <svg width="24" height="24" viewbox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <mask id="mask0_564_5237" style="mask-type:alpha" maskunits="userSpaceOnUse" x="0" y="0" width="24" height="24">
                                        <rect width="24" height="24" fill="white"></rect>
                                    </mask>
                                    <g mask="url(#mask0_564_5237)">
                                        <path d="M9.15722 20.7714V17.7047C9.1572 16.9246 9.79312 16.2908 10.581 16.2856H13.4671C14.2587 16.2856 14.9005 16.9209 14.9005 17.7047V17.7047V20.7809C14.9003 21.4432 15.4343 21.9845 16.103 22H18.0271C19.9451 22 21.5 20.4607 21.5 18.5618V18.5618V9.83784C21.4898 9.09083 21.1355 8.38935 20.538 7.93303L13.9577 2.6853C12.8049 1.77157 11.1662 1.77157 10.0134 2.6853L3.46203 7.94256C2.86226 8.39702 2.50739 9.09967 2.5 9.84736V18.5618C2.5 20.4607 4.05488 22 5.97291 22H7.89696C8.58235 22 9.13797 21.4499 9.13797 20.7714V20.7714" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
                                    </g>
                                </svg>
                            </span>
                            Home
                        </a>
                    </li>
                    <li class="breadcrumb-item active text-white" aria-current="page">Tracking</li>
                </ol>
            </nav>

        </div>
    </div>
    <div class="menupage1-boder"></div>
</section>
<style>
:root{
    --primary:#931A2A;
    --cream:#F5E6D3;
}

body{
    background:var(--cream);
    padding-top:0px;
    font-family:'Poppins',sans-serif;
}

/* ============================= */
/* TRACKER CONTAINER            */
/* ============================= */
.tracker-box{
    background:#fff1dc;
    padding:40px;
    border-radius:20px;
    max-width:900px;
    margin:auto;
}

/* ============================= */
/* TITLE                        */
/* ============================= */
.tracker-box h2{
    color:var(--primary);
    font-weight:600;
    margin-bottom:10px;
}

.tracker-box p{
    color:var(--primary);
    margin-bottom:30px;
}

/* ============================= */
/* STEPS                        */
/* ============================= */
.tracker-steps{
    display:flex;
    justify-content:space-between;
    position:relative;
    margin-top:40px;
}

.tracker-steps::before{
    content:'';
    position:absolute;
    top:22px;
    left:0;
    width:100%;
    height:4px;
    background:#e0c1b6;
    z-index:0;
}

.step{
    position:relative;
    text-align:center;
    width:25%;
    z-index:1;
}

.step span{
    display:inline-flex;
    align-items:center;
    justify-content:center;
    width:45px;
    height:45px;
    border-radius:50%;
    background:#e0c1b6;
    color:#fff;
    font-weight:600;
    margin-bottom:10px;
}

.step.active span{
    background:var(--primary);
}

.step p{
    font-size:14px;
    font-weight:500;
}

/* ============================= */
/* ORDER INFO                   */
/* ============================= */
.order-info{
    margin-top:40px;
    border-top:1px solid rgba(147,26,42,0.3);
    padding-top:25px;
}

.order-info p{
    display:flex;
    justify-content:space-between;
    font-size:15px;
}

/* ============================= */
/* BUTTON                       */
/* ============================= */
.back-btn{
    margin-top:30px;
    display:inline-block;
    background:var(--primary);
    color:#fff;
    padding:12px 30px;
    border-radius:10px;
    text-decoration:none;
    font-weight:600;
    transition:0.0.5s;
}

.back-btn:hover{
    background:#6f1420;
    transform:translateY(-2px);
}/* ============================= */
/* LARGE DESKTOP (1440px)        */
/* ============================= */
@media (min-width: 1366px) and (max-width: 1440px) {

    .tracker-box {
        max-width: 1000px;
        padding: 45px;
    }

    .tracker-steps::before {
        top: 24px;
        height: 4px;
    }

    .step span {
        width: 48px;
        height: 48px;
        font-size: 15px;
    }

    .step p {
        font-size: 15px;
    }
}

/* ============================= */
/* TABLET (≤ 991px)              */
/* ============================= */
@media (max-width: 991px) {

    .tracker-box {
        padding: 30px;
        margin: 20px;
    }

    .tracker-steps {
        flex-wrap: wrap;
        gap: 30px;
    }

    .tracker-steps::before {
        display: none; /* hide horizontal line */
    }

    .step {
        width: 50%;
    }

    .step span {
        width: 42px;
        height: 42px;
    }
}

/* ============================= */
/* MOBILE (≤ 576px)              */
/* ============================= */
@media (max-width: 576px) {

    .tracker-box {
        padding: 25px 20px;
        border-radius: 16px;
    }

    .tracker-box h2 {
        font-size: 20px;
    }

    .tracker-box p {
        font-size: 14px;
    }

    .tracker-steps {
        flex-direction: column;
        align-items: flex-start;
        gap: 25px;
    }

    .step {
        width: 100%;
        display: flex;
        align-items: center;
        gap: 15px;
        text-align: left;
    }

    .step span {
        margin-bottom: 0;
        width: 38px;
        height: 38px;
        font-size: 14px;
    }

    .step p {
        font-size: 14px;
    }

    .order-info p {
        font-size: 14px;
    }

    .back-btn {
        width: 100%;
        text-align: center;
        padding: 12px;
    }
}
.step {
    transition: transform 0.0.5s ease, background 0.0.5s ease;
}

.step.active {
    transform: scale(1.05);
}

</style>
</head>

<body>

<section class="container">
    <div class="tracker-box text-center">

        <h2>Track Your Order</h2>
        <p>Order ID: <strong>#ORD12345</strong></p>

        <!-- STEPS -->
        <div class="tracker-steps">
            <div class="step active">
                <span>1</span>
                <p>Order Confirmed</p>
            </div>
            <div class="step active">
                <span>2</span>
                <p>Preparing</p>
            </div>
            <div class="step">
                <span>3</span>
                <p>Out for Delivery</p>
            </div>
            <div class="step">
                <span>4</span>
                <p>Delivered</p>
            </div>
        </div>

        <!-- ORDER INFO -->
        <div class="order-info">
            <p><span>Order Type</span><span>Home Delivery</span></p>
            <p><span>Estimated Time</span><span>30–40 mins</span></p>
            <p><span>Total Amount</span><span>₹420</span></p>
        </div>

        <a href="index.php" class="back-btn">Back to Home</a>

    </div>
</section>

<script>
/* SIMPLE STATUS SIMULATION */
let steps = document.querySelectorAll(".step");
let current = 1;

setInterval(()=>{
    if(current < steps.length){
        steps[current].classList.add("active");
        current++;
    }
},3000);
</script>
		<!-- Footer Section Start -->
<footer class="restaurant-footer">
    <div class="footer-container">

        <!-- Left Top Logo + Text -->
        <div class="footer-brand">
            <img src="assets/images/Homepage1/footer-logo.png" alt="Restaurant Logo" class="footer-logo">
            <p class="footer-desc">
                A premium dining experience with handcrafted dishes, fresh ingredients, 
                and an elegant ambiance. Your comfort is our priority.
            </p>
        </div>

        <!-- Quick Links -->
        <div class="footer-links">
            <h4>Quick Links</h4>
            <ul>
                <li><a href="reservation-1.php">Reserve a Table</a></li>
                
                <li><a href="#menupage-veg.php">Explore Menu</a></li>
                <li><a href="#weekly.php">Special Offers</a></li>
                <li><a href="#catering-events.php">Catering Service</a></li>
            </ul>
        </div>

        <!-- Contact Section -->
        <div class="footer-contact">
            <h4>Contact Us</h4>
            <p> 123 Food Street, Chennai</p>
            <p> +91 98765 43210</p>
            <p>✉ support@restaurant.com</p>

            <div class="footer-social">
                <a href="#"><i class="fa fa-facebook"></i></a>
                <a href="#"><i class="fa fa-instagram"></i></a>
                <a href="#"><i class="fa fa-twitter"></i></a>
                <a href="#"><i class="fa fa-youtube"></i></a>
            </div>
        </div>

        <!-- Working Hours -->
        <div class="footer-hours">
            <h4>Working Hours</h4>
            <p>Mon – Fri : 09:00 - 22:00</p>
            <p>Saturday : 11:00 - 23:30</p>
            <p>Sunday : 11:00 - 23:00</p>
        </div>

    </div>

    <div class="footer-bottom">
        <p>© 2025 Your Restaurant Name. All Rights Reserved.</p>
        <div class="footer-bottom-links">
            <a href="#">Privacy Policy</a>
            <a href="#">Terms of Service</a>
        </div>
    </div>
</footer>
			<!-- Footer Section End -->
			<!-- Fixed Search Bar Start -->
			<div>
				<div class="fixed-serach-icon ">
					<div class="fixed-search ">
						<a href="javascript:void(0)">
							<svg width="24" height="24" viewbox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
								<mask id="mask0_504_17203" style="mask-type:alpha" maskunits="userSpaceOnUse" x="0" y="0" width="24" height="24">
									<rect width="24" height="24" fill="white"></rect>
								</mask>
								<g mask="url(#mask0_504_17203)">
									<circle cx="11.7666" cy="11.7666" r="8.98856" stroke="#0B1315" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></circle>
									<path d="M18.0183 18.4851L21.5423 22" stroke="#0B1315" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
								</g>
							</svg>
						</a>
					</div>
				</div> 
				<div class="search-popup">
					<span class="search-back-drop"></span>
					<button class="close-search"><span class="fa fa-times"></span></button>
					<div class="search-inner">
						<form method="post" action="index.php">
							<div class="form-group">
								<input type="search" name="search-field" value="" placeholder="Search..." required="">
								<button type="submit"><i class="fa fa-search"></i></button>
							</div>
						</form>
					</div>
				</div>
			</div>
			<!-- Fixed Search Bar End -->
			<!-- Hero Video Modal Start -->
			<div class="modal fade homepage-video-modal" id="hero-video-modal">
				<div class="modal-dialog modal-dialog-centered">
					<div class="modal-content">
						<div class="modal-header">
							<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
						</div>
						<div class="modal-body">
							<video class="video-sec" controls="" loop="" muted="" autoplay="">
								<source src="assets/images/Homepage1/video.mp4" type="video/mp4">
								</video>
							</div>
						</div>
					</div>
				</div>
				<!-- Hero Video Modal End -->
				<!--Scroll Top to Bottom Start -->
				<div class="scroll-top" data-scroll="up">		
				</div>
				<!--Scroll Top to Bottom  End -->
			</div>
			
			<script src="assets/js/jquery-min-3.6.0.js"></script>
			<script src="assets/js/slick.min.js"></script>
			<script src="assets/js/bootstrap.bundle.min.js"></script>
			<script src="assets/js/aos.js"></script>
			<script src="assets/js/jquery-ui.min.js"></script>
			<script src="assets/js/datepicker.js"></script>
			<script src="assets/js/wow.min.js"></script>
			<script src="assets/js/photoswipe.min.js"></script>
			<script src="assets/js/photoswipe-ui-default.min.js"></script>
			<script src="assets/js/gallery-popup.js"></script>
			<script src="assets/js/TweenMax.min.js"></script>
			<script src="assets/js/ScrollMagic.js"></script>
			<script src="assets/js/animation.gsap.min.js"></script>
			<script src="assets/js/scolling.js"></script>
			<script src="assets/js/custom.js"></script>
	</body>
	</html>