<?php
session_start();

// 1. CHECK LOGIN
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

// 2. CONNECT TO DATABASE
$conn = new mysqli("localhost", "root", "", "bermiz_db");
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// 3. HANDLE UPLOAD
if (isset($_FILES['avatar'])) {
    $user_id = $_SESSION['user_id'];
    
    // File properties
    $file_name = $_FILES['avatar']['name'];
    $file_tmp = $_FILES['avatar']['tmp_name'];
    $file_size = $_FILES['avatar']['size'];
    $file_error = $_FILES['avatar']['error'];

    // Get extension (jpg, png, etc.)
    $file_ext = explode('.', $file_name);
    $file_actual_ext = strtolower(end($file_ext));

    // Allowed types
    $allowed = array('jpg', 'jpeg', 'png', 'gif');

    if (in_array($file_actual_ext, $allowed)) {
        if ($file_error === 0) {
            if ($file_size < 5000000) { // Limit 5MB
                
                // Create unique name to prevent overwriting
                $file_new_name = "profile_" . $user_id . "." . $file_actual_ext;
                $file_destination = 'assets/uploads/' . $file_new_name;

                // Create folder if it doesn't exist
                if (!file_exists('assets/uploads')) {
                    mkdir('assets/uploads', 0777, true);
                }

                // Move file
                if (move_uploaded_file($file_tmp, $file_destination)) {
                    
                    // UPDATE DATABASE
                    // This is where your error was happening
                    $sql = "UPDATE users SET profile_image = '$file_new_name' WHERE id = '$user_id'";
                    
                    if ($conn->query($sql) === TRUE) {
                        header("Location: profile.php?upload=success");
                    } else {
                        echo "Database Error: " . $conn->error;
                    }
                    
                } else {
                    echo "Failed to move uploaded file.";
                }
            } else {
                echo "File is too big!";
            }
        } else {
            echo "Error uploading file!";
        }
    } else {
        echo "You cannot upload files of this type!";
    }
}
$conn->close();
?>